/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mock;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.mock.MockAccumulo;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.NamespacePermission;

public class MockNamespace {
    final Map<String, String> settings;
    Map<String, EnumSet<NamespacePermission>> userPermissions = new HashMap<String, EnumSet<NamespacePermission>>();

    public MockNamespace() {
        this.settings = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : AccumuloConfiguration.getDefaultConfiguration()) {
            String key = entry.getKey();
            if (!key.startsWith(Property.TABLE_PREFIX.getKey())) continue;
            this.settings.put(key, entry.getValue());
        }
    }

    public List<String> getTables(MockAccumulo acu) {
        LinkedList<String> l = new LinkedList<String>();
        for (String t : acu.tables.keySet()) {
            if (!acu.tables.get(t).getNamespace().equals(this)) continue;
            l.add(t);
        }
        return l;
    }
}

