/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.ClientExecReturn;
import org.apache.accumulo.core.client.impl.ServerConfigurationUtil;
import org.apache.accumulo.core.client.impl.ThriftTransportKey;
import org.apache.accumulo.core.client.impl.ThriftTransportPool;
import org.apache.accumulo.core.client.impl.thrift.ClientService;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.SslConnectionParams;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.log4j.Logger;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class ServerClient {
    private static final Logger log = Logger.getLogger(ServerClient.class);
    private static final Map<String, ZooCache> zooCaches = new HashMap<String, ZooCache>();
    static volatile boolean warnedAboutTServersBeingDown = false;

    static synchronized ZooCache getZooCache(Instance instance) {
        ZooCache result = zooCaches.get(instance.getZooKeepers());
        if (result == null) {
            result = new ZooCache(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut(), null);
            zooCaches.put(instance.getZooKeepers(), result);
        }
        return result;
    }

    public static <T> T execute(Instance instance, ClientExecReturn<T, ClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        try {
            return ServerClient.executeRaw(instance, exec);
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    public static void execute(Instance instance, ClientExec<ClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        try {
            ServerClient.executeRaw(instance, exec);
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeRaw(Instance instance, ClientExecReturn<T, ClientService.Client> exec) throws Exception {
        while (true) {
            T t;
            block6: {
                ClientService.Client client = null;
                String server = null;
                try {
                    Pair<String, ClientService.Client> pair = ServerClient.getConnection(instance);
                    server = pair.getFirst();
                    client = pair.getSecond();
                    t = exec.execute(client);
                    if (client == null) break block6;
                }
                catch (TTransportException tte) {
                    try {
                        log.debug((Object)("ClientService request failed " + server + ", retrying ... "), (Throwable)tte);
                        UtilWaitThread.sleep(100L);
                        if (client == null) continue;
                    }
                    catch (Throwable throwable) {
                        if (client != null) {
                            ServerClient.close(client);
                        }
                        throw throwable;
                    }
                    ServerClient.close(client);
                    continue;
                }
                ServerClient.close(client);
            }
            return t;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeRaw(Instance instance, ClientExec<ClientService.Client> exec) throws Exception {
        while (true) {
            ClientService.Client client = null;
            String server = null;
            try {
                Pair<String, ClientService.Client> pair = ServerClient.getConnection(instance);
                server = pair.getFirst();
                client = pair.getSecond();
                exec.execute(client);
                if (client == null) break;
            }
            catch (TTransportException tte) {
                try {
                    log.debug((Object)("ClientService request failed " + server + ", retrying ... "), (Throwable)tte);
                    UtilWaitThread.sleep(100L);
                    if (client == null) continue;
                }
                catch (Throwable throwable) {
                    if (client != null) {
                        ServerClient.close(client);
                    }
                    throw throwable;
                }
                ServerClient.close(client);
                continue;
            }
            ServerClient.close(client);
            break;
        }
    }

    public static Pair<String, ClientService.Client> getConnection(Instance instance) throws TTransportException {
        return ServerClient.getConnection(instance, true);
    }

    public static Pair<String, ClientService.Client> getConnection(Instance instance, boolean preferCachedConnections) throws TTransportException {
        AccumuloConfiguration conf = ServerConfigurationUtil.getConfiguration(instance);
        return ServerClient.getConnection(instance, preferCachedConnections, conf.getTimeInMillis(Property.GENERAL_RPC_TIMEOUT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<String, ClientService.Client> getConnection(Instance instance, boolean preferCachedConnections, long rpcTimeout) throws TTransportException {
        ArgumentChecker.notNull(instance);
        ArrayList<ThriftTransportKey> servers = new ArrayList<ThriftTransportKey>();
        ZooCache zc = ServerClient.getZooCache(instance);
        for (String tserver : zc.getChildren(ZooUtil.getRoot(instance) + "/tservers")) {
            String path = ZooUtil.getRoot(instance) + "/tservers" + "/" + tserver;
            byte[] data = ZooUtil.getLockData((ZooCache)zc, (String)path);
            if (data == null || new String(data, Constants.UTF8).equals("master")) continue;
            servers.add(new ThriftTransportKey(new ServerServices(new String(data)).getAddressString(ServerServices.Service.TSERV_CLIENT), rpcTimeout, SslConnectionParams.forClient(ServerConfigurationUtil.getConfiguration(instance))));
        }
        boolean opened = false;
        try {
            Pair<String, TTransport> pair = ThriftTransportPool.getInstance().getAnyTransport(servers, preferCachedConnections);
            ClientService.Client client = ThriftUtil.createClient(new ClientService.Client.Factory(), pair.getSecond());
            opened = true;
            warnedAboutTServersBeingDown = false;
            Pair<String, ClientService.Client> pair2 = new Pair<String, ClientService.Client>(pair.getFirst(), client);
            return pair2;
        }
        finally {
            if (!opened && !warnedAboutTServersBeingDown) {
                if (servers.isEmpty()) {
                    log.warn((Object)"There are no tablet servers: check that zookeeper and accumulo are running.");
                } else {
                    log.warn((Object)("Failed to find an available server in the list of servers: " + servers));
                }
                warnedAboutTServersBeingDown = true;
            }
        }
    }

    public static void close(ClientService.Client client) {
        if (client != null && client.getInputProtocol() != null && client.getInputProtocol().getTransport() != null) {
            ThriftTransportPool.getInstance().returnTransport(client.getInputProtocol().getTransport());
        } else {
            log.debug((Object)"Attempt to close null connection to a server", (Throwable)new Exception());
        }
    }
}

