/*
 * Decompiled with CFR 0.152.
 */
package io.druid.math.expr;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.metamx.common.logger.Logger;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprListenerImpl;
import io.druid.math.expr.Function;
import io.druid.math.expr.antlr.ExprLexer;
import io.druid.math.expr.antlr.ExprParser;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class Parser {
    static final Logger log = new Logger(Parser.class);
    static final Map<String, Function> func;

    public static Expr parse(String in) {
        ExprLexer lexer = new ExprLexer((CharStream)new ANTLRInputStream(in));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ExprParser parser = new ExprParser((TokenStream)tokens);
        parser.setBuildParseTree(true);
        ExprParser.ExprContext parseTree = parser.expr();
        ParseTreeWalker walker = new ParseTreeWalker();
        ExprListenerImpl listener = new ExprListenerImpl((ParseTree)parseTree);
        walker.walk((ParseTreeListener)listener, (ParseTree)parseTree);
        return listener.getAST();
    }

    static {
        HashMap functionMap = Maps.newHashMap();
        for (Class<?> clazz : Function.class.getClasses()) {
            if (Modifier.isAbstract(clazz.getModifiers()) || !Function.class.isAssignableFrom(clazz)) continue;
            try {
                Function function = (Function)clazz.newInstance();
                functionMap.put(function.name().toLowerCase(), function);
            }
            catch (Exception e) {
                log.info("failed to instantiate " + clazz.getName() + ".. ignoring", new Object[]{e});
            }
        }
        func = ImmutableMap.copyOf((Map)functionMap);
    }
}

