/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.workflow;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.slider.core.main.ServiceLaunchException;
import org.apache.slider.server.services.workflow.LongLivedProcess;
import org.apache.slider.server.services.workflow.LongLivedProcessLifecycleEvent;
import org.apache.slider.server.services.workflow.ServiceThreadFactory;
import org.apache.slider.server.services.workflow.WorkflowExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkedProcessService
extends WorkflowExecutorService<ExecutorService>
implements LongLivedProcessLifecycleEvent,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ForkedProcessService.class);
    private final AtomicBoolean processTerminated = new AtomicBoolean(false);
    private boolean processStarted = false;
    private LongLivedProcess process;
    private int executionTimeout = -1;
    private int timeoutCode = 1;
    private Logger processLog = LOG;
    private AtomicInteger exitCode = new AtomicInteger(0);

    public ForkedProcessService(String name) {
        super(name);
    }

    public ForkedProcessService(String name, Map<String, String> env, List<String> commandList) throws IOException {
        super(name);
        this.build(env, commandList);
    }

    protected void serviceStart() throws Exception {
        if (this.process == null) {
            throw new ServiceStateException("Process not yet configured");
        }
        this.process.start();
    }

    @Override
    protected void serviceStop() throws Exception {
        this.completed();
        this.stopForkedProcess();
    }

    private void stopForkedProcess() {
        if (this.process != null) {
            this.process.stop();
        }
    }

    public void setProcessLog(Logger processLog) {
        this.processLog = processLog;
        this.process.setProcessLog(processLog);
    }

    public void setTimeout(int timeout, int code) {
        this.executionTimeout = timeout;
        this.timeoutCode = code;
    }

    public void setRecentLineLimit(int limit) {
        this.process.setRecentLineLimit(limit);
    }

    public void build(Map<String, String> env, List<String> commandList) throws IOException {
        assert (this.process == null);
        this.process = new LongLivedProcess(this.getName(), this.processLog, commandList);
        this.process.setLifecycleCallback(this);
        this.process.putEnvMap(env);
    }

    @Override
    public synchronized void onProcessStarted(LongLivedProcess process) {
        LOG.debug("Process has started");
        this.processStarted = true;
        if (this.executionTimeout > 0) {
            this.setExecutor(ServiceThreadFactory.singleThreadExecutor(this.getName(), true));
            this.execute(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onProcessExited(LongLivedProcess process, int uncorrected, int code) {
        try {
            ForkedProcessService forkedProcessService = this;
            synchronized (forkedProcessService) {
                this.completed();
                LOG.debug("Process has exited with exit code {}", (Object)code);
                if (code != 0) {
                    this.reportFailure(code, String.valueOf(this.getName()) + " failed with code " + code);
                }
            }
        }
        finally {
            this.stop();
        }
    }

    private void reportFailure(int code, String text) {
        ServiceLaunchException execEx = new ServiceLaunchException(code, text);
        LOG.debug("Noting failure", (Throwable)((Object)execEx));
        this.noteFailure((Exception)((Object)execEx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            AtomicBoolean atomicBoolean = this.processTerminated;
            synchronized (atomicBoolean) {
                if (!this.processTerminated.get()) {
                    this.processTerminated.wait(this.executionTimeout);
                }
            }
        }
        catch (InterruptedException interruptedException) {}
        if (!this.processTerminated.getAndSet(true)) {
            LOG.info("process timeout: reporting error code {}", (Object)this.timeoutCode);
            if (this.isInState(Service.STATE.STARTED)) {
                this.stopForkedProcess();
            }
            this.reportFailure(this.timeoutCode, String.valueOf(this.getName()) + ": timeout after " + this.executionTimeout + " millis: exit code =" + this.timeoutCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completed() {
        this.processTerminated.set(true);
        AtomicBoolean atomicBoolean = this.processTerminated;
        synchronized (atomicBoolean) {
            this.processTerminated.notify();
        }
    }

    public boolean isProcessTerminated() {
        return this.processTerminated.get();
    }

    public synchronized boolean isProcessStarted() {
        return this.processStarted;
    }

    public synchronized boolean isProcessRunning() {
        return this.processStarted && !this.isProcessTerminated();
    }

    public Integer getExitCode() {
        return this.process.getExitCode();
    }

    public int getExitCodeSignCorrected() {
        Integer exitCode = this.process.getExitCodeSignCorrected();
        if (exitCode == null) {
            return -1;
        }
        return exitCode;
    }

    public List<String> getRecentOutput() {
        return this.process != null ? this.process.getRecentOutput() : new LinkedList();
    }

    public List<String> getRecentOutput(boolean finalOutput, int duration) {
        if (this.process == null) {
            return new LinkedList<String>();
        }
        return this.process.getRecentOutput(finalOutput, duration);
    }
}

