/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.servicemonitor;

public class LogEntryBuilder {
    private final StringBuilder builder = new StringBuilder();

    public LogEntryBuilder() {
    }

    public LogEntryBuilder(String text) {
        this.elt(text);
    }

    public LogEntryBuilder(String name, Object value) {
        this.entry(name, value);
    }

    public LogEntryBuilder elt(String text) {
        this.addComma();
        this.builder.append(text);
        return this;
    }

    public LogEntryBuilder elt(String name, Object value) {
        this.addComma();
        this.entry(name, value);
        return this;
    }

    private void addComma() {
        if (!this.isEmpty()) {
            this.builder.append(", ");
        }
    }

    private void entry(String name, Object value) {
        this.builder.append(name).append('=');
        if (value != null) {
            this.builder.append('\"').append(value.toString()).append('\"');
        } else {
            this.builder.append("null");
        }
    }

    public String toString() {
        return this.builder.toString();
    }

    private boolean isEmpty() {
        return this.builder.length() == 0;
    }
}

