/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest.application.actions;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.slider.api.SliderExitReason;
import org.apache.slider.server.appmaster.actions.ActionStopSlider;
import org.apache.slider.server.appmaster.web.WebAppApi;
import org.apache.slider.server.appmaster.web.rest.application.actions.StopResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestActionStop {
    private static final Logger log = LoggerFactory.getLogger(RestActionStop.class);
    private final WebAppApi slider;

    public RestActionStop(WebAppApi slider) {
        this.slider = slider;
    }

    public StopResponse stop(HttpServletRequest request, UriInfo uriInfo, String body) {
        String text;
        String verb = request.getMethod();
        log.info("Ping {}", (Object)verb);
        StopResponse response = new StopResponse();
        response.verb = verb;
        long time = System.currentTimeMillis();
        response.text = text = String.format(Locale.ENGLISH, "Stopping action %s received at %tc", verb, time);
        log.info(text);
        ActionStopSlider stopSlider = new ActionStopSlider(text, 1000L, TimeUnit.MILLISECONDS, 0, FinalApplicationStatus.SUCCEEDED, text);
        stopSlider.setExitReason(SliderExitReason.STOP_COMMAND_ISSUED);
        log.info("SliderAppMasterApi.stopCluster: {}", (Object)stopSlider);
        this.slider.getQueues().schedule(stopSlider);
        return response;
    }
}

