/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.state;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.util.Records;

public final class ContainerPriority {
    static final int NOLOCATION = 0x40000000;

    public static int buildPriority(int role, boolean locationSpecified) {
        int location = locationSpecified ? 0 : 0x40000000;
        return role | location;
    }

    public static Priority createPriority(int role, boolean locationSpecified) {
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(ContainerPriority.buildPriority(role, locationSpecified));
        return pri;
    }

    public static int extractRole(int priority) {
        return priority >= 0x40000000 ? priority ^ 0x40000000 : priority;
    }

    public static boolean hasLocation(int priority) {
        return (priority ^ 0x40000000) == 0;
    }

    public static int extractRole(Container container) {
        Priority priority = container.getPriority();
        return ContainerPriority.extractRole(priority);
    }

    public static int extractRole(Priority priorityRecord) {
        Preconditions.checkNotNull((Object)priorityRecord);
        return ContainerPriority.extractRole(priorityRecord.getPriority());
    }

    public static String toString(Priority priorityRecord) {
        if (priorityRecord == null) {
            return "(null)";
        }
        return String.format(Locale.ENGLISH, "role %d (locality=%b)", ContainerPriority.extractRole(priorityRecord), ContainerPriority.hasLocation(priorityRecord.getPriority()));
    }
}

