/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.rpc;

import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.slider.api.ClusterDescription;
import org.apache.slider.api.SliderClusterProtocol;
import org.apache.slider.api.SliderExitReason;
import org.apache.slider.api.proto.Messages;
import org.apache.slider.api.proto.RestTypeMarshalling;
import org.apache.slider.api.types.ApplicationLivenessInformation;
import org.apache.slider.api.types.ComponentInformation;
import org.apache.slider.api.types.ContainerInformation;
import org.apache.slider.api.types.NodeInformation;
import org.apache.slider.api.types.NodeInformationList;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTree;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.persist.AggregateConfSerDeser;
import org.apache.slider.core.persist.ConfTreeSerDeser;
import org.apache.slider.server.appmaster.AppMasterActionOperations;
import org.apache.slider.server.appmaster.actions.ActionFlexCluster;
import org.apache.slider.server.appmaster.actions.ActionHalt;
import org.apache.slider.server.appmaster.actions.ActionKillContainer;
import org.apache.slider.server.appmaster.actions.ActionStopSlider;
import org.apache.slider.server.appmaster.actions.ActionUpgradeContainers;
import org.apache.slider.server.appmaster.actions.AsyncAction;
import org.apache.slider.server.appmaster.actions.QueueAccess;
import org.apache.slider.server.appmaster.management.MetricsAndMonitoring;
import org.apache.slider.server.appmaster.state.RoleInstance;
import org.apache.slider.server.appmaster.state.StateAccessForProviders;
import org.apache.slider.server.appmaster.web.rest.application.resources.ContentCache;
import org.apache.slider.server.services.security.CertificateManager;
import org.apache.slider.server.services.security.SecurityStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliderIPCService
extends AbstractService
implements SliderClusterProtocol {
    protected static final Logger log = LoggerFactory.getLogger(SliderIPCService.class);
    private final QueueAccess actionQueues;
    private final StateAccessForProviders state;
    private final MetricsAndMonitoring metricsAndMonitoring;
    private final AppMasterActionOperations amOperations;
    private final ContentCache cache;
    private final CertificateManager certificateManager;
    public static final String METRICS_PREFIX = "org.apache.slider.api.SliderIPCService.";

    public SliderIPCService(AppMasterActionOperations amOperations, CertificateManager certificateManager, StateAccessForProviders state, QueueAccess actionQueues, MetricsAndMonitoring metricsAndMonitoring, ContentCache cache) {
        super("SliderIPCService");
        Preconditions.checkArgument((amOperations != null ? 1 : 0) != 0, (Object)"null amOperations");
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)"null appState");
        Preconditions.checkArgument((actionQueues != null ? 1 : 0) != 0, (Object)"null actionQueues");
        Preconditions.checkArgument((metricsAndMonitoring != null ? 1 : 0) != 0, (Object)"null metricsAndMonitoring");
        Preconditions.checkArgument((cache != null ? 1 : 0) != 0, (Object)"null cache");
        this.state = state;
        this.actionQueues = actionQueues;
        this.metricsAndMonitoring = metricsAndMonitoring;
        this.amOperations = amOperations;
        this.cache = cache;
        this.certificateManager = certificateManager;
    }

    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        return ProtocolSignature.getProtocolSignature((VersionedProtocol)this, (String)protocol, (long)clientVersion, (int)clientMethodsHash);
    }

    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        return 1L;
    }

    protected void onRpcCall(String operation) throws IOException {
        log.debug("Received call to {}", (Object)operation);
        this.metricsAndMonitoring.markMeterAndCounter(METRICS_PREFIX + operation);
    }

    public void schedule(AsyncAction action) {
        this.actionQueues.schedule(action);
    }

    public void queue(AsyncAction action) {
        this.actionQueues.put(action);
    }

    @Override
    public Messages.StopClusterResponseProto stopCluster(Messages.StopClusterRequestProto request) throws IOException, YarnException {
        this.onRpcCall("stop");
        String message = request.getMessage();
        if (message == null) {
            message = "application stopped by client";
        }
        ActionStopSlider stopSlider = new ActionStopSlider(message, 1000L, TimeUnit.MILLISECONDS, 0, FinalApplicationStatus.SUCCEEDED, message);
        stopSlider.setExitReason(SliderExitReason.STOP_COMMAND_ISSUED);
        log.info("SliderAppMasterApi.stopCluster: {}", (Object)stopSlider);
        this.schedule(stopSlider);
        return Messages.StopClusterResponseProto.getDefaultInstance();
    }

    @Override
    public Messages.UpgradeContainersResponseProto upgradeContainers(Messages.UpgradeContainersRequestProto request) throws IOException, YarnException {
        this.onRpcCall("upgrade");
        String message = request.getMessage();
        if (message == null) {
            message = "application containers upgraded by client";
        }
        ActionUpgradeContainers upgradeContainers = new ActionUpgradeContainers("Upgrade containers", 1000L, TimeUnit.MILLISECONDS, 0, FinalApplicationStatus.SUCCEEDED, request.getContainerList(), request.getComponentList(), message);
        log.info("SliderAppMasterApi.upgradeContainers: {}", (Object)upgradeContainers);
        this.schedule(upgradeContainers);
        return Messages.UpgradeContainersResponseProto.getDefaultInstance();
    }

    @Override
    public Messages.FlexClusterResponseProto flexCluster(Messages.FlexClusterRequestProto request) throws IOException {
        this.onRpcCall("flex");
        String payload = request.getClusterSpec();
        ConfTreeSerDeser confTreeSerDeser = new ConfTreeSerDeser();
        ConfTree updatedResources = (ConfTree)confTreeSerDeser.fromJson(payload);
        this.schedule(new ActionFlexCluster("flex", 1L, TimeUnit.MILLISECONDS, updatedResources));
        return Messages.FlexClusterResponseProto.newBuilder().setResponse(true).build();
    }

    @Override
    public Messages.GetJSONClusterStatusResponseProto getJSONClusterStatus(Messages.GetJSONClusterStatusRequestProto request) throws IOException, YarnException {
        String result;
        this.onRpcCall("getstatus");
        ClusterDescription cd = this.state.refreshClusterStatus();
        String stat = result = cd.toJsonString();
        return Messages.GetJSONClusterStatusResponseProto.newBuilder().setClusterSpec(stat).build();
    }

    @Override
    public Messages.GetInstanceDefinitionResponseProto getInstanceDefinition(Messages.GetInstanceDefinitionRequestProto request) throws IOException, YarnException {
        this.onRpcCall("getinstancedefinition");
        AggregateConf instanceDefinition = this.state.getInstanceDefinitionSnapshot();
        String internal = instanceDefinition.getInternal().toJson();
        String resources = instanceDefinition.getResources().toJson();
        String app = instanceDefinition.getAppConf().toJson();
        assert (internal != null);
        assert (resources != null);
        assert (app != null);
        log.debug("Generating getInstanceDefinition Response");
        Messages.GetInstanceDefinitionResponseProto.Builder builder = Messages.GetInstanceDefinitionResponseProto.newBuilder();
        builder.setInternal(internal);
        builder.setResources(resources);
        builder.setApplication(app);
        return builder.build();
    }

    @Override
    public Messages.ListNodeUUIDsByRoleResponseProto listNodeUUIDsByRole(Messages.ListNodeUUIDsByRoleRequestProto request) throws IOException, YarnException {
        this.onRpcCall("listnodes)");
        String role = request.getRole();
        Messages.ListNodeUUIDsByRoleResponseProto.Builder builder = Messages.ListNodeUUIDsByRoleResponseProto.newBuilder();
        List<RoleInstance> nodes = this.state.enumLiveInstancesInRole(role);
        for (RoleInstance node : nodes) {
            builder.addUuid(node.id);
        }
        return builder.build();
    }

    @Override
    public Messages.GetNodeResponseProto getNode(Messages.GetNodeRequestProto request) throws IOException, YarnException {
        this.onRpcCall("getnode");
        RoleInstance instance = this.state.getLiveInstanceByContainerID(request.getUuid());
        return Messages.GetNodeResponseProto.newBuilder().setClusterNode(instance.toProtobuf()).build();
    }

    @Override
    public Messages.GetClusterNodesResponseProto getClusterNodes(Messages.GetClusterNodesRequestProto request) throws IOException, YarnException {
        this.onRpcCall("getclusternodes");
        List<RoleInstance> clusterNodes = this.state.getLiveInstancesByContainerIDs(request.getUuidList());
        Messages.GetClusterNodesResponseProto.Builder builder = Messages.GetClusterNodesResponseProto.newBuilder();
        for (RoleInstance node : clusterNodes) {
            builder.addClusterNode(node.toProtobuf());
        }
        return builder.build();
    }

    @Override
    public Messages.EchoResponseProto echo(Messages.EchoRequestProto request) throws IOException, YarnException {
        this.onRpcCall("echo");
        Messages.EchoResponseProto.Builder builder = Messages.EchoResponseProto.newBuilder();
        String text = request.getText();
        log.info("Echo request size ={}", (Object)text.length());
        log.info(text);
        builder.setText(text);
        return builder.build();
    }

    @Override
    public Messages.KillContainerResponseProto killContainer(Messages.KillContainerRequestProto request) throws IOException, YarnException {
        this.onRpcCall("killcontainer");
        String containerID = request.getId();
        log.info("Kill Container {}", (Object)containerID);
        RoleInstance instance = this.state.getLiveInstanceByContainerID(containerID);
        this.queue(new ActionKillContainer(instance.getId(), 0L, TimeUnit.MILLISECONDS, this.amOperations));
        Messages.KillContainerResponseProto.Builder builder = Messages.KillContainerResponseProto.newBuilder();
        builder.setSuccess(true);
        return builder.build();
    }

    @Override
    public Messages.AMSuicideResponseProto amSuicide(Messages.AMSuicideRequestProto request) throws IOException {
        this.onRpcCall("amsuicide");
        int signal = request.getSignal();
        String text = request.getText();
        if (text == null) {
            text = "";
        }
        int delay = request.getDelay();
        log.info("AM Suicide with signal {}, message {} delay = {}", new Object[]{signal, text, delay});
        ActionHalt action = new ActionHalt(signal, text, delay, TimeUnit.MILLISECONDS);
        this.schedule(action);
        return Messages.AMSuicideResponseProto.getDefaultInstance();
    }

    @Override
    public Messages.ApplicationLivenessInformationProto getLivenessInformation(Messages.GetApplicationLivenessRequestProto request) throws IOException {
        ApplicationLivenessInformation info = this.state.getApplicationLivenessInformation();
        return RestTypeMarshalling.marshall(info);
    }

    @Override
    public Messages.GetLiveContainersResponseProto getLiveContainers(Messages.GetLiveContainersRequestProto request) throws IOException {
        Map infoMap = (Map)this.cache.lookupWithIOE("/live/containers");
        Messages.GetLiveContainersResponseProto.Builder builder = Messages.GetLiveContainersResponseProto.newBuilder();
        for (Map.Entry entry : infoMap.entrySet()) {
            builder.addNames((String)entry.getKey());
            builder.addContainers(RestTypeMarshalling.marshall((ContainerInformation)entry.getValue()));
        }
        return builder.build();
    }

    @Override
    public Messages.ContainerInformationProto getLiveContainer(Messages.GetLiveContainerRequestProto request) throws IOException {
        String containerId = request.getContainerId();
        RoleInstance id = this.state.getLiveInstanceByContainerID(containerId);
        ContainerInformation containerInformation = id.serialize();
        return RestTypeMarshalling.marshall(containerInformation);
    }

    @Override
    public Messages.GetLiveComponentsResponseProto getLiveComponents(Messages.GetLiveComponentsRequestProto request) throws IOException {
        Map infoMap = (Map)this.cache.lookupWithIOE("/live/components");
        Messages.GetLiveComponentsResponseProto.Builder builder = Messages.GetLiveComponentsResponseProto.newBuilder();
        for (Map.Entry entry : infoMap.entrySet()) {
            builder.addNames((String)entry.getKey());
            builder.addComponents(RestTypeMarshalling.marshall((ComponentInformation)entry.getValue()));
        }
        return builder.build();
    }

    @Override
    public Messages.ComponentInformationProto getLiveComponent(Messages.GetLiveComponentRequestProto request) throws IOException {
        String name = request.getName();
        try {
            return RestTypeMarshalling.marshall(this.state.getComponentInformation(name));
        }
        catch (YarnRuntimeException yarnRuntimeException) {
            throw new FileNotFoundException("Unknown component: " + name);
        }
    }

    @Override
    public Messages.GetLiveNodesResponseProto getLiveNodes(Messages.GetLiveNodesRequestProto request) throws IOException {
        NodeInformationList info = (NodeInformationList)this.cache.lookupWithIOE("/live/nodes");
        Messages.GetLiveNodesResponseProto.Builder builder = Messages.GetLiveNodesResponseProto.newBuilder();
        for (NodeInformation nodeInformation : info) {
            builder.addNodes(RestTypeMarshalling.marshall(nodeInformation));
        }
        return builder.build();
    }

    @Override
    public Messages.NodeInformationProto getLiveNode(Messages.GetLiveNodeRequestProto request) throws IOException {
        String name = request.getName();
        NodeInformation nodeInformation = this.state.getNodeInformation(name);
        if (nodeInformation != null) {
            return RestTypeMarshalling.marshall(nodeInformation);
        }
        throw new FileNotFoundException("Unknown host: " + name);
    }

    @Override
    public Messages.WrappedJsonProto getModelDesired(Messages.EmptyPayloadProto request) throws IOException {
        return this.lookupAggregateConf("/model/desired");
    }

    @Override
    public Messages.WrappedJsonProto getModelDesiredAppconf(Messages.EmptyPayloadProto request) throws IOException {
        return this.lookupConfTree("/model/desired/appconf");
    }

    @Override
    public Messages.WrappedJsonProto getModelDesiredResources(Messages.EmptyPayloadProto request) throws IOException {
        return this.lookupConfTree("/model/desired/resources");
    }

    @Override
    public Messages.WrappedJsonProto getModelResolved(Messages.EmptyPayloadProto request) throws IOException {
        return this.lookupAggregateConf("/model/resolved");
    }

    @Override
    public Messages.WrappedJsonProto getModelResolvedAppconf(Messages.EmptyPayloadProto request) throws IOException {
        return this.lookupConfTree("/model/resolved/appconf");
    }

    @Override
    public Messages.WrappedJsonProto getModelResolvedResources(Messages.EmptyPayloadProto request) throws IOException {
        return this.lookupConfTree("/model/resolved/resources");
    }

    @Override
    public Messages.WrappedJsonProto getLiveResources(Messages.EmptyPayloadProto request) throws IOException {
        return this.lookupConfTree("/live/resources");
    }

    protected Messages.WrappedJsonProto lookupAggregateConf(String key) throws IOException {
        AggregateConf aggregateConf = (AggregateConf)this.cache.lookupWithIOE(key);
        String json = AggregateConfSerDeser.toString(aggregateConf);
        return this.wrap(json);
    }

    protected Messages.WrappedJsonProto lookupConfTree(String key) throws IOException {
        ConfTree conf = (ConfTree)this.cache.lookupWithIOE(key);
        String json = ConfTreeSerDeser.toString(conf);
        return this.wrap(json);
    }

    private Messages.WrappedJsonProto wrap(String json) {
        Messages.WrappedJsonProto.Builder builder = Messages.WrappedJsonProto.newBuilder();
        builder.setJson(json);
        return builder.build();
    }

    @Override
    public Messages.GetCertificateStoreResponseProto getClientCertificateStore(Messages.GetCertificateStoreRequestProto request) throws IOException {
        SecurityStore store;
        block4: {
            String hostname = request.getHostname();
            String clientId = request.getRequesterId();
            String password = request.getPassword();
            String type = request.getType();
            store = null;
            try {
                if (SecurityStore.StoreType.keystore.equals((Object)SecurityStore.StoreType.valueOf(type))) {
                    store = this.certificateManager.generateContainerKeystore(hostname, clientId, null, password);
                    break block4;
                }
                if (SecurityStore.StoreType.truststore.equals((Object)SecurityStore.StoreType.valueOf(type))) {
                    store = this.certificateManager.generateContainerTruststore(clientId, null, password);
                    break block4;
                }
                throw new IOException("Illegal store type");
            }
            catch (SliderException e) {
                throw new IOException((Throwable)((Object)e));
            }
        }
        return RestTypeMarshalling.marshall(store);
    }
}

