/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.management;

import com.codahale.metrics.Counting;
import com.codahale.metrics.Metric;
import java.util.concurrent.atomic.AtomicLong;

public class RangeLimitedCounter
implements Metric,
Counting {
    private final AtomicLong value;
    private final long min;
    private final long max;

    public RangeLimitedCounter(long val, long min, long max) {
        this.value = new AtomicLong(val);
        this.min = min;
        this.max = max;
    }

    public synchronized void set(long val) {
        if (val < this.min) {
            val = this.min;
        } else if (this.max > 0L && val > this.max) {
            val = this.max;
        }
        this.value.set(val);
    }

    public void inc() {
        this.inc(1);
    }

    public void dec() {
        this.dec(1);
    }

    public synchronized void inc(int delta) {
        this.set(this.value.get() + (long)delta);
    }

    public synchronized void dec(int delta) {
        this.set(this.value.get() - (long)delta);
    }

    public long get() {
        return this.value.get();
    }

    public long getCount() {
        return this.value.get();
    }
}

