/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.actions;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.slider.server.appmaster.SliderAppMaster;
import org.apache.slider.server.appmaster.actions.AsyncAction;
import org.apache.slider.server.appmaster.actions.QueueAccess;
import org.apache.slider.server.appmaster.state.AppState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenewingAction<A extends AsyncAction>
extends AsyncAction {
    private static final Logger log = LoggerFactory.getLogger(RenewingAction.class);
    private final A action;
    private long interval;
    private TimeUnit timeUnit;
    public final AtomicInteger executionCount = new AtomicInteger();
    private final ReentrantReadWriteLock intervalLock = new ReentrantReadWriteLock();
    private final Lock intervalReadLock = this.intervalLock.readLock();
    private final Lock intervalWriteLock = this.intervalLock.writeLock();
    public final int limit;

    public RenewingAction(A action, long initialDelay, long interval, TimeUnit timeUnit, int limit) {
        super("renewing " + ((AsyncAction)action).name, initialDelay, timeUnit, ((AsyncAction)action).getAttrs());
        Preconditions.checkArgument((interval > 0L ? 1 : 0) != 0, (Object)("invalid interval: " + interval));
        this.action = action;
        this.interval = interval;
        this.timeUnit = timeUnit;
        this.limit = limit;
    }

    @Override
    public void execute(SliderAppMaster appMaster, QueueAccess queueService, AppState appState) throws Exception {
        long exCount = this.executionCount.incrementAndGet();
        log.debug("{}: Executing inner action count # {}", (Object)this, (Object)exCount);
        ((AsyncAction)this.action).execute(appMaster, queueService, appState);
        boolean reschedule = true;
        if (this.limit > 0) {
            boolean bl = reschedule = (long)this.limit > exCount;
        }
        if (reschedule) {
            this.setNanos(this.convertAndOffset(this.getInterval(), this.getTimeUnit()));
            log.debug("{}: rescheduling, new offset {} mS ", (Object)this, (Object)this.getDelay(TimeUnit.MILLISECONDS));
            queueService.schedule(this);
        }
    }

    public A getAction() {
        return this.action;
    }

    public long getInterval() {
        this.intervalReadLock.lock();
        try {
            long l = this.interval;
            return l;
        }
        finally {
            this.intervalReadLock.unlock();
        }
    }

    public void updateInterval(long delay, TimeUnit timeUnit) {
        this.intervalWriteLock.lock();
        try {
            this.interval = delay;
            this.timeUnit = timeUnit;
        }
        finally {
            this.intervalWriteLock.unlock();
        }
    }

    public TimeUnit getTimeUnit() {
        this.intervalReadLock.lock();
        try {
            TimeUnit timeUnit = this.timeUnit;
            return timeUnit;
        }
        finally {
            this.intervalReadLock.unlock();
        }
    }

    public int getExecutionCount() {
        return this.executionCount.get();
    }

    public int getLimit() {
        return this.limit;
    }
}

