/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent.application.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.providers.agent.application.metadata.ConfigFile;
import org.apache.slider.providers.agent.application.metadata.DockerContainerInputFile;
import org.apache.slider.providers.agent.application.metadata.DockerContainerMount;
import org.apache.slider.providers.agent.application.metadata.DockerContainerPort;
import org.apache.slider.providers.agent.application.metadata.Metainfo;
import org.apache.slider.providers.agent.application.metadata.Validate;
import org.codehaus.jackson.annotate.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerContainer
implements Validate {
    protected static final Logger log = LoggerFactory.getLogger(DockerContainer.class);
    private String name;
    private String image;
    private String network;
    private String useNetworkScript;
    private String options;
    private List<DockerContainerMount> mounts = new ArrayList<DockerContainerMount>();
    private List<DockerContainerPort> ports = new ArrayList<DockerContainerPort>();
    private String statusCommand;
    private String startCommand;
    private String commandPath;
    private String additionalParam;
    private String runPrivilegedContainer;
    private List<DockerContainerInputFile> inputFiles = new ArrayList<DockerContainerInputFile>();
    private List<ConfigFile> configFiles = new ArrayList<ConfigFile>();

    @JsonProperty(value="mounts")
    public List<DockerContainerMount> getMounts() {
        return this.mounts;
    }

    @JsonProperty(value="ports")
    public List<DockerContainerPort> getPorts() {
        return this.ports;
    }

    @JsonProperty(value="inputFiles")
    public List<DockerContainerInputFile> getInputFiles() {
        return this.inputFiles;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public String getUseNetworkScript() {
        return this.useNetworkScript;
    }

    public void setUseNetworkScript(String useNetworkScript) {
        this.useNetworkScript = useNetworkScript;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    @Override
    public void validate(String version) throws SliderException {
        Metainfo.checkNonNull(this.getName(), "name", "dockerContainer");
        Metainfo.checkNonNull(this.getImage(), "image", "dockerContainer");
        for (DockerContainerMount dcm : this.getMounts()) {
            dcm.validate(version);
        }
        for (DockerContainerPort dcp : this.getPorts()) {
            dcp.validate(version);
        }
    }

    @JsonProperty(value="statusCommand")
    public String getStatusCommand() {
        return this.statusCommand;
    }

    @JsonProperty(value="statusCommand")
    public void setStatusCommand(String statusCommand) {
        this.statusCommand = statusCommand;
    }

    public String getCommandPath() {
        return this.commandPath;
    }

    public void setCommandPath(String commandPath) {
        this.commandPath = commandPath;
    }

    public String getAdditionalParam() {
        return this.additionalParam;
    }

    public void setAdditionalParam(String additionalParam) {
        this.additionalParam = additionalParam;
    }

    @JsonProperty(value="startCommand")
    public String getStartCommand() {
        return this.startCommand;
    }

    @JsonProperty(value="startCommand")
    public void setStartCommand(String startCommand) {
        this.startCommand = startCommand;
    }

    @JsonProperty(value="runPrivilegedContainer")
    public String getRunPrivilegedContainer() {
        return this.runPrivilegedContainer;
    }

    @JsonProperty(value="runPrivilegedContainer")
    public void setRunPrivilegedContainer(String runPrivilegedContainer) {
        this.runPrivilegedContainer = runPrivilegedContainer;
    }

    public List<ConfigFile> getConfigFiles() {
        return this.configFiles;
    }

    public void setConfigFiles(List<ConfigFile> configFiles) {
        this.configFiles = configFiles;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("DockerContainer [name=").append(this.name).append(", image=").append(this.image).append(", options=").append(this.options).append(", mounts=").append(this.mounts).append(", ports=").append(this.ports).append(", statusCommand=").append(this.statusCommand).append(", commandPath=").append(this.commandPath).append(", additionalParam=").append(this.additionalParam).append(", inputFiles=").append(this.inputFiles).append(", startCommand=").append(this.startCommand).append(", runPriviledgedContainer=").append(this.runPrivilegedContainer).append(", configFiles=").append(this.configFiles).append("]");
        return result.toString();
    }
}

