/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.slider.common.tools.SliderFileSystem;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.providers.agent.application.metadata.AbstractMetainfoParser;
import org.apache.slider.providers.agent.application.metadata.AddonPackageMetainfoParser;
import org.apache.slider.providers.agent.application.metadata.DefaultConfig;
import org.apache.slider.providers.agent.application.metadata.DefaultConfigParser;
import org.apache.slider.providers.agent.application.metadata.Metainfo;
import org.apache.slider.providers.agent.application.metadata.MetainfoParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentUtils {
    private static final Logger log = LoggerFactory.getLogger(AgentUtils.class);

    public static Metainfo getApplicationMetainfoFromSummaryFile(SliderFileSystem fileSystem, String metainfoPath, boolean metainfoForAddon) {
        FileSystem fs = fileSystem.getFileSystem();
        Path appPathXML = new Path(String.valueOf(metainfoPath) + ".metainfo.xml");
        Path appPathJson = new Path(String.valueOf(metainfoPath) + ".metainfo.json");
        Path appPathUsed = null;
        try {
            FSDataInputStream appStream = null;
            if (fs.exists(appPathXML)) {
                appPathUsed = appPathXML;
                appStream = fs.open(appPathXML);
                return AgentUtils.parseMetainfo((InputStream)appStream, metainfoForAddon, "xml");
            }
            if (fs.exists(appPathJson)) {
                appPathUsed = appPathJson;
                appStream = fs.open(appPathJson);
                return AgentUtils.parseMetainfo((InputStream)appStream, metainfoForAddon, "json");
            }
        }
        catch (IOException e) {
            log.info("Failed to get metainfo from summary file {} - {}", (Object)appPathUsed, (Object)e.getMessage());
            log.debug("Failed to get metainfo", (Throwable)e);
        }
        return null;
    }

    public static Metainfo getApplicationMetainfo(SliderFileSystem fileSystem, String metainfoPath, boolean metainfoForAddon) throws IOException, BadConfigException {
        Path appPath;
        log.info("Reading metainfo at {}", (Object)metainfoPath);
        Metainfo metainfo = AgentUtils.getApplicationMetainfoFromSummaryFile(fileSystem, metainfoPath, metainfoForAddon);
        if (metainfo != null) {
            log.info("Got metainfo from summary file");
            return metainfo;
        }
        FileSystem fs = fileSystem.getFileSystem();
        InputStream metainfoJsonStream = SliderUtils.getApplicationResourceInputStream(fs, appPath = new Path(metainfoPath), "metainfo.json");
        if (metainfoJsonStream == null) {
            InputStream metainfoXMLStream = SliderUtils.getApplicationResourceInputStream(fs, appPath, "metainfo.xml");
            if (metainfoXMLStream != null) {
                metainfo = AgentUtils.parseMetainfo(metainfoXMLStream, metainfoForAddon, "xml");
            }
        } else {
            metainfo = AgentUtils.parseMetainfo(metainfoJsonStream, metainfoForAddon, "json");
        }
        if (metainfo == null) {
            log.error("metainfo is unavailable at {}.", (Object)metainfoPath);
            throw new FileNotFoundException("metainfo.xml/json is required in app package. " + appPath);
        }
        return metainfo;
    }

    private static Metainfo parseMetainfo(InputStream stream, boolean metainfoForAddon, String type) throws IOException {
        AbstractMetainfoParser metainfoParser = null;
        metainfoParser = metainfoForAddon ? new AddonPackageMetainfoParser() : new MetainfoParser();
        if (type.equals("xml")) {
            return metainfoParser.fromXmlStream(stream);
        }
        if (type.equals("json")) {
            return metainfoParser.fromJsonStream(stream);
        }
        return null;
    }

    static DefaultConfig getDefaultConfig(SliderFileSystem fileSystem, String appDef, String configFileName) throws IOException {
        String fileToRead = "configuration/" + configFileName;
        log.info("Reading default config file {} at {}", (Object)fileToRead, (Object)appDef);
        InputStream configStream = SliderUtils.getApplicationResourceInputStream(fileSystem.getFileSystem(), new Path(appDef), fileToRead);
        if (configStream == null) {
            log.error("{} is unavailable at {}.", (Object)fileToRead, (Object)appDef);
            throw new IOException("Expected config file " + fileToRead + " is not available.");
        }
        return new DefaultConfigParser().parse(configStream);
    }

    static String getMetainfoComponentName(String roleGroup, ConfTreeOperations appConf) throws BadConfigException {
        String prefix = appConf.getComponentOpt(roleGroup, "role.prefix", null);
        if (prefix == null) {
            return roleGroup;
        }
        if (!roleGroup.startsWith(prefix)) {
            throw new BadConfigException("Component " + roleGroup + " doesn't start" + " with prefix " + prefix);
        }
        return roleGroup.substring(prefix.length());
    }
}

