/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.slider.api.ClusterDescription;
import org.apache.slider.api.ClusterNode;
import org.apache.slider.common.SliderKeys;
import org.apache.slider.common.tools.MapRSecurityUtil;
import org.apache.slider.common.tools.SliderFileSystem;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.core.exceptions.NoSuchNodeException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.launch.CommandLineBuilder;
import org.apache.slider.core.launch.ContainerLauncher;
import org.apache.slider.core.registry.docstore.ConfigFormat;
import org.apache.slider.core.registry.docstore.ConfigUtils;
import org.apache.slider.core.registry.docstore.ExportEntry;
import org.apache.slider.core.registry.docstore.PublishedConfiguration;
import org.apache.slider.core.registry.docstore.PublishedConfigurationOutputter;
import org.apache.slider.core.registry.docstore.PublishedExports;
import org.apache.slider.providers.AbstractProviderService;
import org.apache.slider.providers.MonitorDetail;
import org.apache.slider.providers.ProviderCore;
import org.apache.slider.providers.ProviderRole;
import org.apache.slider.providers.ProviderUtils;
import org.apache.slider.providers.agent.AgentClientProvider;
import org.apache.slider.providers.agent.AgentKeys;
import org.apache.slider.providers.agent.AgentLaunchParameter;
import org.apache.slider.providers.agent.AgentRoles;
import org.apache.slider.providers.agent.AgentUtils;
import org.apache.slider.providers.agent.Command;
import org.apache.slider.providers.agent.CommandResult;
import org.apache.slider.providers.agent.ComponentCommandOrder;
import org.apache.slider.providers.agent.ComponentInstanceState;
import org.apache.slider.providers.agent.ComponentTagProvider;
import org.apache.slider.providers.agent.HeartbeatMonitor;
import org.apache.slider.providers.agent.State;
import org.apache.slider.providers.agent.application.metadata.AbstractComponent;
import org.apache.slider.providers.agent.application.metadata.Application;
import org.apache.slider.providers.agent.application.metadata.CommandOrder;
import org.apache.slider.providers.agent.application.metadata.CommandScript;
import org.apache.slider.providers.agent.application.metadata.Component;
import org.apache.slider.providers.agent.application.metadata.ComponentCommand;
import org.apache.slider.providers.agent.application.metadata.ComponentExport;
import org.apache.slider.providers.agent.application.metadata.ComponentsInAddonPackage;
import org.apache.slider.providers.agent.application.metadata.ConfigFile;
import org.apache.slider.providers.agent.application.metadata.DefaultConfig;
import org.apache.slider.providers.agent.application.metadata.DockerContainer;
import org.apache.slider.providers.agent.application.metadata.Export;
import org.apache.slider.providers.agent.application.metadata.ExportGroup;
import org.apache.slider.providers.agent.application.metadata.Metainfo;
import org.apache.slider.providers.agent.application.metadata.OSPackage;
import org.apache.slider.providers.agent.application.metadata.OSSpecific;
import org.apache.slider.providers.agent.application.metadata.Package;
import org.apache.slider.providers.agent.application.metadata.PropertyInfo;
import org.apache.slider.server.appmaster.actions.ProviderReportedContainerLoss;
import org.apache.slider.server.appmaster.actions.RegisterComponentInstance;
import org.apache.slider.server.appmaster.state.ContainerPriority;
import org.apache.slider.server.appmaster.state.RoleInstance;
import org.apache.slider.server.appmaster.state.StateAccessForProviders;
import org.apache.slider.server.appmaster.web.rest.agent.AgentCommandType;
import org.apache.slider.server.appmaster.web.rest.agent.AgentRestOperations;
import org.apache.slider.server.appmaster.web.rest.agent.CommandReport;
import org.apache.slider.server.appmaster.web.rest.agent.ComponentStatus;
import org.apache.slider.server.appmaster.web.rest.agent.ExecutionCommand;
import org.apache.slider.server.appmaster.web.rest.agent.HeartBeat;
import org.apache.slider.server.appmaster.web.rest.agent.HeartBeatResponse;
import org.apache.slider.server.appmaster.web.rest.agent.Register;
import org.apache.slider.server.appmaster.web.rest.agent.RegistrationResponse;
import org.apache.slider.server.appmaster.web.rest.agent.RegistrationStatus;
import org.apache.slider.server.appmaster.web.rest.agent.StatusCommand;
import org.apache.slider.server.services.security.CertificateManager;
import org.apache.slider.server.services.security.SecurityStore;
import org.apache.slider.server.services.security.StoresGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentProviderService
extends AbstractProviderService
implements ProviderCore,
AgentKeys,
SliderKeys,
AgentRestOperations {
    protected static final Logger log = LoggerFactory.getLogger(AgentProviderService.class);
    private static final ProviderUtils providerUtils = new ProviderUtils(log);
    private static final String LABEL_MAKER = "___";
    private static final String CONTAINER_ID = "container_id";
    private static final String GLOBAL_CONFIG_TAG = "global";
    private static final String LOG_FOLDERS_TAG = "LogFolders";
    private static final String HOST_FOLDER_FORMAT = "%s:%s";
    private static final String CONTAINER_LOGS_TAG = "container_log_dirs";
    private static final String CONTAINER_PWDS_TAG = "container_work_dirs";
    private static final String COMPONENT_TAG = "component";
    private static final String APPLICATION_TAG = "application";
    private static final String COMPONENT_DATA_TAG = "ComponentInstanceData";
    private static final String SHARED_PORT_TAG = "SHARED";
    private static final String PER_CONTAINER_TAG = "{PER_CONTAINER}";
    private static final int MAX_LOG_ENTRIES = 40;
    private static final int DEFAULT_HEARTBEAT_MONITOR_INTERVAL = 60000;
    private final Object syncLock = new Object();
    private final ComponentTagProvider tags = new ComponentTagProvider();
    private int heartbeatMonitorInterval = 0;
    private int heartbeatLostInterval = 0;
    private AgentClientProvider clientProvider;
    private AtomicInteger taskId = new AtomicInteger(0);
    private volatile Map<String, MetainfoHolder> metaInfoMap = new HashMap<String, MetainfoHolder>();
    private SliderFileSystem fileSystem = null;
    private Map<String, DefaultConfig> defaultConfigs = null;
    private ComponentCommandOrder commandOrder = new ComponentCommandOrder();
    private HeartbeatMonitor monitor;
    private Boolean canAnyMasterPublish = null;
    private AgentLaunchParameter agentLaunchParameter = null;
    private String clusterName = null;
    private boolean isInUpgradeMode;
    private Set<String> upgradeContainers = new HashSet<String>();
    private boolean appStopInitiated;
    private final Map<String, ComponentInstanceState> componentStatuses = new ConcurrentHashMap<String, ComponentInstanceState>();
    private final Map<String, Map<String, String>> componentInstanceData = new ConcurrentHashMap<String, Map<String, String>>();
    private final Map<String, Map<String, List<ExportEntry>>> exportGroups = new ConcurrentHashMap<String, Map<String, List<ExportEntry>>>();
    private final Map<String, Map<String, String>> allocatedPorts = new ConcurrentHashMap<String, Map<String, String>>();
    private final Map<String, Metainfo> packageMetainfo = new ConcurrentHashMap<String, Metainfo>();
    private final Map<String, ExportEntry> logFolderExports = Collections.synchronizedMap(new LinkedHashMap<String, ExportEntry>(40, 0.75f, false){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 40;
        }
    });
    private final Map<String, ExportEntry> workFolderExports = Collections.synchronizedMap(new LinkedHashMap<String, ExportEntry>(40, 0.75f, false){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 40;
        }
    });
    private final Map<String, Set<String>> containerExportsMap = new HashMap<String, Set<String>>();

    public AgentProviderService() {
        super("AgentProviderService");
        this.setAgentRestOperations(this);
        this.setHeartbeatMonitorInterval(60000);
        this.setHeartbeatLostInterval(0x6DDD00);
    }

    @Override
    public String getHumanName() {
        return "Slider Agent";
    }

    @Override
    public List<ProviderRole> getRoles() {
        return AgentRoles.getRoles();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.clientProvider = new AgentClientProvider(conf);
    }

    @Override
    public Configuration loadProviderConfigurationInformation(File confDir) throws BadCommandArgumentsException, IOException {
        return new Configuration(false);
    }

    @Override
    public void validateInstanceDefinition(AggregateConf instanceDefinition) throws SliderException {
        this.clientProvider.validateInstanceDefinition(instanceDefinition, null);
        ConfTreeOperations resources = instanceDefinition.getResourceOperations();
        Set<String> names = resources.getComponentNames();
        names.remove("slider-appmaster");
        for (String name : names) {
            Component componentDef = this.getApplicationComponent(name);
            if (componentDef == null) continue;
            MapOperations componentConfig = resources.getMandatoryComponent(name);
            int count = componentConfig.getMandatoryOptionInt("yarn.component.instances");
            int definedMinCount = componentDef.getMinInstanceCountInt();
            int definedMaxCount = componentDef.getMaxInstanceCountInt();
            if (count >= definedMinCount && count <= definedMaxCount) continue;
            throw new BadConfigException("Component %s, %s value %d out of range. Expected minimum is %d and maximum is %d", name, "yarn.component.instances", count, definedMinCount, definedMaxCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildMetainfo(AggregateConf instanceDefinition, SliderFileSystem fileSystem, String roleGroup) throws IOException, SliderException {
        MetainfoHolder metaInfoHolder;
        String mapKey = instanceDefinition.getAppConfOperations().getComponentOpt(roleGroup, "role.prefix", "DEFAULT_KEY");
        String appDef = SliderUtils.getApplicationDefinitionPath(instanceDefinition.getAppConfOperations(), roleGroup);
        MapOperations component = null;
        if (roleGroup != null) {
            component = instanceDefinition.getAppConfOperations().getComponent(roleGroup);
        }
        if ((metaInfoHolder = this.metaInfoMap.get(mapKey)) == null) {
            Object object = this.syncLock;
            synchronized (object) {
                if (this.fileSystem == null) {
                    this.fileSystem = fileSystem;
                }
                if ((metaInfoHolder = this.metaInfoMap.get(mapKey)) == null) {
                    this.readAndSetHeartbeatMonitoringInterval(instanceDefinition);
                    this.initializeAgentDebugCommands(instanceDefinition);
                    Metainfo metaInfo = this.getApplicationMetainfo(fileSystem, appDef, false);
                    log.info("Master package metainfo: {}", (Object)metaInfo.toString());
                    if (metaInfo == null || metaInfo.getApplication() == null) {
                        log.error("metainfo.xml is unavailable or malformed at {}.", (Object)appDef);
                        throw new SliderException("metainfo.xml is required in app package.");
                    }
                    List<CommandOrder> commandOrders = metaInfo.getApplication().getCommandOrders();
                    if (!"DEFAULT_KEY".equals(mapKey)) {
                        for (Component comp : metaInfo.getApplication().getComponents()) {
                            comp.setName(String.valueOf(mapKey) + comp.getName());
                            log.info("Modifying external metainfo component name to {}", (Object)comp.getName());
                        }
                        for (CommandOrder co : commandOrders) {
                            log.info("Adding prefix {} to command order {}", (Object)mapKey, (Object)co);
                            co.setCommand(String.valueOf(mapKey) + co.getCommand());
                            co.setRequires(String.valueOf(mapKey) + co.getRequires());
                        }
                    }
                    log.debug("Merging command orders {} for {}", commandOrders, (Object)roleGroup);
                    this.commandOrder.mergeCommandOrders(commandOrders, instanceDefinition.getResourceOperations());
                    Map<String, DefaultConfig> defaultConfigs = this.initializeDefaultConfigs(fileSystem, appDef, metaInfo);
                    this.metaInfoMap.put(mapKey, new MetainfoHolder(metaInfo, defaultConfigs));
                    this.monitor = new HeartbeatMonitor(this, this.getHeartbeatMonitorInterval(), this.getHeartbeatLostInterval());
                    this.monitor.start();
                    String addonAppDefString = instanceDefinition.getAppConfOperations().getGlobalOptions().getOption("application.addons", null);
                    if (component != null) {
                        addonAppDefString = component.getOption("application.addons", addonAppDefString);
                    }
                    log.debug("All addon appdefs: {}", (Object)addonAppDefString);
                    if (addonAppDefString != null) {
                        Scanner scanner = new Scanner(addonAppDefString).useDelimiter(",");
                        while (scanner.hasNext()) {
                            String addonAppDef = scanner.next();
                            String addonAppDefPath = instanceDefinition.getAppConfOperations().getGlobalOptions().get(addonAppDef);
                            if (component != null) {
                                addonAppDefPath = component.getOption(addonAppDef, addonAppDefPath);
                            }
                            log.debug("Addon package {} is stored at: {}", (Object)(String.valueOf(addonAppDef) + addonAppDefPath));
                            Metainfo addonMetaInfo = this.getApplicationMetainfo(fileSystem, addonAppDefPath, true);
                            addonMetaInfo.validate();
                            this.packageMetainfo.put(addonMetaInfo.getApplicationPackage().getName(), addonMetaInfo);
                        }
                        log.info("Metainfo map for master and addon: {}", (Object)this.packageMetainfo.toString());
                    }
                }
            }
        }
    }

    @Override
    public void initializeApplicationConfiguration(AggregateConf instanceDefinition, SliderFileSystem fileSystem, String roleGroup) throws IOException, SliderException {
        this.buildMetainfo(instanceDefinition, fileSystem, roleGroup);
    }

    @Override
    public void buildContainerLaunchContext(ContainerLauncher launcher, AggregateConf instanceDefinition, Container container, ProviderRole providerRole, SliderFileSystem fileSystem, Path generatedConfPath, MapOperations resourceComponent, MapOperations appComponent, Path containerTmpDirPath) throws IOException, SliderException {
        String addonAppDefPath22;
        Object addonAppDef;
        MapOperations compOps;
        MapOperations amComponent;
        boolean twoWayEnabled;
        String agentVer;
        String roleName = providerRole.name;
        String roleGroup = providerRole.group;
        String appDef = SliderUtils.getApplicationDefinitionPath(instanceDefinition.getAppConfOperations(), roleGroup);
        this.initializeApplicationConfiguration(instanceDefinition, fileSystem, roleGroup);
        log.info("Build launch context for Agent");
        log.debug(instanceDefinition.toString());
        if (this.isYarnDockerContainer(roleGroup)) {
            launcher.setYarnDockerMode(true);
            launcher.setDockerImage(this.getConfigFromMetaInfo(roleGroup, "image"));
            launcher.setRunPrivilegedContainer(this.getConfigFromMetaInfo(roleGroup, "runPriviledgedContainer"));
            launcher.setYarnContainerMountPoints(this.getConfigFromMetaInfoWithAppConfigOverriding(roleGroup, "yarn.container.mount.points"));
        }
        launcher.putEnv(SliderUtils.buildEnvMap(appComponent, this.getStandardTokenMap(this.getAmState().getAppConfSnapshot(), roleName, roleGroup)));
        String workDir = ApplicationConstants.Environment.PWD.$();
        launcher.setEnv("AGENT_WORK_ROOT", workDir);
        log.info("AGENT_WORK_ROOT set to {}", (Object)workDir);
        String logDir = "<LOG_DIR>";
        launcher.setEnv("AGENT_LOG_ROOT", logDir);
        log.info("AGENT_LOG_ROOT set to {}", (Object)logDir);
        if (System.getenv("HADOOP_USER_NAME") != null) {
            launcher.setEnv("HADOOP_USER_NAME", System.getenv("HADOOP_USER_NAME"));
        }
        launcher.setEnv("SLIDER_PASSPHRASE", instanceDefinition.getPassphrase());
        launcher.setEnv("LANG", "en_US.UTF-8");
        launcher.setEnv("LC_ALL", "en_US.UTF-8");
        launcher.setEnv("LANGUAGE", "en_US.UTF-8");
        String scriptPath = new File("./infra/agent/slider-agent/", "agent/main.py").getPath();
        String appHome = instanceDefinition.getAppConfOperations().getGlobalOptions().get("agent.package.root");
        if (SliderUtils.isSet(appHome)) {
            scriptPath = new File(appHome, "agent/main.py").getPath();
        }
        ArrayList<String> pythonPaths = new ArrayList<String>();
        pythonPaths.add("./infra/agent/slider-agent/");
        pythonPaths.add("./infra/agent/slider-agent/jinja2");
        String pythonPath = StringUtils.join((CharSequence)File.pathSeparator, pythonPaths);
        launcher.setEnv("PYTHONPATH", pythonPath);
        log.info("PYTHONPATH set to {}", (Object)pythonPath);
        Path agentImagePath = null;
        String agentImage = instanceDefinition.getInternalOperations().get("internal.application.image.path");
        agentImagePath = SliderUtils.isUnset(agentImage) ? new Path(new Path(new Path(instanceDefinition.getInternalOperations().get("internal.tmp.dir"), container.getId().getApplicationAttemptId().getApplicationId().toString()), "agent"), "slider-agent.tar.gz") : new Path(agentImage);
        if (fileSystem.getFileSystem().exists(agentImagePath)) {
            LocalResource agentImageRes = fileSystem.createAmResource(agentImagePath, LocalResourceType.ARCHIVE);
            launcher.addLocalResource("infra/agent", agentImageRes);
        } else {
            String msg = String.format("Required agent image slider-agent.tar.gz is unavailable at %s", agentImagePath.toString());
            MapOperations compOps2 = appComponent;
            boolean relaxVerificationForTest = compOps2 != null ? Boolean.valueOf(compOps2.getOptionBool("test.relax.validation", false)) : false;
            log.error(msg);
            if (!relaxVerificationForTest) {
                throw new SliderException(72, msg);
            }
        }
        log.info("Using {} for agent.", (Object)scriptPath);
        LocalResource appDefRes = fileSystem.createAmResource(fileSystem.getFileSystem().resolvePath(new Path(appDef)), LocalResourceType.ARCHIVE);
        launcher.addLocalResource("app/definition", appDefRes);
        for (Package pkg : this.getMetaInfo(roleGroup).getApplication().getPackages()) {
            Path pkgPath = fileSystem.buildResourcePath(pkg.getName());
            if (!fileSystem.isFile(pkgPath)) {
                pkgPath = fileSystem.buildResourcePath(this.getClusterName(), pkg.getName());
            }
            if (!fileSystem.isFile(pkgPath)) {
                throw new IOException("Package doesn't exist as a resource: " + pkg.getName());
            }
            log.info("Adding resource {}", (Object)pkg.getName());
            LocalResourceType type = LocalResourceType.FILE;
            if ("archive".equals(pkg.getType())) {
                type = LocalResourceType.ARCHIVE;
            }
            LocalResource packageResource = fileSystem.createAmResource(pkgPath, type);
            launcher.addLocalResource("app/packages", packageResource);
        }
        String agentConf = instanceDefinition.getAppConfOperations().getGlobalOptions().getOption("agent.conf", "");
        if (SliderUtils.isSet(agentConf)) {
            LocalResource agentConfRes = fileSystem.createAmResource(fileSystem.getFileSystem().resolvePath(new Path(agentConf)), LocalResourceType.FILE);
            launcher.addLocalResource("infra/conf/agent.ini", agentConfRes);
        }
        if ((agentVer = instanceDefinition.getAppConfOperations().getGlobalOptions().getOption("agent.version", null)) != null) {
            LocalResource agentVerRes = fileSystem.createAmResource(fileSystem.getFileSystem().resolvePath(new Path(agentVer)), LocalResourceType.FILE);
            launcher.addLocalResource("infra/version", agentVerRes);
        }
        if (MapRSecurityUtil.isKerberosEnabled()) {
            this.localizeServiceKeytabs(launcher, instanceDefinition, fileSystem);
        }
        boolean bl = twoWayEnabled = (amComponent = instanceDefinition.getAppConfOperations().getComponent("slider-appmaster")) != null ? Boolean.valueOf(amComponent.getOptionBool("ssl.server.client.auth", false)) : false;
        if (twoWayEnabled) {
            this.localizeContainerSSLResources(launcher, container, fileSystem);
        }
        if (this.areStoresRequested(compOps = appComponent)) {
            this.localizeContainerSecurityStores(launcher, container, roleName, fileSystem, instanceDefinition, compOps);
        }
        launcher.addLocalResources(fileSystem.submitDirectory(generatedConfPath, "propagatedconf"));
        if (appComponent.getOptionBool("am.config.generation", false).booleanValue()) {
            Map<String, Map<String, String>> configurations = this.buildCommandConfigurations(instanceDefinition.getAppConfOperations(), container.getId().toString(), roleName, roleGroup);
            this.localizeConfigFiles(launcher, roleName, roleGroup, this.getMetaInfo(roleGroup), configurations, launcher.getEnv(), fileSystem, instanceDefinition.getAppConfOperations());
        }
        String label = this.getContainerLabel(container, roleName, roleGroup);
        CommandLineBuilder operation = new CommandLineBuilder();
        String pythonExec = instanceDefinition.getAppConfOperations().getGlobalOptions().getOption("agent.python.exec.path", "python");
        operation.add(pythonExec);
        operation.add(scriptPath);
        operation.add("--label", label);
        operation.add("--zk-quorum");
        operation.add(this.getClusterOptionPropertyValue("zookeeper.quorum"));
        operation.add("--zk-reg-path");
        operation.add(this.getZkRegistryPath());
        String debugCmd = this.agentLaunchParameter.getNextLaunchParameter(roleGroup);
        if (SliderUtils.isSet(debugCmd)) {
            operation.add("--debug");
            operation.add(debugCmd);
        }
        operation.add("> <LOG_DIR>/slider-agent.out 2>&1");
        launcher.addCommand(operation.build());
        String addonAppDefString = instanceDefinition.getAppConfOperations().getGlobalOptions().getOption("application.addons", null);
        log.debug("All addon appdefs: {}", (Object)addonAppDefString);
        if (addonAppDefString != null) {
            Scanner scanner = new Scanner(addonAppDefString).useDelimiter(",");
            while (scanner.hasNext()) {
                addonAppDef = scanner.next();
                addonAppDefPath22 = instanceDefinition.getAppConfOperations().getGlobalOptions().get(addonAppDef);
                log.debug("Addon package {} is stored at: {}", addonAppDef, (Object)addonAppDefPath22);
                LocalResource addonPkgRes = fileSystem.createAmResource(fileSystem.getFileSystem().resolvePath(new Path(addonAppDefPath22)), LocalResourceType.ARCHIVE);
                launcher.addLocalResource("addon/definition/" + (String)addonAppDef, addonPkgRes);
            }
            log.debug("Metainfo map for master and addon: {}", (Object)this.packageMetainfo.toString());
        }
        String appResourcesString = instanceDefinition.getAppConfOperations().getGlobalOptions().getOption("application.resources", null);
        log.info("Configuration value for extra resources to localize: {}", (Object)appResourcesString);
        if (appResourcesString != null) {
            addonAppDef = null;
            addonAppDefPath22 = null;
            try (Scanner scanner = new Scanner(appResourcesString).useDelimiter(",");){
                while (scanner.hasNext()) {
                    String resource = scanner.next();
                    Path resourcePath = new Path(resource);
                    LocalResource extraResource = fileSystem.createAmResource(fileSystem.getFileSystem().resolvePath(resourcePath), LocalResourceType.FILE);
                    String destination = "app/resources/" + resourcePath.getName();
                    log.info("Localizing {} to {}", (Object)resourcePath, (Object)destination);
                    launcher.addLocalResource(destination, extraResource);
                }
            }
            catch (Throwable addonAppDefPath22) {
                if (addonAppDef == null) {
                    addonAppDef = addonAppDefPath22;
                } else if (addonAppDef != addonAppDefPath22) {
                    ((Throwable)addonAppDef).addSuppressed(addonAppDefPath22);
                }
                throw addonAppDef;
            }
        }
        TreeMap<String, State> pkgStatuses = new TreeMap<String, State>();
        for (Metainfo appPkg : this.packageMetainfo.values()) {
            for (ComponentsInAddonPackage comp : appPkg.getApplicationPackage().getComponents()) {
                log.debug("Current component: {} component in metainfo: {}", (Object)roleName, (Object)comp.getName());
                if (!comp.getName().equals(roleGroup) && !comp.getName().equals("ALL")) continue;
                pkgStatuses.put(appPkg.getApplicationPackage().getName(), State.INIT);
            }
        }
        log.debug("For component: {} pkg status map: {}", (Object)roleName, (Object)((Object)pkgStatuses).toString());
        this.getComponentStatuses().put(label, new ComponentInstanceState(roleGroup, container.getId(), this.getClusterInfoPropertyValue("application.name"), pkgStatuses));
    }

    private void localizeContainerSecurityStores(ContainerLauncher launcher, Container container, String role, SliderFileSystem fileSystem, AggregateConf instanceDefinition, MapOperations compOps) throws SliderException, IOException {
        SecurityStore[] stores;
        HashMap<String, List<String>> newcred = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : instanceDefinition.getAppConf().credentials.entrySet()) {
            ArrayList<String> resultList = new ArrayList<String>();
            for (String v : entry.getValue()) {
                resultList.add(v.replaceAll(Pattern.quote("${CLUSTER_NAME}"), this.clusterName).replaceAll(Pattern.quote("${CLUSTER}"), this.clusterName));
            }
            newcred.put(entry.getKey().replaceAll(Pattern.quote("${CLUSTER_NAME}"), this.clusterName).replaceAll(Pattern.quote("${CLUSTER}"), this.clusterName), resultList);
        }
        instanceDefinition.getAppConf().credentials = newcred;
        SecurityStore[] securityStoreArray = stores = this.generateSecurityStores(container, role, instanceDefinition, compOps);
        int n = stores.length;
        int n2 = 0;
        while (n2 < n) {
            SecurityStore store = securityStoreArray[n2];
            LocalResource keystoreResource = fileSystem.createAmResource(this.uploadSecurityResource(store.getFile(), fileSystem), LocalResourceType.FILE);
            launcher.addLocalResource(String.format("secstores/%s-%s.p12", store.getType(), role), keystoreResource);
            ++n2;
        }
    }

    private SecurityStore[] generateSecurityStores(Container container, String role, AggregateConf instanceDefinition, MapOperations compOps) throws SliderException, IOException {
        return StoresGenerator.generateSecurityStores(container.getNodeId().getHost(), container.getId().toString(), role, instanceDefinition, compOps);
    }

    private boolean areStoresRequested(MapOperations compOps) {
        return compOps != null ? compOps.getOptionBool("slider.component.security.stores.required", false) : false;
    }

    private void localizeContainerSSLResources(ContainerLauncher launcher, Container container, SliderFileSystem fileSystem) throws SliderException {
        try {
            Path certsDir = fileSystem.buildClusterSecurityDirPath(this.getClusterName());
            LocalResource certResource = fileSystem.createAmResource(new Path(certsDir, "ca.crt"), LocalResourceType.FILE);
            launcher.addLocalResource("infra/run/security/ca.crt", certResource);
            CertificateManager certMgr = new CertificateManager();
            String hostname = container.getNodeId().getHost();
            String containerId = container.getId().toString();
            certMgr.generateContainerCertificate(hostname, containerId);
            LocalResource agentCertResource = fileSystem.createAmResource(this.uploadSecurityResource(CertificateManager.getAgentCertficateFilePath(containerId), fileSystem), LocalResourceType.FILE);
            launcher.addLocalResource("infra/run/security/" + hostname + ".crt", agentCertResource);
            LocalResource agentKeyResource = fileSystem.createAmResource(this.uploadSecurityResource(CertificateManager.getAgentKeyFilePath(containerId), fileSystem), LocalResourceType.FILE);
            launcher.addLocalResource("infra/run/security/" + hostname + ".key", agentKeyResource);
        }
        catch (Exception e) {
            throw new SliderException(72, e, "Unable to localize certificates.  Two-way SSL cannot be enabled", new Object[0]);
        }
    }

    private Path uploadSecurityResource(File resource, SliderFileSystem fileSystem) throws IOException {
        Path certsDir = fileSystem.buildClusterSecurityDirPath(this.getClusterName());
        return AgentProviderService.uploadResource(resource, fileSystem, certsDir);
    }

    private Path uploadResource(File resource, SliderFileSystem fileSystem, String roleName) throws IOException {
        Path dir = roleName == null ? fileSystem.buildClusterResourcePath(this.getClusterName()) : fileSystem.buildClusterResourcePath(this.getClusterName(), roleName);
        return AgentProviderService.uploadResource(resource, fileSystem, dir);
    }

    private static synchronized Path uploadResource(File resource, SliderFileSystem fileSystem, Path parentDir) throws IOException {
        if (!fileSystem.getFileSystem().exists(parentDir)) {
            fileSystem.getFileSystem().mkdirs(parentDir, new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE));
        }
        Path destPath = new Path(parentDir, resource.getName());
        if (!fileSystem.getFileSystem().exists(destPath)) {
            FSDataOutputStream os = null;
            try {
                os = fileSystem.getFileSystem().create(destPath);
                byte[] contents = FileUtils.readFileToByteArray((File)resource);
                os.write(contents, 0, contents.length);
                os.flush();
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(os);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)os);
            log.info("Uploaded {} to localization path {}", (Object)resource, (Object)destPath);
        } else {
            log.info("Resource {} already existed at localization path {}", (Object)resource, (Object)destPath);
        }
        while (!fileSystem.getFileSystem().exists(destPath)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        fileSystem.getFileSystem().setPermission(destPath, new FsPermission(FsAction.READ, FsAction.NONE, FsAction.NONE));
        return destPath;
    }

    private void localizeServiceKeytabs(ContainerLauncher launcher, AggregateConf instanceDefinition, SliderFileSystem fileSystem) throws IOException {
        String keytabPathOnHost = instanceDefinition.getAppConfOperations().getComponent("slider-appmaster").get("slider.am.keytab.local.path");
        if (SliderUtils.isUnset(keytabPathOnHost)) {
            String amKeytabName = instanceDefinition.getAppConfOperations().getComponent("slider-appmaster").get("slider.am.login.keytab.name");
            String keytabDir = instanceDefinition.getAppConfOperations().getComponent("slider-appmaster").get("slider.hdfs.keytab.dir");
            Path keytabDirPath = fileSystem.buildKeytabPath(keytabDir, null, this.getClusterName());
            boolean serviceKeytabsDeployed = false;
            if (fileSystem.getFileSystem().exists(keytabDirPath)) {
                FileStatus[] keytabs;
                FileStatus[] fileStatusArray = keytabs = fileSystem.getFileSystem().listStatus(keytabDirPath);
                int n = keytabs.length;
                int n2 = 0;
                while (n2 < n) {
                    FileStatus keytab = fileStatusArray[n2];
                    if (!amKeytabName.equals(keytab.getPath().getName()) && keytab.getPath().getName().endsWith(".keytab")) {
                        serviceKeytabsDeployed = true;
                        log.info("Localizing keytab {}", (Object)keytab.getPath().getName());
                        LocalResource keytabRes = fileSystem.createAmResource(keytab.getPath(), LocalResourceType.FILE);
                        launcher.addLocalResource("keytabs/" + keytab.getPath().getName(), keytabRes);
                    }
                    ++n2;
                }
            }
            if (!serviceKeytabsDeployed) {
                log.warn("No service keytabs for the application have been localized.  If the application requires keytabs for secure operation, please ensure that the required keytabs have been uploaded to the folder {}", (Object)keytabDirPath);
            }
        }
    }

    private synchronized void createConfigFile(SliderFileSystem fileSystem, File file, ConfigFile configFile, Map<String, String> config) throws IOException {
        ConfigFormat configFormat = ConfigFormat.resolve(configFile.getType());
        if (file.exists()) {
            log.info("Skipping writing {} file {} because it already exists", (Object)configFormat, (Object)file);
            return;
        }
        log.info("Writing {} file {}", (Object)configFormat, (Object)file);
        ConfigUtils.prepConfigForTemplateOutputter(configFormat, config, fileSystem, this.getClusterName(), file.getName());
        PublishedConfiguration publishedConfiguration = new PublishedConfiguration(configFile.getDictionaryName(), config.entrySet());
        PublishedConfigurationOutputter configurationOutputter = PublishedConfigurationOutputter.createOutputter(configFormat, publishedConfiguration);
        configurationOutputter.save(file);
    }

    @VisibleForTesting
    protected void localizeConfigFiles(ContainerLauncher launcher, String roleName, String roleGroup, Metainfo metainfo, Map<String, Map<String, String>> configs, MapOperations env, SliderFileSystem fileSystem, ConfTreeOperations appConf) throws IOException {
        for (ConfigFile configFile : metainfo.getComponentConfigFiles(roleGroup)) {
            Map<String, String> config = ConfigUtils.replacePropsInConfig(configs.get(configFile.getDictionaryName()), env.options);
            String fileName = ConfigUtils.replaceProps(config, configFile.getFileName());
            File localFile = new File("resources");
            if (!(localFile.exists() || localFile.mkdir() || localFile.exists())) {
                throw new IOException("resources could not be created!");
            }
            boolean perComponent = appConf.getComponentOptBool(roleGroup, "conf." + configFile.getDictionaryName() + ".per.component", false);
            boolean perGroup = appConf.getComponentOptBool(roleGroup, "conf." + configFile.getDictionaryName() + ".per.group", false);
            String folder = null;
            if (perComponent) {
                folder = roleName;
            } else if (perGroup) {
                folder = roleGroup;
            }
            if (!(folder == null || (localFile = new File(localFile, folder)).exists() || localFile.mkdir() || localFile.exists())) {
                throw new IOException(localFile + " could not be created!");
            }
            localFile = new File(localFile, new File(fileName).getName());
            log.info("Localizing {} configs to config file {} (destination {}) based on {} configs", new Object[]{config.size(), localFile, fileName, configFile.getDictionaryName()});
            if (!localFile.exists()) {
                this.createConfigFile(fileSystem, localFile, configFile, config);
            } else {
                log.info("Local {} file {} already exists", (Object)configFile.getType(), (Object)localFile);
            }
            Path destPath = this.uploadResource(localFile, fileSystem, folder);
            LocalResource configResource = fileSystem.createAmResource(destPath, LocalResourceType.FILE);
            File destFile = new File(fileName);
            if (destFile.isAbsolute()) {
                launcher.addLocalResource("resources/" + destFile.getName(), configResource, fileName);
                continue;
            }
            launcher.addLocalResource("app/conf/" + fileName, configResource);
        }
    }

    private String getZkRegistryPath() {
        Preconditions.checkNotNull((Object)this.yarnRegistry, (Object)"Yarn registry not bound");
        String path = this.yarnRegistry.getAbsoluteSelfRegistrationPath();
        Preconditions.checkNotNull((Object)path, (Object)"Service record path not defined");
        return path;
    }

    @Override
    public void rebuildContainerDetails(List<Container> liveContainers, String applicationId, Map<Integer, ProviderRole> providerRoleMap) {
        for (Container container : liveContainers) {
            ProviderRole role = providerRoleMap.get(ContainerPriority.extractRole(container));
            if (role != null) {
                String roleName = role.name;
                String roleGroup = role.group;
                String label = this.getContainerLabel(container, roleName, roleGroup);
                log.info("Rebuilding in-memory: container {} in role {} in cluster {}", new Object[]{container.getId(), roleName, applicationId});
                this.getComponentStatuses().put(label, new ComponentInstanceState(roleGroup, container.getId(), applicationId));
                continue;
            }
            log.warn("Role not found for container {} in cluster {}", (Object)container.getId(), (Object)applicationId);
        }
    }

    @Override
    public boolean isSupportedRole(String role) {
        return true;
    }

    @Override
    public RegistrationResponse handleRegistration(Register registration) {
        log.info("Handling registration: {}", (Object)registration);
        RegistrationResponse response = new RegistrationResponse();
        String label = registration.getLabel();
        String pkg = registration.getPkg();
        State agentState = registration.getActualState();
        String appVersion = registration.getAppVersion();
        log.info("label: {} pkg: {}", (Object)label, (Object)pkg);
        if (this.getComponentStatuses().containsKey(label)) {
            Map<String, String> folders;
            response.setResponseStatus(RegistrationStatus.OK);
            ComponentInstanceState componentStatus = this.getComponentStatuses().get(label);
            componentStatus.heartbeat(System.currentTimeMillis());
            this.updateComponentStatusWithAgentState(componentStatus, agentState);
            String roleName = this.getRoleName(label);
            String roleGroup = this.getRoleGroup(label);
            String containerId = this.getContainerId(label);
            if (SliderUtils.isSet(registration.getTags())) {
                this.tags.recordAssignedTag(roleName, containerId, registration.getTags());
            } else {
                response.setTags(this.tags.getTag(roleName, containerId));
            }
            String hostFqdn = registration.getPublicHostname();
            Map<String, String> ports = registration.getAllocatedPorts();
            if (ports != null && !ports.isEmpty()) {
                this.processAllocatedPorts(hostFqdn, roleName, roleGroup, containerId, ports);
            }
            if ((folders = registration.getLogFolders()) != null && !folders.isEmpty()) {
                this.publishFolderPaths(folders, containerId, roleName, hostFqdn);
            }
            this.checkAndSetContainerAppVersion(containerId, appVersion);
        } else {
            response.setResponseStatus(RegistrationStatus.FAILED);
            response.setLog("Label not recognized.");
            log.warn("Received registration request from unknown label {}", (Object)label);
        }
        log.info("Registration response: {}", (Object)response);
        return response;
    }

    private void checkAndSetContainerAppVersion(String containerId, String appVersion) {
        StateAccessForProviders amState = this.getAmState();
        try {
            RoleInstance role = amState.getOwnedContainer(containerId);
            if (role != null) {
                String currentAppVersion = role.appVersion;
                log.debug("Container = {}, app version current = {} new = {}", new Object[]{containerId, currentAppVersion, appVersion});
                if (currentAppVersion == null || currentAppVersion.equals("awaiting heartbeat...")) {
                    amState.getOwnedContainer((String)containerId).appVersion = appVersion;
                    amState.getApplicationDiagnostics().getContainer((String)containerId).appVersion = appVersion;
                }
            }
        }
        catch (NoSuchNodeException e) {
            log.warn("Owned container {} not found - {}", (Object)containerId, (Object)e);
        }
    }

    @Override
    public HeartBeatResponse handleHeartBeat(HeartBeat heartBeat) {
        int waitForCount;
        log.debug("Handling heartbeat: {}", (Object)heartBeat);
        HeartBeatResponse response = new HeartBeatResponse();
        long id = heartBeat.getResponseId();
        response.setResponseId(id + 1L);
        String label = heartBeat.getHostname();
        String pkg = heartBeat.getPackage();
        log.debug("package received: " + pkg);
        String roleName = this.getRoleName(label);
        String roleGroup = this.getRoleGroup(label);
        String containerId = this.getContainerId(label);
        boolean doUpgrade = false;
        if (this.isInUpgradeMode && this.upgradeContainers.contains(containerId)) {
            doUpgrade = true;
        }
        StateAccessForProviders accessor = this.getAmState();
        CommandScript cmdScript = this.getScriptPathForMasterPackage(roleGroup);
        List<ComponentCommand> commands = this.getApplicationComponent(roleGroup).getCommands();
        if (!(this.isDockerContainer(roleGroup) || this.isYarnDockerContainer(roleGroup) || cmdScript != null && cmdScript.getScript() != null || commands.size() != 0)) {
            log.error("role.script is unavailable for {}. Commands will not be sent.", (Object)roleName);
            return response;
        }
        String scriptPath = null;
        long timeout = 600L;
        if (cmdScript != null) {
            scriptPath = cmdScript.getScript();
            timeout = cmdScript.getTimeout();
        }
        if (timeout == 0L) {
            timeout = 600L;
        }
        if (!this.getComponentStatuses().containsKey(label)) {
            log.info("Sending terminate signal to completed container (still heartbeating): {}", (Object)label);
            response.setTerminateAgent(true);
            return response;
        }
        List<ComponentStatus> statuses = heartBeat.getComponentStatus();
        if (statuses != null && !statuses.isEmpty()) {
            log.info("status from agent: " + statuses.toString());
            try {
                for (ComponentStatus status : statuses) {
                    RoleInstance role = null;
                    if (status.getIp() != null && !status.getIp().isEmpty()) {
                        role = this.amState.getOwnedContainer(containerId);
                        role.ip = status.getIp();
                    }
                    if (status.getHostname() != null && !status.getHostname().isEmpty()) {
                        role = this.amState.getOwnedContainer(containerId);
                        role.hostname = status.getHostname();
                    }
                    if (role == null) continue;
                    ServiceRecord record = new ServiceRecord();
                    record.set("yarn:id", (Object)containerId);
                    record.description = roleName;
                    record.set("yarn:persistence", (Object)"container");
                    if (role.ip != null) {
                        record.set("yarn:ip", (Object)role.ip);
                    }
                    if (role.hostname != null) {
                        record.set("yarn:hostname", (Object)role.hostname);
                    }
                    this.yarnRegistry.putComponent(RegistryPathUtils.encodeYarnID((String)containerId), record);
                }
            }
            catch (NoSuchNodeException e) {
                log.warn("Owned container {} not found - {}", (Object)containerId, (Object)e);
            }
            catch (IOException e) {
                log.warn("Error updating container {} service record in registry", (Object)containerId, (Object)e);
            }
        }
        Boolean isMaster = this.isMaster(roleGroup);
        ComponentInstanceState componentStatus = this.getComponentStatuses().get(label);
        componentStatus.heartbeat(System.currentTimeMillis());
        if (doUpgrade) {
            switch (componentStatus.getState()) {
                case STARTED: {
                    componentStatus.setTargetState(State.UPGRADED);
                    break;
                }
                case UPGRADED: {
                    componentStatus.setTargetState(State.STOPPED);
                    break;
                }
                case STOPPED: {
                    componentStatus.setTargetState(State.TERMINATING);
                    break;
                }
            }
            log.info("Current state = {} target state {}", (Object)componentStatus.getState(), (Object)componentStatus.getTargetState());
        }
        if (this.appStopInitiated && !componentStatus.isStopInitiated()) {
            log.info("Stop initiated for label {}", (Object)label);
            componentStatus.setTargetState(State.STOPPED);
            componentStatus.setStopInitiated(true);
        }
        this.publishConfigAndExportGroups(heartBeat, componentStatus, roleGroup);
        CommandResult result = null;
        List<CommandReport> reports = heartBeat.getReports();
        if (SliderUtils.isNotEmpty(reports)) {
            CommandReport report = reports.get(0);
            Map<String, String> ports = report.getAllocatedPorts();
            if (SliderUtils.isNotEmpty(ports)) {
                this.processAllocatedPorts(heartBeat.getFqdn(), roleName, roleGroup, containerId, ports);
            }
            result = CommandResult.getCommandResult(report.getStatus());
            Command command = Command.getCommand(report.getRoleCommand());
            componentStatus.applyCommandResult(result, command, pkg);
            log.info("Component operation. Status: {}; new container state: {}; new component state: {}", new Object[]{result, componentStatus.getContainerState(), componentStatus.getState()});
            if (command == Command.INSTALL && SliderUtils.isNotEmpty(report.getFolders())) {
                this.publishFolderPaths(report.getFolders(), containerId, roleName, heartBeat.getFqdn());
            }
        }
        if (id < (long)(waitForCount = accessor.getInstanceDefinitionSnapshot().getAppConfOperations().getComponentOptInt(roleGroup, "wait.heartbeat", 0))) {
            log.info("Waiting until heartbeat count {}. Current val: {}", (Object)waitForCount, (Object)id);
            this.getComponentStatuses().put(label, componentStatus);
            return response;
        }
        Command command = componentStatus.getNextCommand(doUpgrade);
        try {
            if (Command.NOP != command) {
                log.debug("For comp {} pkg {} issuing {}", new Object[]{roleName, componentStatus.getNextPkgToInstall(), command.toString()});
                if (command == Command.INSTALL) {
                    log.info("Installing {} on {}.", (Object)roleName, (Object)containerId);
                    if (this.isDockerContainer(roleGroup) || this.isYarnDockerContainer(roleGroup)) {
                        this.addInstallDockerCommand(roleName, roleGroup, containerId, response, null, timeout);
                    } else if (scriptPath != null) {
                        this.addInstallCommand(roleName, roleGroup, containerId, response, scriptPath, null, timeout, null);
                    } else {
                        ComponentCommand installCmd = null;
                        for (ComponentCommand compCmd : commands) {
                            if (!compCmd.getName().equals("INSTALL")) continue;
                            installCmd = compCmd;
                        }
                        this.addInstallCommand(roleName, roleGroup, containerId, response, null, installCmd, timeout, null);
                    }
                    componentStatus.commandIssued(command);
                } else if (command == Command.INSTALL_ADDON) {
                    String nextPkgToInstall = componentStatus.getNextPkgToInstall();
                    for (ComponentsInAddonPackage comp : this.packageMetainfo.get(nextPkgToInstall).getApplicationPackage().getComponents()) {
                        log.debug("Addon component: {} pkg: {} script: {}", new Object[]{comp.getName(), nextPkgToInstall, comp.getCommandScript().getScript()});
                        if (!comp.getName().equals(roleGroup) && !comp.getName().equals("ALL")) continue;
                        scriptPath = comp.getCommandScript().getScript();
                        if (scriptPath != null) {
                            this.addInstallCommand(roleName, roleGroup, containerId, response, scriptPath, null, timeout, nextPkgToInstall);
                            continue;
                        }
                        ComponentCommand installCmd = null;
                        for (ComponentCommand compCmd : comp.getCommands()) {
                            if (!compCmd.getName().equals("INSTALL")) continue;
                            installCmd = compCmd;
                        }
                        this.addInstallCommand(roleName, roleGroup, containerId, response, null, installCmd, timeout, nextPkgToInstall);
                    }
                    componentStatus.commandIssued(command);
                } else if (command == Command.START) {
                    boolean canExecute = this.commandOrder.canExecute(roleGroup, command, this.getComponentStatuses().values());
                    if (canExecute) {
                        log.info("Starting {} on {}.", (Object)roleName, (Object)containerId);
                        if (this.isDockerContainer(roleGroup) || this.isYarnDockerContainer(roleGroup)) {
                            this.addStartDockerCommand(roleName, roleGroup, containerId, response, null, timeout, false);
                        } else if (scriptPath != null) {
                            this.addStartCommand(roleName, roleGroup, containerId, response, scriptPath, null, null, timeout, this.isMarkedAutoRestart(roleGroup));
                        } else {
                            ComponentCommand startCmd = null;
                            for (ComponentCommand compCmd : commands) {
                                if (!compCmd.getName().equals("START")) continue;
                                startCmd = compCmd;
                            }
                            ComponentCommand stopCmd = null;
                            for (ComponentCommand compCmd : commands) {
                                if (!compCmd.getName().equals("STOP")) continue;
                                stopCmd = compCmd;
                            }
                            this.addStartCommand(roleName, roleGroup, containerId, response, null, startCmd, stopCmd, timeout, false);
                        }
                        componentStatus.commandIssued(command);
                    } else {
                        log.info("Start of {} on {} delayed as dependencies have not started.", (Object)roleName, (Object)containerId);
                    }
                } else if (command == Command.UPGRADE) {
                    this.addUpgradeCommand(roleName, roleGroup, containerId, response, scriptPath, timeout);
                    componentStatus.commandIssued(command, true);
                } else if (command == Command.STOP) {
                    log.info("Stop command being sent to container with id {}", (Object)containerId);
                    this.addStopCommand(roleName, roleGroup, containerId, response, scriptPath, timeout, doUpgrade);
                    componentStatus.commandIssued(command);
                } else if (command == Command.TERMINATE) {
                    log.info("A formal terminate command is being sent to container {} in state {}", (Object)label, (Object)componentStatus.getState());
                    response.setTerminateAgent(true);
                }
            }
            if (isMaster.booleanValue() && componentStatus.getState() == State.STARTED && command == Command.NOP && !componentStatus.getConfigReported().booleanValue()) {
                log.info("Requesting applied config for {} on {}.", (Object)roleName, (Object)containerId);
                if (this.isDockerContainer(roleGroup) || this.isYarnDockerContainer(roleGroup)) {
                    this.addGetConfigDockerCommand(roleName, roleGroup, containerId, response);
                } else {
                    this.addGetConfigCommand(roleName, roleGroup, containerId, response);
                }
            }
            response.setRestartEnabled(false);
            if (componentStatus.getState() == State.STARTED && command == Command.NOP && this.isMarkedAutoRestart(roleGroup)) {
                response.setRestartEnabled(true);
            }
            if (componentStatus.getState() == State.INSTALL_FAILED && command == Command.NOP) {
                log.warn("Sending terminate signal to container that failed installation: {}", (Object)label);
                response.setTerminateAgent(true);
            }
        }
        catch (SliderException e) {
            log.warn("Component instance failed operation.", (Throwable)((Object)e));
            componentStatus.applyCommandResult(CommandResult.FAILED, command, null);
        }
        log.debug("Heartbeat response: " + response);
        return response;
    }

    private boolean isDockerContainer(String roleGroup) {
        String type = this.getApplicationComponent(roleGroup).getType();
        if (SliderUtils.isSet(type)) {
            return type.toLowerCase().equals("docker") || type.toLowerCase().equals("yarn_docker");
        }
        return false;
    }

    private boolean isYarnDockerContainer(String roleGroup) {
        String type = this.getApplicationComponent(roleGroup).getType();
        if (SliderUtils.isSet(type)) {
            return type.toLowerCase().equals("yarn_docker");
        }
        return false;
    }

    protected void processAllocatedPorts(String fqdn, String roleName, String roleGroup, String containerId, Map<String, String> ports) {
        RoleInstance instance;
        try {
            instance = this.getAmState().getOwnedContainer(containerId);
        }
        catch (NoSuchNodeException e) {
            log.warn("Failed to locate instance of container {}", (Object)containerId, (Object)e);
            instance = null;
        }
        for (Map.Entry<String, String> port : ports.entrySet()) {
            String portname = port.getKey();
            String portNo = port.getValue();
            log.info("Recording allocated port for {} as {}", (Object)portname, (Object)portNo);
            this.getAllocatedPorts().put(portname, portNo);
            this.getAllocatedPorts(containerId).put(portname, portNo);
            if (instance == null) continue;
            try {
                instance.registerPortEndpoint(Integer.valueOf(portNo), portname);
            }
            catch (NumberFormatException e) {
                log.warn("Failed to parse {}", (Object)portNo, (Object)e);
            }
        }
        this.processAndPublishComponentSpecificData(ports, containerId, fqdn, roleGroup);
        this.processAndPublishComponentSpecificExports(ports, containerId, fqdn, roleName, roleGroup);
        if (instance != null) {
            this.queueAccess.put(new RegisterComponentInstance(instance.getId(), roleName, roleGroup, 0L, TimeUnit.MILLISECONDS));
        }
    }

    private void updateComponentStatusWithAgentState(ComponentInstanceState componentStatus, State agentState) {
        if (agentState != null) {
            componentStatus.setState(agentState);
        }
    }

    @Override
    public Map<String, MonitorDetail> buildMonitorDetails(ClusterDescription clusterDesc) {
        Map<String, MonitorDetail> details = super.buildMonitorDetails(clusterDesc);
        this.buildRoleHostDetails(details);
        return details;
    }

    @Override
    public void applyInitialRegistryDefinitions(URL amWebURI, URL agentOpsURI, URL agentStatusURI, ServiceRecord serviceRecord) throws IOException {
        super.applyInitialRegistryDefinitions(amWebURI, agentOpsURI, agentStatusURI, serviceRecord);
        try {
            URL restURL = new URL(agentOpsURI, "/ws/v1/slider/agents");
            URL agentStatusURL = new URL(agentStatusURI, "/ws/v1/slider/agents");
            serviceRecord.addInternalEndpoint(new Endpoint("classpath:org.apache.slider.agents.secure", "REST", new URI[]{restURL.toURI()}));
            serviceRecord.addInternalEndpoint(new Endpoint("classpath:org.apache.slider.agents.oneway", "REST", new URI[]{agentStatusURL.toURI()}));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        AbstractComponent client = null;
        for (Component component : this.getMetaInfo().getApplication().getComponents()) {
            if (!component.getCategory().equals("CLIENT")) continue;
            client = component;
            break;
        }
        if (client == null) {
            log.info("No client component specified, not publishing client configs");
            return;
        }
        ConfTreeOperations appConf = this.getAmState().getAppConfSnapshot();
        MapOperations clientOperations = appConf.getOrAddComponent(client.getName());
        appConf.resolve();
        if (!clientOperations.getOptionBool("am.config.generation", false).booleanValue()) {
            log.info("AM config generation is false, not publishing client configs");
            return;
        }
        TreeMap<String, Map<String, String>> configurations = new TreeMap<String, Map<String, String>>();
        Map<String, String> tokens = null;
        try {
            tokens = this.getStandardTokenMap(appConf, client.getName(), client.getName());
        }
        catch (SliderException e) {
            throw new IOException((Throwable)((Object)e));
        }
        for (ConfigFile configFile : this.getMetaInfo().getComponentConfigFiles(client.getName())) {
            this.addNamedConfiguration(configFile.getDictionaryName(), appConf.getGlobalOptions().options, configurations, tokens, null, client.getName(), client.getName());
            if (appConf.getComponent(client.getName()) == null) continue;
            this.addNamedConfiguration(configFile.getDictionaryName(), appConf.getComponent((String)client.getName()).options, configurations, tokens, null, client.getName(), client.getName());
        }
        this.dereferenceAllConfigs(configurations);
        for (ConfigFile configFile : this.getMetaInfo().getComponentConfigFiles(client.getName())) {
            ConfigFormat configFormat = ConfigFormat.resolve(configFile.getType());
            Map config = (Map)configurations.get(configFile.getDictionaryName());
            ConfigUtils.prepConfigForTemplateOutputter(configFormat, config, this.fileSystem, this.getClusterName(), new File(configFile.getFileName()).getName());
            PublishedConfiguration publishedConfiguration = new PublishedConfiguration(configFile.getDictionaryName(), config.entrySet());
            this.getAmState().getPublishedSliderConfigurations().put(configFile.getDictionaryName(), publishedConfiguration);
            log.info("Publishing AM configuration {}", (Object)configFile.getDictionaryName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyContainerCompleted(ContainerId containerId) {
        if (containerId != null) {
            String containerIdStr = containerId.toString();
            if (this.getComponentInstanceData().containsKey(containerIdStr)) {
                this.getComponentInstanceData().remove(containerIdStr);
                log.info("Removing container specific data for {}", (Object)containerIdStr);
                this.publishComponentInstanceData();
            }
            if (this.allocatedPorts.containsKey(containerIdStr)) {
                Map<String, String> portsByContainerId = this.getAllocatedPorts(containerIdStr);
                this.allocatedPorts.remove(containerIdStr);
                for (String portName : portsByContainerId.keySet()) {
                    this.getAllocatedPorts().remove(portName);
                }
            }
            String componentName = null;
            Map<String, Object> map = this.componentStatuses;
            synchronized (map) {
                for (String label : this.getComponentStatuses().keySet()) {
                    if (!label.startsWith(containerIdStr)) continue;
                    componentName = this.getRoleName(label);
                    log.info("Removing component status for label {}", (Object)label);
                    this.getComponentStatuses().remove(label);
                }
            }
            this.tags.releaseTag(componentName, containerIdStr);
            map = this.containerExportsMap;
            synchronized (map) {
                Set<String> containerExportSets = this.containerExportsMap.get(containerIdStr);
                if (containerExportSets != null) {
                    for (String containerExportStr : containerExportSets) {
                        String[] parts = containerExportStr.split(":");
                        Map<String, List<ExportEntry>> exportGroup = this.getCurrentExports(parts[0]);
                        List<ExportEntry> exports = exportGroup.get(parts[1]);
                        ArrayList<ExportEntry> exportToRemove = new ArrayList<ExportEntry>();
                        for (ExportEntry export : exports) {
                            if (!containerIdStr.equals(export.getContainerId())) continue;
                            exportToRemove.add(export);
                        }
                        exports.removeAll(exportToRemove);
                    }
                    log.info("Removing container exports for {}", (Object)containerIdStr);
                    this.containerExportsMap.remove(containerIdStr);
                }
            }
        }
    }

    private void readAndSetHeartbeatMonitoringInterval(AggregateConf instanceDefinition) {
        String hbMonitorInterval = instanceDefinition.getAppConfOperations().getGlobalOptions().getOption("heartbeat.monitor.interval", Integer.toString(60000));
        try {
            this.setHeartbeatMonitorInterval(Integer.parseInt(hbMonitorInterval));
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("Bad value {} for {}. Defaulting to ", new Object[]{hbMonitorInterval, "heartbeat.monitor.interval", 60000});
        }
        String hbLostInterval = instanceDefinition.getAppConfOperations().getGlobalOptions().getOption("heartbeat.lost.interval", Integer.toString(0x6DDD00));
        try {
            this.setHeartbeatLostInterval(Integer.parseInt(hbLostInterval));
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("Bad value {} for {}. Defaulting to ", new Object[]{hbLostInterval, "heartbeat.lost.interval", 0x6DDD00});
        }
    }

    private void initializeAgentDebugCommands(AggregateConf instanceDefinition) {
        String launchParameterStr = instanceDefinition.getAppConfOperations().getGlobalOptions().getOption("agent.instance.debug.data", "");
        this.agentLaunchParameter = new AgentLaunchParameter(launchParameterStr);
    }

    @VisibleForTesting
    protected Map<String, ExportEntry> getLogFolderExports() {
        return this.logFolderExports;
    }

    @VisibleForTesting
    protected Map<String, ExportEntry> getWorkFolderExports() {
        return this.workFolderExports;
    }

    protected Metainfo getMetaInfo() {
        return this.getMetaInfo(null);
    }

    @VisibleForTesting
    protected Metainfo getMetaInfo(String roleGroup) {
        MetainfoHolder mh;
        String mapKey = "DEFAULT_KEY";
        if (roleGroup != null) {
            ConfTreeOperations appConf = this.getAmState().getAppConfSnapshot();
            mapKey = appConf.getComponentOpt(roleGroup, "role.prefix", "DEFAULT_KEY");
        }
        if ((mh = this.metaInfoMap.get(mapKey)) == null) {
            return null;
        }
        return mh.metaInfo;
    }

    @VisibleForTesting
    protected Map<String, ComponentInstanceState> getComponentStatuses() {
        return this.componentStatuses;
    }

    @VisibleForTesting
    protected Metainfo getApplicationMetainfo(SliderFileSystem fileSystem, String appDef, boolean addonPackage) throws IOException, BadConfigException {
        return AgentUtils.getApplicationMetainfo(fileSystem, appDef, addonPackage);
    }

    @VisibleForTesting
    protected Metainfo getApplicationMetainfo(SliderFileSystem fileSystem, String appDef) throws IOException, BadConfigException {
        return this.getApplicationMetainfo(fileSystem, appDef, false);
    }

    @VisibleForTesting
    protected void setHeartbeatMonitorInterval(int heartbeatMonitorInterval) {
        this.heartbeatMonitorInterval = heartbeatMonitorInterval;
    }

    @VisibleForTesting
    protected void setHeartbeatLostInterval(int heartbeatLostInterval) {
        this.heartbeatLostInterval = heartbeatLostInterval;
    }

    public void setInUpgradeMode(boolean inUpgradeMode) {
        this.isInUpgradeMode = inUpgradeMode;
    }

    public void addUpgradeContainers(Set<String> upgradeContainers) {
        this.upgradeContainers.addAll(upgradeContainers);
    }

    public void setAppStopInitiated(boolean appStopInitiated) {
        this.appStopInitiated = appStopInitiated;
    }

    protected Map<String, DefaultConfig> initializeDefaultConfigs(SliderFileSystem fileSystem, String appDef, Metainfo metainfo) throws IOException {
        HashMap<String, DefaultConfig> defaultConfigMap = new HashMap<String, DefaultConfig>();
        if (SliderUtils.isNotEmpty(metainfo.getApplication().getConfigFiles())) {
            for (ConfigFile configFile : metainfo.getApplication().getConfigFiles()) {
                DefaultConfig config = null;
                try {
                    config = AgentUtils.getDefaultConfig(fileSystem, appDef, String.valueOf(configFile.getDictionaryName()) + ".xml");
                }
                catch (IOException iOException) {
                    log.warn("Default config file not found. Only the config as input during create will be applied for {}", (Object)configFile.getDictionaryName());
                }
                if (config == null) continue;
                defaultConfigMap.put(configFile.getDictionaryName(), config);
            }
        }
        return defaultConfigMap;
    }

    protected Map<String, DefaultConfig> getDefaultConfigs(String roleGroup) {
        ConfTreeOperations appConf = this.getAmState().getAppConfSnapshot();
        String mapKey = appConf.getComponentOpt(roleGroup, "role.prefix", "DEFAULT_KEY");
        return this.metaInfoMap.get(mapKey).defaultConfigs;
    }

    private int getHeartbeatMonitorInterval() {
        return this.heartbeatMonitorInterval;
    }

    private int getHeartbeatLostInterval() {
        return this.heartbeatLostInterval;
    }

    private String getClusterName() {
        if (SliderUtils.isUnset(this.clusterName)) {
            this.clusterName = this.getAmState().getInternalsSnapshot().get("application.name");
        }
        return this.clusterName;
    }

    protected void publishApplicationInstanceData(String name, String description, Iterable<Map.Entry<String, String>> entries) {
        PublishedConfiguration pubconf = new PublishedConfiguration();
        pubconf.description = description;
        pubconf.putValues(entries);
        log.info("publishing {}", (Object)pubconf);
        this.getAmState().getPublishedSliderConfigurations().put(name, pubconf);
    }

    protected Map<String, Map<String, ClusterNode>> getRoleClusterNodeMapping() {
        return this.amState.getRoleClusterNodeMapping();
    }

    private String getContainerLabel(Container container, String role, String group) {
        if (role.equals(group)) {
            return String.valueOf(container.getId().toString()) + LABEL_MAKER + role;
        }
        return String.valueOf(container.getId().toString()) + LABEL_MAKER + role + LABEL_MAKER + group;
    }

    protected String getClusterInfoPropertyValue(String name) {
        StateAccessForProviders accessor = this.getAmState();
        assert (accessor.isApplicationLive());
        ClusterDescription description = accessor.getClusterStatus();
        return description.getInfo(name);
    }

    protected String getClusterOptionPropertyValue(String name) throws BadConfigException {
        StateAccessForProviders accessor = this.getAmState();
        assert (accessor.isApplicationLive());
        ClusterDescription description = accessor.getClusterStatus();
        return description.getMandatoryOption(name);
    }

    protected void lostContainer(String label, ContainerId containerId) {
        this.getComponentStatuses().remove(label);
        this.getQueueAccess().put(new ProviderReportedContainerLoss(containerId));
    }

    @Override
    public Map<String, String> buildProviderStatus() {
        HashMap<String, String> stats = new HashMap<String, String>();
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishFolderPaths(Map<String, String> folders, String containerId, String componentName, String hostFqdn) {
        Date now = new Date();
        for (Map.Entry<String, String> entry : folders.entrySet()) {
            Map<String, ExportEntry> map;
            ExportEntry exportEntry = new ExportEntry();
            exportEntry.setValue(String.format(HOST_FOLDER_FORMAT, hostFqdn, entry.getValue()));
            exportEntry.setContainerId(containerId);
            exportEntry.setLevel(COMPONENT_TAG);
            exportEntry.setTag(componentName);
            exportEntry.setUpdatedTime(now.toString());
            if (entry.getKey().equals("AGENT_LOG_ROOT")) {
                map = this.logFolderExports;
                synchronized (map) {
                    this.getLogFolderExports().put(containerId, exportEntry);
                }
            }
            map = this.workFolderExports;
            synchronized (map) {
                this.getWorkFolderExports().put(containerId, exportEntry);
            }
            log.info("Updating log and pwd folders for container {}", (Object)containerId);
        }
        PublishedExports exports = new PublishedExports(CONTAINER_LOGS_TAG);
        exports.setUpdated(now.getTime());
        Map<String, ExportEntry> map = this.logFolderExports;
        synchronized (map) {
            this.updateExportsFromList(exports, this.getLogFolderExports());
        }
        this.getAmState().getPublishedExportsSet().put(CONTAINER_LOGS_TAG, exports);
        exports = new PublishedExports(CONTAINER_PWDS_TAG);
        exports.setUpdated(now.getTime());
        map = this.workFolderExports;
        synchronized (map) {
            this.updateExportsFromList(exports, this.getWorkFolderExports());
        }
        this.getAmState().getPublishedExportsSet().put(CONTAINER_PWDS_TAG, exports);
    }

    private void updateExportsFromList(PublishedExports exports, Map<String, ExportEntry> folderExports) {
        HashMap perComponentList = new HashMap();
        for (Map.Entry<String, ExportEntry> logEntry : folderExports.entrySet()) {
            String componentName = logEntry.getValue().getTag();
            if (!perComponentList.containsKey(componentName)) {
                perComponentList.put(componentName, new ArrayList());
            }
            ((List)perComponentList.get(componentName)).add(logEntry.getValue());
        }
        exports.putValues(perComponentList.entrySet());
    }

    protected void publishConfigAndExportGroups(HeartBeat heartBeat, ComponentInstanceState componentStatus, String componentGroup) {
        List<ComponentStatus> statuses = heartBeat.getComponentStatus();
        if (statuses != null && !statuses.isEmpty()) {
            log.info("Processing {} status reports.", (Object)statuses.size());
            for (ComponentStatus status : statuses) {
                log.info("Status report: {}", (Object)status.toString());
                if (status.getConfigs() == null) continue;
                Application application = this.getMetaInfo(componentGroup).getApplication();
                if (!(this.canAnyMasterPublishConfig(componentGroup) && !this.canPublishConfig(componentGroup) || this.getAmState().getAppConfSnapshot().getComponentOptBool(componentGroup, "am.config.generation", false))) {
                    boolean exportedAllConfigs;
                    HashSet<String> exportedConfigs = new HashSet<String>();
                    String exportedConfigsStr = application.getExportedConfigs();
                    boolean bl = exportedAllConfigs = exportedConfigsStr == null || exportedConfigsStr.isEmpty();
                    if (!exportedAllConfigs) {
                        String[] stringArray = exportedConfigsStr.split(",");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String exportedConfig = stringArray[n2];
                            if (exportedConfig.trim().length() > 0) {
                                exportedConfigs.add(exportedConfig.trim());
                            }
                            ++n2;
                        }
                    }
                    for (String key : status.getConfigs().keySet()) {
                        if ((exportedAllConfigs || !exportedConfigs.contains(key)) && !exportedAllConfigs) continue;
                        Map<String, String> configs = status.getConfigs().get(key);
                        this.publishApplicationInstanceData(key, key, configs.entrySet());
                    }
                }
                List<ExportGroup> appExportGroups = application.getExportGroups();
                boolean hasExportGroups = SliderUtils.isNotEmpty(appExportGroups);
                HashSet<String> appExports = new HashSet<String>();
                String appExportsStr = this.getApplicationComponent(componentGroup).getAppExports();
                if (SliderUtils.isSet(appExportsStr)) {
                    String[] stringArray = appExportsStr.split(",");
                    int n = stringArray.length;
                    int configs = 0;
                    while (configs < n) {
                        String appExport = stringArray[configs];
                        if (!appExport.trim().isEmpty()) {
                            appExports.add(appExport.trim());
                        }
                        ++configs;
                    }
                }
                if (hasExportGroups && !appExports.isEmpty()) {
                    String configKeyFormat = "${site.%s.%s}";
                    String hostKeyFormat = "${%s_HOST}";
                    HashMap<String, String> replaceTokens = new HashMap<String, String>();
                    for (Map.Entry<String, Map<String, ClusterNode>> entry : this.getRoleClusterNodeMapping().entrySet()) {
                        String hostName = this.getHostsList(entry.getValue().values(), true).iterator().next();
                        replaceTokens.put(String.format(hostKeyFormat, entry.getKey().toUpperCase(Locale.ENGLISH)), hostName);
                    }
                    for (String key : status.getConfigs().keySet()) {
                        Map<String, String> configs = status.getConfigs().get(key);
                        for (String configKey : configs.keySet()) {
                            String lookupKey = String.format(configKeyFormat, key, configKey);
                            replaceTokens.put(lookupKey, configs.get(configKey));
                        }
                    }
                    HashSet<String> modifiedGroups = new HashSet<String>();
                    for (ExportGroup exportGroup : appExportGroups) {
                        List<Export> exports = exportGroup.getExports();
                        if (!SliderUtils.isNotEmpty(exports)) continue;
                        String exportGroupName = exportGroup.getName();
                        ConcurrentHashMap map = (ConcurrentHashMap)this.getCurrentExports(exportGroupName);
                        for (Export export : exports) {
                            if (!this.canBeExported(exportGroupName, export.getName(), appExports)) continue;
                            String value = export.getValue();
                            for (String token : replaceTokens.keySet()) {
                                if (!value.contains(token)) continue;
                                value = value.replaceAll(Pattern.quote(token), (String)replaceTokens.get(token));
                            }
                            ExportEntry entry = new ExportEntry();
                            entry.setLevel(APPLICATION_TAG);
                            entry.setValue(value);
                            entry.setUpdatedTime(new Date().toString());
                            map.put(export.getName(), new ArrayList<ExportEntry>(Arrays.asList(entry)));
                            log.info("Preparing to publish. Key {} and Value {}", (Object)export.getName(), (Object)value);
                        }
                        modifiedGroups.add(exportGroupName);
                    }
                    this.publishModifiedExportGroups(modifiedGroups);
                }
                log.info("Received and processed config for {}", (Object)heartBeat.getHostname());
                componentStatus.setConfigReported(true);
            }
        }
    }

    private boolean canBeExported(String exportGroupName, String name, Set<String> appExports) {
        return appExports.contains(String.format("%s-%s", exportGroupName, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, List<ExportEntry>> getCurrentExports(String groupName) {
        if (!this.exportGroups.containsKey(groupName)) {
            Map<String, Map<String, List<ExportEntry>>> map = this.exportGroups;
            synchronized (map) {
                if (!this.exportGroups.containsKey(groupName)) {
                    this.exportGroups.put(groupName, new ConcurrentHashMap());
                }
            }
        }
        return this.exportGroups.get(groupName);
    }

    private void publishModifiedExportGroups(Set<String> modifiedGroups) {
        for (String groupName : modifiedGroups) {
            Map<String, List<ExportEntry>> entries = this.exportGroups.get(groupName);
            HashMap<String, String> simpleEntries = new HashMap<String, String>();
            for (Map.Entry<String, List<ExportEntry>> entry : entries.entrySet()) {
                List<ExportEntry> exports = entry.getValue();
                if (!SliderUtils.isNotEmpty(exports)) continue;
                simpleEntries.put(entry.getKey(), entry.getValue().get(0).getValue());
            }
            if (!this.getAmState().getAppConfSnapshot().getComponentOptBool(groupName, "am.config.generation", false)) {
                this.publishApplicationInstanceData(groupName, groupName, simpleEntries.entrySet());
            }
            PublishedExports exports = new PublishedExports(groupName);
            exports.setUpdated(new Date().getTime());
            exports.putValues(entries.entrySet());
            this.getAmState().getPublishedExportsSet().put(groupName, exports);
        }
    }

    protected void processAndPublishComponentSpecificData(Map<String, String> ports, String containerId, String hostFqdn, String componentGroup) {
        String portVarFormat = "${site.%s}";
        String hostNamePattern = "${THIS_HOST}";
        HashMap<String, String> toPublish = new HashMap<String, String>();
        Application application = this.getMetaInfo(componentGroup).getApplication();
        for (Component component : application.getComponents()) {
            if (!component.getName().equals(componentGroup) || component.getComponentExports().size() <= 0) continue;
            for (ComponentExport export : component.getComponentExports()) {
                String templateToExport = export.getValue();
                for (String portName : ports.keySet()) {
                    boolean publishData = false;
                    String portValPattern = String.format(portVarFormat, portName);
                    if (templateToExport.contains(portValPattern)) {
                        templateToExport = templateToExport.replace(portValPattern, ports.get(portName));
                        publishData = true;
                    }
                    if (templateToExport.contains(hostNamePattern)) {
                        templateToExport = templateToExport.replace(hostNamePattern, hostFqdn);
                        publishData = true;
                    }
                    if (!publishData) continue;
                    toPublish.put(export.getName(), templateToExport);
                    log.info("Publishing {} for name {} and container {}", new Object[]{templateToExport, export.getName(), containerId});
                }
            }
        }
        if (toPublish.size() > 0) {
            Map<String, String> perContainerData = null;
            perContainerData = !this.getComponentInstanceData().containsKey(containerId) ? new ConcurrentHashMap<String, String>() : this.getComponentInstanceData().get(containerId);
            perContainerData.putAll(toPublish);
            this.getComponentInstanceData().put(containerId, perContainerData);
            this.publishComponentInstanceData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAndPublishComponentSpecificExports(Map<String, String> ports, String containerId, String hostFqdn, String compName, String compGroup) {
        String portVarFormat = "${site.%s}";
        String hostNamePattern = "${" + compGroup + "_HOST}";
        List<ExportGroup> appExportGroups = this.getMetaInfo(compGroup).getApplication().getExportGroups();
        Component component = this.getApplicationComponent(compGroup);
        if (component != null && SliderUtils.isSet(component.getCompExports()) && SliderUtils.isNotEmpty(appExportGroups)) {
            HashSet<String> compExports = new HashSet<String>();
            String compExportsStr = component.getCompExports();
            String[] stringArray = compExportsStr.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String compExport = stringArray[n2];
                if (!compExport.trim().isEmpty()) {
                    compExports.add(compExport.trim());
                }
                ++n2;
            }
            Date now = new Date();
            HashSet<String> modifiedGroups = new HashSet<String>();
            for (ExportGroup exportGroup : appExportGroups) {
                List<Export> exports = exportGroup.getExports();
                if (!SliderUtils.isNotEmpty(exports)) continue;
                String exportGroupName = exportGroup.getName();
                ConcurrentHashMap map = (ConcurrentHashMap)this.getCurrentExports(exportGroupName);
                for (Export export : exports) {
                    if (!this.canBeExported(exportGroupName, export.getName(), compExports)) continue;
                    log.info("Attempting to publish {} of group {} for component type {}", new Object[]{export.getName(), exportGroupName, compName});
                    String templateToExport = export.getValue();
                    for (String portName : ports.keySet()) {
                        boolean publishData = false;
                        String portValPattern = String.format(portVarFormat, portName);
                        if (templateToExport.contains(portValPattern)) {
                            templateToExport = templateToExport.replace(portValPattern, ports.get(portName));
                            publishData = true;
                        }
                        if (templateToExport.contains(hostNamePattern)) {
                            templateToExport = templateToExport.replace(hostNamePattern, hostFqdn);
                            publishData = true;
                        }
                        if (!publishData) continue;
                        ExportEntry entryToAdd = new ExportEntry();
                        entryToAdd.setLevel(COMPONENT_TAG);
                        entryToAdd.setValue(templateToExport);
                        entryToAdd.setUpdatedTime(now.toString());
                        entryToAdd.setContainerId(containerId);
                        entryToAdd.setTag(this.tags.getTag(compName, containerId));
                        List existingList = map.putIfAbsent(export.getName(), new CopyOnWriteArrayList<ExportEntry>(Arrays.asList(entryToAdd)));
                        if (existingList != null) {
                            boolean updatedInPlace = false;
                            for (ExportEntry entry : existingList) {
                                if (!containerId.toLowerCase(Locale.ENGLISH).equals(entry.getContainerId())) continue;
                                entryToAdd.setValue(templateToExport);
                                entryToAdd.setUpdatedTime(now.toString());
                                updatedInPlace = true;
                            }
                            if (!updatedInPlace) {
                                existingList.add(entryToAdd);
                            }
                        }
                        log.info("Publishing {} for name {} and container {}", new Object[]{templateToExport, export.getName(), containerId});
                        modifiedGroups.add(exportGroupName);
                        Map<String, Set<String>> map2 = this.containerExportsMap;
                        synchronized (map2) {
                            if (!this.containerExportsMap.containsKey(containerId)) {
                                this.containerExportsMap.put(containerId, new HashSet());
                            }
                            Set<String> containerExportMaps = this.containerExportsMap.get(containerId);
                            containerExportMaps.add(String.format(HOST_FOLDER_FORMAT, exportGroupName, export.getName()));
                        }
                    }
                }
            }
            this.publishModifiedExportGroups(modifiedGroups);
        }
    }

    private void publishComponentInstanceData() {
        HashMap<String, String> dataToPublish = new HashMap<String, String>();
        for (String container : this.getComponentInstanceData().keySet()) {
            for (String prop : this.getComponentInstanceData().get(container).keySet()) {
                dataToPublish.put(String.valueOf(container) + "." + prop, this.getComponentInstanceData().get(container).get(prop));
            }
        }
        this.publishApplicationInstanceData(COMPONENT_DATA_TAG, COMPONENT_DATA_TAG, dataToPublish.entrySet());
    }

    protected Component getApplicationComponent(String roleGroup) {
        Metainfo metainfo = this.getMetaInfo(roleGroup);
        if (metainfo == null) {
            return null;
        }
        return metainfo.getApplicationComponent(roleGroup);
    }

    protected CommandScript getScriptPathForMasterPackage(String roleGroup) {
        Component component = this.getApplicationComponent(roleGroup);
        if (component != null) {
            return component.getCommandScript();
        }
        return null;
    }

    protected boolean isMaster(String roleGroup) {
        Component component = this.getApplicationComponent(roleGroup);
        return component != null && component.getCategory().equals("MASTER");
    }

    protected boolean canPublishConfig(String roleGroup) {
        Component component = this.getApplicationComponent(roleGroup);
        if (component != null) {
            return Boolean.TRUE.toString().equals(component.getPublishConfig());
        }
        return false;
    }

    protected boolean isMarkedAutoRestart(String roleGroup) {
        Component component = this.getApplicationComponent(roleGroup);
        if (component != null) {
            return component.getAutoStartOnFailureBoolean();
        }
        return false;
    }

    protected boolean canAnyMasterPublishConfig(String roleGroup) {
        if (this.canAnyMasterPublish == null) {
            Application application = this.getMetaInfo(roleGroup).getApplication();
            if (application == null) {
                log.error("Malformed app definition: Expect application as root element in the metainfo.xml");
            } else {
                for (Component component : application.getComponents()) {
                    if (!Boolean.TRUE.toString().equals(component.getPublishConfig()) || !component.getCategory().equals("MASTER")) continue;
                    this.canAnyMasterPublish = true;
                }
            }
        }
        if (this.canAnyMasterPublish == null) {
            this.canAnyMasterPublish = false;
        }
        return this.canAnyMasterPublish;
    }

    private String getRoleName(String label) {
        int index2;
        int index1 = label.indexOf(LABEL_MAKER);
        if (index1 == (index2 = label.lastIndexOf(LABEL_MAKER))) {
            return label.substring(index1 + LABEL_MAKER.length());
        }
        return label.substring(index1 + LABEL_MAKER.length(), index2);
    }

    private String getRoleGroup(String label) {
        return label.substring(label.lastIndexOf(LABEL_MAKER) + LABEL_MAKER.length());
    }

    private String getContainerId(String label) {
        return label.substring(0, label.indexOf(LABEL_MAKER));
    }

    @VisibleForTesting
    protected void addInstallCommand(String roleName, String roleGroup, String containerId, HeartBeatResponse response, String scriptPath, ComponentCommand compCmd, long timeout, String pkg) throws SliderException {
        assert (this.getAmState().isApplicationLive());
        ConfTreeOperations appConf = this.getAmState().getAppConfSnapshot();
        ExecutionCommand cmd = new ExecutionCommand(AgentCommandType.EXECUTION_COMMAND);
        this.prepareExecutionCommand(cmd);
        String clusterName = this.getClusterName();
        cmd.setClusterName(clusterName);
        cmd.setRoleCommand(Command.INSTALL.toString());
        cmd.setServiceName(clusterName);
        cmd.setComponentName(roleName);
        cmd.setRole(roleName);
        cmd.setPkg(pkg);
        TreeMap<String, String> hostLevelParams = new TreeMap<String, String>();
        hostLevelParams.put("java_home", appConf.getGlobalOptions().getOption("java_home", AgentProviderService.getJDKDir()));
        hostLevelParams.put("package_list", this.getPackageList(roleGroup));
        hostLevelParams.put(CONTAINER_ID, containerId);
        cmd.setHostLevelParams(hostLevelParams);
        Map<String, Map<String, String>> configurations = this.buildCommandConfigurations(appConf, containerId, roleName, roleGroup);
        cmd.setConfigurations(configurations);
        Map<String, Map<String, String>> componentConfigurations = this.buildComponentConfigurations(appConf);
        cmd.setComponentConfigurations(componentConfigurations);
        if (SliderUtils.isSet(scriptPath)) {
            cmd.setCommandParams(this.commandParametersSet(scriptPath, timeout, false));
        } else {
            ComponentCommand effectiveCommand = compCmd;
            if (effectiveCommand == null) {
                effectiveCommand = ComponentCommand.getDefaultComponentCommand("INSTALL");
            }
            cmd.setCommandParams(this.commandParametersSet(effectiveCommand, timeout, false));
            configurations.get(GLOBAL_CONFIG_TAG).put("exec_cmd", effectiveCommand.getExec());
        }
        cmd.setHostname(this.getClusterInfoPropertyValue("info.am.hostname"));
        response.addExecutionCommand(cmd);
        log.debug("command looks like: {} ", (Object)cmd);
    }

    @VisibleForTesting
    protected void addInstallDockerCommand(String roleName, String roleGroup, String containerId, HeartBeatResponse response, ComponentCommand compCmd, long timeout) throws SliderException {
        assert (this.getAmState().isApplicationLive());
        ConfTreeOperations appConf = this.getAmState().getAppConfSnapshot();
        ExecutionCommand cmd = new ExecutionCommand(AgentCommandType.EXECUTION_COMMAND);
        this.prepareExecutionCommand(cmd);
        String clusterName = this.getClusterName();
        cmd.setClusterName(clusterName);
        cmd.setRoleCommand(Command.INSTALL.toString());
        cmd.setServiceName(clusterName);
        cmd.setComponentName(roleName);
        cmd.setRole(roleName);
        TreeMap<String, String> hostLevelParams = new TreeMap<String, String>();
        hostLevelParams.put("package_list", this.getPackageList(roleGroup));
        hostLevelParams.put(CONTAINER_ID, containerId);
        cmd.setHostLevelParams(hostLevelParams);
        Map<String, Map<String, String>> configurations = this.buildCommandConfigurations(appConf, containerId, roleName, roleGroup);
        cmd.setConfigurations(configurations);
        Map<String, Map<String, String>> componentConfigurations = this.buildComponentConfigurations(appConf);
        cmd.setComponentConfigurations(componentConfigurations);
        ComponentCommand effectiveCommand = compCmd;
        if (compCmd == null) {
            effectiveCommand = new ComponentCommand();
            effectiveCommand.setName("INSTALL");
            effectiveCommand.setExec("DEFAULT");
        }
        cmd.setCommandParams(this.setCommandParameters(effectiveCommand, timeout, false));
        configurations.get(GLOBAL_CONFIG_TAG).put("exec_cmd", effectiveCommand.getExec());
        cmd.setHostname(this.getClusterInfoPropertyValue("info.am.hostname"));
        cmd.addContainerDetails(roleGroup, this.getMetaInfo(roleGroup));
        HashMap<String, String> dockerConfig = new HashMap<String, String>();
        if (this.isYarnDockerContainer(roleGroup)) {
            cmd.setYarnDockerMode(true);
        } else {
            dockerConfig.put("docker.command_path", this.getConfigFromMetaInfoWithAppConfigOverriding(roleGroup, "commandPath"));
            dockerConfig.put("docker.image_name", this.getConfigFromMetaInfo(roleGroup, "image"));
        }
        configurations.put("docker", dockerConfig);
        log.debug("Docker- command: {}", (Object)cmd.toString());
        response.addExecutionCommand(cmd);
    }

    private Map<String, String> setCommandParameters(String scriptPath, long timeout, boolean recordConfig) {
        TreeMap<String, String> cmdParams = new TreeMap<String, String>();
        cmdParams.put("service_package_folder", "${AGENT_WORK_ROOT}/work/app/definition/package");
        cmdParams.put("script", scriptPath);
        cmdParams.put("schema_version", "2.0");
        cmdParams.put("command_timeout", Long.toString(timeout));
        cmdParams.put("script_type", "PYTHON");
        cmdParams.put("record_config", Boolean.toString(recordConfig));
        return cmdParams;
    }

    private Map<String, String> setCommandParameters(ComponentCommand compCmd, long timeout, boolean recordConfig) {
        TreeMap<String, String> cmdParams = new TreeMap<String, String>();
        cmdParams.put("service_package_folder", "${AGENT_WORK_ROOT}/work/app/definition/package");
        cmdParams.put("command", compCmd.getExec());
        cmdParams.put("schema_version", "2.0");
        cmdParams.put("command_timeout", Long.toString(timeout));
        cmdParams.put("script_type", compCmd.getType());
        cmdParams.put("record_config", Boolean.toString(recordConfig));
        return cmdParams;
    }

    private Map<String, Map<String, String>> buildComponentConfigurations(ConfTreeOperations appConf) {
        return appConf.getComponents();
    }

    protected static String getPackageListFromApplication(Application application) {
        List<OSSpecific> osSpecifics;
        String pkgFormatString = "{\"type\":\"%s\",\"name\":\"%s\"}";
        ArrayList<String> packages = new ArrayList<String>();
        if (application != null && application.getPackages().size() <= 0 && (osSpecifics = application.getOSSpecifics()) != null && osSpecifics.size() > 0) {
            for (OSSpecific osSpecific : osSpecifics) {
                if (!osSpecific.getOsType().equals("any")) continue;
                for (OSPackage osPackage : osSpecific.getPackages()) {
                    packages.add(String.format(pkgFormatString, osPackage.getType(), osPackage.getName()));
                }
            }
        }
        if (!packages.isEmpty()) {
            return "[" + SliderUtils.join(packages, ",", false) + "]";
        }
        return "[]";
    }

    private String getPackageList(String roleGroup) {
        return AgentProviderService.getPackageListFromApplication(this.getMetaInfo(roleGroup).getApplication());
    }

    private void prepareExecutionCommand(ExecutionCommand cmd) {
        cmd.setTaskId(this.taskId.incrementAndGet());
        cmd.setCommandId(String.valueOf(cmd.getTaskId()) + "-1");
    }

    private Map<String, String> commandParametersSet(String scriptPath, long timeout, boolean recordConfig) {
        TreeMap<String, String> cmdParams = new TreeMap<String, String>();
        cmdParams.put("service_package_folder", "${AGENT_WORK_ROOT}/work/app/definition/package");
        cmdParams.put("script", scriptPath);
        cmdParams.put("schema_version", "2.0");
        cmdParams.put("command_timeout", Long.toString(timeout));
        cmdParams.put("script_type", "PYTHON");
        cmdParams.put("record_config", Boolean.toString(recordConfig));
        return cmdParams;
    }

    private Map<String, String> commandParametersSet(ComponentCommand compCmd, long timeout, boolean recordConfig) {
        TreeMap<String, String> cmdParams = new TreeMap<String, String>();
        cmdParams.put("service_package_folder", "${AGENT_WORK_ROOT}/work/app/definition/package");
        cmdParams.put("command", compCmd.getExec());
        cmdParams.put("schema_version", "2.0");
        cmdParams.put("command_timeout", Long.toString(timeout));
        cmdParams.put("script_type", compCmd.getType());
        cmdParams.put("record_config", Boolean.toString(recordConfig));
        return cmdParams;
    }

    @VisibleForTesting
    protected void addStatusCommand(String roleName, String roleGroup, String containerId, HeartBeatResponse response, String scriptPath, long timeout) throws SliderException {
        assert (this.getAmState().isApplicationLive());
        ConfTreeOperations appConf = this.getAmState().getAppConfSnapshot();
        if (this.isDockerContainer(roleGroup) || this.isYarnDockerContainer(roleGroup)) {
            this.addStatusDockerCommand(roleName, roleGroup, containerId, response, scriptPath, timeout);
            return;
        }
        StatusCommand cmd = new StatusCommand();
        String clusterName = this.getClusterName();
        cmd.setCommandType(AgentCommandType.STATUS_COMMAND);
        cmd.setComponentName(roleName);
        cmd.setServiceName(clusterName);
        cmd.setClusterName(clusterName);
        cmd.setRoleCommand(StatusCommand.STATUS_COMMAND);
        TreeMap<String, String> hostLevelParams = new TreeMap<String, String>();
        hostLevelParams.put("java_home", appConf.getGlobalOptions().getOption("java_home", AgentProviderService.getJDKDir()));
        hostLevelParams.put(CONTAINER_ID, containerId);
        cmd.setHostLevelParams(hostLevelParams);
        cmd.setCommandParams(this.commandParametersSet(scriptPath, timeout, false));
        Map<String, Map<String, String>> configurations = this.buildCommandConfigurations(appConf, containerId, roleName, roleGroup);
        cmd.setConfigurations(configurations);
        response.addStatusCommand(cmd);
    }

    @VisibleForTesting
    protected void addStatusDockerCommand(String roleName, String roleGroup, String containerId, HeartBeatResponse response, String scriptPath, long timeout) throws SliderException {
        assert (this.getAmState().isApplicationLive());
        ConfTreeOperations appConf = this.getAmState().getAppConfSnapshot();
        StatusCommand cmd = new StatusCommand();
        String clusterName = this.getClusterName();
        cmd.setCommandType(AgentCommandType.STATUS_COMMAND);
        cmd.setComponentName(roleName);
        cmd.setServiceName(clusterName);
        cmd.setClusterName(clusterName);
        cmd.setRoleCommand(StatusCommand.STATUS_COMMAND);
        TreeMap<String, String> hostLevelParams = new TreeMap<String, String>();
        hostLevelParams.put("java_home", appConf.getGlobalOptions().getMandatoryOption("java_home"));
        hostLevelParams.put(CONTAINER_ID, containerId);
        cmd.setHostLevelParams(hostLevelParams);
        cmd.setCommandParams(this.setCommandParameters(scriptPath, timeout, false));
        Map<String, Map<String, String>> configurations = this.buildCommandConfigurations(appConf, containerId, roleName, roleGroup);
        HashMap<String, String> dockerConfig = new HashMap<String, String>();
        String statusCommand = this.getConfigFromMetaInfoWithAppConfigOverriding(roleGroup, "statusCommand");
        if (statusCommand == null) {
            if (this.isYarnDockerContainer(roleGroup)) {
                cmd.setYarnDockerMode(true);
            } else {
                statusCommand = "docker top " + containerId + " | grep \"\"";
            }
        }
        dockerConfig.put("docker.status_command", statusCommand);
        configurations.put("docker", dockerConfig);
        cmd.setConfigurations(configurations);
        log.debug("Docker- status {}", (Object)cmd);
        response.addStatusCommand(cmd);
    }

    @VisibleForTesting
    protected void addGetConfigDockerCommand(String roleName, String roleGroup, String containerId, HeartBeatResponse response) throws SliderException {
        assert (this.getAmState().isApplicationLive());
        StatusCommand cmd = new StatusCommand();
        String clusterName = this.getClusterName();
        cmd.setCommandType(AgentCommandType.STATUS_COMMAND);
        cmd.setComponentName(roleName);
        cmd.setServiceName(clusterName);
        cmd.setClusterName(clusterName);
        cmd.setRoleCommand(StatusCommand.GET_CONFIG_COMMAND);
        TreeMap<String, String> hostLevelParams = new TreeMap<String, String>();
        hostLevelParams.put(CONTAINER_ID, containerId);
        cmd.setHostLevelParams(hostLevelParams);
        hostLevelParams.put(CONTAINER_ID, containerId);
        ConfTreeOperations appConf = this.getAmState().getAppConfSnapshot();
        Map<String, Map<String, String>> configurations = this.buildCommandConfigurations(appConf, containerId, roleName, roleGroup);
        HashMap<String, String> dockerConfig = new HashMap<String, String>();
        String statusCommand = this.getConfigFromMetaInfoWithAppConfigOverriding(roleGroup, "statusCommand");
        if (statusCommand == null) {
            if (this.isYarnDockerContainer(roleGroup)) {
                cmd.setYarnDockerMode(true);
            } else {
                statusCommand = "docker top " + containerId + " | grep \"\"";
            }
        }
        dockerConfig.put("docker.status_command", statusCommand);
        configurations.put("docker", dockerConfig);
        cmd.setConfigurations(configurations);
        log.debug("Docker- getconfig command {}", (Object)cmd);
        response.addStatusCommand(cmd);
    }

    private String getConfigFromMetaInfoWithAppConfigOverriding(String roleGroup, String configName) {
        ConfTreeOperations appConf = this.getAmState().getAppConfSnapshot();
        String containerName = this.getApplicationComponent(roleGroup).getDockerContainers().get(0).getName();
        String composedConfigName = null;
        String appConfigValue = null;
        composedConfigName = configName.equals("containerPort") || configName.equals("hostPort") ? String.valueOf(containerName) + ".ports." + configName : (configName.equals("containerMount") || configName.equals("hostMount") ? String.valueOf(containerName) + ".mounts." + configName : (configName.equals("containerPath") || configName.equals("fileLocalPath") ? String.valueOf(containerName) + ".inputFiles." + configName : String.valueOf(containerName) + "." + configName));
        appConfigValue = appConf.getComponentOpt(roleGroup, composedConfigName, null);
        log.debug("Docker- value from appconfig component: {} configName: {} value: {}", new Object[]{roleGroup, composedConfigName, appConfigValue});
        if (appConfigValue == null) {
            appConfigValue = this.getConfigFromMetaInfo(roleGroup, configName);
            log.debug("Docker- value from metainfo component: {} configName: {} value: {}", new Object[]{roleGroup, configName, appConfigValue});
        }
        return appConfigValue;
    }

    @VisibleForTesting
    protected void addStartDockerCommand(String roleName, String roleGroup, String containerId, HeartBeatResponse response, ComponentCommand startCommand, long timeout, boolean isMarkedAutoRestart) throws SliderException {
        assert (this.getAmState().isApplicationLive());
        ConfTreeOperations appConf = this.getAmState().getAppConfSnapshot();
        ConfTreeOperations internalsConf = this.getAmState().getInternalsSnapshot();
        ExecutionCommand cmd = new ExecutionCommand(AgentCommandType.EXECUTION_COMMAND);
        this.prepareExecutionCommand(cmd);
        String clusterName = internalsConf.get("application.name");
        String hostName = this.getClusterInfoPropertyValue("info.am.hostname");
        cmd.setHostname(hostName);
        cmd.setClusterName(clusterName);
        cmd.setRoleCommand(Command.START.toString());
        cmd.setServiceName(clusterName);
        cmd.setComponentName(roleName);
        cmd.setRole(roleName);
        TreeMap<String, String> hostLevelParams = new TreeMap<String, String>();
        hostLevelParams.put(CONTAINER_ID, containerId);
        cmd.setHostLevelParams(hostLevelParams);
        TreeMap<String, String> roleParams = new TreeMap<String, String>();
        cmd.setRoleParams(roleParams);
        cmd.getRoleParams().put("auto_restart", Boolean.toString(isMarkedAutoRestart));
        startCommand = new ComponentCommand();
        startCommand.setName("START");
        startCommand.setType("docker");
        startCommand.setExec("exec");
        cmd.setCommandParams(this.setCommandParameters(startCommand, timeout, true));
        Map<String, Map<String, String>> configurations = this.buildCommandConfigurations(appConf, containerId, roleName, roleGroup);
        Map<String, Map<String, String>> componentConfigurations = this.buildComponentConfigurations(appConf);
        cmd.setComponentConfigurations(componentConfigurations);
        HashMap<String, String> dockerConfig = new HashMap<String, String>();
        if (this.isYarnDockerContainer(roleGroup)) {
            dockerConfig.put("docker.startCommand", this.getConfigFromMetaInfoWithAppConfigOverriding(roleGroup, "start_command"));
            cmd.setYarnDockerMode(true);
        } else {
            dockerConfig.put("docker.command_path", this.getConfigFromMetaInfoWithAppConfigOverriding(roleGroup, "commandPath"));
            dockerConfig.put("docker.image_name", this.getConfigFromMetaInfo(roleGroup, "image"));
            String options = this.getConfigFromMetaInfoWithAppConfigOverriding(roleGroup, "options");
            options = options != null && !options.isEmpty() ? String.valueOf(options) + " -d" : "-d";
            dockerConfig.put("docker.options", options);
            dockerConfig.put("docker.containerPort", this.getConfigFromMetaInfoWithAppConfigOverriding(roleGroup, "containerPort"));
            dockerConfig.put("docker.hostPort", this.getConfigFromMetaInfoWithAppConfigOverriding(roleGroup, "hostPort"));
            dockerConfig.put("docker.mounting_directory", this.getConfigFromMetaInfoWithAppConfigOverriding(roleGroup, "containerMount"));
            dockerConfig.put("docker.host_mounting_directory", this.getConfigFromMetaInfoWithAppConfigOverriding(roleGroup, "hostMount"));
            dockerConfig.put("docker.additional_param", this.getConfigFromMetaInfoWithAppConfigOverriding(roleGroup, "additionalParam"));
            dockerConfig.put("docker.input_file.mount_path", this.getConfigFromMetaInfo(roleGroup, "containerPath"));
        }
        String lifetime = this.getConfigFromMetaInfoWithAppConfigOverriding(roleGroup, "lifetime");
        dockerConfig.put("docker.lifetime", lifetime);
        configurations.put("docker", dockerConfig);
        String statusCommand = this.getConfigFromMetaInfoWithAppConfigOverriding(roleGroup, "statusCommand");
        if (statusCommand == null && !this.isYarnDockerContainer(roleGroup)) {
            statusCommand = "docker top " + containerId + " | grep \"\"";
        }
        dockerConfig.put("docker.status_command", statusCommand);
        cmd.setConfigurations(configurations);
        cmd.addContainerDetails(roleGroup, this.getMetaInfo(roleGroup));
        log.info("Docker- command: {}", (Object)cmd.toString());
        response.addExecutionCommand(cmd);
    }

    private String getConfigFromMetaInfo(String roleGroup, String configName) {
        String result;
        block46: {
            result = null;
            List<DockerContainer> containers = this.getApplicationComponent(roleGroup).getDockerContainers();
            log.debug("Docker- containers metainfo: {}", (Object)containers.toString());
            if (containers.size() <= 0) break block46;
            DockerContainer container = containers.get(0);
            switch (configName) {
                case "start_command": {
                    result = container.getStartCommand();
                    break;
                }
                case "image": {
                    result = container.getImage();
                    break;
                }
                case "network": {
                    if (container.getNetwork() == null || container.getNetwork().isEmpty()) {
                        result = "none";
                        break;
                    }
                    result = container.getNetwork();
                    break;
                }
                case "useNetworkScript": {
                    if (container.getUseNetworkScript() == null || container.getUseNetworkScript().isEmpty()) {
                        result = "yes";
                        break;
                    }
                    result = container.getUseNetworkScript();
                    break;
                }
                case "statusCommand": {
                    result = container.getStatusCommand();
                    break;
                }
                case "commandPath": {
                    result = container.getCommandPath();
                    break;
                }
                case "options": {
                    result = container.getOptions();
                    break;
                }
                case "containerPort": {
                    result = container.getPorts().size() > 0 ? container.getPorts().get(0).getContainerPort() : null;
                    break;
                }
                case "hostPort": {
                    result = container.getPorts().size() > 0 ? container.getPorts().get(0).getHostPort() : null;
                    break;
                }
                case "containerMount": {
                    result = container.getMounts().size() > 0 ? container.getMounts().get(0).getContainerMount() : null;
                    break;
                }
                case "hostMount": {
                    result = container.getMounts().size() > 0 ? container.getMounts().get(0).getHostMount() : null;
                    break;
                }
                case "additionalParam": {
                    result = container.getAdditionalParam();
                    break;
                }
                case "runPriviledgedContainer": {
                    if (container.getRunPrivilegedContainer() == null) {
                        result = "false";
                        break;
                    }
                    result = container.getRunPrivilegedContainer();
                    break;
                }
            }
        }
        log.debug("Docker- component: {} configName: {} value: {}", new Object[]{roleGroup, configName, result});
        return result;
    }

    @VisibleForTesting
    protected void addGetConfigCommand(String roleName, String roleGroup, String containerId, HeartBeatResponse response) throws SliderException {
        assert (this.getAmState().isApplicationLive());
        StatusCommand cmd = new StatusCommand();
        String clusterName = this.getClusterName();
        cmd.setCommandType(AgentCommandType.STATUS_COMMAND);
        cmd.setComponentName(roleName);
        cmd.setServiceName(clusterName);
        cmd.setClusterName(clusterName);
        cmd.setRoleCommand(StatusCommand.GET_CONFIG_COMMAND);
        TreeMap<String, String> hostLevelParams = new TreeMap<String, String>();
        hostLevelParams.put(CONTAINER_ID, containerId);
        cmd.setHostLevelParams(hostLevelParams);
        hostLevelParams.put(CONTAINER_ID, containerId);
        response.addStatusCommand(cmd);
    }

    @VisibleForTesting
    protected void addStartCommand(String roleName, String roleGroup, String containerId, HeartBeatResponse response, String scriptPath, ComponentCommand startCommand, ComponentCommand stopCommand, long timeout, boolean isMarkedAutoRestart) throws SliderException {
        assert (this.getAmState().isApplicationLive());
        ConfTreeOperations appConf = this.getAmState().getAppConfSnapshot();
        ConfTreeOperations internalsConf = this.getAmState().getInternalsSnapshot();
        ExecutionCommand cmd = new ExecutionCommand(AgentCommandType.EXECUTION_COMMAND);
        this.prepareExecutionCommand(cmd);
        String clusterName = internalsConf.get("application.name");
        String hostName = this.getClusterInfoPropertyValue("info.am.hostname");
        cmd.setHostname(hostName);
        cmd.setClusterName(clusterName);
        cmd.setRoleCommand(Command.START.toString());
        cmd.setServiceName(clusterName);
        cmd.setComponentName(roleName);
        cmd.setRole(roleName);
        TreeMap<String, String> hostLevelParams = new TreeMap<String, String>();
        hostLevelParams.put("java_home", appConf.getGlobalOptions().getOption("java_home", AgentProviderService.getJDKDir()));
        hostLevelParams.put(CONTAINER_ID, containerId);
        cmd.setHostLevelParams(hostLevelParams);
        TreeMap<String, String> roleParams = new TreeMap<String, String>();
        cmd.setRoleParams(roleParams);
        cmd.getRoleParams().put("auto_restart", Boolean.toString(isMarkedAutoRestart));
        Map<String, Map<String, String>> configurations = this.buildCommandConfigurations(appConf, containerId, roleName, roleGroup);
        cmd.setConfigurations(configurations);
        Map<String, Map<String, String>> componentConfigurations = this.buildComponentConfigurations(appConf);
        cmd.setComponentConfigurations(componentConfigurations);
        if (SliderUtils.isSet(scriptPath)) {
            cmd.setCommandParams(this.commandParametersSet(scriptPath, timeout, true));
        } else {
            if (startCommand == null) {
                throw new SliderException("Expected START command not found for component " + roleName);
            }
            cmd.setCommandParams(this.commandParametersSet(startCommand, timeout, true));
            configurations.get(GLOBAL_CONFIG_TAG).put("exec_cmd", startCommand.getExec());
        }
        response.addExecutionCommand(cmd);
        log.debug("command looks like: {}", (Object)cmd);
        ExecutionCommand cmdStop = new ExecutionCommand(AgentCommandType.EXECUTION_COMMAND);
        cmdStop.setTaskId(this.taskId.get());
        cmdStop.setCommandId(String.valueOf(cmdStop.getTaskId()) + "-1");
        cmdStop.setHostname(hostName);
        cmdStop.setClusterName(clusterName);
        cmdStop.setRoleCommand(Command.STOP.toString());
        cmdStop.setServiceName(clusterName);
        cmdStop.setComponentName(roleName);
        cmdStop.setRole(roleName);
        TreeMap<String, String> hostLevelParamsStop = new TreeMap<String, String>();
        hostLevelParamsStop.put("java_home", appConf.getGlobalOptions().getOption("java_home", ""));
        hostLevelParamsStop.put(CONTAINER_ID, containerId);
        cmdStop.setHostLevelParams(hostLevelParamsStop);
        TreeMap<String, String> roleParamsStop = new TreeMap<String, String>();
        cmdStop.setRoleParams(roleParamsStop);
        cmdStop.getRoleParams().put("auto_restart", Boolean.toString(isMarkedAutoRestart));
        if (SliderUtils.isSet(scriptPath)) {
            cmdStop.setCommandParams(this.commandParametersSet(scriptPath, timeout, true));
        } else {
            if (stopCommand == null) {
                stopCommand = ComponentCommand.getDefaultComponentCommand("STOP");
            }
            cmd.setCommandParams(this.commandParametersSet(stopCommand, timeout, true));
            configurations.get(GLOBAL_CONFIG_TAG).put("exec_cmd", startCommand.getExec());
        }
        Map<String, Map<String, String>> configurationsStop = this.buildCommandConfigurations(appConf, containerId, roleName, roleGroup);
        cmdStop.setConfigurations(configurationsStop);
        response.addExecutionCommand(cmdStop);
    }

    @VisibleForTesting
    protected void addUpgradeCommand(String roleName, String roleGroup, String containerId, HeartBeatResponse response, String scriptPath, long timeout) throws SliderException {
        assert (this.getAmState().isApplicationLive());
        ConfTreeOperations appConf = this.getAmState().getAppConfSnapshot();
        ConfTreeOperations internalsConf = this.getAmState().getInternalsSnapshot();
        ExecutionCommand cmd = new ExecutionCommand(AgentCommandType.EXECUTION_COMMAND);
        this.prepareExecutionCommand(cmd);
        String clusterName = internalsConf.get("application.name");
        String hostName = this.getClusterInfoPropertyValue("info.am.hostname");
        cmd.setHostname(hostName);
        cmd.setClusterName(clusterName);
        cmd.setRoleCommand(Command.UPGRADE.toString());
        cmd.setServiceName(clusterName);
        cmd.setComponentName(roleName);
        cmd.setRole(roleName);
        TreeMap<String, String> hostLevelParams = new TreeMap<String, String>();
        hostLevelParams.put("java_home", appConf.getGlobalOptions().getMandatoryOption("java_home"));
        hostLevelParams.put(CONTAINER_ID, containerId);
        cmd.setHostLevelParams(hostLevelParams);
        cmd.setCommandParams(this.commandParametersSet(scriptPath, timeout, true));
        Map<String, Map<String, String>> configurations = this.buildCommandConfigurations(appConf, containerId, roleName, roleGroup);
        cmd.setConfigurations(configurations);
        response.addExecutionCommand(cmd);
    }

    protected void addStopCommand(String roleName, String roleGroup, String containerId, HeartBeatResponse response, String scriptPath, long timeout, boolean isInUpgradeMode) throws SliderException {
        assert (this.getAmState().isApplicationLive());
        ConfTreeOperations appConf = this.getAmState().getAppConfSnapshot();
        ConfTreeOperations internalsConf = this.getAmState().getInternalsSnapshot();
        ExecutionCommand cmdStop = new ExecutionCommand(AgentCommandType.EXECUTION_COMMAND);
        cmdStop.setTaskId(this.taskId.get());
        cmdStop.setCommandId(String.valueOf(cmdStop.getTaskId()) + "-1");
        String clusterName = internalsConf.get("application.name");
        String hostName = this.getClusterInfoPropertyValue("info.am.hostname");
        cmdStop.setHostname(hostName);
        cmdStop.setClusterName(clusterName);
        cmdStop.setRoleCommand(Command.transform(Command.STOP, isInUpgradeMode));
        cmdStop.setServiceName(clusterName);
        cmdStop.setComponentName(roleName);
        cmdStop.setRole(roleName);
        TreeMap<String, String> hostLevelParamsStop = new TreeMap<String, String>();
        hostLevelParamsStop.put("java_home", appConf.getGlobalOptions().getMandatoryOption("java_home"));
        hostLevelParamsStop.put(CONTAINER_ID, containerId);
        cmdStop.setHostLevelParams(hostLevelParamsStop);
        cmdStop.setCommandParams(this.commandParametersSet(scriptPath, timeout, true));
        Map<String, Map<String, String>> configurationsStop = this.buildCommandConfigurations(appConf, containerId, roleName, roleGroup);
        cmdStop.setConfigurations(configurationsStop);
        response.addExecutionCommand(cmdStop);
    }

    protected static String getJDKDir() {
        File javaHome = new File(System.getProperty("java.home")).getParentFile();
        File jdkDirectory = null;
        if (javaHome.getName().contains("jdk")) {
            jdkDirectory = javaHome;
        }
        if (jdkDirectory != null) {
            return jdkDirectory.getAbsolutePath();
        }
        return "";
    }

    protected Map<String, String> getAllocatedPorts() {
        return this.getAllocatedPorts(SHARED_PORT_TAG);
    }

    protected Map<String, Map<String, String>> getComponentInstanceData() {
        return this.componentInstanceData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getAllocatedPorts(String containerId) {
        if (!this.allocatedPorts.containsKey(containerId)) {
            Map<String, Map<String, String>> map = this.allocatedPorts;
            synchronized (map) {
                if (!this.allocatedPorts.containsKey(containerId)) {
                    this.allocatedPorts.put(containerId, new ConcurrentHashMap());
                }
            }
        }
        return this.allocatedPorts.get(containerId);
    }

    private Map<String, Map<String, String>> buildCommandConfigurations(ConfTreeOperations appConf, String containerId, String roleName, String roleGroup) throws SliderException {
        TreeMap<String, Map<String, String>> configurations = new TreeMap<String, Map<String, String>>();
        Map<String, String> tokens = this.getStandardTokenMap(appConf, roleName, roleGroup);
        tokens.put("${CONTAINER_ID}", containerId);
        HashSet<String> configs = new HashSet<String>();
        configs.addAll(this.getApplicationConfigurationTypes(roleGroup));
        configs.addAll(this.getSystemConfigurationsRequested(appConf));
        for (String configType : configs) {
            this.addNamedConfiguration(configType, appConf.getGlobalOptions().options, configurations, tokens, containerId, roleName, roleGroup);
            if (appConf.getComponent(roleGroup) == null) continue;
            this.addNamedConfiguration(configType, appConf.getComponent((String)roleGroup).options, configurations, tokens, containerId, roleName, roleGroup);
        }
        this.dereferenceAllConfigs(configurations);
        return configurations;
    }

    protected void dereferenceAllConfigs(Map<String, Map<String, String>> configurations) {
        HashMap<String, String> allConfigs = new HashMap<String, String>();
        String lookupFormat = "${@//site/%s/%s}";
        for (String configType : configurations.keySet()) {
            Map<String, String> configBucket = configurations.get(configType);
            for (String configName : configBucket.keySet()) {
                allConfigs.put(String.format(lookupFormat, configType, configName), configBucket.get(configName));
            }
        }
        boolean finished = false;
        while (!finished) {
            finished = true;
            for (Map.Entry entry : allConfigs.entrySet()) {
                String configValue = (String)entry.getValue();
                for (Map.Entry<String, String> entry2 : allConfigs.entrySet()) {
                    String lookUpValue = entry2.getValue();
                    if (lookUpValue.contains("${@//site/")) continue;
                    String lookUpKey = entry2.getKey();
                    if (configValue == null || !configValue.contains(lookUpKey)) continue;
                    configValue = configValue.replace(lookUpKey, lookUpValue);
                }
                if (configValue.equals(entry.getValue())) continue;
                finished = false;
                allConfigs.put((String)entry.getKey(), configValue);
            }
        }
        for (String string : configurations.keySet()) {
            Map<String, String> configBucket = configurations.get(string);
            for (Map.Entry<String, String> entry : configBucket.entrySet()) {
                String configName = entry.getKey();
                String configValue = entry.getValue();
                for (Map.Entry lookUpEntry : allConfigs.entrySet()) {
                    String lookUpValue = (String)lookUpEntry.getValue();
                    if (lookUpValue.contains("${@//site/")) continue;
                    String lookUpKey = (String)lookUpEntry.getKey();
                    if (configValue == null || !configValue.contains(lookUpKey)) continue;
                    configValue = configValue.replace(lookUpKey, lookUpValue);
                }
                configBucket.put(configName, configValue);
            }
        }
    }

    private Map<String, String> getStandardTokenMap(ConfTreeOperations appConf, String componentName, String componentGroup) throws SliderException {
        HashMap<String, String> tokens = new HashMap<String, String>();
        String nnuri = appConf.get("site.fs.defaultFS");
        tokens.put("${NN_URI}", nnuri);
        tokens.put("${NN_HOST}", URI.create(nnuri).getHost());
        tokens.put("${ZK_HOST}", appConf.get("zookeeper.hosts"));
        tokens.put("${DEFAULT_ZK_PATH}", appConf.get("zookeeper.path"));
        String prefix = appConf.getComponentOpt(componentGroup, "role.prefix", null);
        String dataDirSuffix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            dataDirSuffix = "_" + SliderUtils.trimPrefix(prefix);
        }
        tokens.put("${DEFAULT_DATA_DIR}", String.valueOf(this.getAmState().getInternalsSnapshot().getGlobalOptions().getMandatoryOption("internal.data.dir.path")) + dataDirSuffix);
        tokens.put("${JAVA_HOME}", appConf.get("java_home"));
        tokens.put("${COMPONENT_NAME}", componentName);
        tokens.put("${COMPONENT_NAME.lc}", componentName.toLowerCase());
        tokens.put("${COMPONENT_PREFIX}", prefix);
        tokens.put("${COMPONENT_PREFIX.lc}", prefix.toLowerCase());
        if (!componentName.equals(componentGroup) && componentName.startsWith(componentGroup)) {
            tokens.put("${COMPONENT_ID}", componentName.substring(componentGroup.length()));
        }
        tokens.put("${CLUSTER_NAME}", this.getClusterName());
        tokens.put("${CLUSTER_NAME.lc}", this.getClusterName().toLowerCase());
        tokens.put("${APP_NAME}", this.getClusterName());
        tokens.put("${APP_NAME.lc}", this.getClusterName().toLowerCase());
        tokens.put("${APP_COMPONENT_NAME}", componentName);
        tokens.put("${APP_COMPONENT_NAME.lc}", componentName.toLowerCase());
        return tokens;
    }

    @VisibleForTesting
    protected List<String> getSystemConfigurationsRequested(ConfTreeOperations appConf) {
        ArrayList<String> configList = new ArrayList<String>();
        String configTypes = appConf.get("system_configs");
        if (configTypes != null && configTypes.length() > 0) {
            String[] configs;
            String[] stringArray = configs = configTypes.split(",");
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                String config = stringArray[n2];
                configList.add(config.trim());
                ++n2;
            }
        }
        return new ArrayList<String>(new HashSet(configList));
    }

    @VisibleForTesting
    protected List<String> getApplicationConfigurationTypes(String roleGroup) {
        ArrayList<String> configList = new ArrayList<String>();
        configList.add(GLOBAL_CONFIG_TAG);
        List<ConfigFile> configFiles = this.getMetaInfo(roleGroup).getApplication().getConfigFiles();
        for (ConfigFile configFile : configFiles) {
            log.info("Expecting config type {}.", (Object)configFile.getDictionaryName());
            configList.add(configFile.getDictionaryName());
        }
        for (Component component : this.getMetaInfo(roleGroup).getApplication().getComponents()) {
            if (!component.getName().equals(roleGroup) || component.getDockerContainers() == null) continue;
            for (DockerContainer container : component.getDockerContainers()) {
                if (container.getConfigFiles() == null) continue;
                for (ConfigFile configFile : container.getConfigFiles()) {
                    log.info("Expecting config type {}.", (Object)configFile.getDictionaryName());
                    configList.add(configFile.getDictionaryName());
                }
            }
        }
        return new ArrayList<String>(new HashSet(configList));
    }

    private void addNamedConfiguration(String configName, Map<String, String> sourceConfig, Map<String, Map<String, String>> configurations, Map<String, String> tokens, String containerId, String roleName, String roleGroup) {
        HashMap<String, String> config = new HashMap<String, String>();
        if (configName.equals(GLOBAL_CONFIG_TAG)) {
            this.addDefaultGlobalConfig(config, containerId, roleName);
        }
        this.addRoleRelatedTokens(tokens);
        providerUtils.propagateSiteOptions(sourceConfig, config, configName, tokens);
        if (!this.getAllocatedPorts().isEmpty()) {
            for (String key : config.keySet()) {
                String value = (String)config.get(key);
                String lookupKey = String.valueOf(configName) + "." + key;
                if (!value.contains(PER_CONTAINER_TAG)) {
                    if (!this.getAllocatedPorts().containsKey(lookupKey)) continue;
                    config.put(key, this.getAllocatedPorts().get(lookupKey));
                    continue;
                }
                if (!this.getAllocatedPorts(containerId).containsKey(lookupKey)) continue;
                config.put(key, this.getAllocatedPorts(containerId).get(lookupKey));
            }
        }
        if (this.getDefaultConfigs(roleGroup).containsKey(configName)) {
            log.info("Adding default configs for type {}.", (Object)configName);
            for (PropertyInfo defaultConfigProp : this.getDefaultConfigs(roleGroup).get(configName).getPropertyInfos()) {
                if (config.containsKey(defaultConfigProp.getName()) || defaultConfigProp.getName().isEmpty() || defaultConfigProp.getValue() == null || defaultConfigProp.getValue().isEmpty()) continue;
                config.put(defaultConfigProp.getName(), defaultConfigProp.getValue());
            }
        }
        configurations.put(configName, config);
    }

    protected void addRoleRelatedTokens(Map<String, String> tokens) {
        for (Map.Entry<String, Map<String, ClusterNode>> entry : this.getRoleClusterNodeMapping().entrySet()) {
            String tokenName = String.valueOf(entry.getKey().toUpperCase(Locale.ENGLISH)) + "_HOST";
            String hosts = StringUtils.join((CharSequence)",", this.getHostsList(entry.getValue().values(), true));
            tokens.put("${" + tokenName + "}", hosts);
        }
    }

    private Iterable<String> getHostsList(Collection<ClusterNode> values, boolean hostOnly) {
        ArrayList<String> hosts = new ArrayList<String>();
        for (ClusterNode cn : values) {
            hosts.add(hostOnly ? cn.host : String.valueOf(cn.host) + "/" + cn.name);
        }
        return hosts;
    }

    private void addDefaultGlobalConfig(Map<String, String> config, String containerId, String roleName) {
        config.put("app_log_dir", "${AGENT_LOG_ROOT}");
        config.put("app_pid_dir", "${AGENT_WORK_ROOT}/app/run");
        config.put("app_install_dir", "${AGENT_WORK_ROOT}/app/install");
        config.put("app_conf_dir", "${AGENT_WORK_ROOT}/app/conf");
        config.put("app_input_conf_dir", "${AGENT_WORK_ROOT}/propagatedconf");
        config.put("app_container_id", containerId);
        config.put("app_container_tag", this.tags.getTag(roleName, containerId));
        if (!config.containsKey("pid_file")) {
            config.put("pid_file", "${AGENT_WORK_ROOT}/app/run/component.pid");
        }
        if (!config.containsKey("app_root")) {
            config.put("app_root", "${AGENT_WORK_ROOT}/app/install");
        }
    }

    private void buildRoleHostDetails(Map<String, MonitorDetail> details) {
        for (Map.Entry<String, Map<String, ClusterNode>> entry : this.getRoleClusterNodeMapping().entrySet()) {
            details.put(String.valueOf(entry.getKey()) + " Host(s)/Container(s)", new MonitorDetail(this.getHostsList(entry.getValue().values(), false).toString(), false));
        }
    }

    private static class MetainfoHolder {
        Metainfo metaInfo;
        private Map<String, DefaultConfig> defaultConfigs = null;

        public MetainfoHolder(Metainfo metaInfo, Map<String, DefaultConfig> defaultConfigs) {
            this.metaInfo = metaInfo;
            this.defaultConfigs = defaultConfigs;
        }
    }
}

