/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.registry.docstore;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.slider.core.registry.docstore.PublishedConfiguration;
import org.apache.slider.server.services.utility.PatternValidator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class PublishedConfigSet {
    private static final PatternValidator validator = new PatternValidator("[a-z0-9][a-z0-9_\\+-]*");
    public Map<String, PublishedConfiguration> configurations = new HashMap<String, PublishedConfiguration>();

    public void put(String name, PublishedConfiguration conf) {
        String name1 = name.toLowerCase(Locale.ENGLISH);
        PublishedConfigSet.validateName(name1);
        this.configurations.put(name1, conf);
    }

    public static void validateName(String name) {
        validator.validate(name);
    }

    public PublishedConfiguration get(String name) {
        return this.configurations.get(name);
    }

    public boolean contains(String name) {
        return this.configurations.containsKey(name);
    }

    public int size() {
        return this.configurations.size();
    }

    public Set<String> keys() {
        TreeSet<String> keys = new TreeSet<String>();
        keys.addAll(this.configurations.keySet());
        return keys;
    }

    public PublishedConfigSet shallowCopy() {
        PublishedConfigSet that = new PublishedConfigSet();
        for (Map.Entry<String, PublishedConfiguration> entry : this.configurations.entrySet()) {
            that.put(entry.getKey(), entry.getValue().shallowCopy());
        }
        return that;
    }
}

