/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.api;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.slider.api.types.ApplicationDiagnostics;
import org.apache.slider.api.types.ApplicationLivenessInformation;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.BadConfigException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ClusterDescription
implements Cloneable {
    protected static final Logger log = LoggerFactory.getLogger(ClusterDescription.class);
    private static final String UTF_8 = "UTF-8";
    public String version = "1.0";
    public String name;
    public String type = "agent";
    public int state;
    public static final int STATE_INCOMPLETE = 0;
    public static final int STATE_SUBMITTED = 1;
    public static final int STATE_CREATED = 2;
    public static final int STATE_LIVE = 3;
    public static final int STATE_STOPPED = 4;
    public static final int STATE_DESTROYED = 5;
    public long createTime;
    public long updateTime;
    public String originConfigurationPath;
    public String generatedConfigurationPath;
    public String dataPath;
    public Map<String, String> options = new HashMap<String, String>();
    public Map<String, String> info = new HashMap<String, String>();
    public Map<String, Map<String, Integer>> statistics = new HashMap<String, Map<String, Integer>>();
    public Map<String, List<String>> instances = new HashMap<String, List<String>>();
    public Map<String, Map<String, String>> roles = new HashMap<String, Map<String, String>>();
    public Map<String, String> clientProperties = new HashMap<String, String>();
    public Map<String, Object> status;
    public ApplicationLivenessInformation liveness;
    public ApplicationDiagnostics appDiagnostics = new ApplicationDiagnostics();

    public String toString() {
        try {
            return this.toJsonString();
        }
        catch (Exception e) {
            log.debug("Failed to convert CD to JSON ", (Throwable)e);
            return super.toString();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ClusterDescription deepClone() {
        try {
            return ClusterDescription.fromJson(this.toJsonString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void save(FileSystem fs, Path path, boolean overwrite) throws IOException {
        FSDataOutputStream dataOutputStream = fs.create(path, overwrite);
        this.writeJsonAsBytes((DataOutputStream)dataOutputStream);
    }

    public void save(File file) throws IOException {
        log.debug("Saving to {}", (Object)file.getAbsolutePath());
        if (!file.getParentFile().mkdirs()) {
            log.warn("Failed to mkdirs for {}", (Object)file.getParentFile());
        }
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        this.writeJsonAsBytes(dataOutputStream);
    }

    private void writeJsonAsBytes(DataOutputStream dataOutputStream) throws IOException {
        try {
            String json = this.toJsonString();
            byte[] b = json.getBytes(UTF_8);
            dataOutputStream.write(b);
        }
        finally {
            dataOutputStream.close();
        }
    }

    public static ClusterDescription load(FileSystem fs, Path path) throws IOException, JsonParseException, JsonMappingException {
        FileStatus status = fs.getFileStatus(path);
        byte[] b = new byte[(int)status.getLen()];
        FSDataInputStream dataInputStream = fs.open(path);
        int count = dataInputStream.read(b);
        String json = new String(b, 0, count, UTF_8);
        return ClusterDescription.fromJson(json);
    }

    public static ClusterDescription copy(ClusterDescription source) {
        try {
            return ClusterDescription.fromJson(source.toJsonString());
        }
        catch (IOException e) {
            throw new RuntimeException("ClusterDescription copy failed " + e, e);
        }
    }

    public String toJsonString() throws IOException, JsonGenerationException, JsonMappingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        return mapper.writeValueAsString((Object)this);
    }

    public static ClusterDescription fromJson(String json) throws IOException, JsonParseException, JsonMappingException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (ClusterDescription)mapper.readValue(json, ClusterDescription.class);
        }
        catch (IOException e) {
            log.error("Exception while parsing json : " + e + "\n" + json, (Throwable)e);
            throw e;
        }
    }

    public static ClusterDescription fromStream(InputStream is) throws IOException, JsonParseException, JsonMappingException {
        if (is == null) {
            throw new FileNotFoundException("Empty Stream");
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (ClusterDescription)mapper.readValue(is, ClusterDescription.class);
        }
        catch (IOException e) {
            log.error("Exception while parsing input stream : {}", (Object)e, (Object)e);
            throw e;
        }
    }

    public static ClusterDescription fromFile(File jsonFile) throws IOException, JsonParseException, JsonMappingException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (ClusterDescription)mapper.readValue(jsonFile, ClusterDescription.class);
        }
        catch (IOException e) {
            log.error("Exception while parsing json file {}", (Object)jsonFile, (Object)e);
            throw e;
        }
    }

    public void setOption(String key, String val) {
        this.options.put(key, val);
    }

    public void setOptionifUnset(String key, String val) {
        if (this.options.get(key) == null) {
            this.options.put(key, val);
        }
    }

    public void setOption(String option, int val) {
        this.setOption(option, Integer.toString(val));
    }

    public void setOption(String option, boolean val) {
        this.setOption(option, Boolean.toString(val));
    }

    public String getOption(String key, String defVal) {
        String val = this.options.get(key);
        return val != null ? val : defVal;
    }

    public String getMandatoryOption(String key) throws BadConfigException {
        String val = this.options.get(key);
        if (val == null) {
            throw new BadConfigException("Missing option " + key);
        }
        return val;
    }

    public int getOptionInt(String option, int defVal) {
        String val = this.getOption(option, Integer.toString(defVal));
        return Integer.decode(val);
    }

    public void verifyOptionSet(String key) throws BadConfigException {
        if (SliderUtils.isUnset(this.getOption(key, null))) {
            throw new BadConfigException("Unset cluster option %s", key);
        }
    }

    public boolean getOptionBool(String option, boolean defVal) {
        return Boolean.valueOf(this.getOption(option, Boolean.toString(defVal)));
    }

    public String getRoleOpt(String role, String option, String defVal) {
        Map<String, String> roleopts = this.getRole(role);
        if (roleopts == null) {
            return defVal;
        }
        String val = roleopts.get(option);
        return val != null ? val : defVal;
    }

    public String getMandatoryRoleOpt(String role, String option) throws BadConfigException {
        Map<String, String> roleopts = this.getRole(role);
        if (roleopts == null) {
            throw new BadConfigException("Missing role %s ", role);
        }
        String val = roleopts.get(option);
        if (val == null) {
            throw new BadConfigException("Missing option '%s' in role %s ", option, role);
        }
        return val;
    }

    public int getMandatoryRoleOptInt(String role, String option) throws BadConfigException {
        this.getMandatoryRoleOpt(role, option);
        return this.getRoleOptInt(role, option, 0);
    }

    public Map<String, String> getRole(String role) {
        return this.roles.get(role);
    }

    public Map<String, String> getOrAddRole(String role) {
        Map<String, String> map = this.getRole(role);
        if (map == null) {
            map = new HashMap<String, String>();
        }
        this.roles.put(role, map);
        return map;
    }

    @JsonIgnore
    public Set<String> getRoleNames() {
        return new HashSet<String>(this.roles.keySet());
    }

    public Map<String, String> getMandatoryRole(String role) throws BadConfigException {
        Map<String, String> roleOptions = this.getRole(role);
        if (roleOptions == null) {
            throw new BadConfigException("Missing role " + role);
        }
        return roleOptions;
    }

    public int getRoleOptInt(String role, String option, int defVal) {
        String val = this.getRoleOpt(role, option, Integer.toString(defVal));
        return Integer.decode(val);
    }

    public long getRoleOptLong(String role, String option, long defVal) {
        String val = this.getRoleOpt(role, option, Long.toString(defVal));
        return Long.decode(val);
    }

    public void setRoleOpt(String role, String option, String val) {
        Map<String, String> roleopts = this.getOrAddRole(role);
        roleopts.put(option, val);
    }

    public void setRoleOpt(String role, String option, int val) {
        this.setRoleOpt(role, option, Integer.toString(val));
    }

    public void setRoleOpt(String role, String option, Object val) {
        this.setRoleOpt(role, option, val.toString());
    }

    public int getRoleResourceRequirement(String role, String option, int defVal, int maxVal) {
        String val = this.getRoleOpt(role, option, Integer.toString(defVal));
        Integer intVal = "max".equals(val) ? Integer.valueOf(maxVal) : Integer.decode(val);
        return intVal;
    }

    public void setInfoTime(String keyHumanTime, String keyMachineTime, long time) {
        SliderUtils.setInfoTime(this.info, keyHumanTime, keyMachineTime, time);
    }

    @JsonIgnore
    public void setInfo(String key, String value) {
        this.info.put(key, value);
    }

    @JsonIgnore
    public String getInfo(String key) {
        return this.info.get(key);
    }

    @JsonIgnore
    public boolean getInfoBool(String key) {
        String val = this.info.get(key);
        if (val != null) {
            return Boolean.valueOf(val);
        }
        return false;
    }

    @JsonIgnore
    public String getZkHosts() throws BadConfigException {
        return this.getMandatoryOption("zookeeper.quorum");
    }

    @JsonIgnore
    public void setZkHosts(String zkHosts) {
        this.setOption("zookeeper.quorum", zkHosts);
    }

    @JsonIgnore
    public String getZkPath() throws BadConfigException {
        return this.getMandatoryOption("zookeeper.path");
    }

    @JsonIgnore
    public void setZkPath(String zkPath) {
        this.setOption("zookeeper.path", zkPath);
    }

    @JsonIgnore
    public String getApplicationHome() {
        return this.getOption("internal.application.home", "");
    }

    @JsonIgnore
    public void setApplicationHome(String applicationHome) {
        this.setOption("internal.application.home", applicationHome);
    }

    @JsonIgnore
    public String getImagePath() {
        return this.getOption("internal.application.image.path", "");
    }

    @JsonIgnore
    public void setImagePath(String imagePath) {
        this.setOption("internal.application.image.path", imagePath);
    }

    @JsonIgnore
    public boolean isImagePathSet() {
        return SliderUtils.isSet(this.getImagePath());
    }
}

