/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.serde2.io.DateWritable;

public class DateTimeMath {
    protected Calendar calUtc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    protected Calendar calLocal = Calendar.getInstance();
    protected NanosResult nanosResult = new NanosResult();

    public long addMonthsToMillisUtc(long millis, int months) {
        this.calUtc.setTimeInMillis(millis);
        this.calUtc.add(2, months);
        return this.calUtc.getTimeInMillis();
    }

    public long addMonthsToMillisLocal(long millis, int months) {
        this.calLocal.setTimeInMillis(millis);
        this.calLocal.add(2, months);
        return this.calLocal.getTimeInMillis();
    }

    public long addMonthsToNanosUtc(long nanos, int months) {
        long result = this.addMonthsToMillisUtc(nanos / 1000000L, months) * 1000000L + nanos % 1000000L;
        return result;
    }

    public long addMonthsToNanosLocal(long nanos, int months) {
        long result = this.addMonthsToMillisLocal(nanos / 1000000L, months) * 1000000L + nanos % 1000000L;
        return result;
    }

    public long addMonthsToDays(long days, int months) {
        long millis = DateWritable.daysToMillis((int)days);
        millis = this.addMonthsToMillisLocal(millis, months);
        return DateWritable.millisToDays(millis);
    }

    public Timestamp add(Timestamp ts, HiveIntervalYearMonth interval) {
        if (ts == null || interval == null) {
            return null;
        }
        Timestamp tsResult = new Timestamp(0L);
        this.add(ts, interval, tsResult);
        return tsResult;
    }

    public boolean add(Timestamp ts, HiveIntervalYearMonth interval, Timestamp result) {
        if (ts == null || interval == null) {
            return false;
        }
        long resultMillis = this.addMonthsToMillisUtc(ts.getTime(), interval.getTotalMonths());
        result.setTime(resultMillis);
        result.setNanos(ts.getNanos());
        return true;
    }

    public Timestamp add(HiveIntervalYearMonth interval, Timestamp ts) {
        if (ts == null || interval == null) {
            return null;
        }
        Timestamp tsResult = new Timestamp(0L);
        this.add(interval, ts, tsResult);
        return tsResult;
    }

    public boolean add(HiveIntervalYearMonth interval, Timestamp ts, Timestamp result) {
        if (ts == null || interval == null) {
            return false;
        }
        long resultMillis = this.addMonthsToMillisUtc(ts.getTime(), interval.getTotalMonths());
        result.setTime(resultMillis);
        result.setNanos(ts.getNanos());
        return true;
    }

    public Date add(Date dt, HiveIntervalYearMonth interval) {
        if (dt == null || interval == null) {
            return null;
        }
        Date dtResult = new Date(0L);
        this.add(dt, interval, dtResult);
        return dtResult;
    }

    public boolean add(Date dt, HiveIntervalYearMonth interval, Date result) {
        if (dt == null || interval == null) {
            return false;
        }
        long resultMillis = this.addMonthsToMillisLocal(dt.getTime(), interval.getTotalMonths());
        result.setTime(resultMillis);
        return true;
    }

    public Date add(HiveIntervalYearMonth interval, Date dt) {
        if (dt == null || interval == null) {
            return null;
        }
        Date dtResult = new Date(0L);
        this.add(interval, dt, dtResult);
        return dtResult;
    }

    public boolean add(HiveIntervalYearMonth interval, Date dt, Date result) {
        if (dt == null || interval == null) {
            return false;
        }
        long resultMillis = this.addMonthsToMillisLocal(dt.getTime(), interval.getTotalMonths());
        result.setTime(resultMillis);
        return true;
    }

    public HiveIntervalYearMonth add(HiveIntervalYearMonth left, HiveIntervalYearMonth right) {
        HiveIntervalYearMonth result = null;
        if (left == null || right == null) {
            return null;
        }
        result = new HiveIntervalYearMonth(left.getTotalMonths() + right.getTotalMonths());
        return result;
    }

    public Timestamp subtract(Timestamp left, HiveIntervalYearMonth right) {
        if (left == null || right == null) {
            return null;
        }
        Timestamp tsResult = new Timestamp(0L);
        this.subtract(left, right, tsResult);
        return tsResult;
    }

    public boolean subtract(Timestamp left, HiveIntervalYearMonth right, Timestamp result) {
        if (left == null || right == null) {
            return false;
        }
        return this.add(left, right.negate(), result);
    }

    public Date subtract(Date left, HiveIntervalYearMonth right) {
        if (left == null || right == null) {
            return null;
        }
        Date dtResult = new Date(0L);
        this.subtract(left, right, dtResult);
        return dtResult;
    }

    public boolean subtract(Date left, HiveIntervalYearMonth right, Date result) {
        if (left == null || right == null) {
            return false;
        }
        return this.add(left, right.negate(), result);
    }

    public HiveIntervalYearMonth subtract(HiveIntervalYearMonth left, HiveIntervalYearMonth right) {
        if (left == null || right == null) {
            return null;
        }
        return this.add(left, right.negate());
    }

    public Timestamp add(Timestamp ts, HiveIntervalDayTime interval) {
        if (ts == null || interval == null) {
            return null;
        }
        Timestamp tsResult = new Timestamp(0L);
        this.add(ts, interval, tsResult);
        return tsResult;
    }

    public boolean add(Timestamp ts, HiveIntervalDayTime interval, Timestamp result) {
        if (ts == null || interval == null) {
            return false;
        }
        this.nanosResult.addNanos(ts.getNanos(), interval.getNanos());
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(ts.getTime()), ZoneId.systemDefault());
        result.setTime(dateTime.plus(interval.getTotalSeconds() + (long)this.nanosResult.seconds, ChronoUnit.SECONDS).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        result.setTime(Timestamp.valueOf(result.toString()).getTime());
        DateTimeMath.adjustDaylightSaving(interval, result);
        result.setNanos(this.nanosResult.nanos);
        return true;
    }

    private static void adjustDaylightSaving(HiveIntervalDayTime interval, Timestamp result) {
        boolean isResultInDaylight = ZoneId.systemDefault().getRules().isDaylightSavings(result.toInstant());
        Timestamp timestampForCheckDaylightSaving = Timestamp.from(result.toInstant().minus(1L, ChronoUnit.HOURS));
        boolean isTimestampForCheckInDaylight = ZoneId.systemDefault().getRules().isDaylightSavings(timestampForCheckDaylightSaving.toInstant());
        if (isResultInDaylight != isTimestampForCheckInDaylight && (interval.getTotalSeconds() < 0L || interval.getNanos() < 0)) {
            result.setTime(result.toInstant().minus(1L, ChronoUnit.HOURS).toEpochMilli());
        }
    }

    public Timestamp add(HiveIntervalDayTime interval, Timestamp ts) {
        if (ts == null || interval == null) {
            return null;
        }
        Timestamp tsResult = new Timestamp(0L);
        this.add(interval, ts, tsResult);
        return tsResult;
    }

    public boolean add(HiveIntervalDayTime interval, Timestamp ts, Timestamp result) {
        if (ts == null || interval == null) {
            return false;
        }
        this.nanosResult.addNanos(ts.getNanos(), interval.getNanos());
        long newMillis = ts.getTime() + TimeUnit.SECONDS.toMillis(interval.getTotalSeconds() + (long)this.nanosResult.seconds);
        result.setTime(newMillis);
        result.setNanos(this.nanosResult.nanos);
        return true;
    }

    public HiveIntervalDayTime add(HiveIntervalDayTime left, HiveIntervalDayTime right) {
        if (left == null || right == null) {
            return null;
        }
        HiveIntervalDayTime result = new HiveIntervalDayTime();
        this.add(left, right, result);
        return result;
    }

    public boolean add(HiveIntervalDayTime left, HiveIntervalDayTime right, HiveIntervalDayTime result) {
        if (left == null || right == null) {
            return false;
        }
        this.nanosResult.addNanos(left.getNanos(), right.getNanos());
        long totalSeconds = left.getTotalSeconds() + right.getTotalSeconds() + (long)this.nanosResult.seconds;
        result.set(totalSeconds, this.nanosResult.nanos);
        return true;
    }

    public Timestamp subtract(Timestamp left, HiveIntervalDayTime right) {
        if (left == null || right == null) {
            return null;
        }
        return this.add(left, right.negate());
    }

    public boolean subtract(Timestamp left, HiveIntervalDayTime right, Timestamp result) {
        if (left == null || right == null) {
            return false;
        }
        return this.add(left, right.negate(), result);
    }

    public HiveIntervalDayTime subtract(HiveIntervalDayTime left, HiveIntervalDayTime right) {
        if (left == null || right == null) {
            return null;
        }
        return this.add(left, right.negate());
    }

    public boolean subtract(HiveIntervalDayTime left, HiveIntervalDayTime right, HiveIntervalDayTime result) {
        if (left == null || right == null) {
            return false;
        }
        return this.add(left, right.negate(), result);
    }

    public HiveIntervalDayTime subtract(Timestamp left, Timestamp right) {
        if (left == null || right == null) {
            return null;
        }
        HiveIntervalDayTime result = new HiveIntervalDayTime();
        this.subtract(left, right, result);
        return result;
    }

    public boolean subtract(Timestamp left, Timestamp right, HiveIntervalDayTime result) {
        if (left == null || right == null) {
            return false;
        }
        this.nanosResult.addNanos(left.getNanos(), -right.getNanos());
        long totalSeconds = TimeUnit.MILLISECONDS.toSeconds(left.getTime()) - TimeUnit.MILLISECONDS.toSeconds(right.getTime()) + (long)this.nanosResult.seconds;
        result.set(totalSeconds, this.nanosResult.nanos);
        return true;
    }

    private static class NanosResult {
        public int seconds;
        public int nanos;

        private NanosResult() {
        }

        public void addNanos(int leftNanos, int rightNanos) {
            this.seconds = 0;
            this.nanos = leftNanos + rightNanos;
            if (this.nanos < 0) {
                this.seconds = -1;
                this.nanos += 1000000000;
            } else if (this.nanos >= 1000000000) {
                this.seconds = 1;
                this.nanos -= 1000000000;
            }
        }
    }
}

