/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc.encoded;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.common.Pool;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedReader;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;
import org.apache.orc.DataReader;
import org.apache.orc.OrcProto;

public interface Reader
extends org.apache.hadoop.hive.ql.io.orc.Reader {
    public EncodedReader encodedReader(Object var1, DataCache var2, DataReader var3, PoolFactory var4) throws IOException;

    public static final class OrcEncodedColumnBatch
    extends EncodedColumnBatch<OrcBatchKey> {
        public static final int ALL_RGS = -1;
        public static final int MAX_DATA_STREAMS = OrcProto.Stream.Kind.ROW_INDEX.getNumber();
        protected List<ColumnVector>[] columnVectors;

        public void init(Object fileKey, int stripeIx, int rgIx, int columnCount) {
            if (this.batchKey == null) {
                this.batchKey = new OrcBatchKey(fileKey, stripeIx, rgIx);
            } else {
                ((OrcBatchKey)this.batchKey).set(fileKey, stripeIx, rgIx);
            }
            this.resetColumnArrays(columnCount);
        }

        public void initOrcColumn(int colIx) {
            super.initColumn(colIx, MAX_DATA_STREAMS);
        }

        @Override
        public void reset() {
            super.reset();
            if (this.columnVectors == null) {
                return;
            }
            Arrays.fill(this.columnVectors, null);
        }

        public void initColumnWithVectors(int colIx, List<ColumnVector> data) {
            if (this.columnVectors == null) {
                this.columnVectors = new List[this.columnData.length];
            }
            this.columnVectors[colIx] = data;
        }

        @Override
        protected void resetColumnArrays(int columnCount) {
            super.resetColumnArrays(columnCount);
            if (this.columnVectors != null && columnCount == this.columnVectors.length) {
                Arrays.fill(this.columnVectors, null);
                return;
            }
            this.columnVectors = this.columnVectors != null ? new List[columnCount] : null;
        }

        public boolean hasVectors(int colIx) {
            return this.columnVectors != null && this.columnVectors[colIx] != null;
        }

        public List<ColumnVector> getColumnVectors(int colIx) {
            if (!this.hasVectors(colIx)) {
                throw new AssertionError((Object)("No data for column " + colIx));
            }
            return this.columnVectors[colIx];
        }
    }

    public static interface PoolFactory {
        public <T> Pool<T> createPool(int var1, Pool.PoolObjectHelper<T> var2);

        public Pool<OrcEncodedColumnBatch> createEncodedColumnBatchPool();

        public Pool<EncodedColumnBatch.ColumnStreamData> createColumnStreamDataPool();
    }
}

