/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.pig;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.security.Credentials;
import org.apache.hive.hcatalog.common.HCatContext;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.Pair;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.HCatInputFormat;
import org.apache.hive.hcatalog.mapreduce.HCatTableInfo;
import org.apache.hive.hcatalog.mapreduce.InputJobInfo;
import org.apache.hive.hcatalog.mapreduce.SpecialCases;
import org.apache.hive.hcatalog.pig.HCatBaseLoader;
import org.apache.hive.hcatalog.pig.PigHCatUtil;
import org.apache.pig.Expression;
import org.apache.pig.LoadPushDown;
import org.apache.pig.PigException;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.impl.util.UDFContext;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HCatLoader
extends HCatBaseLoader {
    private static final Logger LOG = LoggerFactory.getLogger(HCatLoader.class);
    private static final String PARTITION_FILTER = "partition.filter";
    private HCatInputFormat hcatInputFormat = null;
    private String dbName;
    private String tableName;
    private String hcatServerUri;
    private String partitionFilterString;
    private final PigHCatUtil phutil = new PigHCatUtil();
    public static final String INNER_SIGNATURE = "hcatloader.inner.signature";
    public static final String INNER_SIGNATURE_PREFIX = "hcatloader_inner_signature";
    private static Map<String, Credentials> jobCredentials = new HashMap<String, Credentials>();

    public InputFormat<?, ?> getInputFormat() throws IOException {
        if (this.hcatInputFormat == null) {
            this.hcatInputFormat = new HCatInputFormat();
        }
        return this.hcatInputFormat;
    }

    public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
        return location;
    }

    public void setLocation(String location, Job job) throws IOException {
        ((Configuration)HCatContext.INSTANCE.setConf(job.getConfiguration()).getConf().get()).setBoolean("hcat.data.tiny.small.int.promotion", true);
        UDFContext udfContext = UDFContext.getUDFContext();
        Properties udfProps = udfContext.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature});
        job.getConfiguration().set(INNER_SIGNATURE, "hcatloader_inner_signature_" + this.signature);
        Pair<String, String> dbTablePair = PigHCatUtil.getDBTableNames(location);
        this.dbName = (String)dbTablePair.first;
        this.tableName = (String)dbTablePair.second;
        LoadPushDown.RequiredFieldList requiredFieldsInfo = (LoadPushDown.RequiredFieldList)udfProps.get("prune.projection.info");
        if (udfProps.containsKey("hcat.pig.loader.location.set")) {
            Enumeration<Object> emr = udfProps.keys();
            while (emr.hasMoreElements()) {
                PigHCatUtil.getConfigFromUDFProperties(udfProps, job.getConfiguration(), emr.nextElement().toString());
            }
            if (!HCatUtil.checkJobContextIfRunningFromBackend((JobContext)job)) {
                Credentials crd = jobCredentials.get("hcatloader_inner_signature_" + this.signature);
                job.getCredentials().addAll(crd);
            }
        } else {
            Job clone = new Job(job.getConfiguration());
            HCatInputFormat.setInput((Job)job, (String)this.dbName, (String)this.tableName, (String)this.getPartitionFilterString());
            InputJobInfo inputJobInfo = (InputJobInfo)HCatUtil.deserialize((String)job.getConfiguration().get("mapreduce.lib.hcat.job.info"));
            SpecialCases.addSpecialCasesParametersForHCatLoader((Configuration)job.getConfiguration(), (HCatTableInfo)inputJobInfo.getTableInfo());
            for (Map.Entry keyValue : job.getConfiguration()) {
                String oldValue = clone.getConfiguration().getRaw((String)keyValue.getKey());
                if (oldValue != null && ((String)keyValue.getValue()).equals(oldValue)) continue;
                udfProps.put(keyValue.getKey(), keyValue.getValue());
            }
            udfProps.put("hcat.pig.loader.location.set", (Object)true);
            Credentials crd = new Credentials();
            crd.addAll(job.getCredentials());
            jobCredentials.put("hcatloader_inner_signature_" + this.signature, crd);
        }
        if (requiredFieldsInfo != null) {
            try {
                ArrayList<Integer> list = new ArrayList<Integer>(requiredFieldsInfo.getFields().size());
                for (LoadPushDown.RequiredField rf : requiredFieldsInfo.getFields()) {
                    list.add(rf.getIndex());
                }
                ColumnProjectionUtils.setReadColumns((Configuration)job.getConfiguration(), list);
                this.outputSchema = this.phutil.getHCatSchema(requiredFieldsInfo.getFields(), this.signature, ((Object)((Object)this)).getClass());
                HCatInputFormat.setOutputSchema((Job)job, (HCatSchema)this.outputSchema);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        ColumnProjectionUtils.setReadAllColumns((Configuration)job.getConfiguration());
        if (HCatUtil.checkJobContextIfRunningFromBackend((JobContext)job)) {
            try {
                HCatSchema hcatTableSchema;
                this.outputSchema = hcatTableSchema = (HCatSchema)udfProps.get("hcat.table.schema");
                HCatInputFormat.setOutputSchema((Job)job, (HCatSchema)this.outputSchema);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("outputSchema=" + this.outputSchema);
        }
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        Table table = this.phutil.getTable(location, this.hcatServerUri != null ? this.hcatServerUri : PigHCatUtil.getHCatServerUri(job), PigHCatUtil.getHCatServerPrincipal(job), job);
        List tablePartitionKeys = table.getPartitionKeys();
        String[] partitionKeys = new String[tablePartitionKeys.size()];
        for (int i = 0; i < tablePartitionKeys.size(); ++i) {
            partitionKeys[i] = ((FieldSchema)tablePartitionKeys.get(i)).getName();
        }
        return partitionKeys;
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        ((Configuration)HCatContext.INSTANCE.setConf(job.getConfiguration()).getConf().get()).setBoolean("hcat.data.tiny.small.int.promotion", true);
        Table table = this.phutil.getTable(location, this.hcatServerUri != null ? this.hcatServerUri : PigHCatUtil.getHCatServerUri(job), PigHCatUtil.getHCatServerPrincipal(job), job);
        HCatSchema hcatTableSchema = HCatUtil.getTableSchemaWithPtnCols((Table)table);
        try {
            PigHCatUtil.validateHCatTableSchemaFollowsPigRules(hcatTableSchema);
        }
        catch (IOException e) {
            throw new PigException("Table schema incompatible for reading through HCatLoader :" + e.getMessage() + ";[Table schema was " + hcatTableSchema.toString() + "]", 1115, (Throwable)e);
        }
        this.storeInUDFContext(this.signature, "hcat.table.schema", hcatTableSchema);
        this.outputSchema = hcatTableSchema;
        return PigHCatUtil.getResourceSchema(hcatTableSchema);
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
        this.partitionFilterString = this.getHCatComparisonString(partitionFilter);
        this.storeInUDFContext(this.signature, PARTITION_FILTER, this.partitionFilterString);
    }

    @Override
    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        try {
            ResourceStatistics stats = new ResourceStatistics();
            InputJobInfo inputJobInfo = (InputJobInfo)HCatUtil.deserialize((String)job.getConfiguration().get("mapreduce.lib.hcat.job.info"));
            stats.setmBytes(Long.valueOf(HCatLoader.getSizeInBytes(inputJobInfo) / 1024L / 1024L));
            return stats;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private String getPartitionFilterString() {
        if (this.partitionFilterString == null) {
            Properties props = UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature});
            this.partitionFilterString = props.getProperty(PARTITION_FILTER);
        }
        return this.partitionFilterString;
    }

    private String getHCatConstString(Expression.Const con, HCatFieldSchema.Type type) {
        Object value = con.getValue();
        switch (type) {
            case DATE: {
                return ((DateTime)value).toString(DateTimeFormat.forPattern((String)"YYYY-MM-dd"));
            }
        }
        return con.toString();
    }

    private String getHCatComparisonString(Expression expr) {
        if (expr instanceof Expression.BinaryExpression) {
            String opStr = null;
            switch (expr.getOpType()) {
                case OP_EQ: {
                    opStr = " = ";
                    break;
                }
                default: {
                    opStr = expr.getOpType().toString();
                }
            }
            Expression.BinaryExpression be = (Expression.BinaryExpression)expr;
            if (be.getRhs() instanceof Expression.Const) {
                UDFContext udfContext = UDFContext.getUDFContext();
                Properties udfProps = udfContext.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature});
                HCatSchema hcatTableSchema = (HCatSchema)udfProps.get("hcat.table.schema");
                HCatFieldSchema fs = null;
                try {
                    fs = hcatTableSchema.get(be.getLhs().toString());
                }
                catch (HCatException hCatException) {
                    // empty catch block
                }
                if (fs != null) {
                    return "(" + this.getHCatComparisonString(be.getLhs()) + opStr + this.getHCatConstString((Expression.Const)be.getRhs(), fs.getType()) + ")";
                }
            }
            return "(" + this.getHCatComparisonString(be.getLhs()) + opStr + this.getHCatComparisonString(be.getRhs()) + ")";
        }
        return expr.toString();
    }
}

