/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.types;

import java.io.Serializable;
import java.util.Date;
import org.ojai.annotation.API;
import org.ojai.exceptions.ParseException;
import org.ojai.joda.Chronology;
import org.ojai.joda.DateTime;
import org.ojai.joda.DateTimeZone;
import org.ojai.joda.chrono.ISOChronology;
import org.ojai.joda.format.DateTimeFormat;
import org.ojai.joda.format.DateTimeFormatter;

@API.Public
public final class OTimestamp
implements Comparable<OTimestamp>,
Serializable {
    private static final long serialVersionUID = 4035440459956412424L;
    private static final DateTimeFormatter UTC_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZoneUTC();
    private static final DateTimeFormatter LOCAL_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ").withZone(DateTimeZone.getDefault());
    private static final ISOChronology UTC_CHRONOLOGY = ISOChronology.getInstanceUTC();
    private volatile transient DateTime datetime;
    private final long millisSinceEpoch;

    public static OTimestamp parse(String dateTimeStr) {
        try {
            return new OTimestamp(DateTime.parse(dateTimeStr));
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e);
        }
    }

    public OTimestamp(long millisSinceEpoch) {
        this.millisSinceEpoch = millisSinceEpoch;
    }

    public OTimestamp(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        this(new DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond));
    }

    public OTimestamp(Date date) {
        this(new DateTime(date));
    }

    private OTimestamp(DateTime date_time) {
        this.datetime = date_time;
        this.millisSinceEpoch = date_time.getMillis();
    }

    public int getYear() {
        return UTC_CHRONOLOGY.year().get(this.millisSinceEpoch);
    }

    public int getMonth() {
        return UTC_CHRONOLOGY.monthOfYear().get(this.millisSinceEpoch);
    }

    public int getDayOfMonth() {
        return UTC_CHRONOLOGY.dayOfMonth().get(this.millisSinceEpoch);
    }

    public int getHour() {
        return UTC_CHRONOLOGY.hourOfDay().get(this.millisSinceEpoch);
    }

    public int getMinute() {
        return UTC_CHRONOLOGY.minuteOfHour().get(this.millisSinceEpoch);
    }

    public int getSecond() {
        return UTC_CHRONOLOGY.secondOfMinute().get(this.millisSinceEpoch);
    }

    public int getMilliSecond() {
        return UTC_CHRONOLOGY.millisOfSecond().get(this.millisSinceEpoch);
    }

    public long getMillis() {
        return this.millisSinceEpoch;
    }

    public Date toDate() {
        return new Date(this.millisSinceEpoch);
    }

    public String toUTCString() {
        return UTC_FORMATTER.print(this.getDateTime());
    }

    public String toLocalString() {
        return LOCAL_FORMATTER.print(this.getDateTime());
    }

    public String toString(String pattern) {
        return this.getDateTime().toString(pattern);
    }

    public String toString() {
        return this.toUTCString();
    }

    public int hashCode() {
        return (int)(this.millisSinceEpoch ^ this.millisSinceEpoch >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OTimestamp other = (OTimestamp)obj;
        return this.millisSinceEpoch == other.millisSinceEpoch;
    }

    @Override
    public int compareTo(OTimestamp o) {
        return Long.compare(this.millisSinceEpoch, o.millisSinceEpoch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DateTime getDateTime() {
        if (this.datetime == null) {
            OTimestamp oTimestamp = this;
            synchronized (oTimestamp) {
                if (this.datetime == null) {
                    this.datetime = new DateTime(this.millisSinceEpoch, (Chronology)UTC_CHRONOLOGY);
                }
            }
        }
        return this.datetime;
    }
}

