/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.hdfs.tasklog;

import com.google.common.base.Optional;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.storage.hdfs.tasklog.HdfsTaskLogsConfig;
import io.druid.tasklogs.TaskLogs;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsTaskLogs
implements TaskLogs {
    private static final Logger log = new Logger(HdfsTaskLogs.class);
    private final HdfsTaskLogsConfig config;
    private final Configuration hadoopConfig;

    @Inject
    public HdfsTaskLogs(HdfsTaskLogsConfig config, Configuration hadoopConfig) {
        this.config = config;
        this.hadoopConfig = hadoopConfig;
    }

    public void pushTaskLog(String taskId, File logFile) throws IOException {
        Path path = this.getTaskLogFileFromId(taskId);
        log.info("Writing task log to: %s", new Object[]{path});
        FileSystem fs = path.getFileSystem(this.hadoopConfig);
        try (FileInputStream in = new FileInputStream(logFile);
             FSDataOutputStream out = fs.create(path, true);){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
            log.info("Wrote task log to: %s", new Object[]{path});
        }
    }

    public Optional<ByteSource> streamTaskLog(String taskId, final long offset) throws IOException {
        final Path path = this.getTaskLogFileFromId(taskId);
        final FileSystem fs = path.getFileSystem(this.hadoopConfig);
        if (fs.exists(path)) {
            return Optional.of((Object)new ByteSource(){

                public InputStream openStream() throws IOException {
                    long seekPos;
                    log.info("Reading task log from: %s", new Object[]{path});
                    if (offset < 0L) {
                        FileStatus stat = fs.getFileStatus(path);
                        seekPos = Math.max(0L, stat.getLen() + offset);
                    } else {
                        seekPos = offset;
                    }
                    FSDataInputStream inputStream = fs.open(path);
                    inputStream.seek(seekPos);
                    log.info("Read task log from: %s (seek = %,d)", new Object[]{path, seekPos});
                    return inputStream;
                }
            });
        }
        return Optional.absent();
    }

    private Path getTaskLogFileFromId(String taskId) {
        return new Path(HdfsTaskLogs.mergePaths(this.config.getDirectory(), taskId.replaceAll(":", "_")));
    }

    private static String mergePaths(String path1, String path2) {
        return path1 + (path1.endsWith("/") ? "" : "/") + path2;
    }
}

