/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JFrame;
import jline.console.completer.StringsCompleter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassNameCompleter
extends StringsCompleter {
    private static final Logger LOG = LoggerFactory.getLogger((String)ClassNameCompleter.class.getName());
    public static final String clazzFileNameExtension = ".class";
    public static final String jarFileNameExtension = ".jar";

    public ClassNameCompleter(String ... candidates) {
        super(candidates);
    }

    public static String[] getClassNames() throws IOException {
        HashSet<URL> urls = new HashSet<URL>();
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            urls.addAll(Arrays.asList(((URLClassLoader)loader).getURLs()));
        }
        Class[] systemClasses = new Class[]{String.class, JFrame.class};
        for (int i = 0; i < systemClasses.length; ++i) {
            URLConnection uc;
            URL classURL = systemClasses[i].getResource("/" + systemClasses[i].getName().replace('.', '/') + clazzFileNameExtension);
            if (classURL == null || !((uc = classURL.openConnection()) instanceof JarURLConnection)) continue;
            urls.add(((JarURLConnection)uc).getJarFileURL());
        }
        HashSet<String> classes = new HashSet<String>();
        for (URL url : urls) {
            try {
                File file = new File(url.getFile());
                if (file.isDirectory()) {
                    Set files = ClassNameCompleter.getClassFiles(file.getAbsolutePath(), new HashSet(), file, new int[]{200});
                    classes.addAll(files);
                    continue;
                }
                if (!ClassNameCompleter.isJarFile(file)) continue;
                JarFile jf = new JarFile(file);
                Enumeration<JarEntry> e = jf.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    if (entry == null) continue;
                    String name = entry.getName();
                    if (ClassNameCompleter.isClazzFile(name)) {
                        classes.add(name);
                        continue;
                    }
                    if (!ClassNameCompleter.isJarFile(name)) continue;
                    classes.addAll(ClassNameCompleter.getClassNamesFromJar(name));
                }
            }
            catch (IOException e) {
                throw new IOException(String.format("Error reading classpath entry: %s", url), e);
            }
        }
        TreeSet<String> classNames = new TreeSet<String>();
        for (String name : classes) {
            classNames.add(name.replace('/', '.').substring(0, name.length() - 6));
        }
        return classNames.toArray(new String[classNames.size()]);
    }

    private static Set getClassFiles(String root, Set holder, File directory, int[] maxDirectories) {
        int n = maxDirectories[0];
        maxDirectories[0] = n - 1;
        if (n < 0) {
            return holder;
        }
        File[] files = directory.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            String name = files[i].getAbsolutePath();
            if (!name.startsWith(root)) continue;
            if (files[i].isDirectory()) {
                ClassNameCompleter.getClassFiles(root, holder, files[i], maxDirectories);
                continue;
            }
            if (!files[i].getName().endsWith(clazzFileNameExtension)) continue;
            holder.add(files[i].getAbsolutePath().substring(root.length() + 1));
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getClassNamesFromJar(String path) {
        ArrayList<String> classNames = new ArrayList<String>();
        ZipInputStream zip = null;
        try {
            zip = new ZipInputStream(new FileInputStream(path));
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory() && entry.getName().endsWith(clazzFileNameExtension)) {
                    StringBuilder className = new StringBuilder();
                    for (String part : entry.getName().split("/")) {
                        if (className.length() != 0) {
                            className.append(".");
                        }
                        className.append(part);
                        if (!part.endsWith(clazzFileNameExtension)) continue;
                        className.setLength(className.length() - clazzFileNameExtension.length());
                    }
                    classNames.add(className.toString());
                }
                entry = zip.getNextEntry();
            }
        }
        catch (IOException e) {
            LOG.error("Fail to parse the class name from the Jar file due to the exception:" + e);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    LOG.error("Fail to close the file due to the exception:" + e);
                }
            }
        }
        return classNames;
    }

    private static boolean isJarFile(File file) {
        return file != null && file.isFile() && ClassNameCompleter.isJarFile(file.getName());
    }

    private static boolean isJarFile(String fileName) {
        return fileName.endsWith(jarFileNameExtension);
    }

    private static boolean isClazzFile(String clazzName) {
        return clazzName.endsWith(clazzFileNameExtension);
    }
}

