/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Predicate;
import com.metamx.collections.bitmap.ImmutableBitmap;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.Filter;
import io.druid.query.filter.JavaScriptDimFilter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.segment.filter.Filters;
import org.mozilla.javascript.Context;

public class JavaScriptFilter
implements Filter {
    private final String dimension;
    private final JavaScriptDimFilter.JavaScriptPredicateFactory predicateFactory;

    public JavaScriptFilter(String dimension, JavaScriptDimFilter.JavaScriptPredicateFactory predicate) {
        this.dimension = dimension;
        this.predicateFactory = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableBitmap getBitmapIndex(BitmapIndexSelector selector) {
        final Context cx = Context.enter();
        try {
            Predicate<String> contextualPredicate = new Predicate<String>(){

                public boolean apply(String input) {
                    return JavaScriptFilter.this.predicateFactory.applyInContext(cx, input);
                }
            };
            ImmutableBitmap immutableBitmap = Filters.matchPredicate(this.dimension, selector, contextualPredicate);
            return immutableBitmap;
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        return factory.makeValueMatcher(this.dimension, this.predicateFactory);
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }
}

