/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.metamx.collections.bitmap.ImmutableBitmap;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.BooleanFilter;
import io.druid.query.filter.Filter;
import io.druid.query.filter.RowOffsetMatcherFactory;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.segment.filter.BooleanValueMatcher;
import java.util.ArrayList;
import java.util.List;

public class AndFilter
implements BooleanFilter {
    private static final Joiner AND_JOINER = Joiner.on((String)" && ");
    private final List<Filter> filters;

    public AndFilter(List<Filter> filters) {
        this.filters = filters;
    }

    @Override
    public ImmutableBitmap getBitmapIndex(BitmapIndexSelector selector) {
        if (this.filters.size() == 1) {
            return this.filters.get(0).getBitmapIndex(selector);
        }
        ArrayList bitmaps = Lists.newArrayList();
        for (int i = 0; i < this.filters.size(); ++i) {
            bitmaps.add(this.filters.get(i).getBitmapIndex(selector));
        }
        return selector.getBitmapFactory().intersection((Iterable)bitmaps);
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        if (this.filters.size() == 0) {
            return new BooleanValueMatcher(false);
        }
        ValueMatcher[] matchers = new ValueMatcher[this.filters.size()];
        for (int i = 0; i < this.filters.size(); ++i) {
            matchers[i] = this.filters.get(i).makeMatcher(factory);
        }
        return this.makeMatcher(matchers);
    }

    @Override
    public ValueMatcher makeMatcher(BitmapIndexSelector selector, ValueMatcherFactory valueMatcherFactory, RowOffsetMatcherFactory rowOffsetMatcherFactory) {
        final ArrayList<ValueMatcher> matchers = new ArrayList<ValueMatcher>();
        ArrayList<ImmutableBitmap> bitmaps = new ArrayList<ImmutableBitmap>();
        for (Filter filter : this.filters) {
            if (filter.supportsBitmapIndex(selector)) {
                bitmaps.add(filter.getBitmapIndex(selector));
                continue;
            }
            ValueMatcher matcher = filter.makeMatcher(valueMatcherFactory);
            matchers.add(matcher);
        }
        if (bitmaps.size() > 0) {
            ImmutableBitmap combinedBitmap = selector.getBitmapFactory().intersection(bitmaps);
            ValueMatcher offsetMatcher = rowOffsetMatcherFactory.makeRowOffsetMatcher(combinedBitmap);
            matchers.add(0, offsetMatcher);
        }
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                for (ValueMatcher valueMatcher : matchers) {
                    if (valueMatcher.matches()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        for (Filter filter : this.filters) {
            if (filter.supportsBitmapIndex(selector)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("(%s)", AND_JOINER.join(this.filters));
    }

    private ValueMatcher makeMatcher(final ValueMatcher[] baseMatchers) {
        if (baseMatchers.length == 1) {
            return baseMatchers[0];
        }
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                for (ValueMatcher matcher : baseMatchers) {
                    if (matcher.matches()) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

