/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.query.ordering.StringComparator;
import io.druid.query.ordering.StringComparators;
import io.druid.query.search.search.SearchHit;
import java.util.Comparator;

public class SearchSortSpec {
    public static final StringComparator DEFAULT_ORDERING = StringComparators.LEXICOGRAPHIC;
    private final StringComparator ordering;

    @JsonCreator
    public SearchSortSpec(@JsonProperty(value="type") StringComparator ordering) {
        this.ordering = ordering == null ? DEFAULT_ORDERING : ordering;
    }

    @JsonProperty(value="type")
    public StringComparator getOrdering() {
        return this.ordering;
    }

    public Comparator<SearchHit> getComparator() {
        return new Comparator<SearchHit>(){

            @Override
            public int compare(SearchHit searchHit, SearchHit searchHit1) {
                int retVal = SearchSortSpec.this.ordering.compare(searchHit.getValue(), searchHit1.getValue());
                if (retVal == 0) {
                    retVal = StringComparators.LEXICOGRAPHIC.compare(searchHit.getDimension(), searchHit1.getDimension());
                }
                return retVal;
            }
        };
    }

    public byte[] getCacheKey() {
        return this.ordering.getCacheKey();
    }

    public String toString() {
        return String.format("%sSort", this.ordering.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchSortSpec that = (SearchSortSpec)o;
        return this.ordering.equals(that.ordering);
    }

    public int hashCode() {
        return this.ordering.hashCode();
    }
}

