/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.guava.nary.BinaryFn;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.query.BaseQuery;
import io.druid.query.CacheStrategy;
import io.druid.query.DruidMetrics;
import io.druid.query.IntervalChunkingQueryRunnerDecorator;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.ResultGranularTimestampComparator;
import io.druid.query.ResultMergeQueryRunner;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.filter.DimFilter;
import io.druid.query.search.BySegmentSearchResultValue;
import io.druid.query.search.SearchBinaryFn;
import io.druid.query.search.SearchResultValue;
import io.druid.query.search.search.SearchHit;
import io.druid.query.search.search.SearchQuery;
import io.druid.query.search.search.SearchQueryConfig;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class SearchQueryQueryToolChest
extends QueryToolChest<Result<SearchResultValue>, SearchQuery> {
    private static final byte SEARCH_QUERY = 21;
    private static final TypeReference<Result<SearchResultValue>> TYPE_REFERENCE = new TypeReference<Result<SearchResultValue>>(){};
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private final SearchQueryConfig config;
    private final IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator;

    @Inject
    public SearchQueryQueryToolChest(SearchQueryConfig config, IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator) {
        this.config = config;
        this.intervalChunkingQueryRunnerDecorator = intervalChunkingQueryRunnerDecorator;
    }

    @Override
    public QueryRunner<Result<SearchResultValue>> mergeResults(QueryRunner<Result<SearchResultValue>> runner) {
        return new ResultMergeQueryRunner<Result<SearchResultValue>>(runner){

            @Override
            protected Ordering<Result<SearchResultValue>> makeOrdering(Query<Result<SearchResultValue>> query) {
                return ResultGranularTimestampComparator.create(((SearchQuery)query).getGranularity(), query.isDescending());
            }

            @Override
            protected BinaryFn<Result<SearchResultValue>, Result<SearchResultValue>, Result<SearchResultValue>> createMergeFn(Query<Result<SearchResultValue>> input) {
                SearchQuery query = (SearchQuery)input;
                return new SearchBinaryFn(query.getSort(), query.getGranularity(), query.getLimit());
            }
        };
    }

    @Override
    public ServiceMetricEvent.Builder makeMetricBuilder(SearchQuery query) {
        return DruidMetrics.makePartialQueryTimeMetric(query);
    }

    @Override
    public Function<Result<SearchResultValue>, Result<SearchResultValue>> makePreComputeManipulatorFn(SearchQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<Result<SearchResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<SearchResultValue>, Object, SearchQuery> getCacheStrategy(final SearchQuery query) {
        return new CacheStrategy<Result<SearchResultValue>, Object, SearchQuery>(){
            private final List<DimensionSpec> dimensionSpecs;
            private final List<String> dimOutputNames;
            {
                this.dimensionSpecs = query.getDimensions() != null ? query.getDimensions() : Collections.emptyList();
                this.dimOutputNames = this.dimensionSpecs.size() > 0 ? Lists.transform(this.dimensionSpecs, (Function)new Function<DimensionSpec, String>(){

                    public String apply(DimensionSpec input) {
                        return input.getOutputName();
                    }
                }) : Collections.emptyList();
            }

            @Override
            public byte[] computeCacheKey(SearchQuery query2) {
                DimFilter dimFilter = query2.getDimensionsFilter();
                byte[] filterBytes = dimFilter == null ? new byte[]{} : dimFilter.getCacheKey();
                byte[] querySpecBytes = query2.getQuery().getCacheKey();
                byte[] granularityBytes = query2.getGranularity().cacheKey();
                List<Object> dimensionSpecs = query2.getDimensions() != null ? query2.getDimensions() : Collections.emptyList();
                byte[][] dimensionsBytes = new byte[dimensionSpecs.size()][];
                int dimensionsBytesSize = 0;
                int index = 0;
                for (DimensionSpec dimensionSpec : dimensionSpecs) {
                    dimensionsBytes[index] = dimensionSpec.getCacheKey();
                    dimensionsBytesSize += dimensionsBytes[index].length;
                    ++index;
                }
                byte[] sortSpecBytes = query2.getSort().getCacheKey();
                ByteBuffer byteBuffer = ByteBuffer.allocate(5 + granularityBytes.length + filterBytes.length + querySpecBytes.length + dimensionsBytesSize + sortSpecBytes.length).put((byte)21).put(Ints.toByteArray((int)query2.getLimit())).put(granularityBytes).put(filterBytes).put(querySpecBytes).put(sortSpecBytes);
                for (byte[] bytes : dimensionsBytes) {
                    byteBuffer.put(bytes);
                }
                return byteBuffer.array();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<SearchResultValue>, Object> prepareForCache() {
                return new Function<Result<SearchResultValue>, Object>(){

                    public Object apply(Result<SearchResultValue> input) {
                        return dimensionSpecs.size() > 0 ? Lists.newArrayList((Object[])new Object[]{input.getTimestamp().getMillis(), input.getValue(), dimOutputNames}) : Lists.newArrayList((Object[])new Object[]{input.getTimestamp().getMillis(), input.getValue()});
                    }
                };
            }

            @Override
            public Function<Object, Result<SearchResultValue>> pullFromCache() {
                return new Function<Object, Result<SearchResultValue>>(){

                    public Result<SearchResultValue> apply(Object input) {
                        List result = (List)input;
                        boolean needsRename = false;
                        final HashMap outputNameMap = Maps.newHashMap();
                        if (this.hasOutputName(result)) {
                            List cachedOutputNames = (List)result.get(2);
                            Preconditions.checkArgument((cachedOutputNames.size() == dimOutputNames.size() ? 1 : 0) != 0, (Object)"cache hit, but number of dimensions mismatch");
                            needsRename = false;
                            for (int idx = 0; idx < cachedOutputNames.size(); ++idx) {
                                String outputName;
                                String cachedOutputName = (String)cachedOutputNames.get(idx);
                                if (!cachedOutputName.equals(outputName = (String)dimOutputNames.get(idx))) {
                                    needsRename = true;
                                }
                                outputNameMap.put(cachedOutputName, outputName);
                            }
                        }
                        return !needsRename ? new Result<SearchResultValue>(new DateTime(((Number)result.get(0)).longValue()), new SearchResultValue(Lists.transform((List)((List)result.get(1)), (Function)new Function<Object, SearchHit>(){

                            public SearchHit apply(@Nullable Object input) {
                                if (input instanceof Map) {
                                    return new SearchHit((String)((Map)input).get("dimension"), (String)((Map)input).get("value"), (Integer)((Map)input).get("count"));
                                }
                                if (input instanceof SearchHit) {
                                    return (SearchHit)input;
                                }
                                throw new IAE("Unknown format [%s]", new Object[]{input.getClass()});
                            }
                        }))) : new Result<SearchResultValue>(new DateTime(((Number)result.get(0)).longValue()), new SearchResultValue(Lists.transform((List)((List)result.get(1)), (Function)new Function<Object, SearchHit>(){

                            public SearchHit apply(@Nullable Object input) {
                                String dim = null;
                                String val = null;
                                Integer cnt = null;
                                if (input instanceof Map) {
                                    dim = (String)outputNameMap.get((String)((Map)input).get("dimension"));
                                    val = (String)((Map)input).get("value");
                                    cnt = (Integer)((Map)input).get("count");
                                } else if (input instanceof SearchHit) {
                                    SearchHit cached = (SearchHit)input;
                                    dim = (String)outputNameMap.get(cached.getDimension());
                                    val = cached.getValue();
                                    cnt = cached.getCount();
                                } else {
                                    throw new IAE("Unknown format [%s]", new Object[]{input.getClass()});
                                }
                                return new SearchHit(dim, val, cnt);
                            }
                        })));
                    }
                };
            }

            private boolean hasOutputName(List<Object> cachedEntry) {
                return cachedEntry.size() == 3;
            }
        };
    }

    @Override
    public QueryRunner<Result<SearchResultValue>> preMergeQueryDecoration(final QueryRunner<Result<SearchResultValue>> runner) {
        return new SearchThresholdAdjustingQueryRunner(this.intervalChunkingQueryRunnerDecorator.decorate(new QueryRunner<Result<SearchResultValue>>(){

            @Override
            public Sequence<Result<SearchResultValue>> run(Query<Result<SearchResultValue>> query, Map<String, Object> responseContext) {
                SearchQuery searchQuery = (SearchQuery)query;
                if (searchQuery.getDimensionsFilter() != null) {
                    searchQuery = searchQuery.withDimFilter(searchQuery.getDimensionsFilter().optimize());
                }
                return runner.run(searchQuery, responseContext);
            }
        }, this), this.config);
    }

    private static class SearchThresholdAdjustingQueryRunner
    implements QueryRunner<Result<SearchResultValue>> {
        private final QueryRunner<Result<SearchResultValue>> runner;
        private final SearchQueryConfig config;

        public SearchThresholdAdjustingQueryRunner(QueryRunner<Result<SearchResultValue>> runner, SearchQueryConfig config) {
            this.runner = runner;
            this.config = config;
        }

        @Override
        public Sequence<Result<SearchResultValue>> run(Query<Result<SearchResultValue>> input, Map<String, Object> responseContext) {
            if (!(input instanceof SearchQuery)) {
                throw new ISE("Can only handle [%s], got [%s]", new Object[]{SearchQuery.class, input.getClass()});
            }
            final SearchQuery query = (SearchQuery)input;
            if (query.getLimit() < this.config.getMaxSearchLimit()) {
                return this.runner.run(query, responseContext);
            }
            final boolean isBySegment = BaseQuery.getContextBySegment(query, false);
            return Sequences.map(this.runner.run(query.withLimit(this.config.getMaxSearchLimit()), responseContext), (Function)new Function<Result<SearchResultValue>, Result<SearchResultValue>>(){

                public Result<SearchResultValue> apply(Result<SearchResultValue> input) {
                    if (isBySegment) {
                        BySegmentSearchResultValue value = (BySegmentSearchResultValue)input.getValue();
                        return new Result<SearchResultValue>(input.getTimestamp(), new BySegmentSearchResultValue(Lists.transform(value.getResults(), (Function)new Function<Result<SearchResultValue>, Result<SearchResultValue>>(){

                            public Result<SearchResultValue> apply(@Nullable Result<SearchResultValue> input) {
                                return new Result<SearchResultValue>(input.getTimestamp(), new SearchResultValue(Lists.newArrayList((Iterable)Iterables.limit((Iterable)input.getValue(), (int)query.getLimit()))));
                            }
                        }), value.getSegmentId(), value.getInterval()));
                    }
                    return new Result<SearchResultValue>(input.getTimestamp(), new SearchResultValue(Lists.newArrayList((Iterable)Iterables.limit((Iterable)input.getValue(), (int)query.getLimit()))));
                }
            });
        }
    }
}

