/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.MetricManipulationFn;

public class MetricManipulatorFns {
    private static final MetricManipulationFn IDENTITY_INSTANCE = new MetricManipulationFn(){

        @Override
        public Object manipulate(AggregatorFactory factory, Object object) {
            return object;
        }
    };
    private static final MetricManipulationFn FINALIZING_INSTANCE = new MetricManipulationFn(){

        @Override
        public Object manipulate(AggregatorFactory factory, Object object) {
            return factory.finalizeComputation(object);
        }
    };
    private static final MetricManipulationFn DESERIALIZING_INSTANCE = new MetricManipulationFn(){

        @Override
        public Object manipulate(AggregatorFactory factory, Object object) {
            return factory.deserialize(object);
        }
    };

    public static MetricManipulationFn identity() {
        return IDENTITY_INSTANCE;
    }

    public static MetricManipulationFn finalizing() {
        return FINALIZING_INSTANCE;
    }

    public static MetricManipulationFn deserializing() {
        return DESERIALIZING_INSTANCE;
    }
}

