/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.google.common.collect.Lists;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.JavaScriptAggregator;
import io.druid.segment.ObjectColumnSelector;
import java.nio.ByteBuffer;
import java.util.List;

public class JavaScriptBufferAggregator
implements BufferAggregator {
    private final ObjectColumnSelector[] selectorList;
    private final JavaScriptAggregator.ScriptAggregator script;

    public JavaScriptBufferAggregator(List<ObjectColumnSelector> selectorList, JavaScriptAggregator.ScriptAggregator script) {
        this.selectorList = Lists.newArrayList(selectorList).toArray(new ObjectColumnSelector[0]);
        this.script = script;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putDouble(position, this.script.reset());
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        buf.putDouble(position, this.script.aggregate(buf.getDouble(position), this.selectorList));
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return buf.getDouble(position);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return (float)buf.getDouble(position);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return (long)buf.getDouble(position);
    }

    @Override
    public void close() {
        this.script.close();
    }
}

