/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.ExecuteException;
import org.apache.hadoop.fs.Path;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BadParam;
import org.apache.hive.hcatalog.templeton.BusyException;
import org.apache.hive.hcatalog.templeton.EnqueueBean;
import org.apache.hive.hcatalog.templeton.LauncherDelegator;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.QueueException;
import org.apache.hive.hcatalog.templeton.TooManyRequestsException;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;

public class HiveDelegator
extends LauncherDelegator {
    public HiveDelegator(AppConfig appConf) {
        super(appConf);
    }

    public EnqueueBean run(String user, Map<String, Object> userArgs, String execute, String srcFile, List<String> defines, List<String> hiveArgs, String otherFiles, String statusdir, String callback, String completedUrl, boolean enablelog, Boolean enableJobReconnect) throws NotAuthorizedException, BadParam, BusyException, QueueException, ExecuteException, IOException, InterruptedException, TooManyRequestsException {
        this.runAs = user;
        List<String> args = this.makeArgs(execute, srcFile, defines, hiveArgs, otherFiles, statusdir, completedUrl, enablelog, enableJobReconnect);
        return this.enqueueController(user, userArgs, callback, args);
    }

    private List<String> makeArgs(String execute, String srcFile, List<String> defines, List<String> hiveArgs, String otherFiles, String statusdir, String completedUrl, boolean enablelog, Boolean enableJobReconnect) throws BadParam, IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        try {
            args.addAll(this.makeBasicArgs(execute, srcFile, otherFiles, statusdir, completedUrl, enablelog, enableJobReconnect));
            args.add("--");
            this.addHiveMetaStoreTokenArg();
            args.add(this.appConf.hivePath());
            args.add("--service");
            args.add("cli");
            args.add("--hiveconf");
            args.add("__MR_JOB_CREDENTIALS_OPTION=WEBHCAT_TOKEN_FILE_LOCATION__");
            args.add("--hiveconf");
            args.add("__TEZ_CREDENTIALS_OPTION=WEBHCAT_TOKEN_FILE_LOCATION_TEZ__");
            args.add("--hiveconf");
            args.add("__MR_JOB_TAGS_OPTION=MR_JOB_TAGS_JOBID__");
            for (String prop : this.appConf.hiveProps()) {
                args.add("--hiveconf");
                args.add(prop);
            }
            for (String prop : defines) {
                args.add("--hiveconf");
                args.add(prop);
            }
            for (String hiveArg : hiveArgs) {
                args.add(hiveArg);
            }
            if (TempletonUtils.isset(execute)) {
                args.add("-e");
                args.add(execute);
            } else if (TempletonUtils.isset(srcFile)) {
                args.add("-f");
                args.add(TempletonUtils.hadoopFsPath(srcFile, this.appConf, this.runAs).getName());
            }
        }
        catch (FileNotFoundException e) {
            throw new BadParam(e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new BadParam(e.getMessage());
        }
        return args;
    }

    private List<String> makeBasicArgs(String execute, String srcFile, String otherFiles, String statusdir, String completedUrl, boolean enablelog, Boolean enableJobReconnect) throws URISyntaxException, IOException, InterruptedException {
        String extras;
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<String> allFiles = new ArrayList<String>();
        if (TempletonUtils.isset(srcFile)) {
            allFiles.add(TempletonUtils.hadoopFsFilename(srcFile, this.appConf, this.runAs));
        }
        if (TempletonUtils.isset(otherFiles)) {
            String[] ofs = TempletonUtils.hadoopFsListAsArray(otherFiles, this.appConf, this.runAs);
            allFiles.addAll(Arrays.asList(ofs));
        }
        args.addAll(this.makeLauncherArgs(this.appConf, statusdir, completedUrl, allFiles, enablelog, enableJobReconnect, LauncherDelegator.JobType.HIVE));
        if (this.appConf.hiveArchive() != null && !this.appConf.hiveArchive().equals("")) {
            args.add("-archives");
            args.add(this.appConf.hiveArchive());
        }
        if ((extras = this.appConf.get("templeton.hive.extra.files")) != null && extras.length() > 0) {
            boolean foundFiles = false;
            for (int i = 0; i < args.size(); ++i) {
                if (!"-files".equals(args.get(i))) continue;
                String value = args.get(i + 1);
                args.set(i + 1, value + "," + extras);
                foundFiles = true;
            }
            if (!foundFiles) {
                args.add("-files");
                args.add(extras);
            }
            String[] extraFiles = this.appConf.getStrings("templeton.hive.extra.files");
            StringBuilder extraFileNames = new StringBuilder();
            for (String file : extraFiles) {
                Path p = new Path(file);
                extraFileNames.append(p.getName()).append(",");
            }
            HiveDelegator.addDef(args, "templeton.hadoop.classpath.extras", extraFileNames.toString());
        }
        return args;
    }
}

