/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.utilities;

import it.uniroma3.mat.extendedset.intset.IntSet;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;

public class IntSetStatistics
implements IntSet {
    private final IntSet container;
    private static long unionCount = 0L;
    private static long intersectionCount = 0L;
    private static long differenceCount = 0L;
    private static long symmetricDifferenceCount = 0L;
    private static long complementCount = 0L;
    private static long unionSizeCount = 0L;
    private static long intersectionSizeCount = 0L;
    private static long differenceSizeCount = 0L;
    private static long symmetricDifferenceSizeCount = 0L;
    private static long complementSizeCount = 0L;
    private static long equalsCount = 0L;
    private static long hashCodeCount = 0L;
    private static long containsAllCount = 0L;
    private static long containsAnyCount = 0L;
    private static long containsAtLeastCount = 0L;

    public static long getUnionCount() {
        return unionCount;
    }

    public static long getIntersectionCount() {
        return intersectionCount;
    }

    public static long getDifferenceCount() {
        return differenceCount;
    }

    public static long getSymmetricDifferenceCount() {
        return symmetricDifferenceCount;
    }

    public static long getComplementCount() {
        return complementCount;
    }

    public static long getUnionSizeCount() {
        return unionSizeCount;
    }

    public static long getIntersectionSizeCount() {
        return intersectionSizeCount;
    }

    public static long getDifferenceSizeCount() {
        return differenceSizeCount;
    }

    public static long getSymmetricDifferenceSizeCount() {
        return symmetricDifferenceSizeCount;
    }

    public static long getComplementSizeCount() {
        return complementSizeCount;
    }

    public static long getEqualsCount() {
        return equalsCount;
    }

    public static long getHashCodeCount() {
        return hashCodeCount;
    }

    public static long getContainsAllCount() {
        return containsAllCount;
    }

    public static long getContainsAnyCount() {
        return containsAnyCount;
    }

    public static long getContainsAtLeastCount() {
        return containsAtLeastCount;
    }

    public static long getSizeCheckCount() {
        return IntSetStatistics.getIntersectionSizeCount() + IntSetStatistics.getUnionSizeCount() + IntSetStatistics.getDifferenceSizeCount() + IntSetStatistics.getSymmetricDifferenceSizeCount() + IntSetStatistics.getComplementSizeCount();
    }

    public static void resetCounters() {
        containsAtLeastCount = 0L;
        containsAnyCount = 0L;
        containsAllCount = 0L;
        hashCodeCount = 0L;
        equalsCount = 0L;
        complementSizeCount = 0L;
        symmetricDifferenceSizeCount = 0L;
        differenceSizeCount = 0L;
        intersectionSizeCount = 0L;
        unionSizeCount = 0L;
        complementCount = 0L;
        symmetricDifferenceCount = 0L;
        differenceCount = 0L;
        intersectionCount = 0L;
        unionCount = 0L;
    }

    public static String summary() {
        StringBuilder s = new StringBuilder();
        Formatter f = new Formatter(s);
        f.format("unionCount: %d\n", unionCount);
        f.format("intersectionCount: %d\n", intersectionCount);
        f.format("differenceCount: %d\n", differenceCount);
        f.format("symmetricDifferenceCount: %d\n", symmetricDifferenceCount);
        f.format("complementCount: %d\n", complementCount);
        f.format("unionSizeCount: %d\n", unionSizeCount);
        f.format("intersectionSizeCount: %d\n", intersectionSizeCount);
        f.format("differenceSizeCount: %d\n", differenceSizeCount);
        f.format("symmetricDifferenceSizeCount: %d\n", symmetricDifferenceSizeCount);
        f.format("complementSizeCount: %d\n", complementSizeCount);
        f.format("equalsCount: %d\n", equalsCount);
        f.format("hashCodeCount: %d\n", hashCodeCount);
        f.format("containsAllCount: %d\n", containsAllCount);
        f.format("containsAnyCount: %d\n", containsAnyCount);
        f.format("containsAtLeastCount: %d\n", containsAtLeastCount);
        return s.toString();
    }

    public IntSetStatistics(IntSet container) {
        this.container = IntSetStatistics.extractContainer(container);
    }

    public static IntSet extractContainer(IntSet c) {
        if (c instanceof IntSetStatistics) {
            return IntSetStatistics.extractContainer(((IntSetStatistics)c).container);
        }
        return c;
    }

    @Override
    public boolean addAll(IntSet c) {
        ++unionCount;
        return this.container.addAll(IntSetStatistics.extractContainer(c));
    }

    @Override
    public IntSet union(IntSet other) {
        ++unionCount;
        return new IntSetStatistics(this.container.union(IntSetStatistics.extractContainer(other)));
    }

    @Override
    public boolean retainAll(IntSet c) {
        ++intersectionCount;
        return this.container.retainAll(IntSetStatistics.extractContainer(c));
    }

    @Override
    public IntSet intersection(IntSet other) {
        ++intersectionCount;
        return new IntSetStatistics(this.container.intersection(IntSetStatistics.extractContainer(other)));
    }

    @Override
    public boolean removeAll(IntSet c) {
        ++differenceCount;
        return this.container.removeAll(IntSetStatistics.extractContainer(c));
    }

    @Override
    public IntSet difference(IntSet other) {
        ++differenceCount;
        return new IntSetStatistics(this.container.difference(IntSetStatistics.extractContainer(other)));
    }

    @Override
    public IntSet symmetricDifference(IntSet other) {
        ++symmetricDifferenceCount;
        return this.container.symmetricDifference(IntSetStatistics.extractContainer(other));
    }

    @Override
    public void complement() {
        ++complementCount;
        this.container.complement();
    }

    @Override
    public IntSet complemented() {
        ++complementCount;
        return new IntSetStatistics(this.container.complemented());
    }

    @Override
    public int unionSize(IntSet other) {
        ++unionSizeCount;
        return this.container.unionSize(IntSetStatistics.extractContainer(other));
    }

    @Override
    public int intersectionSize(IntSet other) {
        ++intersectionSizeCount;
        return this.container.intersectionSize(IntSetStatistics.extractContainer(other));
    }

    @Override
    public int differenceSize(IntSet other) {
        ++differenceSizeCount;
        return this.container.differenceSize(IntSetStatistics.extractContainer(other));
    }

    @Override
    public int symmetricDifferenceSize(IntSet other) {
        ++symmetricDifferenceSizeCount;
        return this.container.symmetricDifferenceSize(IntSetStatistics.extractContainer(other));
    }

    @Override
    public int complementSize() {
        ++complementSizeCount;
        return this.container.complementSize();
    }

    @Override
    public boolean containsAll(IntSet c) {
        ++containsAllCount;
        return this.container.containsAll(IntSetStatistics.extractContainer(c));
    }

    @Override
    public boolean containsAny(IntSet other) {
        ++containsAnyCount;
        return this.container.containsAny(IntSetStatistics.extractContainer(other));
    }

    @Override
    public boolean containsAtLeast(IntSet other, int minElements) {
        ++containsAtLeastCount;
        return this.container.containsAtLeast(IntSetStatistics.extractContainer(other), minElements);
    }

    public int hashCode() {
        ++hashCodeCount;
        return this.container.hashCode();
    }

    public boolean equals(Object obj) {
        ++equalsCount;
        return obj != null && (obj instanceof IntSetStatistics ? this.container.equals(IntSetStatistics.extractContainer((IntSetStatistics)obj)) : this.container.equals(obj));
    }

    @Override
    public double bitmapCompressionRatio() {
        return this.container.bitmapCompressionRatio();
    }

    @Override
    public double collectionCompressionRatio() {
        return this.container.collectionCompressionRatio();
    }

    @Override
    public void clear(int from, int to) {
        this.container.clear(from, to);
    }

    @Override
    public void fill(int from, int to) {
        this.container.fill(from, to);
    }

    @Override
    public void clear() {
        this.container.clear();
    }

    @Override
    public boolean add(int i) {
        return this.container.add(i);
    }

    @Override
    public boolean remove(int i) {
        return this.container.remove(i);
    }

    @Override
    public void flip(int e) {
        this.container.flip(e);
    }

    @Override
    public int get(int i) {
        return this.container.get(i);
    }

    @Override
    public int indexOf(int e) {
        return this.container.indexOf(e);
    }

    @Override
    public boolean contains(int i) {
        return this.container.contains(i);
    }

    @Override
    public int first() {
        return this.container.first();
    }

    @Override
    public int last() {
        return this.container.last();
    }

    @Override
    public boolean isEmpty() {
        return this.container.isEmpty();
    }

    @Override
    public int size() {
        return this.container.size();
    }

    @Override
    public IntSet.IntIterator iterator() {
        return this.container.iterator();
    }

    @Override
    public IntSet.IntIterator descendingIterator() {
        return this.container.descendingIterator();
    }

    @Override
    public int[] toArray() {
        return this.container.toArray();
    }

    @Override
    public int[] toArray(int[] a) {
        return this.container.toArray(a);
    }

    @Override
    public int compareTo(IntSet o) {
        return this.container.compareTo(o);
    }

    public String toString() {
        return this.container.toString();
    }

    @Override
    public List<? extends IntSet> powerSet() {
        return this.container.powerSet();
    }

    @Override
    public List<? extends IntSet> powerSet(int min, int max) {
        return this.container.powerSet(min, max);
    }

    @Override
    public int powerSetSize() {
        return this.container.powerSetSize();
    }

    @Override
    public int powerSetSize(int min, int max) {
        return this.container.powerSetSize(min, max);
    }

    @Override
    public double jaccardSimilarity(IntSet other) {
        return this.container.jaccardSimilarity(other);
    }

    @Override
    public double jaccardDistance(IntSet other) {
        return this.container.jaccardDistance(other);
    }

    @Override
    public double weightedJaccardSimilarity(IntSet other) {
        return this.container.weightedJaccardSimilarity(other);
    }

    @Override
    public double weightedJaccardDistance(IntSet other) {
        return this.container.weightedJaccardDistance(other);
    }

    @Override
    public IntSet empty() {
        return new IntSetStatistics(this.container.empty());
    }

    @Override
    public IntSet clone() {
        return new IntSetStatistics(this.container.clone());
    }

    @Override
    public IntSet convert(int ... a) {
        return new IntSetStatistics(this.container.convert(a));
    }

    @Override
    public IntSet convert(Collection<Integer> c) {
        return new IntSetStatistics(this.container.convert(c));
    }

    @Override
    public String debugInfo() {
        return "Analyzed IntSet:\n" + this.container.debugInfo();
    }
}

