/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.HashMultimap;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.CreateFunctionDesc;
import org.apache.hadoop.hive.ql.plan.CreateMacroDesc;
import org.apache.hadoop.hive.ql.plan.DropFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DropMacroDesc;
import org.apache.hadoop.hive.ql.plan.FunctionWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;

public class FunctionTask
extends Task<FunctionWork> {
    private static final long serialVersionUID = 1L;
    private static final transient Log LOG = LogFactory.getLog(FunctionTask.class);

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext ctx) {
        super.initialize(conf, queryPlan, ctx);
    }

    @Override
    public int execute(DriverContext driverContext) {
        CreateMacroDesc createMacroDesc;
        CreateFunctionDesc createFunctionDesc = ((FunctionWork)this.work).getCreateFunctionDesc();
        if (createFunctionDesc != null) {
            if (createFunctionDesc.isTemp()) {
                return this.createTemporaryFunction(createFunctionDesc);
            }
            try {
                return this.createPermanentFunction(Hive.get(this.conf), createFunctionDesc);
            }
            catch (Exception e) {
                this.setException(e);
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                return 1;
            }
        }
        DropFunctionDesc dropFunctionDesc = ((FunctionWork)this.work).getDropFunctionDesc();
        if (dropFunctionDesc != null) {
            if (dropFunctionDesc.isTemp()) {
                return this.dropTemporaryFunction(dropFunctionDesc);
            }
            try {
                return this.dropPermanentFunction(Hive.get(this.conf), dropFunctionDesc);
            }
            catch (Exception e) {
                this.setException(e);
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                return 1;
            }
        }
        if (((FunctionWork)this.work).getReloadFunctionDesc() != null) {
            try {
                Hive.get().reloadFunctions();
            }
            catch (Exception e) {
                this.setException(e);
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                return 1;
            }
        }
        if ((createMacroDesc = ((FunctionWork)this.work).getCreateMacroDesc()) != null) {
            return this.createMacro(createMacroDesc);
        }
        DropMacroDesc dropMacroDesc = ((FunctionWork)this.work).getDropMacroDesc();
        if (dropMacroDesc != null) {
            return this.dropMacro(dropMacroDesc);
        }
        return 0;
    }

    private int createPermanentFunction(Hive db, CreateFunctionDesc createFunctionDesc) throws HiveException, IOException {
        String[] qualifiedNameParts = FunctionUtils.getQualifiedFunctionNameParts(createFunctionDesc.getFunctionName());
        String dbName = qualifiedNameParts[0];
        String funcName = qualifiedNameParts[1];
        String registeredName = FunctionUtils.qualifyFunctionName(funcName, dbName);
        String className = createFunctionDesc.getClassName();
        List<ResourceUri> resources = createFunctionDesc.getResources();
        this.checkLocalFunctionResources(db, createFunctionDesc.getResources());
        FunctionInfo registered = FunctionRegistry.registerPermanentFunction(registeredName, className, true, FunctionTask.toFunctionResource(resources));
        if (registered == null) {
            this.console.printError("Failed to register " + registeredName + " using class " + createFunctionDesc.getClassName());
            return 1;
        }
        Function func = new Function(funcName, dbName, className, SessionState.get().getUserName(), PrincipalType.USER, (int)(System.currentTimeMillis() / 1000L), FunctionType.JAVA, resources);
        db.createFunction(func);
        return 0;
    }

    private int createTemporaryFunction(CreateFunctionDesc createFunctionDesc) {
        try {
            FunctionInfo.FunctionResource[] resources = FunctionTask.toFunctionResource(createFunctionDesc.getResources());
            FunctionTask.addFunctionResources(resources);
            Class<?> udfClass = this.getUdfClass(createFunctionDesc);
            FunctionInfo registered = FunctionRegistry.registerTemporaryUDF(createFunctionDesc.getFunctionName(), udfClass, resources);
            if (registered != null) {
                return 0;
            }
            this.console.printError("FAILED: Class " + createFunctionDesc.getClassName() + " does not implement UDF, GenericUDF, or UDAF");
            return 1;
        }
        catch (HiveException e) {
            this.console.printError("FAILED: " + e.toString());
            LOG.info((Object)("create function: " + StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (ClassNotFoundException e) {
            this.console.printError("FAILED: Class " + createFunctionDesc.getClassName() + " not found");
            LOG.info((Object)("create function: " + StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
    }

    private int createMacro(CreateMacroDesc createMacroDesc) {
        FunctionRegistry.registerTemporaryMacro(createMacroDesc.getMacroName(), createMacroDesc.getBody(), createMacroDesc.getColNames(), createMacroDesc.getColTypes());
        return 0;
    }

    private int dropMacro(DropMacroDesc dropMacroDesc) {
        try {
            FunctionRegistry.unregisterTemporaryUDF(dropMacroDesc.getMacroName());
            return 0;
        }
        catch (HiveException e) {
            LOG.info((Object)("drop macro: " + StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
    }

    private int dropPermanentFunction(Hive db, DropFunctionDesc dropFunctionDesc) {
        try {
            String[] qualifiedNameParts = FunctionUtils.getQualifiedFunctionNameParts(dropFunctionDesc.getFunctionName());
            String dbName = qualifiedNameParts[0];
            String funcName = qualifiedNameParts[1];
            String registeredName = FunctionUtils.qualifyFunctionName(funcName, dbName);
            FunctionRegistry.unregisterPermanentFunction(registeredName);
            db.dropFunction(dbName, funcName);
            return 0;
        }
        catch (Exception e) {
            LOG.info((Object)("drop function: " + StringUtils.stringifyException((Throwable)e)));
            this.console.printError("FAILED: error during drop function: " + StringUtils.stringifyException((Throwable)e));
            return 1;
        }
    }

    private int dropTemporaryFunction(DropFunctionDesc dropFunctionDesc) {
        try {
            FunctionRegistry.unregisterTemporaryUDF(dropFunctionDesc.getFunctionName());
            return 0;
        }
        catch (HiveException e) {
            LOG.info((Object)("drop function: " + StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
    }

    private void checkLocalFunctionResources(Hive db, List<ResourceUri> resources) throws HiveException {
        if (resources != null && resources.size() > 0) {
            try {
                String localFsScheme = FileSystem.getLocal((Configuration)db.getConf()).getUri().getScheme();
                String configuredFsScheme = FileSystem.get((Configuration)db.getConf()).getUri().getScheme();
                if (configuredFsScheme.equals(localFsScheme)) {
                    return;
                }
                for (ResourceUri res : resources) {
                    String resUri = res.getUri();
                    if (SessionState.canDownloadResource(resUri)) continue;
                    throw new HiveException("Hive warehouse is non-local, but " + res.getUri() + " specifies file on local filesystem. " + "Resources on non-local warehouse should specify a non-local scheme/path");
                }
            }
            catch (HiveException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)e);
                throw new HiveException(e);
            }
        }
    }

    public static FunctionInfo.FunctionResource[] toFunctionResource(List<ResourceUri> resources) throws HiveException {
        if (resources == null) {
            return null;
        }
        FunctionInfo.FunctionResource[] converted = new FunctionInfo.FunctionResource[resources.size()];
        for (int i = 0; i < converted.length; ++i) {
            ResourceUri resource = resources.get(i);
            SessionState.ResourceType type = FunctionTask.getResourceType(resource.getResourceType());
            converted[i] = new FunctionInfo.FunctionResource(type, resource.getUri());
        }
        return converted;
    }

    private static SessionState.ResourceType getResourceType(ResourceType rt) throws HiveException {
        switch (rt) {
            case JAR: {
                return SessionState.ResourceType.JAR;
            }
            case FILE: {
                return SessionState.ResourceType.FILE;
            }
            case ARCHIVE: {
                return SessionState.ResourceType.ARCHIVE;
            }
        }
        throw new HiveException("Unexpected resource type " + rt);
    }

    public static void addFunctionResources(FunctionInfo.FunctionResource[] resources) throws HiveException {
        if (resources != null) {
            HashMultimap<SessionState.ResourceType, String> mappings = HashMultimap.create();
            for (FunctionInfo.FunctionResource res : resources) {
                mappings.put(res.getResourceType(), res.getResourceURI());
            }
            for (SessionState.ResourceType type : mappings.keys()) {
                SessionState.get().add_resources(type, mappings.get(type));
            }
        }
    }

    private Class<?> getUdfClass(CreateFunctionDesc desc) throws ClassNotFoundException {
        ClassLoader classLoader = Utilities.getSessionSpecifiedClassLoader();
        return Class.forName(desc.getClassName(), true, classLoader);
    }

    @Override
    public StageType getType() {
        return StageType.FUNC;
    }

    @Override
    public String getName() {
        return "FUNCTION";
    }
}

