/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.start.classloader.vfs.providers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import org.apache.accumulo.start.classloader.vfs.providers.HdfsFileObject;
import org.apache.accumulo.start.classloader.vfs.providers.HdfsFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsFileSystem
extends AbstractFileSystem {
    private static final Log log = LogFactory.getLog(HdfsFileSystem.class);
    private FileSystem fs;

    protected HdfsFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
    }

    protected void addCapabilities(Collection<Capability> capabilities) {
        capabilities.addAll(HdfsFileProvider.CAPABILITIES);
    }

    public synchronized void close() {
        try {
            if (null != this.fs) {
                this.fs.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing HDFS client", e);
        }
        super.close();
    }

    protected FileObject createFile(AbstractFileName name) throws Exception {
        throw new FileSystemException("Operation not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject resolveFile(FileName name) throws FileSystemException {
        HdfsFileSystem hdfsFileSystem = this;
        synchronized (hdfsFileSystem) {
            if (null == this.fs) {
                String hdfsUri = name.getRootURI();
                Configuration conf = new Configuration(true);
                conf.set("fs.defaultFS", hdfsUri);
                this.fs = null;
                try {
                    this.fs = FileSystem.get((Configuration)conf);
                }
                catch (IOException e) {
                    log.error((Object)("Error connecting to filesystem " + hdfsUri), (Throwable)e);
                    throw new FileSystemException("Error connecting to filesystem " + hdfsUri, (Throwable)e);
                }
            }
        }
        boolean useCache = null != this.getContext().getFileSystemManager().getFilesCache();
        Object file = useCache ? this.getFileFromCache(name) : null;
        if (null == file) {
            String path = null;
            try {
                path = URLDecoder.decode(name.getPath(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                path = name.getPath();
            }
            Path filePath = new Path(path);
            file = new HdfsFileObject((AbstractFileName)name, this, this.fs, filePath);
            if (useCache) {
                this.putFileToCache((FileObject)file);
            }
        }
        if (this.getFileSystemManager().getCacheStrategy().equals((Object)CacheStrategy.ON_RESOLVE)) {
            file.refresh();
        }
        return file;
    }
}

