/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.springframework.asm.MethodVisitor;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.Indexer;
import org.springframework.expression.spel.ast.PropertyOrFieldReference;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.StringLiteral;
import org.springframework.expression.spel.ast.ValueRef;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Indexer
extends SpelNodeImpl {
    @Nullable
    private String cachedReadName;
    @Nullable
    private Class<?> cachedReadTargetType;
    @Nullable
    private PropertyAccessor cachedReadAccessor;
    @Nullable
    private String cachedWriteName;
    @Nullable
    private Class<?> cachedWriteTargetType;
    @Nullable
    private PropertyAccessor cachedWriteAccessor;
    @Nullable
    private IndexedType indexedType;

    public Indexer(int startPos, int endPos, SpelNodeImpl expr) {
        super(startPos, endPos, new SpelNodeImpl[]{expr});
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        return this.getValueRef(state).getValue();
    }

    public TypedValue setValueInternal(ExpressionState state, Supplier<TypedValue> valueSupplier) throws EvaluationException {
        TypedValue typedValue = valueSupplier.get();
        this.getValueRef(state).setValue(typedValue.getValue());
        return typedValue;
    }

    public boolean isWritable(ExpressionState expressionState) throws SpelEvaluationException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueRef getValueRef(ExpressionState state) throws EvaluationException {
        TypedValue indexValue;
        Object index;
        TypedValue context = state.getActiveContextObject();
        Object target = context.getValue();
        TypeDescriptor targetDescriptor = context.getTypeDescriptor();
        if (target instanceof Map && this.children[0] instanceof PropertyOrFieldReference) {
            PropertyOrFieldReference reference = (PropertyOrFieldReference)this.children[0];
            index = reference.getName();
            indexValue = new TypedValue(index);
        } else {
            try {
                state.pushActiveContextObject(state.getRootContextObject());
                indexValue = this.children[0].getValueInternal(state);
                index = indexValue.getValue();
                Assert.state((index != null ? 1 : 0) != 0, (String)"No index");
            }
            finally {
                state.popActiveContextObject();
            }
        }
        if (target == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.CANNOT_INDEX_INTO_NULL_VALUE, new Object[0]);
        }
        Assert.state((targetDescriptor != null ? 1 : 0) != 0, (String)"No type descriptor");
        if (target instanceof Map) {
            Object key = index;
            if (targetDescriptor.getMapKeyTypeDescriptor() != null) {
                key = state.convertValue(key, targetDescriptor.getMapKeyTypeDescriptor());
            }
            this.indexedType = IndexedType.MAP;
            return new MapIndexingValueRef(state.getTypeConverter(), (Map)target, key, targetDescriptor);
        }
        if (target.getClass().isArray() || target instanceof Collection || target instanceof String) {
            int idx = (Integer)state.convertValue(index, TypeDescriptor.valueOf(Integer.class));
            if (target.getClass().isArray()) {
                this.indexedType = IndexedType.ARRAY;
                return new ArrayIndexingValueRef(this, state.getTypeConverter(), target, idx, targetDescriptor);
            }
            if (target instanceof Collection) {
                if (target instanceof List) {
                    this.indexedType = IndexedType.LIST;
                }
                return new CollectionIndexingValueRef(this, (Collection)target, idx, targetDescriptor, state.getTypeConverter(), state.getConfiguration().isAutoGrowCollections(), state.getConfiguration().getMaximumAutoGrowSize());
            }
            this.indexedType = IndexedType.STRING;
            return new StringIndexingLValue((String)target, idx, targetDescriptor);
        }
        TypeDescriptor valueType = indexValue.getTypeDescriptor();
        if (valueType != null && String.class == valueType.getType()) {
            this.indexedType = IndexedType.OBJECT;
            return new PropertyIndexingValueRef(this, target, (String)index, state.getEvaluationContext(), targetDescriptor);
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, targetDescriptor);
    }

    public boolean isCompilable() {
        if (this.indexedType == IndexedType.ARRAY) {
            return this.exitTypeDescriptor != null;
        }
        if (this.indexedType == IndexedType.LIST) {
            return this.children[0].isCompilable();
        }
        if (this.indexedType == IndexedType.MAP) {
            return this.children[0] instanceof PropertyOrFieldReference || this.children[0].isCompilable();
        }
        if (this.indexedType == IndexedType.OBJECT) {
            return this.cachedReadAccessor != null && this.cachedReadAccessor instanceof ReflectivePropertyAccessor.OptimalPropertyAccessor && this.getChild(0) instanceof StringLiteral;
        }
        return false;
    }

    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        String descriptor = cf.lastDescriptor();
        if (descriptor == null) {
            cf.loadTarget(mv);
        }
        if (this.indexedType == IndexedType.ARRAY) {
            int insn;
            if ("D".equals(this.exitTypeDescriptor)) {
                mv.visitTypeInsn(192, "[D");
                insn = 49;
            } else if ("F".equals(this.exitTypeDescriptor)) {
                mv.visitTypeInsn(192, "[F");
                insn = 48;
            } else if ("J".equals(this.exitTypeDescriptor)) {
                mv.visitTypeInsn(192, "[J");
                insn = 47;
            } else if ("I".equals(this.exitTypeDescriptor)) {
                mv.visitTypeInsn(192, "[I");
                insn = 46;
            } else if ("S".equals(this.exitTypeDescriptor)) {
                mv.visitTypeInsn(192, "[S");
                insn = 53;
            } else if ("B".equals(this.exitTypeDescriptor)) {
                mv.visitTypeInsn(192, "[B");
                insn = 51;
            } else if ("C".equals(this.exitTypeDescriptor)) {
                mv.visitTypeInsn(192, "[C");
                insn = 52;
            } else {
                mv.visitTypeInsn(192, "[" + this.exitTypeDescriptor + (CodeFlow.isPrimitiveArray(this.exitTypeDescriptor) ? "" : ";"));
                insn = 50;
            }
            SpelNodeImpl index = this.children[0];
            cf.enterCompilationScope();
            index.generateCode(mv, cf);
            cf.exitCompilationScope();
            mv.visitInsn(insn);
        } else if (this.indexedType == IndexedType.LIST) {
            mv.visitTypeInsn(192, "java/util/List");
            cf.enterCompilationScope();
            this.children[0].generateCode(mv, cf);
            cf.exitCompilationScope();
            mv.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;", true);
        } else if (this.indexedType == IndexedType.MAP) {
            mv.visitTypeInsn(192, "java/util/Map");
            if (this.children[0] instanceof PropertyOrFieldReference) {
                PropertyOrFieldReference reference = (PropertyOrFieldReference)this.children[0];
                String mapKeyName = reference.getName();
                mv.visitLdcInsn((Object)mapKeyName);
            } else {
                cf.enterCompilationScope();
                this.children[0].generateCode(mv, cf);
                cf.exitCompilationScope();
            }
            mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
        } else if (this.indexedType == IndexedType.OBJECT) {
            ReflectivePropertyAccessor.OptimalPropertyAccessor accessor = (ReflectivePropertyAccessor.OptimalPropertyAccessor)this.cachedReadAccessor;
            Assert.state((accessor != null ? 1 : 0) != 0, (String)"No cached read accessor");
            Member member = accessor.member;
            boolean isStatic = Modifier.isStatic(member.getModifiers());
            String classDesc = member.getDeclaringClass().getName().replace('.', '/');
            if (!isStatic) {
                if (descriptor == null) {
                    cf.loadTarget(mv);
                }
                if (descriptor == null || !classDesc.equals(descriptor.substring(1))) {
                    mv.visitTypeInsn(192, classDesc);
                }
            }
            if (member instanceof Method) {
                mv.visitMethodInsn(isStatic ? 184 : 182, classDesc, member.getName(), CodeFlow.createSignatureDescriptor((Method)member), false);
            } else {
                mv.visitFieldInsn(isStatic ? 178 : 180, classDesc, member.getName(), CodeFlow.toJvmDescriptor(((Field)member).getType()));
            }
        }
        cf.pushDescriptor(this.exitTypeDescriptor);
    }

    public String toStringAST() {
        StringJoiner sj = new StringJoiner(",", "[", "]");
        for (int i = 0; i < this.getChildCount(); ++i) {
            sj.add(this.getChild(i).toStringAST());
        }
        return sj.toString();
    }

    private void setArrayElement(TypeConverter converter, Object ctx, int idx, @Nullable Object newValue, Class<?> arrayComponentType) throws EvaluationException {
        if (arrayComponentType == Boolean.TYPE) {
            boolean[] array = (boolean[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = this.convertValue(converter, newValue, Boolean.class);
        } else if (arrayComponentType == Byte.TYPE) {
            byte[] array = (byte[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = this.convertValue(converter, newValue, Byte.class);
        } else if (arrayComponentType == Character.TYPE) {
            char[] array = (char[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = this.convertValue(converter, newValue, Character.class).charValue();
        } else if (arrayComponentType == Double.TYPE) {
            double[] array = (double[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = this.convertValue(converter, newValue, Double.class);
        } else if (arrayComponentType == Float.TYPE) {
            float[] array = (float[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = this.convertValue(converter, newValue, Float.class).floatValue();
        } else if (arrayComponentType == Integer.TYPE) {
            int[] array = (int[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = this.convertValue(converter, newValue, Integer.class);
        } else if (arrayComponentType == Long.TYPE) {
            long[] array = (long[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = this.convertValue(converter, newValue, Long.class);
        } else if (arrayComponentType == Short.TYPE) {
            short[] array = (short[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = this.convertValue(converter, newValue, Short.class);
        } else {
            Object[] array = (Object[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = this.convertValue(converter, newValue, arrayComponentType);
        }
    }

    private Object accessArrayElement(Object ctx, int idx) throws SpelEvaluationException {
        Class<?> arrayComponentType = ctx.getClass().getComponentType();
        if (arrayComponentType == Boolean.TYPE) {
            boolean[] array = (boolean[])ctx;
            this.checkAccess(array.length, idx);
            this.exitTypeDescriptor = "Z";
            return array[idx];
        }
        if (arrayComponentType == Byte.TYPE) {
            byte[] array = (byte[])ctx;
            this.checkAccess(array.length, idx);
            this.exitTypeDescriptor = "B";
            return array[idx];
        }
        if (arrayComponentType == Character.TYPE) {
            char[] array = (char[])ctx;
            this.checkAccess(array.length, idx);
            this.exitTypeDescriptor = "C";
            return Character.valueOf(array[idx]);
        }
        if (arrayComponentType == Double.TYPE) {
            double[] array = (double[])ctx;
            this.checkAccess(array.length, idx);
            this.exitTypeDescriptor = "D";
            return array[idx];
        }
        if (arrayComponentType == Float.TYPE) {
            float[] array = (float[])ctx;
            this.checkAccess(array.length, idx);
            this.exitTypeDescriptor = "F";
            return Float.valueOf(array[idx]);
        }
        if (arrayComponentType == Integer.TYPE) {
            int[] array = (int[])ctx;
            this.checkAccess(array.length, idx);
            this.exitTypeDescriptor = "I";
            return array[idx];
        }
        if (arrayComponentType == Long.TYPE) {
            long[] array = (long[])ctx;
            this.checkAccess(array.length, idx);
            this.exitTypeDescriptor = "J";
            return array[idx];
        }
        if (arrayComponentType == Short.TYPE) {
            short[] array = (short[])ctx;
            this.checkAccess(array.length, idx);
            this.exitTypeDescriptor = "S";
            return array[idx];
        }
        Object[] array = (Object[])ctx;
        this.checkAccess(array.length, idx);
        Object retValue = array[idx];
        this.exitTypeDescriptor = CodeFlow.toDescriptor(arrayComponentType);
        return retValue;
    }

    private void checkAccess(int arrayLength, int index) throws SpelEvaluationException {
        if (index >= arrayLength) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.ARRAY_INDEX_OUT_OF_BOUNDS, arrayLength, index);
        }
    }

    private <T> T convertValue(TypeConverter converter, @Nullable Object value, Class<T> targetType) {
        Object result = converter.convertValue(value, TypeDescriptor.forObject((Object)value), TypeDescriptor.valueOf(targetType));
        if (result == null) {
            throw new IllegalStateException("Null conversion result for index [" + value + "]");
        }
        return (T)result;
    }

    static /* synthetic */ Object access$000(Indexer x0, Object x1, int x2) throws SpelEvaluationException {
        return x0.accessArrayElement(x1, x2);
    }

    static /* synthetic */ void access$100(Indexer x0, TypeConverter x1, Object x2, int x3, Object x4, Class x5) throws EvaluationException {
        x0.setArrayElement(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ String access$200(Indexer x0) {
        return x0.cachedReadName;
    }

    static /* synthetic */ Class access$300(Indexer x0) {
        return x0.cachedReadTargetType;
    }

    static /* synthetic */ PropertyAccessor access$400(Indexer x0) {
        return x0.cachedReadAccessor;
    }

    static /* synthetic */ PropertyAccessor access$402(Indexer x0, PropertyAccessor x1) {
        x0.cachedReadAccessor = x1;
        return x0.cachedReadAccessor;
    }

    static /* synthetic */ String access$202(Indexer x0, String x1) {
        x0.cachedReadName = x1;
        return x0.cachedReadName;
    }

    static /* synthetic */ Class access$302(Indexer x0, Class x1) {
        x0.cachedReadTargetType = x1;
        return x0.cachedReadTargetType;
    }

    static /* synthetic */ String access$500(Indexer x0) {
        return x0.cachedWriteName;
    }

    static /* synthetic */ Class access$600(Indexer x0) {
        return x0.cachedWriteTargetType;
    }

    static /* synthetic */ PropertyAccessor access$700(Indexer x0) {
        return x0.cachedWriteAccessor;
    }

    static /* synthetic */ String access$502(Indexer x0, String x1) {
        x0.cachedWriteName = x1;
        return x0.cachedWriteName;
    }

    static /* synthetic */ Class access$602(Indexer x0, Class x1) {
        x0.cachedWriteTargetType = x1;
        return x0.cachedWriteTargetType;
    }

    static /* synthetic */ PropertyAccessor access$702(Indexer x0, PropertyAccessor x1) {
        x0.cachedWriteAccessor = x1;
        return x0.cachedWriteAccessor;
    }

    private class StringIndexingLValue
    implements ValueRef {
        private final String target;
        private final int index;
        private final TypeDescriptor typeDescriptor;

        public StringIndexingLValue(String target, int index, TypeDescriptor typeDescriptor) {
            this.target = target;
            this.index = index;
            this.typeDescriptor = typeDescriptor;
        }

        @Override
        public TypedValue getValue() {
            if (this.index >= this.target.length()) {
                throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.STRING_INDEX_OUT_OF_BOUNDS, this.target.length(), this.index);
            }
            return new TypedValue(String.valueOf(this.target.charAt(this.index)));
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.typeDescriptor.toString());
        }

        @Override
        public boolean isWritable() {
            return true;
        }
    }

    private class MapIndexingValueRef
    implements ValueRef {
        private final TypeConverter typeConverter;
        private final Map map;
        @Nullable
        private final Object key;
        private final TypeDescriptor mapEntryDescriptor;

        public MapIndexingValueRef(TypeConverter typeConverter, @Nullable Map map, Object key, TypeDescriptor mapEntryDescriptor) {
            this.typeConverter = typeConverter;
            this.map = map;
            this.key = key;
            this.mapEntryDescriptor = mapEntryDescriptor;
        }

        @Override
        public TypedValue getValue() {
            Object value = this.map.get(this.key);
            Indexer.this.exitTypeDescriptor = CodeFlow.toDescriptor(Object.class);
            return new TypedValue(value, this.mapEntryDescriptor.getMapValueTypeDescriptor(value));
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            if (this.mapEntryDescriptor.getMapValueTypeDescriptor() != null) {
                newValue = this.typeConverter.convertValue(newValue, TypeDescriptor.forObject((Object)newValue), this.mapEntryDescriptor.getMapValueTypeDescriptor());
            }
            this.map.put(this.key, newValue);
        }

        @Override
        public boolean isWritable() {
            return true;
        }
    }

    private static enum IndexedType {
        ARRAY,
        LIST,
        MAP,
        STRING,
        OBJECT;

    }
}

