/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hive.service.AbstractService;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.operation.GetCatalogsOperation;
import org.apache.hive.service.cli.operation.GetColumnsOperation;
import org.apache.hive.service.cli.operation.GetFunctionsOperation;
import org.apache.hive.service.cli.operation.GetSchemasOperation;
import org.apache.hive.service.cli.operation.GetTableTypesOperation;
import org.apache.hive.service.cli.operation.GetTablesOperation;
import org.apache.hive.service.cli.operation.GetTypeInfoOperation;
import org.apache.hive.service.cli.operation.LogDivertAppender;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public class OperationManager
extends AbstractService {
    private final Log LOG = LogFactory.getLog((String)OperationManager.class.getName());
    private final Map<OperationHandle, Operation> handleToOperation = new HashMap<OperationHandle, Operation>();

    public OperationManager() {
        super(OperationManager.class.getSimpleName());
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED)) {
            this.initOperationLogCapture(hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LEVEL));
        } else {
            this.LOG.debug((Object)"Operation level logging is turned off");
        }
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
    }

    private void initOperationLogCapture(String loggingMode) {
        LogDivertAppender ap = new LogDivertAppender(this, OperationLog.getLoggingLevel((String)loggingMode));
        Logger.getRootLogger().addAppender((Appender)ap);
    }

    public ExecuteStatementOperation newExecuteStatementOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runAsync) throws HiveSQLException {
        ExecuteStatementOperation executeStatementOperation = ExecuteStatementOperation.newExecuteStatementOperation(parentSession, statement, confOverlay, runAsync);
        this.addOperation(executeStatementOperation);
        return executeStatementOperation;
    }

    public GetTypeInfoOperation newGetTypeInfoOperation(HiveSession parentSession) {
        GetTypeInfoOperation operation = new GetTypeInfoOperation(parentSession);
        this.addOperation(operation);
        return operation;
    }

    public GetCatalogsOperation newGetCatalogsOperation(HiveSession parentSession) {
        GetCatalogsOperation operation = new GetCatalogsOperation(parentSession);
        this.addOperation(operation);
        return operation;
    }

    public GetSchemasOperation newGetSchemasOperation(HiveSession parentSession, String catalogName, String schemaName) {
        GetSchemasOperation operation = new GetSchemasOperation(parentSession, catalogName, schemaName);
        this.addOperation(operation);
        return operation;
    }

    public MetadataOperation newGetTablesOperation(HiveSession parentSession, String catalogName, String schemaName, String tableName, List<String> tableTypes) {
        GetTablesOperation operation = new GetTablesOperation(parentSession, catalogName, schemaName, tableName, tableTypes);
        this.addOperation(operation);
        return operation;
    }

    public GetTableTypesOperation newGetTableTypesOperation(HiveSession parentSession) {
        GetTableTypesOperation operation = new GetTableTypesOperation(parentSession);
        this.addOperation(operation);
        return operation;
    }

    public GetColumnsOperation newGetColumnsOperation(HiveSession parentSession, String catalogName, String schemaName, String tableName, String columnName) {
        GetColumnsOperation operation = new GetColumnsOperation(parentSession, catalogName, schemaName, tableName, columnName);
        this.addOperation(operation);
        return operation;
    }

    public GetFunctionsOperation newGetFunctionsOperation(HiveSession parentSession, String catalogName, String schemaName, String functionName) {
        GetFunctionsOperation operation = new GetFunctionsOperation(parentSession, catalogName, schemaName, functionName);
        this.addOperation(operation);
        return operation;
    }

    public Operation getOperation(OperationHandle operationHandle) throws HiveSQLException {
        Operation operation = this.getOperationInternal(operationHandle);
        if (operation == null) {
            throw new HiveSQLException("Invalid OperationHandle: " + operationHandle);
        }
        return operation;
    }

    private synchronized Operation getOperationInternal(OperationHandle operationHandle) {
        return this.handleToOperation.get(operationHandle);
    }

    private synchronized Operation removeTimedOutOperation(OperationHandle operationHandle) {
        Operation operation = this.handleToOperation.get(operationHandle);
        if (operation != null && operation.isTimedOut(System.currentTimeMillis())) {
            this.handleToOperation.remove(operationHandle);
            return operation;
        }
        return null;
    }

    private synchronized void addOperation(Operation operation) {
        this.handleToOperation.put(operation.getHandle(), operation);
    }

    private synchronized Operation removeOperation(OperationHandle opHandle) {
        return this.handleToOperation.remove(opHandle);
    }

    public OperationStatus getOperationStatus(OperationHandle opHandle) throws HiveSQLException {
        return this.getOperation(opHandle).getStatus();
    }

    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        Operation operation = this.getOperation(opHandle);
        OperationState opState = operation.getStatus().getState();
        if (opState == OperationState.CANCELED || opState == OperationState.CLOSED || opState == OperationState.FINISHED || opState == OperationState.ERROR || opState == OperationState.UNKNOWN) {
            this.LOG.debug((Object)(opHandle + ": Operation is already aborted in state - " + (Object)((Object)opState)));
        } else {
            this.LOG.debug((Object)(opHandle + ": Attempting to cancel from state - " + (Object)((Object)opState)));
            operation.cancel();
        }
    }

    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        Operation operation = this.removeOperation(opHandle);
        if (operation == null) {
            throw new HiveSQLException("Operation does not exist!");
        }
        operation.close();
    }

    public TableSchema getOperationResultSetSchema(OperationHandle opHandle) throws HiveSQLException {
        return this.getOperation(opHandle).getResultSetSchema();
    }

    public RowSet getOperationNextRowSet(OperationHandle opHandle) throws HiveSQLException {
        return this.getOperation(opHandle).getNextRowSet();
    }

    public RowSet getOperationNextRowSet(OperationHandle opHandle, FetchOrientation orientation, long maxRows) throws HiveSQLException {
        return this.getOperation(opHandle).getNextRowSet(orientation, maxRows);
    }

    public RowSet getOperationLogRowSet(OperationHandle opHandle, FetchOrientation orientation, long maxRows) throws HiveSQLException {
        List logs;
        OperationLog operationLog = this.getOperation(opHandle).getOperationLog();
        if (operationLog == null) {
            throw new HiveSQLException("Couldn't find log associated with operation handle: " + opHandle);
        }
        try {
            logs = operationLog.readOperationLog(this.isFetchFirst(orientation), maxRows);
        }
        catch (SQLException e) {
            throw new HiveSQLException(e.getMessage(), e.getCause());
        }
        TableSchema tableSchema = new TableSchema(this.getLogSchema());
        RowSet rowSet = RowSetFactory.create(tableSchema, this.getOperation(opHandle).getProtocolVersion());
        for (String log : logs) {
            rowSet.addRow(new String[]{log});
        }
        return rowSet;
    }

    private boolean isFetchFirst(FetchOrientation fetchOrientation) {
        return fetchOrientation.equals((Object)FetchOrientation.FETCH_FIRST);
    }

    private Schema getLogSchema() {
        Schema schema = new Schema();
        FieldSchema fieldSchema = new FieldSchema();
        fieldSchema.setName("operation_log");
        fieldSchema.setType("string");
        schema.addToFieldSchemas(fieldSchema);
        return schema;
    }

    public Collection<Operation> getOperations() {
        return Collections.unmodifiableCollection(this.handleToOperation.values());
    }

    public OperationLog getOperationLogByThread() {
        return OperationLog.getCurrentOperationLog();
    }

    public List<Operation> removeExpiredOperations(OperationHandle[] handles) {
        ArrayList<Operation> removed = new ArrayList<Operation>();
        for (OperationHandle handle : handles) {
            Operation operation = this.removeTimedOutOperation(handle);
            if (operation == null) continue;
            this.LOG.warn((Object)("Operation " + handle + " is timed-out and will be closed"));
            removed.add(operation);
        }
        return removed;
    }
}

