/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.io.IOException;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class PasswdCommand
extends Shell.Command {
    private Option userOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, IOException {
        String currentUser = shellState.getConnector().whoami();
        String user = cl.getOptionValue(this.userOpt.getOpt(), currentUser);
        String password = null;
        String passwordConfirm = null;
        String oldPassword = null;
        oldPassword = shellState.readMaskedLine("Enter current password for '" + currentUser + "': ", Character.valueOf('*'));
        if (oldPassword == null) {
            shellState.getReader().println();
            return 0;
        }
        if (!shellState.getConnector().securityOperations().authenticateUser(currentUser, new PasswordToken(oldPassword))) {
            throw new AccumuloSecurityException(user, SecurityErrorCode.BAD_CREDENTIALS);
        }
        password = shellState.readMaskedLine("Enter new password for '" + user + "': ", Character.valueOf('*'));
        if (password == null) {
            shellState.getReader().println();
            return 0;
        }
        passwordConfirm = shellState.readMaskedLine("Please confirm new password for '" + user + "': ", Character.valueOf('*'));
        if (passwordConfirm == null) {
            shellState.getReader().println();
            return 0;
        }
        if (!password.equals(passwordConfirm)) {
            throw new IllegalArgumentException("Passwords do not match");
        }
        byte[] pass = password.getBytes(Constants.UTF8);
        shellState.getConnector().securityOperations().changeLocalUserPassword(user, new PasswordToken(pass));
        if (shellState.getConnector().whoami().equals(user)) {
            shellState.updateUser(user, new PasswordToken(pass));
        }
        Shell.log.debug((Object)("Changed password for user " + user));
        return 0;
    }

    @Override
    public String description() {
        return "changes a user's password";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.userOpt = new Option("u", "user", true, "user to operate on");
        this.userOpt.setArgName("user");
        o.addOption(this.userOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

