/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mock;

import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.mock.MockAccumulo;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.util.ArgumentChecker;

public class MockBatchWriter
implements BatchWriter {
    final String tablename;
    final MockAccumulo acu;

    MockBatchWriter(MockAccumulo acu, String tablename) {
        this.acu = acu;
        this.tablename = tablename;
    }

    @Override
    public void addMutation(Mutation m) throws MutationsRejectedException {
        ArgumentChecker.notNull(m);
        this.acu.addMutation(this.tablename, m);
    }

    @Override
    public void addMutations(Iterable<Mutation> iterable) throws MutationsRejectedException {
        ArgumentChecker.notNull(iterable);
        for (Mutation m : iterable) {
            this.acu.addMutation(this.tablename, m);
        }
    }

    @Override
    public void flush() throws MutationsRejectedException {
    }

    @Override
    public void close() throws MutationsRejectedException {
    }
}

