/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class ClientConfiguration
extends CompositeConfiguration {
    public static final String USER_ACCUMULO_DIR_NAME = ".accumulo";
    public static final String USER_CONF_FILENAME = "config";
    public static final String GLOBAL_CONF_FILENAME = "client.conf";

    public ClientConfiguration(List<? extends Configuration> configs) {
        super(configs);
    }

    public ClientConfiguration(Configuration ... configs) {
        this(Arrays.asList(configs));
    }

    public static ClientConfiguration loadDefault() {
        return ClientConfiguration.loadFromSearchPath(ClientConfiguration.getDefaultSearchPath());
    }

    private static ClientConfiguration loadFromSearchPath(List<String> paths) {
        try {
            LinkedList<PropertiesConfiguration> configs = new LinkedList<PropertiesConfiguration>();
            for (String path : paths) {
                File conf = new File(path);
                if (!conf.canRead()) continue;
                configs.add(new PropertiesConfiguration(conf));
            }
            return new ClientConfiguration(configs);
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException("Error loading client configuration", e);
        }
    }

    public static ClientConfiguration deserialize(String serializedConfig) {
        PropertiesConfiguration propConfig = new PropertiesConfiguration();
        try {
            propConfig.load((Reader)new StringReader(serializedConfig));
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Error deserializing client configuration: " + serializedConfig, e);
        }
        return new ClientConfiguration(new Configuration[]{propConfig});
    }

    private static List<String> getDefaultSearchPath() {
        LinkedList<String> clientConfPaths;
        String clientConfSearchPath = System.getenv("ACCUMULO_CLIENT_CONF_PATH");
        if (clientConfSearchPath != null) {
            clientConfPaths = Arrays.asList(clientConfSearchPath.split(File.pathSeparator));
        } else {
            clientConfPaths = new LinkedList();
            clientConfPaths.add(System.getProperty("user.home") + File.separator + USER_ACCUMULO_DIR_NAME + File.separator + USER_CONF_FILENAME);
            if (System.getenv("ACCUMULO_CONF_DIR") != null) {
                clientConfPaths.add(System.getenv("ACCUMULO_CONF_DIR") + File.separator + GLOBAL_CONF_FILENAME);
            } else if (System.getenv("ACCUMULO_HOME") != null) {
                clientConfPaths.add(System.getenv("ACCUMULO_HOME") + File.separator + "conf" + File.separator + GLOBAL_CONF_FILENAME);
            }
            clientConfPaths.add("/etc/accumulo/client.conf");
        }
        return clientConfPaths;
    }

    public String serialize() {
        PropertiesConfiguration propConfig = new PropertiesConfiguration();
        propConfig.copy((Configuration)this);
        StringWriter writer = new StringWriter();
        try {
            propConfig.save((Writer)writer);
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException(e);
        }
        return writer.toString();
    }

    public String get(ClientProperty prop) {
        if (this.containsKey(prop.getKey())) {
            return this.getString(prop.getKey());
        }
        return prop.getDefaultValue();
    }

    public void setProperty(ClientProperty prop, String value) {
        this.setProperty(prop.getKey(), value);
    }

    public ClientConfiguration with(ClientProperty prop, String value) {
        this.setProperty(prop.getKey(), value);
        return this;
    }

    public ClientConfiguration withInstance(String instanceName) {
        ArgumentChecker.notNull(instanceName);
        return this.with(ClientProperty.INSTANCE_NAME, instanceName);
    }

    public ClientConfiguration withInstance(UUID instanceId) {
        ArgumentChecker.notNull(instanceId);
        return this.with(ClientProperty.INSTANCE_ID, instanceId.toString());
    }

    public ClientConfiguration withZkHosts(String zooKeepers) {
        ArgumentChecker.notNull(zooKeepers);
        return this.with(ClientProperty.INSTANCE_ZK_HOST, zooKeepers);
    }

    public ClientConfiguration withZkTimeout(int timeout) {
        return this.with(ClientProperty.INSTANCE_ZK_TIMEOUT, String.valueOf(timeout));
    }

    public ClientConfiguration withSsl(boolean sslEnabled) {
        return this.withSsl(sslEnabled, false);
    }

    public ClientConfiguration withSsl(boolean sslEnabled, boolean useJsseConfig) {
        return this.with(ClientProperty.INSTANCE_RPC_SSL_ENABLED, String.valueOf(sslEnabled)).with(ClientProperty.RPC_USE_JSSE, String.valueOf(useJsseConfig));
    }

    public ClientConfiguration withTruststore(String path) {
        return this.withTruststore(path, null, null);
    }

    public ClientConfiguration withTruststore(String path, String password, String type) {
        ArgumentChecker.notNull(path);
        this.setProperty(ClientProperty.RPC_SSL_TRUSTSTORE_PATH, path);
        if (password != null) {
            this.setProperty(ClientProperty.RPC_SSL_TRUSTSTORE_PASSWORD, password);
        }
        if (type != null) {
            this.setProperty(ClientProperty.RPC_SSL_TRUSTSTORE_TYPE, type);
        }
        return this;
    }

    public ClientConfiguration withKeystore(String path) {
        return this.withKeystore(path, null, null);
    }

    public ClientConfiguration withKeystore(String path, String password, String type) {
        ArgumentChecker.notNull(path);
        this.setProperty(ClientProperty.INSTANCE_RPC_SSL_CLIENT_AUTH, "true");
        this.setProperty(ClientProperty.RPC_SSL_KEYSTORE_PATH, path);
        if (password != null) {
            this.setProperty(ClientProperty.RPC_SSL_KEYSTORE_PASSWORD, password);
        }
        if (type != null) {
            this.setProperty(ClientProperty.RPC_SSL_KEYSTORE_TYPE, type);
        }
        return this;
    }

    public static enum ClientProperty {
        RPC_SSL_TRUSTSTORE_PATH(Property.RPC_SSL_TRUSTSTORE_PATH),
        RPC_SSL_TRUSTSTORE_PASSWORD(Property.RPC_SSL_TRUSTSTORE_PASSWORD),
        RPC_SSL_TRUSTSTORE_TYPE(Property.RPC_SSL_TRUSTSTORE_TYPE),
        RPC_SSL_KEYSTORE_PATH(Property.RPC_SSL_KEYSTORE_PATH),
        RPC_SSL_KEYSTORE_PASSWORD(Property.RPC_SSL_KEYSTORE_PASSWORD),
        RPC_SSL_KEYSTORE_TYPE(Property.RPC_SSL_KEYSTORE_TYPE),
        RPC_USE_JSSE(Property.RPC_USE_JSSE),
        INSTANCE_RPC_SSL_CLIENT_AUTH(Property.INSTANCE_RPC_SSL_CLIENT_AUTH),
        INSTANCE_RPC_SSL_ENABLED(Property.INSTANCE_RPC_SSL_ENABLED),
        INSTANCE_ZK_HOST(Property.INSTANCE_ZK_HOST),
        INSTANCE_ZK_TIMEOUT(Property.INSTANCE_ZK_TIMEOUT),
        INSTANCE_NAME("instance.name", null, PropertyType.STRING, "Name of Accumulo instance to connect to"),
        INSTANCE_ID("instance.id", null, PropertyType.STRING, "UUID of Accumulo instance to connect to");

        private String key;
        private String defaultValue;
        private PropertyType type;
        private String description;
        private Property accumuloProperty = null;

        private ClientProperty(Property prop) {
            this(prop.getKey(), prop.getDefaultValue(), prop.getType(), prop.getDescription());
            this.accumuloProperty = prop;
        }

        private ClientProperty(String key, String defaultValue, PropertyType type, String description) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.type = type;
            this.description = description;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public PropertyType getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public Property getAccumuloProperty() {
            return this.accumuloProperty;
        }

        public static ClientProperty getPropertyByKey(String key) {
            for (ClientProperty prop : ClientProperty.values()) {
                if (!prop.getKey().equals(key)) continue;
                return prop;
            }
            return null;
        }
    }
}

