/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase;

import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.hbase.SharedStorageDescriptor;
import org.apache.hadoop.hive.metastore.hbase.TestHBaseStore;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSharedStorageDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestHBaseStore.class.getName());

    @Test
    public void changeOnSerde() {
        StorageDescriptor sd = new StorageDescriptor();
        SerDeInfo serde = new SerDeInfo();
        serde.setName("serde");
        sd.setSerdeInfo(serde);
        SharedStorageDescriptor ssd = new SharedStorageDescriptor();
        ssd.setShared(sd);
        ssd.getSerdeInfo().setName("different");
        Assert.assertFalse((sd.getSerdeInfo() == ssd.getSerdeInfo() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"serde", (Object)serde.getName());
        Assert.assertEquals((Object)"different", (Object)ssd.getSerdeInfo().getName());
        Assert.assertEquals((Object)"serde", (Object)sd.getSerdeInfo().getName());
    }

    @Test
    public void changeOnSkewed() {
        StorageDescriptor sd = new StorageDescriptor();
        SkewedInfo skew = new SkewedInfo();
        sd.setSkewedInfo(skew);
        SharedStorageDescriptor ssd = new SharedStorageDescriptor();
        ssd.setShared(sd);
        ssd.setSkewedInfo(new SkewedInfo());
        Assert.assertFalse((sd.getSkewedInfo() == ssd.getSkewedInfo() ? 1 : 0) != 0);
    }

    @Test
    public void changeOnUnset() {
        StorageDescriptor sd = new StorageDescriptor();
        SkewedInfo skew = new SkewedInfo();
        sd.setSkewedInfo(skew);
        SharedStorageDescriptor ssd = new SharedStorageDescriptor();
        ssd.setShared(sd);
        ssd.unsetSkewedInfo();
        Assert.assertFalse((sd.getSkewedInfo() == ssd.getSkewedInfo() ? 1 : 0) != 0);
    }

    @Test
    public void changeOrder() {
        StorageDescriptor sd = new StorageDescriptor();
        sd.addToSortCols(new Order("fred", 1));
        SharedStorageDescriptor ssd = new SharedStorageDescriptor();
        ssd.setShared(sd);
        ((Order)ssd.getSortCols().get(0)).setOrder(2);
        Assert.assertFalse((sd.getSortCols() == ssd.getSortCols() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)((Order)ssd.getSortCols().get(0)).getOrder());
        Assert.assertEquals((long)1L, (long)((Order)sd.getSortCols().get(0)).getOrder());
    }

    @Test
    public void unsetOrder() {
        StorageDescriptor sd = new StorageDescriptor();
        sd.addToSortCols(new Order("fred", 1));
        SharedStorageDescriptor ssd = new SharedStorageDescriptor();
        ssd.setShared(sd);
        ssd.unsetSortCols();
        Assert.assertFalse((sd.getSortCols() == ssd.getSortCols() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)ssd.getSortColsSize());
        Assert.assertEquals((long)1L, (long)sd.getSortColsSize());
    }

    @Test
    public void changeBucketList() {
        StorageDescriptor sd = new StorageDescriptor();
        sd.addToBucketCols(new String("fred"));
        SharedStorageDescriptor ssd = new SharedStorageDescriptor();
        ssd.setShared(sd);
        List list = ssd.getBucketCols();
        list.add(new String("bob"));
        Assert.assertFalse((sd.getBucketCols() == ssd.getBucketCols() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)ssd.getBucketColsSize());
        Assert.assertEquals((long)1L, (long)sd.getBucketColsSize());
    }

    @Test
    public void addToColList() {
        StorageDescriptor sd = new StorageDescriptor();
        sd.addToCols(new FieldSchema("fred", "string", ""));
        SharedStorageDescriptor ssd = new SharedStorageDescriptor();
        ssd.setShared(sd);
        ssd.addToCols(new FieldSchema("joe", "int", ""));
        Assert.assertFalse((sd.getCols() == ssd.getCols() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)ssd.getColsSize());
        Assert.assertEquals((long)1L, (long)sd.getColsSize());
    }

    @Test
    public void colIterator() {
        StorageDescriptor sd = new StorageDescriptor();
        sd.addToCols(new FieldSchema("fred", "string", ""));
        SharedStorageDescriptor ssd = new SharedStorageDescriptor();
        ssd.setShared(sd);
        Iterator iter = ssd.getColsIterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"fred", (Object)((FieldSchema)iter.next()).getName());
        Assert.assertFalse((sd.getCols() == ssd.getCols() ? 1 : 0) != 0);
    }

    @Test
    public void setReadOnly() {
        StorageDescriptor sd = new StorageDescriptor();
        sd.addToCols(new FieldSchema("fred", "string", ""));
        SharedStorageDescriptor ssd = new SharedStorageDescriptor();
        ssd.setShared(sd);
        ssd.setReadOnly();
        List cols = ssd.getCols();
        Assert.assertEquals((long)1L, (long)cols.size());
        Assert.assertTrue((sd.getCols() == ssd.getCols() ? 1 : 0) != 0);
    }
}

