/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.StatObjectConverter;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.hbase.HBaseStore;
import org.apache.hadoop.hive.metastore.hbase.HBaseUtils;
import org.apache.hadoop.hive.metastore.hbase.MockUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHBaseAggregateStatsNDVUniformDist {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestHBaseAggregateStatsNDVUniformDist.class.getName());
    @Mock
    HTableInterface htable;
    private HBaseStore store;
    SortedMap<String, Cell> rows = new TreeMap<String, Cell>();
    String[] bitVectors = new String[]{"{0, 4, 5, 7}{0, 1}{0, 1, 2}{0, 1, 4}{0}{0, 2}{0, 3}{0, 2, 3, 4}{0, 1, 4}{0, 1}{0}{0, 1, 3, 8}{0, 2}{0, 2}{0, 9}{0, 1, 4}", "{1, 2}{1, 2}{1, 2}{1, 2}{1, 2}{1, 2}{1, 2}{1, 2}{1, 2}{1, 2}{1, 2}{1, 2}{1, 2}{1, 2}{1, 2}{1, 2}"};

    @Before
    public void before() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        HiveConf conf = new HiveConf();
        conf.setBoolean("no.use.cache", true);
        conf.setBoolean(HiveConf.ConfVars.HIVE_METASTORE_STATS_NDV_DENSITY_FUNCTION.varname, true);
        this.store = MockUtils.init((Configuration)conf, this.htable, this.rows);
        this.store.backdoor().getStatsCache().resetCounters();
    }

    @Test
    public void allPartitionsHaveBitVectorStatus() throws Exception {
        String dbName = "default";
        String tableName = "snp";
        long now = System.currentTimeMillis();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", "long", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, Collections.emptyMap());
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table = new Table(tableName, dbName, "me", (int)now, (int)now, 0, sd, partCols, Collections.emptyMap(), null, null, null);
        this.store.createTable(table);
        ArrayList<List<String>> partVals = new ArrayList<List<String>>();
        for (int i = 0; i < 10; ++i) {
            List<String> partVal = Arrays.asList("" + i);
            partVals.add(partVal);
            StorageDescriptor psd = new StorageDescriptor(sd);
            psd.setLocation("file:/tmp/default/hit/ds=" + partVal);
            Partition part = new Partition(partVal, dbName, tableName, (int)now, (int)now, psd, Collections.emptyMap());
            this.store.addPartition(part);
            ColumnStatistics cs = new ColumnStatistics();
            ColumnStatisticsDesc desc = new ColumnStatisticsDesc(false, dbName, tableName);
            desc.setLastAnalyzed(now);
            desc.setPartName("ds=" + partVal);
            cs.setStatsDesc(desc);
            ColumnStatisticsObj obj = new ColumnStatisticsObj();
            obj.setColName("col1");
            obj.setColType("long");
            ColumnStatisticsData data = new ColumnStatisticsData();
            LongColumnStatsData dcsd = new LongColumnStatsData();
            dcsd.setHighValue((long)(1000 + i));
            dcsd.setLowValue((long)(-1000 - i));
            dcsd.setNumNulls((long)i);
            dcsd.setNumDVs((long)(10 * i + 1));
            dcsd.setBitVectors(this.bitVectors[0]);
            data.setLongStats(dcsd);
            obj.setStatsData(data);
            cs.addToStatsObj(obj);
            this.store.updatePartitionColumnStatistics(cs, partVal);
        }
        Checker statChecker = new Checker(){

            @Override
            public void checkStats(AggrStats aggrStats) throws Exception {
                Assert.assertEquals((long)10L, (long)aggrStats.getPartsFound());
                Assert.assertEquals((long)1L, (long)aggrStats.getColStatsSize());
                ColumnStatisticsObj cso = (ColumnStatisticsObj)aggrStats.getColStats().get(0);
                Assert.assertEquals((Object)"col1", (Object)cso.getColName());
                Assert.assertEquals((Object)"long", (Object)cso.getColType());
                LongColumnStatsData lcsd = cso.getStatsData().getLongStats();
                Assert.assertEquals((double)1009.0, (double)lcsd.getHighValue(), (double)0.01);
                Assert.assertEquals((double)-1009.0, (double)lcsd.getLowValue(), (double)0.01);
                Assert.assertEquals((long)45L, (long)lcsd.getNumNulls());
                Assert.assertEquals((long)3L, (long)lcsd.getNumDVs());
            }
        };
        ArrayList<String> partNames = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            partNames.add("ds=" + i);
        }
        AggrStats aggrStats = this.store.get_aggr_stats_for(dbName, tableName, partNames, Arrays.asList("col1"));
        statChecker.checkStats(aggrStats);
    }

    @Test
    public void noPartitionsHaveBitVectorStatus() throws Exception {
        String dbName = "default";
        String tableName = "snp";
        long now = System.currentTimeMillis();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col2", "long", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, Collections.emptyMap());
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table = new Table(tableName, dbName, "me", (int)now, (int)now, 0, sd, partCols, Collections.emptyMap(), null, null, null);
        this.store.createTable(table);
        ArrayList<List<String>> partVals = new ArrayList<List<String>>();
        for (int i = 0; i < 10; ++i) {
            List<String> partVal = Arrays.asList("" + i);
            partVals.add(partVal);
            StorageDescriptor psd = new StorageDescriptor(sd);
            psd.setLocation("file:/tmp/default/hit/ds=" + partVal);
            Partition part = new Partition(partVal, dbName, tableName, (int)now, (int)now, psd, Collections.emptyMap());
            this.store.addPartition(part);
            ColumnStatistics cs = new ColumnStatistics();
            ColumnStatisticsDesc desc = new ColumnStatisticsDesc(false, dbName, tableName);
            desc.setLastAnalyzed(now);
            desc.setPartName("ds=" + partVal);
            cs.setStatsDesc(desc);
            ColumnStatisticsObj obj = new ColumnStatisticsObj();
            obj.setColName("col2");
            obj.setColType("long");
            ColumnStatisticsData data = new ColumnStatisticsData();
            LongColumnStatsData dcsd = new LongColumnStatsData();
            dcsd.setHighValue((long)(1000 + i));
            dcsd.setLowValue((long)(-1000 - i));
            dcsd.setNumNulls((long)i);
            dcsd.setNumDVs((long)(10 * i + 1));
            data.setLongStats(dcsd);
            obj.setStatsData(data);
            cs.addToStatsObj(obj);
            this.store.updatePartitionColumnStatistics(cs, partVal);
        }
        Checker statChecker = new Checker(){

            @Override
            public void checkStats(AggrStats aggrStats) throws Exception {
                Assert.assertEquals((long)10L, (long)aggrStats.getPartsFound());
                Assert.assertEquals((long)1L, (long)aggrStats.getColStatsSize());
                ColumnStatisticsObj cso = (ColumnStatisticsObj)aggrStats.getColStats().get(0);
                Assert.assertEquals((Object)"col2", (Object)cso.getColName());
                Assert.assertEquals((Object)"long", (Object)cso.getColType());
                LongColumnStatsData lcsd = cso.getStatsData().getLongStats();
                Assert.assertEquals((double)1009.0, (double)lcsd.getHighValue(), (double)0.01);
                Assert.assertEquals((double)-1009.0, (double)lcsd.getLowValue(), (double)0.01);
                Assert.assertEquals((long)45L, (long)lcsd.getNumNulls());
                Assert.assertEquals((long)91L, (long)lcsd.getNumDVs());
            }
        };
        ArrayList<String> partNames = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            partNames.add("ds=" + i);
        }
        AggrStats aggrStats = this.store.get_aggr_stats_for(dbName, tableName, partNames, Arrays.asList("col2"));
        statChecker.checkStats(aggrStats);
    }

    @Test
    public void TwoEndsOfPartitionsHaveBitVectorStatus() throws Exception {
        String dbName = "default";
        String tableName = "snp";
        long now = System.currentTimeMillis();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col3", "long", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, Collections.emptyMap());
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table = new Table(tableName, dbName, "me", (int)now, (int)now, 0, sd, partCols, Collections.emptyMap(), null, null, null);
        this.store.createTable(table);
        ArrayList<List<String>> partVals = new ArrayList<List<String>>();
        for (int i = 0; i < 10; ++i) {
            List<String> partVal = Arrays.asList("" + i);
            partVals.add(partVal);
            StorageDescriptor psd = new StorageDescriptor(sd);
            psd.setLocation("file:/tmp/default/hit/ds=" + partVal);
            Partition part = new Partition(partVal, dbName, tableName, (int)now, (int)now, psd, Collections.emptyMap());
            this.store.addPartition(part);
            if (i >= 2 && i <= 7) continue;
            ColumnStatistics cs = new ColumnStatistics();
            ColumnStatisticsDesc desc = new ColumnStatisticsDesc(false, dbName, tableName);
            desc.setLastAnalyzed(now);
            desc.setPartName("ds=" + partVal);
            cs.setStatsDesc(desc);
            ColumnStatisticsObj obj = new ColumnStatisticsObj();
            obj.setColName("col3");
            obj.setColType("long");
            ColumnStatisticsData data = new ColumnStatisticsData();
            LongColumnStatsData dcsd = new LongColumnStatsData();
            dcsd.setHighValue((long)(1000 + i));
            dcsd.setLowValue((long)(-1000 - i));
            dcsd.setNumNulls((long)i);
            dcsd.setNumDVs((long)(10 * i + 1));
            dcsd.setBitVectors(this.bitVectors[i / 5]);
            data.setLongStats(dcsd);
            obj.setStatsData(data);
            cs.addToStatsObj(obj);
            this.store.updatePartitionColumnStatistics(cs, partVal);
        }
        Checker statChecker = new Checker(){

            @Override
            public void checkStats(AggrStats aggrStats) throws Exception {
                Assert.assertEquals((long)4L, (long)aggrStats.getPartsFound());
                Assert.assertEquals((long)1L, (long)aggrStats.getColStatsSize());
                ColumnStatisticsObj cso = (ColumnStatisticsObj)aggrStats.getColStats().get(0);
                Assert.assertEquals((Object)"col3", (Object)cso.getColName());
                Assert.assertEquals((Object)"long", (Object)cso.getColType());
                LongColumnStatsData lcsd = cso.getStatsData().getLongStats();
                Assert.assertEquals((double)1010.0, (double)lcsd.getHighValue(), (double)0.01);
                Assert.assertEquals((double)-1010.0, (double)lcsd.getLowValue(), (double)0.01);
                Assert.assertEquals((long)45L, (long)lcsd.getNumNulls());
                Assert.assertEquals((long)12L, (long)lcsd.getNumDVs());
            }
        };
        ArrayList<String> partNames = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            partNames.add("ds=" + i);
        }
        AggrStats aggrStats = this.store.get_aggr_stats_for(dbName, tableName, partNames, Arrays.asList("col3"));
        statChecker.checkStats(aggrStats);
    }

    @Test
    public void MiddleOfPartitionsHaveBitVectorStatus() throws Exception {
        String dbName = "default";
        String tableName = "snp";
        long now = System.currentTimeMillis();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col4", "long", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, Collections.emptyMap());
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table = new Table(tableName, dbName, "me", (int)now, (int)now, 0, sd, partCols, Collections.emptyMap(), null, null, null);
        this.store.createTable(table);
        ArrayList<List<String>> partVals = new ArrayList<List<String>>();
        for (int i = 0; i < 10; ++i) {
            List<String> partVal = Arrays.asList("" + i);
            partVals.add(partVal);
            StorageDescriptor psd = new StorageDescriptor(sd);
            psd.setLocation("file:/tmp/default/hit/ds=" + partVal);
            Partition part = new Partition(partVal, dbName, tableName, (int)now, (int)now, psd, Collections.emptyMap());
            this.store.addPartition(part);
            if (i <= 2 || i >= 7) continue;
            ColumnStatistics cs = new ColumnStatistics();
            ColumnStatisticsDesc desc = new ColumnStatisticsDesc(false, dbName, tableName);
            desc.setLastAnalyzed(now);
            desc.setPartName("ds=" + partVal);
            cs.setStatsDesc(desc);
            ColumnStatisticsObj obj = new ColumnStatisticsObj();
            obj.setColName("col4");
            obj.setColType("long");
            ColumnStatisticsData data = new ColumnStatisticsData();
            LongColumnStatsData dcsd = new LongColumnStatsData();
            dcsd.setHighValue((long)(1000 + i));
            dcsd.setLowValue((long)(-1000 - i));
            dcsd.setNumNulls((long)i);
            dcsd.setNumDVs((long)(10 * i + 1));
            dcsd.setBitVectors(this.bitVectors[0]);
            data.setLongStats(dcsd);
            obj.setStatsData(data);
            cs.addToStatsObj(obj);
            this.store.updatePartitionColumnStatistics(cs, partVal);
        }
        Checker statChecker = new Checker(){

            @Override
            public void checkStats(AggrStats aggrStats) throws Exception {
                Assert.assertEquals((long)4L, (long)aggrStats.getPartsFound());
                Assert.assertEquals((long)1L, (long)aggrStats.getColStatsSize());
                ColumnStatisticsObj cso = (ColumnStatisticsObj)aggrStats.getColStats().get(0);
                Assert.assertEquals((Object)"col4", (Object)cso.getColName());
                Assert.assertEquals((Object)"long", (Object)cso.getColType());
                LongColumnStatsData lcsd = cso.getStatsData().getLongStats();
                Assert.assertEquals((double)1006.0, (double)lcsd.getHighValue(), (double)0.01);
                Assert.assertEquals((double)-1006.0, (double)lcsd.getLowValue(), (double)0.01);
                Assert.assertEquals((long)45L, (long)lcsd.getNumNulls());
                Assert.assertEquals((long)3L, (long)lcsd.getNumDVs());
            }
        };
        ArrayList<String> partNames = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            partNames.add("ds=" + i);
        }
        AggrStats aggrStats = this.store.get_aggr_stats_for(dbName, tableName, partNames, Arrays.asList("col4"));
        statChecker.checkStats(aggrStats);
    }

    @Test
    public void TwoEndsAndMiddleOfPartitionsHaveBitVectorStatusLong() throws Exception {
        String dbName = "default";
        String tableName = "snp";
        long now = System.currentTimeMillis();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col5_long", "long", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, Collections.emptyMap());
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table = new Table(tableName, dbName, "me", (int)now, (int)now, 0, sd, partCols, Collections.emptyMap(), null, null, null);
        this.store.createTable(table);
        ArrayList<List<String>> partVals = new ArrayList<List<String>>();
        for (int i = 0; i < 10; ++i) {
            List<String> partVal = Arrays.asList("" + i);
            partVals.add(partVal);
            StorageDescriptor psd = new StorageDescriptor(sd);
            psd.setLocation("file:/tmp/default/hit/ds=" + partVal);
            Partition part = new Partition(partVal, dbName, tableName, (int)now, (int)now, psd, Collections.emptyMap());
            this.store.addPartition(part);
            if (i != 0 && i != 2 && i != 3 && i != 5 && i != 6 && i != 8) continue;
            ColumnStatistics cs = new ColumnStatistics();
            ColumnStatisticsDesc desc = new ColumnStatisticsDesc(false, dbName, tableName);
            desc.setLastAnalyzed(now);
            desc.setPartName("ds=" + partVal);
            cs.setStatsDesc(desc);
            ColumnStatisticsObj obj = new ColumnStatisticsObj();
            obj.setColName("col5_long");
            obj.setColType("long");
            ColumnStatisticsData data = new ColumnStatisticsData();
            LongColumnStatsData dcsd = new LongColumnStatsData();
            dcsd.setHighValue((long)(1000 + i));
            dcsd.setLowValue((long)(-1000 - i));
            dcsd.setNumNulls((long)i);
            dcsd.setNumDVs((long)(10 * i + 1));
            dcsd.setBitVectors(this.bitVectors[i / 5]);
            data.setLongStats(dcsd);
            obj.setStatsData(data);
            cs.addToStatsObj(obj);
            this.store.updatePartitionColumnStatistics(cs, partVal);
        }
        Checker statChecker = new Checker(){

            @Override
            public void checkStats(AggrStats aggrStats) throws Exception {
                Assert.assertEquals((long)6L, (long)aggrStats.getPartsFound());
                Assert.assertEquals((long)1L, (long)aggrStats.getColStatsSize());
                ColumnStatisticsObj cso = (ColumnStatisticsObj)aggrStats.getColStats().get(0);
                Assert.assertEquals((Object)"col5_long", (Object)cso.getColName());
                Assert.assertEquals((Object)"long", (Object)cso.getColType());
                LongColumnStatsData lcsd = cso.getStatsData().getLongStats();
                Assert.assertEquals((double)1010.0, (double)lcsd.getHighValue(), (double)0.01);
                Assert.assertEquals((double)-1010.0, (double)lcsd.getLowValue(), (double)0.01);
                Assert.assertEquals((long)40L, (long)lcsd.getNumNulls());
                Assert.assertEquals((long)12L, (long)lcsd.getNumDVs());
            }
        };
        ArrayList<String> partNames = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            partNames.add("ds=" + i);
        }
        AggrStats aggrStats = this.store.get_aggr_stats_for(dbName, tableName, partNames, Arrays.asList("col5_long"));
        statChecker.checkStats(aggrStats);
    }

    @Test
    public void TwoEndsAndMiddleOfPartitionsHaveBitVectorStatusDecimal() throws Exception {
        String dbName = "default";
        String tableName = "snp";
        long now = System.currentTimeMillis();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col5_decimal", "decimal", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, Collections.emptyMap());
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table = new Table(tableName, dbName, "me", (int)now, (int)now, 0, sd, partCols, Collections.emptyMap(), null, null, null);
        this.store.createTable(table);
        ArrayList<List<String>> partVals = new ArrayList<List<String>>();
        for (int i = 0; i < 10; ++i) {
            List<String> partVal = Arrays.asList("" + i);
            partVals.add(partVal);
            StorageDescriptor psd = new StorageDescriptor(sd);
            psd.setLocation("file:/tmp/default/hit/ds=" + partVal);
            Partition part = new Partition(partVal, dbName, tableName, (int)now, (int)now, psd, Collections.emptyMap());
            this.store.addPartition(part);
            if (i != 0 && i != 2 && i != 3 && i != 5 && i != 6 && i != 8) continue;
            ColumnStatistics cs = new ColumnStatistics();
            ColumnStatisticsDesc desc = new ColumnStatisticsDesc(false, dbName, tableName);
            desc.setLastAnalyzed(now);
            desc.setPartName("ds=" + partVal);
            cs.setStatsDesc(desc);
            ColumnStatisticsObj obj = new ColumnStatisticsObj();
            obj.setColName("col5_decimal");
            obj.setColType("decimal");
            ColumnStatisticsData data = new ColumnStatisticsData();
            DecimalColumnStatsData dcsd = new DecimalColumnStatsData();
            dcsd.setHighValue(StatObjectConverter.createThriftDecimal((String)("" + (1000 + i))));
            dcsd.setLowValue(StatObjectConverter.createThriftDecimal((String)("" + (-1000 - i))));
            dcsd.setNumNulls((long)i);
            dcsd.setNumDVs((long)(10 * i + 1));
            dcsd.setBitVectors(this.bitVectors[i / 5]);
            data.setDecimalStats(dcsd);
            obj.setStatsData(data);
            cs.addToStatsObj(obj);
            this.store.updatePartitionColumnStatistics(cs, partVal);
        }
        Checker statChecker = new Checker(){

            @Override
            public void checkStats(AggrStats aggrStats) throws Exception {
                Assert.assertEquals((long)6L, (long)aggrStats.getPartsFound());
                Assert.assertEquals((long)1L, (long)aggrStats.getColStatsSize());
                ColumnStatisticsObj cso = (ColumnStatisticsObj)aggrStats.getColStats().get(0);
                Assert.assertEquals((Object)"col5_decimal", (Object)cso.getColName());
                Assert.assertEquals((Object)"decimal", (Object)cso.getColType());
                DecimalColumnStatsData lcsd = cso.getStatsData().getDecimalStats();
                Assert.assertEquals((double)1010.0, (double)HBaseUtils.getDoubleValue((Decimal)lcsd.getHighValue()), (double)0.01);
                Assert.assertEquals((double)-1010.0, (double)HBaseUtils.getDoubleValue((Decimal)lcsd.getLowValue()), (double)0.01);
                Assert.assertEquals((long)40L, (long)lcsd.getNumNulls());
                Assert.assertEquals((long)12L, (long)lcsd.getNumDVs());
            }
        };
        ArrayList<String> partNames = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            partNames.add("ds=" + i);
        }
        AggrStats aggrStats = this.store.get_aggr_stats_for(dbName, tableName, partNames, Arrays.asList("col5_decimal"));
        statChecker.checkStats(aggrStats);
    }

    @Test
    public void TwoEndsAndMiddleOfPartitionsHaveBitVectorStatusDouble() throws Exception {
        String dbName = "default";
        String tableName = "snp";
        long now = System.currentTimeMillis();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col5_double", "double", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, Collections.emptyMap());
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table = new Table(tableName, dbName, "me", (int)now, (int)now, 0, sd, partCols, Collections.emptyMap(), null, null, null);
        this.store.createTable(table);
        ArrayList<List<String>> partVals = new ArrayList<List<String>>();
        for (int i = 0; i < 10; ++i) {
            List<String> partVal = Arrays.asList("" + i);
            partVals.add(partVal);
            StorageDescriptor psd = new StorageDescriptor(sd);
            psd.setLocation("file:/tmp/default/hit/ds=" + partVal);
            Partition part = new Partition(partVal, dbName, tableName, (int)now, (int)now, psd, Collections.emptyMap());
            this.store.addPartition(part);
            if (i != 0 && i != 2 && i != 3 && i != 5 && i != 6 && i != 8) continue;
            ColumnStatistics cs = new ColumnStatistics();
            ColumnStatisticsDesc desc = new ColumnStatisticsDesc(false, dbName, tableName);
            desc.setLastAnalyzed(now);
            desc.setPartName("ds=" + partVal);
            cs.setStatsDesc(desc);
            ColumnStatisticsObj obj = new ColumnStatisticsObj();
            obj.setColName("col5_double");
            obj.setColType("double");
            ColumnStatisticsData data = new ColumnStatisticsData();
            DoubleColumnStatsData dcsd = new DoubleColumnStatsData();
            dcsd.setHighValue((double)(1000 + i));
            dcsd.setLowValue((double)(-1000 - i));
            dcsd.setNumNulls((long)i);
            dcsd.setNumDVs((long)(10 * i + 1));
            dcsd.setBitVectors(this.bitVectors[i / 5]);
            data.setDoubleStats(dcsd);
            obj.setStatsData(data);
            cs.addToStatsObj(obj);
            this.store.updatePartitionColumnStatistics(cs, partVal);
        }
        Checker statChecker = new Checker(){

            @Override
            public void checkStats(AggrStats aggrStats) throws Exception {
                Assert.assertEquals((long)6L, (long)aggrStats.getPartsFound());
                Assert.assertEquals((long)1L, (long)aggrStats.getColStatsSize());
                ColumnStatisticsObj cso = (ColumnStatisticsObj)aggrStats.getColStats().get(0);
                Assert.assertEquals((Object)"col5_double", (Object)cso.getColName());
                Assert.assertEquals((Object)"double", (Object)cso.getColType());
                DoubleColumnStatsData lcsd = cso.getStatsData().getDoubleStats();
                Assert.assertEquals((double)1010.0, (double)lcsd.getHighValue(), (double)0.01);
                Assert.assertEquals((double)-1010.0, (double)lcsd.getLowValue(), (double)0.01);
                Assert.assertEquals((long)40L, (long)lcsd.getNumNulls());
                Assert.assertEquals((long)12L, (long)lcsd.getNumDVs());
            }
        };
        ArrayList<String> partNames = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            partNames.add("ds=" + i);
        }
        AggrStats aggrStats = this.store.get_aggr_stats_for(dbName, tableName, partNames, Arrays.asList("col5_double"));
        statChecker.checkStats(aggrStats);
    }

    private static interface Checker {
        public void checkStats(AggrStats var1) throws Exception;
    }
}

