/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.hbase.HBaseStore;
import org.apache.hadoop.hive.metastore.hbase.MockUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHBaseAggregateStatsCache {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestHBaseAggregateStatsCache.class.getName());
    @Mock
    HTableInterface htable;
    private HBaseStore store;
    SortedMap<String, Cell> rows = new TreeMap<String, Cell>();

    @Before
    public void before() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        HiveConf conf = new HiveConf();
        conf.setBoolean("no.use.cache", true);
        this.store = MockUtils.init((Configuration)conf, this.htable, this.rows);
        this.store.backdoor().getStatsCache().resetCounters();
    }

    @Test
    public void allWithStats() throws Exception {
        String dbName = "default";
        String tableName = "hit";
        List<String> partVals1 = Arrays.asList("today");
        List<String> partVals2 = Arrays.asList("yesterday");
        long now = System.currentTimeMillis();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", "boolean", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, Collections.emptyMap());
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table = new Table(tableName, dbName, "me", (int)now, (int)now, 0, sd, partCols, Collections.emptyMap(), null, null, null);
        this.store.createTable(table);
        for (List partVals : Arrays.asList(partVals1, partVals2)) {
            StorageDescriptor psd = new StorageDescriptor(sd);
            psd.setLocation("file:/tmp/default/hit/ds=" + (String)partVals.get(0));
            Partition part = new Partition(partVals, dbName, tableName, (int)now, (int)now, psd, Collections.emptyMap());
            this.store.addPartition(part);
            ColumnStatistics cs = new ColumnStatistics();
            ColumnStatisticsDesc desc = new ColumnStatisticsDesc(false, dbName, tableName);
            desc.setLastAnalyzed(now);
            desc.setPartName("ds=" + (String)partVals.get(0));
            cs.setStatsDesc(desc);
            ColumnStatisticsObj obj = new ColumnStatisticsObj();
            obj.setColName("col1");
            obj.setColType("boolean");
            ColumnStatisticsData data = new ColumnStatisticsData();
            BooleanColumnStatsData bcsd = new BooleanColumnStatsData();
            bcsd.setNumFalses(10L);
            bcsd.setNumTrues(20L);
            bcsd.setNumNulls(30L);
            data.setBooleanStats(bcsd);
            obj.setStatsData(data);
            cs.addToStatsObj(obj);
            this.store.updatePartitionColumnStatistics(cs, partVals);
        }
        Checker statChecker = new Checker(){

            @Override
            public void checkStats(AggrStats aggrStats) throws Exception {
                Assert.assertEquals((long)2L, (long)aggrStats.getPartsFound());
                Assert.assertEquals((long)1L, (long)aggrStats.getColStatsSize());
                ColumnStatisticsObj cso = (ColumnStatisticsObj)aggrStats.getColStats().get(0);
                Assert.assertEquals((Object)"col1", (Object)cso.getColName());
                Assert.assertEquals((Object)"boolean", (Object)cso.getColType());
                BooleanColumnStatsData bcsd = cso.getStatsData().getBooleanStats();
                Assert.assertEquals((long)20L, (long)bcsd.getNumFalses());
                Assert.assertEquals((long)40L, (long)bcsd.getNumTrues());
                Assert.assertEquals((long)60L, (long)bcsd.getNumNulls());
            }
        };
        AggrStats aggrStats = this.store.get_aggr_stats_for(dbName, tableName, Arrays.asList("ds=today", "ds=yesterday"), Arrays.asList("col1"));
        statChecker.checkStats(aggrStats);
        Assert.assertEquals((long)0L, (long)this.store.backdoor().getStatsCache().hbaseHits.getCnt());
        Assert.assertEquals((long)1L, (long)this.store.backdoor().getStatsCache().totalGets.getCnt());
        Assert.assertEquals((long)1L, (long)this.store.backdoor().getStatsCache().misses.getCnt());
        aggrStats = this.store.get_aggr_stats_for(dbName, tableName, Arrays.asList("ds=yesterday", "ds=today"), Arrays.asList("col1"));
        statChecker.checkStats(aggrStats);
        Assert.assertEquals((long)0L, (long)this.store.backdoor().getStatsCache().hbaseHits.getCnt());
        Assert.assertEquals((long)2L, (long)this.store.backdoor().getStatsCache().totalGets.getCnt());
        Assert.assertEquals((long)1L, (long)this.store.backdoor().getStatsCache().misses.getCnt());
    }

    @Test
    public void noneWithStats() throws Exception {
        String dbName = "default";
        String tableName = "nws";
        List<String> partVals1 = Arrays.asList("today");
        List<String> partVals2 = Arrays.asList("yesterday");
        long now = System.currentTimeMillis();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", "boolean", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, Collections.emptyMap());
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table = new Table(tableName, dbName, "me", (int)now, (int)now, 0, sd, partCols, Collections.emptyMap(), null, null, null);
        this.store.createTable(table);
        for (List partVals : Arrays.asList(partVals1, partVals2)) {
            StorageDescriptor psd = new StorageDescriptor(sd);
            psd.setLocation("file:/tmp/default/nws/ds=" + (String)partVals.get(0));
            Partition part = new Partition(partVals, dbName, tableName, (int)now, (int)now, psd, Collections.emptyMap());
            this.store.addPartition(part);
        }
        Checker statChecker = new Checker(){

            @Override
            public void checkStats(AggrStats aggrStats) throws Exception {
                Assert.assertEquals((long)0L, (long)aggrStats.getPartsFound());
            }
        };
        AggrStats aggrStats = this.store.get_aggr_stats_for(dbName, tableName, Arrays.asList("ds=today", "ds=yesterday"), Arrays.asList("col1"));
        statChecker.checkStats(aggrStats);
    }

    @Test
    public void someNonexistentPartitions() throws Exception {
        String dbName = "default";
        String tableName = "snp";
        List<String> partVals1 = Arrays.asList("today");
        List<String> partVals2 = Arrays.asList("yesterday");
        long now = System.currentTimeMillis();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", "boolean", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, Collections.emptyMap());
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table = new Table(tableName, dbName, "me", (int)now, (int)now, 0, sd, partCols, Collections.emptyMap(), null, null, null);
        this.store.createTable(table);
        StorageDescriptor psd = new StorageDescriptor(sd);
        psd.setLocation("file:/tmp/default/hit/ds=" + partVals1.get(0));
        Partition part = new Partition(partVals1, dbName, tableName, (int)now, (int)now, psd, Collections.emptyMap());
        this.store.addPartition(part);
        ColumnStatistics cs = new ColumnStatistics();
        ColumnStatisticsDesc desc = new ColumnStatisticsDesc(false, dbName, tableName);
        desc.setLastAnalyzed(now);
        desc.setPartName("ds=" + partVals1.get(0));
        cs.setStatsDesc(desc);
        ColumnStatisticsObj obj = new ColumnStatisticsObj();
        obj.setColName("col1");
        obj.setColType("double");
        ColumnStatisticsData data = new ColumnStatisticsData();
        DoubleColumnStatsData dcsd = new DoubleColumnStatsData();
        dcsd.setHighValue(1000.2342343);
        dcsd.setLowValue(-20.1234213423);
        dcsd.setNumNulls(30L);
        dcsd.setNumDVs(12342L);
        data.setDoubleStats(dcsd);
        obj.setStatsData(data);
        cs.addToStatsObj(obj);
        this.store.updatePartitionColumnStatistics(cs, partVals1);
        Checker statChecker = new Checker(){

            @Override
            public void checkStats(AggrStats aggrStats) throws Exception {
                Assert.assertEquals((long)1L, (long)aggrStats.getPartsFound());
                Assert.assertEquals((long)1L, (long)aggrStats.getColStatsSize());
                ColumnStatisticsObj cso = (ColumnStatisticsObj)aggrStats.getColStats().get(0);
                Assert.assertEquals((Object)"col1", (Object)cso.getColName());
                Assert.assertEquals((Object)"double", (Object)cso.getColType());
                DoubleColumnStatsData dcsd = cso.getStatsData().getDoubleStats();
                Assert.assertEquals((double)1000.23, (double)dcsd.getHighValue(), (double)0.01);
                Assert.assertEquals((double)-20.12, (double)dcsd.getLowValue(), (double)0.01);
                Assert.assertEquals((long)30L, (long)dcsd.getNumNulls());
                Assert.assertEquals((long)12342L, (long)dcsd.getNumDVs());
            }
        };
        AggrStats aggrStats = this.store.get_aggr_stats_for(dbName, tableName, Arrays.asList("ds=today", "ds=yesterday"), Arrays.asList("col1"));
        statChecker.checkStats(aggrStats);
        Assert.assertEquals((long)0L, (long)this.store.backdoor().getStatsCache().hbaseHits.getCnt());
        Assert.assertEquals((long)1L, (long)this.store.backdoor().getStatsCache().totalGets.getCnt());
        Assert.assertEquals((long)1L, (long)this.store.backdoor().getStatsCache().misses.getCnt());
        aggrStats = this.store.get_aggr_stats_for(dbName, tableName, Arrays.asList("ds=yesterday", "ds=today"), Arrays.asList("col1"));
        statChecker.checkStats(aggrStats);
        Assert.assertEquals((long)0L, (long)this.store.backdoor().getStatsCache().hbaseHits.getCnt());
        Assert.assertEquals((long)2L, (long)this.store.backdoor().getStatsCache().totalGets.getCnt());
        Assert.assertEquals((long)1L, (long)this.store.backdoor().getStatsCache().misses.getCnt());
    }

    @Test
    public void nonexistentPartitions() throws Exception {
        String dbName = "default";
        String tableName = "nep";
        List<String> partVals1 = Arrays.asList("today");
        List<String> partVals2 = Arrays.asList("yesterday");
        long now = System.currentTimeMillis();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", "boolean", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, Collections.emptyMap());
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table = new Table(tableName, dbName, "me", (int)now, (int)now, 0, sd, partCols, Collections.emptyMap(), null, null, null);
        this.store.createTable(table);
        Checker statChecker = new Checker(){

            @Override
            public void checkStats(AggrStats aggrStats) throws Exception {
                Assert.assertEquals((long)0L, (long)aggrStats.getPartsFound());
            }
        };
        AggrStats aggrStats = this.store.get_aggr_stats_for(dbName, tableName, Arrays.asList("ds=today", "ds=yesterday"), Arrays.asList("col1"));
        statChecker.checkStats(aggrStats);
        Assert.assertEquals((long)0L, (long)this.store.backdoor().getStatsCache().hbaseHits.getCnt());
        Assert.assertEquals((long)1L, (long)this.store.backdoor().getStatsCache().totalGets.getCnt());
        Assert.assertEquals((long)1L, (long)this.store.backdoor().getStatsCache().misses.getCnt());
    }

    private static interface Checker {
        public void checkStats(AggrStats var1) throws Exception;
    }
}

