/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.junit.Test;

public class TestHiveMetastoreCli {
    private static final String[] CLI_ARGUMENTS = new String[]{"9999"};

    @Test
    public void testDefaultCliPortValue() {
        HiveConf configuration = new HiveConf();
        HiveMetaStore.HiveMetastoreCli cli = new HiveMetaStore.HiveMetastoreCli((Configuration)configuration);
        assert (cli.getPort() == HiveConf.getIntVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_SERVER_PORT));
    }

    @Test
    public void testOverriddenCliPortValue() {
        HiveConf configuration = new HiveConf();
        HiveMetaStore.HiveMetastoreCli cli = new HiveMetaStore.HiveMetastoreCli((Configuration)configuration);
        cli.parse(CLI_ARGUMENTS);
        assert (cli.getPort() == 9999);
    }

    @Test
    public void testOverriddenMetastoreServerPortValue() {
        HiveConf configuration = new HiveConf();
        HiveConf.setIntVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_SERVER_PORT, (int)12345);
        HiveMetaStore.HiveMetastoreCli cli = new HiveMetaStore.HiveMetastoreCli((Configuration)configuration);
        assert (cli.getPort() == 12345);
    }

    @Test
    public void testCliOverridesConfiguration() {
        HiveConf configuration = new HiveConf();
        HiveConf.setIntVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_SERVER_PORT, (int)12345);
        HiveMetaStore.HiveMetastoreCli cli = new HiveMetaStore.HiveMetastoreCli((Configuration)configuration);
        cli.parse(CLI_ARGUMENTS);
        assert (cli.getPort() == 9999);
    }
}

