/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.FileFormatProxy;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.hbase.HBaseConnection;
import org.apache.hadoop.hive.metastore.hbase.HBaseReadWrite;
import org.apache.hadoop.hive.metastore.hbase.HBaseStore;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class MockUtils {
    static HBaseStore init(Configuration conf, HTableInterface htable, final SortedMap<String, Cell> rows) throws IOException {
        ((HiveConf)conf).setVar(HiveConf.ConfVars.METASTORE_EXPRESSION_PROXY_CLASS, NOOPProxy.class.getName());
        Mockito.when((Object)htable.get((Get)Mockito.any(Get.class))).thenAnswer((Answer)new Answer<Result>(){

            public Result answer(InvocationOnMock invocation) throws Throwable {
                Get get = (Get)invocation.getArguments()[0];
                Cell cell = (Cell)rows.get(new String(get.getRow()));
                if (cell == null) {
                    return new Result();
                }
                return Result.create((Cell[])new Cell[]{cell});
            }
        });
        Mockito.when((Object)htable.get(Mockito.anyListOf(Get.class))).thenAnswer((Answer)new Answer<Result[]>(){

            public Result[] answer(InvocationOnMock invocation) throws Throwable {
                List gets = (List)invocation.getArguments()[0];
                Result[] results = new Result[gets.size()];
                for (int i = 0; i < gets.size(); ++i) {
                    Cell cell = (Cell)rows.get(new String(((Get)gets.get(i)).getRow()));
                    Result result = cell == null ? new Result() : Result.create((Cell[])new Cell[]{cell});
                    results[i] = result;
                }
                return results;
            }
        });
        Mockito.when((Object)htable.getScanner((Scan)Mockito.any(Scan.class))).thenAnswer((Answer)new Answer<ResultScanner>(){

            public ResultScanner answer(InvocationOnMock invocation) throws Throwable {
                Scan scan = (Scan)invocation.getArguments()[0];
                ArrayList<Result> results = new ArrayList<Result>();
                String start = new String(scan.getStartRow());
                String stop = new String(scan.getStopRow());
                SortedMap sub = rows.subMap(start, stop);
                for (Map.Entry e : sub.entrySet()) {
                    results.add(Result.create((Cell[])new Cell[]{(Cell)e.getValue()}));
                }
                final Iterator iter = results.iterator();
                return new ResultScanner(){

                    public Result next() throws IOException {
                        return null;
                    }

                    public Result[] next(int nbRows) throws IOException {
                        return new Result[0];
                    }

                    public void close() {
                    }

                    public Iterator<Result> iterator() {
                        return iter;
                    }
                };
            }
        });
        ((HTableInterface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Put put = (Put)invocation.getArguments()[0];
                rows.put(new String(put.getRow()), ((List)put.getFamilyCellMap().firstEntry().getValue()).get(0));
                return null;
            }
        }).when((Object)htable)).put((Put)Mockito.any(Put.class));
        Mockito.when((Object)htable.checkAndPut((byte[])Mockito.any(byte[].class), (byte[])Mockito.any(byte[].class), (byte[])Mockito.any(byte[].class), (byte[])Mockito.any(byte[].class), (Put)Mockito.any(Put.class))).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                Put put = (Put)invocation.getArguments()[4];
                rows.put(new String(put.getRow()), ((List)put.getFamilyCellMap().firstEntry().getValue()).get(0));
                return true;
            }
        });
        ((HTableInterface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Delete del = (Delete)invocation.getArguments()[0];
                rows.remove(new String(del.getRow()));
                return null;
            }
        }).when((Object)htable)).delete((Delete)Mockito.any(Delete.class));
        Mockito.when((Object)htable.checkAndDelete((byte[])Mockito.any(byte[].class), (byte[])Mockito.any(byte[].class), (byte[])Mockito.any(byte[].class), (byte[])Mockito.any(byte[].class), (Delete)Mockito.any(Delete.class))).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                Delete del = (Delete)invocation.getArguments()[4];
                rows.remove(new String(del.getRow()));
                return true;
            }
        });
        HBaseConnection hconn = (HBaseConnection)Mockito.mock(HBaseConnection.class);
        Mockito.when((Object)hconn.getHBaseTable(Mockito.anyString())).thenReturn((Object)htable);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_HBASE_CONNECTION_CLASS, (String)"test_connection");
        HBaseReadWrite.setTestConnection((HBaseConnection)hconn);
        HBaseReadWrite.setConf((Configuration)conf);
        HBaseStore store = new HBaseStore();
        store.setConf(conf);
        return store;
    }

    public static class NOOPProxy
    implements PartitionExpressionProxy {
        public String convertExprToFilter(byte[] expr) throws MetaException {
            return null;
        }

        public boolean filterPartitionsByExpr(List<String> partColumnNames, List<PrimitiveTypeInfo> partColumnTypeInfos, byte[] expr, String defaultPartitionName, List<String> partitionNames) throws MetaException {
            return false;
        }

        public SearchArgument createSarg(byte[] expr) {
            return null;
        }

        public FileMetadataExprType getMetadataType(String inputFormat) {
            return null;
        }

        public FileFormatProxy getFileFormatProxy(FileMetadataExprType type) {
            return null;
        }
    }
}

