/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import javax.jdo.JDOException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.RetryingHMSHandler;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRetriesInRetryingHMSHandler {
    private static HiveConf hiveConf;
    private static final int RETRY_ATTEMPTS = 3;

    @BeforeClass
    public static void setup() throws IOException {
        hiveConf = new HiveConf();
        int port = MetaStoreUtils.findFreePort();
        hiveConf.setVar(HiveConf.ConfVars.METASTOREURIS, "thrift://localhost:" + port);
        hiveConf.setIntVar(HiveConf.ConfVars.METASTORETHRIFTCONNECTIONRETRIES, 3);
        hiveConf.setIntVar(HiveConf.ConfVars.HMSHANDLERATTEMPTS, 3);
        hiveConf.setTimeVar(HiveConf.ConfVars.HMSHANDLERINTERVAL, 10L, TimeUnit.MILLISECONDS);
        hiveConf.setBoolVar(HiveConf.ConfVars.HMSHANDLERFORCERELOADCONF, false);
    }

    @Test
    public void testRetryInit() throws MetaException {
        IHMSHandler mockBaseHandler = (IHMSHandler)Mockito.mock(HiveMetaStore.HMSHandler.class);
        Mockito.when((Object)mockBaseHandler.getConf()).thenReturn((Object)hiveConf);
        ((IHMSHandler)Mockito.doThrow(JDOException.class).doNothing().when((Object)mockBaseHandler)).init();
        RetryingHMSHandler.getProxy((HiveConf)hiveConf, (IHMSHandler)mockBaseHandler, (boolean)false);
        ((IHMSHandler)Mockito.verify((Object)mockBaseHandler, (VerificationMode)Mockito.times((int)2))).init();
    }

    @Test
    public void testNoRetryInit() throws MetaException {
        IHMSHandler mockBaseHandler = (IHMSHandler)Mockito.mock(HiveMetaStore.HMSHandler.class);
        Mockito.when((Object)mockBaseHandler.getConf()).thenReturn((Object)hiveConf);
        ((IHMSHandler)Mockito.doNothing().when((Object)mockBaseHandler)).init();
        RetryingHMSHandler.getProxy((HiveConf)hiveConf, (IHMSHandler)mockBaseHandler, (boolean)false);
        ((IHMSHandler)Mockito.verify((Object)mockBaseHandler, (VerificationMode)Mockito.times((int)1))).init();
    }

    @Test(expected=MetaException.class)
    public void testRetriesLimit() throws MetaException {
        IHMSHandler mockBaseHandler = (IHMSHandler)Mockito.mock(HiveMetaStore.HMSHandler.class);
        Mockito.when((Object)mockBaseHandler.getConf()).thenReturn((Object)hiveConf);
        ((IHMSHandler)Mockito.doThrow(JDOException.class).when((Object)mockBaseHandler)).init();
        RetryingHMSHandler.getProxy((HiveConf)hiveConf, (IHMSHandler)mockBaseHandler, (boolean)false);
        ((IHMSHandler)Mockito.verify((Object)mockBaseHandler, (VerificationMode)Mockito.times((int)3))).init();
    }

    @Test
    public void testWrappedMetaExceptionRetry() throws MetaException {
        IHMSHandler mockBaseHandler = (IHMSHandler)Mockito.mock(HiveMetaStore.HMSHandler.class);
        Mockito.when((Object)mockBaseHandler.getConf()).thenReturn((Object)hiveConf);
        MetaException me = new MetaException("Dummy exception");
        me.initCause((Throwable)new JDOException());
        InvocationTargetException ex = new InvocationTargetException(me);
        ((IHMSHandler)Mockito.doThrow((Throwable)me).doNothing().when((Object)mockBaseHandler)).init();
        RetryingHMSHandler.getProxy((HiveConf)hiveConf, (IHMSHandler)mockBaseHandler, (boolean)false);
        ((IHMSHandler)Mockito.verify((Object)mockBaseHandler, (VerificationMode)Mockito.times((int)2))).init();
    }
}

