/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json;

import com.google.common.io.Resources;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hive.maprdb.json.BaseExplainTest;
import org.apache.hadoop.hive.maprdb.json.BaseSingleDeleteTest;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleDeleteNegativeTest
extends BaseSingleDeleteTest {
    private static final Logger LOG = LoggerFactory.getLogger((String)SingleDeleteNegativeTest.class.getName());
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Override
    @Before
    public void setup() throws HiveException {
        super.setup();
    }

    @Test
    public void testDeleteFromNonMapRDbJson() throws Exception {
        try {
            this.thrown.expect(SemanticException.class);
            this.thrown.expectMessage(CoreMatchers.containsString((String)"Operation is not supported. Table is nor ACID neither MapRDbJSON"));
            this.query = IOUtils.toString((URL)Resources.getResource((String)"single-delete-negative/delete-from-non-mapr-db-json-table.sql"));
            BaseExplainTest.ReturnInfo rc = this.parseAndAnalyze(this.query);
            String result = this.explain((SemanticAnalyzer)rc.sem, rc.plan);
            LOG.info(result);
            Assert.assertFalse((boolean)result.contains("Deletion from MapR DB Json Table"));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testWithNonKeyColumn() throws Exception {
        try {
            this.thrown.expect(SemanticException.class);
            this.thrown.expectMessage(CoreMatchers.containsString((String)"Deletion over column name is forbidden. Use only key column of MapR Db Json table: id"));
            this.query = IOUtils.toString((URL)Resources.getResource((String)"single-delete-negative/delete-with-non-key-column.sql"));
            BaseExplainTest.ReturnInfo rc = this.parseAndAnalyze(this.query);
            String result = this.explain((SemanticAnalyzer)rc.sem, rc.plan);
            LOG.info(result);
            Assert.assertFalse((boolean)result.contains("Deletion from MapR DB Json Table"));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testWithNonSupportedCondition() throws Exception {
        try {
            this.thrown.expect(SemanticException.class);
            this.thrown.expectMessage(CoreMatchers.containsString((String)"This condition is not supported for MapR Db Json deletions."));
            this.query = IOUtils.toString((URL)Resources.getResource((String)"single-delete-negative/delete-with-unsupported-condition.sql"));
            BaseExplainTest.ReturnInfo rc = this.parseAndAnalyze(this.query);
            String result = this.explain((SemanticAnalyzer)rc.sem, rc.plan);
            LOG.info(result);
            Assert.assertFalse((boolean)result.contains("Deletion from MapR DB Json Table"));
        }
        finally {
            this.cleanupTables();
        }
    }
}

