/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json;

import com.mapr.db.Admin;
import com.mapr.db.MapRDB;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.maprdb.json.input.HiveMapRDBJsonInputFormat;
import org.apache.hadoop.hive.maprdb.json.output.HiveMapRDBJsonOutputFormat;
import org.apache.hadoop.hive.maprdb.json.serde.MapRDBSerDe;
import org.apache.hadoop.hive.maprdb.json.util.MapRDbFileUtil;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRDBJsonStorageHandler
extends DefaultStorageHandler
implements HiveMetaHook {
    private static final Logger LOG = LoggerFactory.getLogger(MapRDBJsonStorageHandler.class);
    private Admin admin;

    private Admin getMapRDBAdmin() {
        if (this.admin == null) {
            this.admin = MapRDB.newAdmin((Configuration)this.getConf());
        }
        return this.admin;
    }

    private String getMapRDBTableName(Table tbl) {
        return (String)tbl.getParameters().get("maprdb.table.name");
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return HiveMapRDBJsonInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return HiveMapRDBJsonOutputFormat.class;
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return MapRDBSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return this;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties tableProperties = tableDesc.getProperties();
        Configuration conf = this.getConf();
        conf.set("maprdb.mapreduce.inputtable", tableProperties.getProperty("maprdb.table.name"));
        conf.set("maprdb.column.id", tableProperties.getProperty("maprdb.column.id"));
        jobProperties.put("maprdb.mapreduce.inputtable", tableProperties.getProperty("maprdb.table.name"));
        jobProperties.put("maprdb.column.id", tableProperties.getProperty("maprdb.column.id"));
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties tableProperties = tableDesc.getProperties();
        String property = tableProperties.getProperty("maprdb.mapred.outputtable");
        if (property != null) {
            this.getConf().set("maprdb.mapred.outputtable", property);
        } else {
            this.getConf().set("maprdb.mapred.outputtable", tableProperties.getProperty("maprdb.table.name"));
        }
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        try {
            MapRDbFileUtil.addDependencyJars((Configuration)jobConf, (Class[])new Class[]{HiveMapRDBJsonInputFormat.class});
            MapRDbFileUtil.addDependencyJars((Configuration)jobConf, (Class[])new Class[]{HiveMapRDBJsonOutputFormat.class});
        }
        catch (IOException e) {
            LOG.warn("Can't set properties for job", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void preCreateTable(Table tbl) throws MetaException {
        MapRDBJsonStorageHandler.checkPreConditions(tbl);
        if (MapRDBJsonStorageHandler.isInTestMode(tbl)) {
            return;
        }
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)tbl);
        try {
            String tableName = this.getMapRDBTableName(tbl);
            if (!this.getMapRDBAdmin().tableExists(tableName)) {
                if (isExternal) throw new MetaException(String.format("MapRDB table %s doesn't exist while the table is declared as an external table.", tableName));
                this.getMapRDBAdmin().createTable(tableName);
                return;
            } else {
                if (isExternal) return;
                throw new MetaException(String.format("Table %s already exists; use CREATE EXTERNAL TABLE instead to register it in Hive.", tableName));
            }
        }
        catch (Exception se) {
            throw new MetaException(StringUtils.stringifyException((Throwable)se));
        }
        finally {
            if (this.admin != null) {
                this.admin.close();
            }
        }
    }

    private static boolean isInTestMode(Table tbl) {
        Map tblParams = tbl.getParameters();
        if (!tblParams.containsKey("maprdb.is.in.test.mode")) {
            return false;
        }
        return "true".equalsIgnoreCase((String)tblParams.get("maprdb.is.in.test.mode"));
    }

    private static void checkPreConditions(Table tbl) throws MetaException {
        Map tblParams = tbl.getParameters();
        if (!tblParams.containsKey("maprdb.table.name")) {
            throw new MetaException(String.format("You must specify '%s' in TBLPROPERTIES", "maprdb.table.name"));
        }
        if (!((String)tblParams.get("maprdb.table.name")).startsWith("/")) {
            throw new MetaException(String.format("MapRDB should start with \"/\", actual table name '%s'", "maprdb.table.name"));
        }
        if (!tblParams.containsKey("maprdb.column.id") || ((String)tblParams.get("maprdb.column.id")).isEmpty()) {
            throw new MetaException(String.format("You must specify '%s' in TBLPROPERTIES", "maprdb.column.id"));
        }
        String bindedId = ((String)tblParams.get("maprdb.column.id")).trim();
        boolean match = false;
        for (FieldSchema field : tbl.getSd().getCols()) {
            if (!field.getName().equalsIgnoreCase(bindedId)) continue;
            String type = field.getType();
            if (!type.equalsIgnoreCase("binary") && !type.equalsIgnoreCase("string")) {
                throw new MetaException(String.format("'%s' must be STRING or BINARY type, actual: '%s'", "maprdb.column.id", field.getType().toUpperCase()));
            }
            match = true;
            break;
        }
        if (!match) {
            throw new MetaException(String.format("'%s' should matches column name.", "maprdb.column.id"));
        }
    }

    public void rollbackCreateTable(Table table) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)table);
        String tableName = this.getMapRDBTableName(table);
        if (!isExternal && this.getMapRDBAdmin().tableExists(tableName)) {
            this.getMapRDBAdmin().deleteTable(tableName);
        }
    }

    public void commitCreateTable(Table table) {
    }

    public void preDropTable(Table table) {
    }

    public void rollbackDropTable(Table table) {
    }

    public void commitDropTable(Table table, boolean deleteData) {
        if (MapRDBJsonStorageHandler.isInTestMode(table)) {
            return;
        }
        String tableName = this.getMapRDBTableName(table);
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)table);
        boolean exists = this.getMapRDBAdmin().tableExists(tableName);
        if (deleteData && !isExternal && exists) {
            this.getMapRDBAdmin().deleteTable(tableName);
        }
    }
}

