/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.session.SessionState;

abstract class BaseExplainTest {
    private QueryState queryState;
    private HiveConf conf;
    Hive db;
    String query;

    BaseExplainTest() {
    }

    void setup() throws HiveException {
        this.conf = new HiveConf();
        this.conf.set("fs.default.name", "file:///");
        this.queryState = new QueryState(this.conf);
        this.conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, SQLStdHiveAuthorizerFactory.class.getName());
        SessionState.start((HiveConf)this.conf);
        this.db = Hive.get((HiveConf)this.conf);
        this.createTables();
    }

    abstract void createTables() throws HiveException;

    String explain(SemanticAnalyzer sem, QueryPlan plan) throws IOException {
        int bytesRead;
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        File f = File.createTempFile("result", "explain");
        Path tmp = new Path(f.getPath());
        fs.create(tmp);
        fs.deleteOnExit(tmp);
        ExplainConfiguration config = new ExplainConfiguration();
        config.setExtended(true);
        ExplainWork work = new ExplainWork(tmp, sem.getParseContext(), sem.getRootTasks(), (Task)sem.getFetchTask(), null, (BaseSemanticAnalyzer)sem, config, null);
        ExplainTask task = new ExplainTask();
        task.setWork((Serializable)work);
        task.initialize(this.queryState, plan, null, null);
        task.execute(null);
        FSDataInputStream in = fs.open(tmp);
        StringBuilder builder = new StringBuilder();
        int bufSz = 4096;
        byte[] buf = new byte[4096];
        long pos = 0L;
        while ((bytesRead = in.read(pos, buf, 0, 4096)) > 0) {
            pos += (long)bytesRead;
            builder.append(new String(buf, 0, bytesRead));
        }
        in.close();
        return builder.toString().replaceAll("pfile:/.*\n", "pfile:MASKED-OUT\n").replaceAll("location file:/.*\n", "location file:MASKED-OUT\n").replaceAll("file:/.*\n", "file:MASKED-OUT\n").replaceAll("transient_lastDdlTime.*\n", "transient_lastDdlTime MASKED-OUT\n");
    }

    ReturnInfo parseAndAnalyze(String query) throws IOException, ParseException, HiveException {
        Context ctx = new Context((Configuration)this.conf);
        ctx.setCmd(query);
        ctx.setHDFSCleanup(true);
        SessionState.get().initTxnMgr(this.conf);
        ASTNode tree = ParseUtils.parse((String)query, (Context)ctx, (HiveConf)this.conf);
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get((QueryState)this.queryState, (ASTNode)tree);
        sem.analyze(tree, ctx);
        sem.validate();
        QueryPlan plan = new QueryPlan(query, sem, Long.valueOf(0L), null, null, null);
        return new ReturnInfo(sem, plan);
    }

    static String readFile(String path) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, StandardCharsets.UTF_8);
    }

    class ReturnInfo {
        BaseSemanticAnalyzer sem;
        QueryPlan plan;

        ReturnInfo(BaseSemanticAnalyzer s, QueryPlan p) {
            this.sem = s;
            this.plan = p;
        }
    }
}

