/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json.shims;

import java.io.IOException;
import org.apache.hadoop.hive.maprdb.json.shims.DocumentWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.RecordReader;
import org.ojai.Document;
import org.ojai.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordReaderWrapper
implements RecordReader<NullWritable, DocumentWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(RecordReaderWrapper.class);
    private final org.apache.hadoop.mapreduce.RecordReader<Value, Document> recordReader;

    public RecordReaderWrapper(org.apache.hadoop.mapreduce.RecordReader<Value, Document> recordReader) {
        this.recordReader = recordReader;
    }

    public boolean next(NullWritable key, DocumentWritable value) throws IOException {
        try {
            boolean next = this.recordReader.nextKeyValue();
            if (next) {
                value.setDocument((Document)this.recordReader.getCurrentValue());
            }
            return next;
        }
        catch (InterruptedException e) {
            throw new IOException("Error reading the next key/value pair from the input", e);
        }
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public DocumentWritable createValue() {
        return new DocumentWritable();
    }

    public long getPos() throws IOException {
        return 0L;
    }

    public void close() throws IOException {
        LOG.info("Closing Record Reader");
        this.recordReader.close();
    }

    public float getProgress() throws IOException {
        try {
            return this.recordReader.getProgress();
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to get current progress of the record reader", e);
        }
    }
}

