/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cli.LlapSliderUtils;
import org.apache.hadoop.hive.llap.cli.LlapStatusOptionsProcessor;
import org.apache.hadoop.hive.llap.cli.status.LlapStatusHelpers;
import org.apache.hadoop.hive.llap.configuration.LlapDaemonConfiguration;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapStatusServiceDriver {
    private static final EnumSet<LlapStatusHelpers.State> NO_YARN_SERVICE_INFO_STATES = EnumSet.of(LlapStatusHelpers.State.APP_NOT_FOUND, LlapStatusHelpers.State.COMPLETE, LlapStatusHelpers.State.LAUNCHING);
    private static final EnumSet<LlapStatusHelpers.State> LAUNCHING_STATES = EnumSet.of(LlapStatusHelpers.State.LAUNCHING, LlapStatusHelpers.State.RUNNING_PARTIAL, LlapStatusHelpers.State.RUNNING_ALL);
    private static final Logger LOG = LoggerFactory.getLogger(LlapStatusServiceDriver.class);
    private static final Logger CONSOLE_LOGGER = LoggerFactory.getLogger((String)"LlapStatusServiceDriverConsole");
    private static final String CONF_PREFIX = "hive.llapcli.";
    @InterfaceAudience.Private
    private static final String CONFIG_YARN_RM_TIMEOUT_MAX_WAIT_MS = "hive.llapcli.yarn.rm.connect.max-wait-ms";
    private static final long CONFIG_YARN_RM_TIMEOUT_MAX_WAIT_MS_DEFAULT = 10000L;
    @InterfaceAudience.Private
    private static final String CONFIG_YARN_RM_RETRY_INTERVAL_MS = "hive.llapcli.yarn.rm.connect.retry-interval.ms";
    private static final long CONFIG_YARN_RM_RETRY_INTERVAL_MS_DEFAULT = 5000L;
    @InterfaceAudience.Private
    private static final String CONFIG_IPC_CLIENT_CONNECT_MAX_RETRIES = "hive.llapcli.ipc.client.max-retries";
    private static final int CONFIG_IPC_CLIENT_CONNECT_MAX_RETRIES_DEFAULT = 2;
    @InterfaceAudience.Private
    private static final String CONFIG_IPC_CLIENT_CONNECT_RETRY_INTERVAL_MS = "hive.llapcli.ipc.client.connect.retry-interval-ms";
    private static final long CONFIG_IPC_CLIENT_CONNECT_RETRY_INTERVAL_MS_DEFAULT = 1500L;
    @InterfaceAudience.Private
    private static final String CONFIG_TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_RETRY_POLICY_SPEC = "hive.llapcli.timeline.service.fs-store.retry.policy.spec";
    private static final String CONFIG_TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_RETRY_POLICY_SPEC_DEFAULT = "2000, 1";
    private static final String CONFIG_LLAP_ZK_REGISTRY_TIMEOUT_MS = "hive.llapcli.zk-registry.timeout-ms";
    private static final long CONFIG_LLAP_ZK_REGISTRY_TIMEOUT_MS_DEFAULT = 20000L;
    private static final long LOG_SUMMARY_INTERVAL = 15000L;
    private static final String LLAP_KEY = "llap";
    private final Configuration conf;
    private final Clock clock = new SystemClock();
    private String appName = null;
    private ServiceClient serviceClient = null;
    private Configuration llapRegistryConf = null;
    private LlapRegistryService llapRegistry = null;
    @VisibleForTesting
    LlapStatusHelpers.AppStatusBuilder appStatusBuilder;

    public LlapStatusServiceDriver() {
        SessionState ss = SessionState.get();
        this.conf = ss != null ? ss.getConf() : new HiveConf(SessionState.class);
        this.setupConf();
    }

    private void setupConf() {
        for (String f : LlapDaemonConfiguration.DAEMON_CONFIGS) {
            this.conf.addResource(f);
        }
        this.conf.reloadConfiguration();
        this.conf.set("yarn.timeline-service.entity-group-fs-store.retry-policy-spec", this.conf.get(CONFIG_TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_RETRY_POLICY_SPEC, CONFIG_TIMELINE_SERVICE_ENTITYGROUP_FS_STORE_RETRY_POLICY_SPEC_DEFAULT));
        this.conf.setLong("yarn.resourcemanager.connect.max-wait.ms", this.conf.getLong(CONFIG_YARN_RM_TIMEOUT_MAX_WAIT_MS, 10000L));
        this.conf.setLong("yarn.resourcemanager.connect.retry-interval.ms", this.conf.getLong(CONFIG_YARN_RM_RETRY_INTERVAL_MS, 5000L));
        this.conf.setInt("ipc.client.connect.max.retries", this.conf.getInt(CONFIG_IPC_CLIENT_CONNECT_MAX_RETRIES, 2));
        this.conf.setLong("ipc.client.connect.retry.interval", this.conf.getLong(CONFIG_IPC_CLIENT_CONNECT_RETRY_INTERVAL_MS, 1500L));
        HiveConf.setVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ZOOKEEPER_SESSION_TIMEOUT, (String)(this.conf.getLong(CONFIG_LLAP_ZK_REGISTRY_TIMEOUT_MS, 20000L) + "ms"));
        this.llapRegistryConf = new Configuration(this.conf);
    }

    public LlapStatusOptionsProcessor.LlapStatusOptions parseOptions(String[] args) throws LlapStatusCliException {
        LlapStatusOptionsProcessor optionsProcessor = new LlapStatusOptionsProcessor();
        try {
            LlapStatusOptionsProcessor.LlapStatusOptions options = optionsProcessor.processOptions(args);
            return options;
        }
        catch (Exception e) {
            LOG.info("Failed to parse arguments", (Throwable)e);
            throw new LlapStatusCliException(ExitCode.INCORRECT_USAGE, "Incorrect usage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(LlapStatusOptionsProcessor.LlapStatusOptions options, long watchTimeoutMs) {
        this.appStatusBuilder = new LlapStatusHelpers.AppStatusBuilder();
        try {
            ExitCode ret;
            ApplicationReport appReport;
            if (this.appName == null) {
                for (Map.Entry<Object, Object> props : options.getConf().entrySet()) {
                    this.conf.set((String)props.getKey(), (String)props.getValue());
                }
                this.appName = options.getName();
                if (StringUtils.isEmpty((CharSequence)this.appName)) {
                    this.appName = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
                    this.appName = this.appName.startsWith("@") && this.appName.length() > 1 ? this.appName.substring(1) : null;
                }
                if (StringUtils.isEmpty((CharSequence)this.appName)) {
                    String message = "Invalid app name. This must be setup via config or passed in as a parameter. This tool works with clusters deployed by YARN Service";
                    LOG.info(message);
                    int props = ExitCode.INCORRECT_USAGE.getInt();
                    return props;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using appName: {}", (Object)this.appName);
                }
                this.llapRegistryConf.set(HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS.varname, "@" + this.appName);
            }
            try {
                if (this.serviceClient == null) {
                    this.serviceClient = LlapSliderUtils.createServiceClient(this.conf);
                }
            }
            catch (Exception e) {
                LlapStatusCliException le = new LlapStatusCliException(ExitCode.SERVICE_CLIENT_ERROR_CREATE_FAILED, "Failed to create service client", e);
                LlapStatusServiceDriver.logError(le);
                int n = le.getExitCode().getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
                }
                return n;
            }
            try {
                appReport = LlapSliderUtils.getAppReport(this.appName, this.serviceClient, options.getFindAppTimeoutMs());
            }
            catch (LlapStatusCliException e) {
                LlapStatusServiceDriver.logError(e);
                int n = e.getExitCode().getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
                }
                return n;
            }
            try {
                ret = this.processAppReport(appReport, this.appStatusBuilder);
            }
            catch (LlapStatusCliException e) {
                LlapStatusServiceDriver.logError(e);
                int n = e.getExitCode().getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
                }
                return n;
            }
            if (ret != ExitCode.SUCCESS) {
                int e = ret.getInt();
                return e;
            }
            if (NO_YARN_SERVICE_INFO_STATES.contains((Object)this.appStatusBuilder.getState())) {
                int e = ExitCode.SUCCESS.getInt();
                return e;
            }
            try {
                ret = this.populateAppStatusFromServiceStatus(this.appName, this.serviceClient, this.appStatusBuilder);
            }
            catch (LlapStatusCliException e) {
                LlapStatusServiceDriver.logError(e);
                int n = e.getExitCode().getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
                }
                return n;
            }
            if (ret != ExitCode.SUCCESS) {
                int e = ret.getInt();
                return e;
            }
            try {
                ret = this.populateAppStatusFromLlapRegistry(this.appStatusBuilder, watchTimeoutMs);
            }
            catch (LlapStatusCliException e) {
                LlapStatusServiceDriver.logError(e);
                int n = e.getExitCode().getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
                }
                return n;
            }
            int n = ret.getInt();
            return n;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Final AppState: " + this.appStatusBuilder.toString());
            }
        }
    }

    public void outputJson(PrintWriter writer) throws LlapStatusCliException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        try {
            writer.println(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.appStatusBuilder));
        }
        catch (IOException e) {
            LOG.warn("Failed to create JSON", (Throwable)e);
            throw new LlapStatusCliException(ExitCode.LLAP_JSON_GENERATION_ERROR, "Failed to create JSON", e);
        }
    }

    private ExitCode processAppReport(ApplicationReport appReport, LlapStatusHelpers.AppStatusBuilder appStatusBuilder) throws LlapStatusCliException {
        if (appReport == null) {
            appStatusBuilder.setState(LlapStatusHelpers.State.APP_NOT_FOUND);
            LOG.info("No Application Found");
            return ExitCode.SUCCESS;
        }
        appStatusBuilder.setAmInfo(new LlapStatusHelpers.AmInfo().setAppName(appReport.getName()).setAppType(appReport.getApplicationType()));
        appStatusBuilder.setAppStartTime(appReport.getStartTime());
        switch (appReport.getYarnApplicationState()) {
            case NEW: 
            case NEW_SAVING: 
            case SUBMITTED: {
                appStatusBuilder.setState(LlapStatusHelpers.State.LAUNCHING);
                return ExitCode.SUCCESS;
            }
            case ACCEPTED: {
                appStatusBuilder.maybeCreateAndGetAmInfo().setAppId(appReport.getApplicationId().toString());
                appStatusBuilder.setState(LlapStatusHelpers.State.LAUNCHING);
                return ExitCode.SUCCESS;
            }
            case RUNNING: {
                appStatusBuilder.maybeCreateAndGetAmInfo().setAppId(appReport.getApplicationId().toString());
                return ExitCode.SUCCESS;
            }
            case FINISHED: 
            case FAILED: 
            case KILLED: {
                appStatusBuilder.maybeCreateAndGetAmInfo().setAppId(appReport.getApplicationId().toString());
                appStatusBuilder.setAppFinishTime(appReport.getFinishTime());
                appStatusBuilder.setState(LlapStatusHelpers.State.COMPLETE);
                return ExitCode.SUCCESS;
            }
        }
        throw new LlapStatusCliException(ExitCode.INTERNAL_ERROR, "Unknown Yarn Application State: " + appReport.getYarnApplicationState());
    }

    private ExitCode populateAppStatusFromServiceStatus(String appName, ServiceClient serviceClient, LlapStatusHelpers.AppStatusBuilder appStatusBuilder) throws LlapStatusCliException {
        ExitCode exitCode = ExitCode.YARN_ERROR;
        try {
            Service service = serviceClient.getStatus(appName);
            if (service != null) {
                ServiceState state = service.getState();
                appStatusBuilder.setAppStartTime(service.getLaunchTime() == null ? 0L : service.getLaunchTime().getTime());
                appStatusBuilder.setDesiredInstances(service.getComponent(LLAP_KEY).getNumberOfContainers() == null ? 0 : service.getComponent(LLAP_KEY).getNumberOfContainers().intValue());
                appStatusBuilder.setLiveInstances(service.getComponent(LLAP_KEY).getContainers().size());
                for (Container cont : service.getComponent(LLAP_KEY).getContainers()) {
                    LlapStatusHelpers.LlapInstance llapInstance = new LlapStatusHelpers.LlapInstance(cont.getHostname(), cont.getId());
                    appStatusBuilder.addNewRunningLlapInstance(llapInstance);
                }
                if (state == ServiceState.STABLE) {
                    exitCode = ExitCode.SUCCESS;
                }
            } else {
                exitCode = ExitCode.SERVICE_CLIENT_ERROR_OTHER;
            }
        }
        catch (IOException | YarnException e) {
            LlapStatusCliException le = new LlapStatusCliException(ExitCode.SERVICE_CLIENT_ERROR_OTHER, "Failed to get service status", e);
            LlapStatusServiceDriver.logError(le);
            exitCode = le.getExitCode();
        }
        return exitCode;
    }

    private ExitCode populateAppStatusFromLlapRegistry(LlapStatusHelpers.AppStatusBuilder appStatusBuilder, long watchTimeoutMs) throws LlapStatusCliException {
        Collection serviceInstances;
        if (this.llapRegistry == null) {
            try {
                this.llapRegistry = LlapRegistryService.getClient((Configuration)this.llapRegistryConf);
            }
            catch (Exception e) {
                throw new LlapStatusCliException(ExitCode.LLAP_REGISTRY_ERROR, "Failed to create llap registry client", e);
            }
        }
        try {
            serviceInstances = this.llapRegistry.getInstances(watchTimeoutMs).getAll();
        }
        catch (Exception e) {
            throw new LlapStatusCliException(ExitCode.LLAP_REGISTRY_ERROR, "Failed to get instances from llap registry", e);
        }
        if (serviceInstances == null || serviceInstances.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No information found in the LLAP registry");
            }
            appStatusBuilder.setLiveInstances(0);
            appStatusBuilder.setState(LlapStatusHelpers.State.LAUNCHING);
            appStatusBuilder.clearRunningLlapInstances();
            return ExitCode.SUCCESS;
        }
        LinkedList<LlapStatusHelpers.LlapInstance> validatedInstances = new LinkedList<LlapStatusHelpers.LlapInstance>();
        LinkedList<String> llapExtraInstances = new LinkedList<String>();
        for (LlapServiceInstance serviceInstance : serviceInstances) {
            String containerIdString = (String)serviceInstance.getProperties().get(HiveConf.ConfVars.LLAP_DAEMON_CONTAINER_ID.varname);
            LlapStatusHelpers.LlapInstance llapInstance = appStatusBuilder.removeAndGetRunningLlapInstanceForContainer(containerIdString);
            if (llapInstance != null) {
                llapInstance.setMgmtPort(serviceInstance.getManagementPort());
                llapInstance.setRpcPort(serviceInstance.getRpcPort());
                llapInstance.setShufflePort(serviceInstance.getShufflePort());
                llapInstance.setWebUrl(serviceInstance.getServicesAddress());
                llapInstance.setStatusUrl(serviceInstance.getServicesAddress() + "/status");
                validatedInstances.add(llapInstance);
                continue;
            }
            llapExtraInstances.add(containerIdString);
        }
        appStatusBuilder.setLiveInstances(validatedInstances.size());
        appStatusBuilder.setLaunchingInstances(llapExtraInstances.size());
        if (appStatusBuilder.getDesiredInstances() != null && validatedInstances.size() >= appStatusBuilder.getDesiredInstances()) {
            appStatusBuilder.setState(LlapStatusHelpers.State.RUNNING_ALL);
            if (validatedInstances.size() > appStatusBuilder.getDesiredInstances()) {
                LOG.warn("Found more entries in LLAP registry, as compared to desired entries");
            }
        } else if (validatedInstances.size() > 0) {
            appStatusBuilder.setState(LlapStatusHelpers.State.RUNNING_PARTIAL);
        } else {
            appStatusBuilder.setState(LlapStatusHelpers.State.LAUNCHING);
        }
        if (appStatusBuilder.allRunningInstances().size() > 0) {
            LOG.debug("Potential instances starting up: {}", appStatusBuilder.allRunningInstances());
        }
        if (llapExtraInstances.size() > 0) {
            LOG.debug("Instances likely to shutdown soon: {}", llapExtraInstances);
        }
        appStatusBuilder.clearAndAddPreviouslyKnownRunningInstances(validatedInstances);
        return ExitCode.SUCCESS;
    }

    private static String constructCompletedContainerDiagnostics(List<LlapStatusHelpers.LlapInstance> completedInstances) {
        StringBuilder sb = new StringBuilder();
        if (completedInstances == null || completedInstances.size() == 0) {
            return "";
        }
        boolean isFirst = true;
        for (LlapStatusHelpers.LlapInstance instance : completedInstances) {
            if (!isFirst) {
                sb.append("\n");
            } else {
                isFirst = false;
            }
            if (instance.getYarnContainerExitStatus() == -104 || instance.getYarnContainerExitStatus() == -103) {
                sb.append("\tKILLED container (by YARN for exceeding memory limits): ");
            } else {
                sb.append("\tFAILED container: ");
            }
            sb.append(" ").append(instance.getContainerId());
            sb.append(", Logs at: ").append(instance.getLogUrl());
        }
        return sb.toString();
    }

    private static String constructDiagnostics(LlapStatusHelpers.AppStatusBuilder appStatusBuilder) {
        StringBuilder sb = new StringBuilder();
        switch (appStatusBuilder.getState()) {
            case APP_NOT_FOUND: {
                sb.append("LLAP status unknown. Awaiting app launch");
                break;
            }
            case LAUNCHING: {
                if (StringUtils.isNotBlank((CharSequence)appStatusBuilder.getAmInfo().getAppId())) {
                    String containerDiagnostics;
                    sb.append("LLAP Starting up with AppId=").append(appStatusBuilder.getAmInfo().getAppId()).append(".");
                    if (appStatusBuilder.getDesiredInstances() != null) {
                        sb.append(" Started 0/").append(appStatusBuilder.getDesiredInstances()).append(" instances");
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)(containerDiagnostics = LlapStatusServiceDriver.constructCompletedContainerDiagnostics(appStatusBuilder.getCompletedInstances())))) break;
                    sb.append("\n").append(containerDiagnostics);
                    break;
                }
                sb.append("Awaiting LLAP startup");
                break;
            }
            case RUNNING_PARTIAL: {
                sb.append("LLAP Starting up with ApplicationId=").append(appStatusBuilder.getAmInfo().getAppId());
                sb.append(" Started").append(appStatusBuilder.getLiveInstances()).append("/").append(appStatusBuilder.getDesiredInstances()).append(" instances");
                String containerDiagnostics = LlapStatusServiceDriver.constructCompletedContainerDiagnostics(appStatusBuilder.getCompletedInstances());
                if (!StringUtils.isNotEmpty((CharSequence)containerDiagnostics)) break;
                sb.append("\n").append(containerDiagnostics);
                break;
            }
            case RUNNING_ALL: {
                sb.append("LLAP Application running with ApplicationId=").append(appStatusBuilder.getAmInfo().getAppId());
                break;
            }
            case COMPLETE: {
                sb.append("LLAP Application already complete. ApplicationId=").append(appStatusBuilder.getAmInfo().getAppId());
                String containerDiagnostics = LlapStatusServiceDriver.constructCompletedContainerDiagnostics(appStatusBuilder.getCompletedInstances());
                if (!StringUtils.isNotEmpty((CharSequence)containerDiagnostics)) break;
                sb.append("\n").append(containerDiagnostics);
                break;
            }
            case UNKNOWN: {
                sb.append("LLAP status unknown");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)appStatusBuilder.getDiagnostics())) {
            sb.append("\n").append(appStatusBuilder.getDiagnostics());
        }
        return sb.toString();
    }

    private static void logError(Throwable t) {
        LOG.error("FAILED: " + t.getMessage(), t);
        System.err.println("FAILED: " + t.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        LOG.info("LLAP status invoked with arguments = {}", (Object)Arrays.toString(args));
        int ret = ExitCode.SUCCESS.getInt();
        SystemClock clock = SystemClock.getInstance();
        long startTime = clock.getTime();
        long lastSummaryLogTime = -1L;
        LlapStatusServiceDriver statusServiceDriver = null;
        LlapStatusOptionsProcessor.LlapStatusOptions options = null;
        try {
            statusServiceDriver = new LlapStatusServiceDriver();
            options = statusServiceDriver.parseOptions(args);
        }
        catch (Throwable t) {
            statusServiceDriver.close();
            LlapStatusServiceDriver.logError(t);
            if (t instanceof LlapStatusCliException) {
                LlapStatusCliException ce = (LlapStatusCliException)t;
                ret = ce.getExitCode().getInt();
            }
            ret = ExitCode.INTERNAL_ERROR.getInt();
        }
        if (ret != 0 || options == null) {
            if (statusServiceDriver != null) {
                statusServiceDriver.close();
            }
            System.exit(ret);
        }
        boolean firstAttempt = true;
        long refreshInterval = options.getRefreshIntervalMs();
        boolean watchMode = options.isWatchMode();
        long watchTimeout = options.getWatchTimeoutMs();
        long numAttempts = watchTimeout / refreshInterval;
        numAttempts = watchMode ? numAttempts : 1L;
        LlapStatusHelpers.State launchingState = null;
        LlapStatusHelpers.State currentState = null;
        boolean desiredStateAttained = false;
        float runningNodesThreshold = options.getRunningNodesThreshold();
        try (FilterOutputStream os = options.getOutputFile() == null ? System.out : new BufferedOutputStream(new FileOutputStream(options.getOutputFile()));
             PrintWriter pw = new PrintWriter(os);){
            LOG.info("Configured refresh interval: {}s. Watch timeout: {}s. Attempts remaining: {}. Watch mode: {}. Running nodes threshold: {}.", new Object[]{TimeUnit.SECONDS.convert(refreshInterval, TimeUnit.MILLISECONDS), TimeUnit.SECONDS.convert(watchTimeout, TimeUnit.MILLISECONDS), numAttempts, watchMode, new DecimalFormat("#.###").format(runningNodesThreshold)});
            while (numAttempts > 0L) {
                if (!firstAttempt) {
                    if (!watchMode) break;
                    try {
                        Thread.sleep(refreshInterval);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    firstAttempt = false;
                }
                ret = statusServiceDriver.run(options, watchMode ? watchTimeout : 0L);
                currentState = statusServiceDriver.appStatusBuilder.getState();
                try {
                    lastSummaryLogTime = LlapStatusServiceDriver.maybeLogSummary((Clock)clock, lastSummaryLogTime, statusServiceDriver, watchMode, watchTimeout, launchingState);
                }
                catch (Exception e) {
                    LOG.warn("Failed to log summary", (Throwable)e);
                }
                if (ret == ExitCode.SUCCESS.getInt()) {
                    if (!watchMode) break;
                    if (launchingState == null && LAUNCHING_STATES.contains((Object)currentState)) {
                        launchingState = currentState;
                    }
                    if (currentState.equals((Object)LlapStatusHelpers.State.COMPLETE)) {
                        if (launchingState != null || options.isLaunched()) {
                            LOG.warn("COMPLETE state reached while waiting for RUNNING state. Failing.");
                            System.err.println("Final diagnostics: " + statusServiceDriver.appStatusBuilder.getDiagnostics());
                            break;
                        }
                        LOG.info("Found a stopped application; assuming it was a previous attempt and waiting for the next one. Omit the -l flag to avoid this.");
                    }
                    if (!currentState.equals((Object)LlapStatusHelpers.State.RUNNING_PARTIAL) && !currentState.equals((Object)LlapStatusHelpers.State.RUNNING_ALL)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Current state: {}. Desired state: {}. {}/{} instances.", new Object[]{currentState, runningNodesThreshold == 1.0f ? LlapStatusHelpers.State.RUNNING_ALL : LlapStatusHelpers.State.RUNNING_PARTIAL, statusServiceDriver.appStatusBuilder.getLiveInstances(), statusServiceDriver.appStatusBuilder.getDesiredInstances()});
                        }
                        --numAttempts;
                        continue;
                    }
                    int liveInstances = statusServiceDriver.appStatusBuilder.getLiveInstances();
                    int desiredInstances = statusServiceDriver.appStatusBuilder.getDesiredInstances();
                    if (desiredInstances > 0) {
                        float ratio = (float)liveInstances / (float)desiredInstances;
                        if (ratio < runningNodesThreshold) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Waiting until running nodes threshold is reached. Current: {} Desired: {}. {}/{} instances.", new Object[]{new DecimalFormat("#.###").format(ratio), new DecimalFormat("#.###").format(runningNodesThreshold), statusServiceDriver.appStatusBuilder.getLiveInstances(), statusServiceDriver.appStatusBuilder.getDesiredInstances()});
                            }
                            --numAttempts;
                            continue;
                        }
                        desiredStateAttained = true;
                        statusServiceDriver.appStatusBuilder.setRunningThresholdAchieved(true);
                        break;
                    }
                    --numAttempts;
                    continue;
                }
                if (ret == ExitCode.YARN_ERROR.getInt() && watchMode) {
                    LOG.warn("Watch mode enabled and got YARN error. Retrying..");
                    --numAttempts;
                    continue;
                }
                if (ret == ExitCode.SERVICE_CLIENT_ERROR_CREATE_FAILED.getInt() && watchMode) {
                    LOG.warn("Watch mode enabled and YARN Service client creation failed. Retrying..");
                    --numAttempts;
                    continue;
                }
                if (ret == ExitCode.SERVICE_CLIENT_ERROR_OTHER.getInt() && watchMode) {
                    LOG.warn("Watch mode enabled and got YARN Service client error. Retrying..");
                    --numAttempts;
                    continue;
                }
                if (ret != ExitCode.LLAP_REGISTRY_ERROR.getInt() || !watchMode) break;
                LOG.warn("Watch mode enabled and got LLAP registry error. Retrying..");
                --numAttempts;
            }
            LlapStatusServiceDriver.maybeLogSummary((Clock)clock, 0L, statusServiceDriver, watchMode, watchTimeout, launchingState);
            CONSOLE_LOGGER.info("\n\n\n");
            statusServiceDriver.outputJson(pw);
            ((OutputStream)os).flush();
            pw.flush();
            if (numAttempts == 0L && watchMode && !desiredStateAttained) {
                LOG.warn("Watch timeout {}s exhausted before desired state RUNNING is attained.", (Object)TimeUnit.SECONDS.convert(watchTimeout, TimeUnit.MILLISECONDS));
            }
        }
        catch (Throwable t) {
            LlapStatusServiceDriver.logError(t);
            if (t instanceof LlapStatusCliException) {
                LlapStatusCliException ce = (LlapStatusCliException)t;
                ret = ce.getExitCode().getInt();
            } else {
                ret = ExitCode.INTERNAL_ERROR.getInt();
            }
        }
        finally {
            LOG.info("LLAP status finished");
            statusServiceDriver.close();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Completed processing - exiting with " + ret);
        }
        System.exit(ret);
    }

    private static long maybeLogSummary(Clock clock, long lastSummaryLogTime, LlapStatusServiceDriver statusServiceDriver, boolean watchMode, long watchTimeout, LlapStatusHelpers.State launchingState) {
        long currentTime = clock.getTime();
        if (lastSummaryLogTime < currentTime - 15000L) {
            String diagString = null;
            if (launchingState == null && statusServiceDriver.appStatusBuilder.getState() == LlapStatusHelpers.State.COMPLETE && watchMode) {
                diagString = "Awaiting LLAP launch";
                statusServiceDriver.appStatusBuilder.clearCompletedLlapInstances();
            } else {
                diagString = LlapStatusServiceDriver.constructDiagnostics(statusServiceDriver.appStatusBuilder);
            }
            if (lastSummaryLogTime == -1L) {
                if (watchMode) {
                    CONSOLE_LOGGER.info("\nLLAPSTATUS WatchMode with timeout={} s", (Object)TimeUnit.SECONDS.convert(watchTimeout, TimeUnit.MILLISECONDS));
                } else {
                    CONSOLE_LOGGER.info("\nLLAPSTATUS");
                }
                CONSOLE_LOGGER.info("--------------------------------------------------------------------------------");
            }
            CONSOLE_LOGGER.info(diagString);
            CONSOLE_LOGGER.info("--------------------------------------------------------------------------------");
            lastSummaryLogTime = currentTime;
        }
        return lastSummaryLogTime;
    }

    private void close() {
        if (this.serviceClient != null) {
            this.serviceClient.stop();
        }
        if (this.llapRegistry != null) {
            this.llapRegistry.stop();
        }
    }

    public static class LlapStatusCliException
    extends Exception {
        final ExitCode exitCode;

        public LlapStatusCliException(ExitCode exitCode, String message) {
            super(exitCode.getInt() + ": " + message);
            this.exitCode = exitCode;
        }

        public LlapStatusCliException(ExitCode exitCode, String message, Throwable cause) {
            super(message, cause);
            this.exitCode = exitCode;
        }

        public ExitCode getExitCode() {
            return this.exitCode;
        }
    }

    public static enum ExitCode {
        SUCCESS(0),
        INCORRECT_USAGE(10),
        YARN_ERROR(20),
        SERVICE_CLIENT_ERROR_CREATE_FAILED(30),
        SERVICE_CLIENT_ERROR_OTHER(31),
        LLAP_REGISTRY_ERROR(40),
        LLAP_JSON_GENERATION_ERROR(50),
        INTERNAL_ERROR(100);

        private final int exitCode;

        private ExitCode(int exitCode) {
            this.exitCode = exitCode;
        }

        public int getInt() {
            return this.exitCode;
        }
    }
}

