/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.IdentityHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticPermanentFunctionChecker
implements GenericUDFBridge.UdfWhitelistChecker {
    private static final Logger LOG = LoggerFactory.getLogger(StaticPermanentFunctionChecker.class);
    public static final String PERMANENT_FUNCTIONS_LIST = "llap-udfs.lst";
    private final IdentityHashMap<Class<?>, Boolean> allowedUdfClasses = new IdentityHashMap();

    public StaticPermanentFunctionChecker(Configuration conf) {
        URL logger = conf.getResource(PERMANENT_FUNCTIONS_LIST);
        if (logger == null) {
            LOG.warn("Could not find UDF whitelist in configuration: llap-udfs.lst");
            return;
        }
        try (BufferedReader r = new BufferedReader(new InputStreamReader(logger.openStream()));){
            String klassName = r.readLine();
            while (klassName != null) {
                try {
                    Class<?> clazz = Class.forName(klassName.trim(), false, this.getClass().getClassLoader());
                    this.allowedUdfClasses.put(clazz, true);
                }
                catch (ClassNotFoundException ie) {
                    LOG.warn("Could not load class " + klassName + " declared in UDF whitelist", (Throwable)ie);
                }
                klassName = r.readLine();
            }
        }
        catch (IOException ioe) {
            LOG.warn("Could not read UDF whitelist: llap-udfs.lst", (Throwable)ioe);
        }
    }

    public boolean isUdfAllowed(Class<?> clazz) {
        return FunctionRegistry.isBuiltInFuncClass(clazz) || this.allowedUdfClasses.containsKey(clazz);
    }
}

