/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapOomDebugDump;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;

public class LowLevelLrfuCachePolicy
implements LowLevelCachePolicy {
    private final double lambda;
    private static final double F0 = 1.0;
    private final AtomicLong timer = new AtomicLong(0L);
    private LlapCacheableBuffer[] heap;
    private final Object heapLock = new Object();
    private final ReentrantLock listLock = new ReentrantLock();
    private LlapCacheableBuffer listHead;
    private LlapCacheableBuffer listTail;
    private int heapSize = 0;
    private final int maxHeapSize;
    private EvictionListener evictionListener;
    private LlapOomDebugDump parentDebugDump;

    private final double f(long x) {
        return Math.pow(0.5, this.lambda * (double)x);
    }

    private final double touchPriority(long time, long lastAccess, double previous) {
        return 1.0 + this.f(time - lastAccess) * previous;
    }

    private final double expirePriority(long time, long lastAccess, double previous) {
        return this.f(time - lastAccess) * previous;
    }

    public LowLevelLrfuCachePolicy(int minBufferSize, long maxSize, Configuration conf) {
        this.lambda = HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_LRFU_LAMBDA);
        int maxBuffers = (int)Math.ceil((double)maxSize * 1.0 / (double)minBufferSize);
        if (this.lambda == 0.0) {
            this.maxHeapSize = maxBuffers;
        } else {
            int lrfuThreshold = (int)(Math.log(1.0 - Math.pow(0.5, this.lambda)) / Math.log(0.5) / this.lambda);
            this.maxHeapSize = Math.min(lrfuThreshold, maxBuffers);
        }
        LlapIoImpl.LOG.info("LRFU cache policy with min buffer size {} and lambda {} (heap size {})", new Object[]{minBufferSize, this.lambda, this.maxHeapSize});
        this.heap = new LlapCacheableBuffer[this.maxHeapSize];
        this.listTail = null;
        this.listHead = null;
    }

    @Override
    public void cache(LlapCacheableBuffer buffer, LowLevelCache.Priority priority) {
        assert (buffer.lastUpdate == -1L);
        long time = this.timer.incrementAndGet();
        buffer.priority = 1.0;
        buffer.lastUpdate = time;
        if (priority == LowLevelCache.Priority.HIGH) {
            buffer.priority *= 3.0;
        } else assert (priority == LowLevelCache.Priority.NORMAL);
    }

    @Override
    public void notifyLock(LlapCacheableBuffer buffer) {
        if (buffer.indexInHeap != -2) {
            return;
        }
        if (!this.listLock.tryLock()) {
            return;
        }
        this.removeFromListAndUnlock(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyUnlock(LlapCacheableBuffer buffer) {
        long time = this.timer.incrementAndGet();
        if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
            LlapIoImpl.CACHE_LOGGER.trace("Touching {} at {}", (Object)buffer, (Object)time);
        }
        Object object = this.heapLock;
        synchronized (object) {
            buffer.priority = buffer.lastUpdate == -1L ? 1.0 : this.touchPriority(time, buffer.lastUpdate, buffer.priority);
            buffer.lastUpdate = time;
            if (buffer.indexInHeap == -2) {
                this.listLock.lock();
                this.removeFromListAndUnlock(buffer);
            }
            if (buffer.indexInHeap >= 0) {
                this.heapifyDownUnderLock(buffer, time);
            } else if (this.heapSize == this.heap.length) {
                LlapCacheableBuffer demoted = this.heap[0];
                this.listLock.lock();
                try {
                    assert (demoted.indexInHeap == 0);
                    demoted.indexInHeap = -2;
                    demoted.prev = null;
                    if (this.listHead != null) {
                        demoted.next = this.listHead;
                        this.listHead.prev = demoted;
                        this.listHead = demoted;
                    } else {
                        this.listHead = this.listTail = demoted;
                        demoted.next = null;
                    }
                }
                finally {
                    this.listLock.unlock();
                }
                buffer.indexInHeap = 0;
                this.heapifyDownUnderLock(buffer, time);
            } else {
                assert (this.heapSize < this.heap.length) : this.heap.length + " < " + this.heapSize;
                buffer.indexInHeap = this.heapSize++;
                this.heapifyUpUnderLock(buffer, time);
            }
        }
    }

    @Override
    public void setEvictionListener(EvictionListener listener) {
        this.evictionListener = listener;
    }

    @Override
    public void setParentDebugDumper(LlapOomDebugDump dumper) {
        this.parentDebugDump = dumper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long purge() {
        int i;
        Object newCurrent;
        long evicted = 0L;
        LlapCacheableBuffer oldTail = null;
        this.listLock.lock();
        try {
            oldTail = this.listTail;
            Object current = oldTail;
            while (current != null) {
                boolean canEvict = 0 != ((LlapCacheableBuffer)current).invalidate();
                ((LlapCacheableBuffer)current).indexInHeap = -1;
                if (canEvict) {
                    current = ((LlapCacheableBuffer)current).prev;
                    continue;
                }
                newCurrent = ((LlapCacheableBuffer)current).prev;
                oldTail = LowLevelLrfuCachePolicy.removeFromLocalList(oldTail, (LlapCacheableBuffer)current);
                current = newCurrent;
            }
            this.listTail = null;
            this.listHead = null;
        }
        finally {
            this.listLock.unlock();
        }
        LlapCacheableBuffer[] oldHeap = null;
        int oldHeapSize = -1;
        newCurrent = this.heapLock;
        synchronized (newCurrent) {
            oldHeap = this.heap;
            oldHeapSize = this.heapSize;
            this.heap = new LlapCacheableBuffer[this.maxHeapSize];
            this.heapSize = 0;
            for (i = 0; i < oldHeapSize; ++i) {
                LlapCacheableBuffer result = oldHeap[i];
                result.indexInHeap = -1;
                int invalidateResult = result.invalidate();
                if (invalidateResult == 0) continue;
                oldHeap[i] = null;
            }
        }
        LlapCacheableBuffer current = oldTail;
        while (current != null) {
            evicted += current.getMemoryUsage();
            this.evictionListener.notifyEvicted(current);
            current = current.prev;
        }
        for (i = 0; i < oldHeapSize; ++i) {
            current = oldHeap[i];
            if (current == null) continue;
            evicted += current.getMemoryUsage();
            this.evictionListener.notifyEvicted(current);
        }
        LlapIoImpl.LOG.info("PURGE: evicted {} from LRFU policy", (Object)LlapUtil.humanReadableByteCount((long)evicted));
        return evicted;
    }

    private static LlapCacheableBuffer removeFromLocalList(LlapCacheableBuffer tail, LlapCacheableBuffer current) {
        if (current == tail) {
            tail = current.prev;
        } else {
            current.next.prev = current.prev;
        }
        if (current.prev != null) {
            current.prev.next = current.next;
        }
        current.next = null;
        current.prev = null;
        return tail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long evictSomeBlocks(long memoryToReserve) {
        long evicted = this.evictFromList(memoryToReserve);
        if (evicted >= memoryToReserve) {
            return evicted;
        }
        long time = this.timer.get();
        while (evicted < memoryToReserve) {
            LlapCacheableBuffer buffer = null;
            Object object = this.heapLock;
            synchronized (object) {
                buffer = this.evictFromHeapUnderLock(time);
            }
            if (buffer == null) {
                return evicted;
            }
            evicted += buffer.getMemoryUsage();
            this.evictionListener.notifyEvicted(buffer);
        }
        return evicted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long evictFromList(long memoryToReserve) {
        long evicted = 0L;
        LlapCacheableBuffer nextCandidate = null;
        LlapCacheableBuffer firstCandidate = null;
        this.listLock.lock();
        try {
            nextCandidate = firstCandidate = this.listTail;
            while (evicted < memoryToReserve && nextCandidate != null) {
                if (0 != nextCandidate.invalidate()) {
                    LlapCacheableBuffer lockedBuffer = nextCandidate;
                    if (firstCandidate == nextCandidate) {
                        firstCandidate = nextCandidate.prev;
                    }
                    nextCandidate = nextCandidate.prev;
                    this.removeFromListUnderLock(lockedBuffer);
                    continue;
                }
                nextCandidate.indexInHeap = -1;
                evicted += nextCandidate.getMemoryUsage();
                nextCandidate = nextCandidate.prev;
            }
            if (firstCandidate != nextCandidate) {
                if (nextCandidate == null) {
                    this.listTail = null;
                    this.listHead = null;
                } else {
                    this.removeFromListUnderLockNoStateUpdate(nextCandidate.next, firstCandidate);
                }
            }
        }
        finally {
            this.listLock.unlock();
        }
        while (firstCandidate != nextCandidate) {
            this.evictionListener.notifyEvicted(firstCandidate);
            firstCandidate = firstCandidate.prev;
        }
        return evicted;
    }

    private LlapCacheableBuffer evictFromHeapUnderLock(long time) {
        LlapCacheableBuffer result;
        do {
            if (this.heapSize != 0) continue;
            return null;
        } while ((result = this.evictHeapElementUnderLock(time, 0)) == null);
        return result;
    }

    private void heapifyUpUnderLock(LlapCacheableBuffer buffer, long time) {
        int parentIx;
        LlapCacheableBuffer parent;
        double parentPri;
        int ix = buffer.indexInHeap;
        double priority = buffer.priority;
        while (ix != 0 && !(priority >= (parentPri = this.getHeapifyPriority(parent = this.heap[parentIx = ix - 1 >>> 1], time)))) {
            this.heap[ix] = parent;
            parent.indexInHeap = ix;
            ix = parentIx;
        }
        buffer.indexInHeap = ix;
        this.heap[ix] = buffer;
    }

    private LlapCacheableBuffer evictHeapElementUnderLock(long time, int ix) {
        boolean canEvict;
        LlapCacheableBuffer result = this.heap[ix];
        if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
            LlapIoImpl.CACHE_LOGGER.trace("Evicting {} at {}", (Object)result, (Object)time);
        }
        result.indexInHeap = -1;
        --this.heapSize;
        int invalidateResult = result.invalidate();
        boolean bl = canEvict = invalidateResult == 0;
        if (this.heapSize > 0) {
            LlapCacheableBuffer newRoot = this.heap[this.heapSize];
            newRoot.indexInHeap = ix;
            if (newRoot.lastUpdate != time) {
                newRoot.priority = this.expirePriority(time, newRoot.lastUpdate, newRoot.priority);
                newRoot.lastUpdate = time;
            }
            this.heapifyDownUnderLock(newRoot, time);
        }
        return canEvict ? result : null;
    }

    private void heapifyDownUnderLock(LlapCacheableBuffer buffer, long time) {
        int newIx;
        int ix = buffer.indexInHeap;
        double priority = buffer.priority;
        while ((newIx = this.moveMinChildUp(ix, time, priority)) != -1) {
            ix = newIx;
        }
        buffer.indexInHeap = ix;
        this.heap[ix] = buffer;
    }

    private int moveMinChildUp(int targetPos, long time, double comparePri) {
        int leftIx = (targetPos << 1) + 1;
        int rightIx = leftIx + 1;
        if (leftIx >= this.heapSize) {
            return -1;
        }
        LlapCacheableBuffer left = this.heap[leftIx];
        LlapCacheableBuffer right = null;
        if (rightIx < this.heapSize) {
            right = this.heap[rightIx];
        }
        double leftPri = this.getHeapifyPriority(left, time);
        double rightPri = this.getHeapifyPriority(right, time);
        if (comparePri >= 0.0 && comparePri <= leftPri && comparePri <= rightPri) {
            return -1;
        }
        if (leftPri <= rightPri) {
            this.heap[targetPos] = left;
            left.indexInHeap = targetPos;
            return leftIx;
        }
        this.heap[targetPos] = right;
        right.indexInHeap = targetPos;
        return rightIx;
    }

    private double getHeapifyPriority(LlapCacheableBuffer buf, long time) {
        if (buf == null) {
            return Double.MAX_VALUE;
        }
        if (buf.lastUpdate != time && time >= 0L) {
            buf.priority = this.expirePriority(time, buf.lastUpdate, buf.priority);
            buf.lastUpdate = time;
        }
        return buf.priority;
    }

    private void removeFromListAndUnlock(LlapCacheableBuffer buffer) {
        try {
            if (buffer.indexInHeap != -2) {
                return;
            }
            this.removeFromListUnderLock(buffer);
        }
        finally {
            this.listLock.unlock();
        }
    }

    private void removeFromListUnderLock(LlapCacheableBuffer buffer) {
        buffer.indexInHeap = -1;
        boolean isTail = buffer == this.listTail;
        boolean isHead = buffer == this.listHead;
        if (isTail != (buffer.next == null) || isHead != (buffer.prev == null)) {
            this.debugDumpListOnError(buffer);
            throw new AssertionError((Object)"LRFU list is corrupted.");
        }
        if (isTail) {
            this.listTail = buffer.prev;
        } else {
            buffer.next.prev = buffer.prev;
        }
        if (isHead) {
            this.listHead = buffer.next;
        } else {
            buffer.prev.next = buffer.next;
        }
    }

    private void removeFromListUnderLockNoStateUpdate(LlapCacheableBuffer from, LlapCacheableBuffer to) {
        boolean isToTail = to == this.listTail;
        boolean isFromHead = from == this.listHead;
        if (isToTail != (to.next == null) || isFromHead != (from.prev == null)) {
            this.debugDumpListOnError(from, to);
            throw new AssertionError((Object)"LRFU list is corrupted.");
        }
        if (isToTail) {
            this.listTail = from.prev;
        } else {
            to.next.prev = from.prev;
        }
        if (isFromHead) {
            this.listHead = to.next;
        } else {
            from.prev.next = to.next;
        }
    }

    private void debugDumpListOnError(LlapCacheableBuffer ... buffers) {
        StringBuilder listDump = new StringBuilder("Invalid list removal. List: ");
        try {
            LowLevelLrfuCachePolicy.dumpList(listDump, this.listHead, this.listTail);
            int i = 0;
            for (LlapCacheableBuffer buffer : buffers) {
                listDump.append("; list from the buffer #").append(i).append(" being removed: ");
                LowLevelLrfuCachePolicy.dumpList(listDump, buffer, null);
            }
        }
        catch (Throwable t) {
            LlapIoImpl.LOG.error("Error dumping the lists on error", t);
        }
        LlapIoImpl.LOG.error(listDump.toString());
    }

    public String debugDumpHeap() {
        StringBuilder result = new StringBuilder("List: ");
        LowLevelLrfuCachePolicy.dumpList(result, this.listHead, this.listTail);
        result.append("\nHeap:");
        if (this.heapSize == 0) {
            result.append(" <empty>\n");
            return result.toString();
        }
        result.append("\n");
        int levels = 32 - Integer.numberOfLeadingZeros(this.heapSize);
        int ix = 0;
        int spacesCount = this.heap[0].toStringForCache().length() + 3;
        String full = StringUtils.repeat((String)" ", (int)spacesCount);
        String half = StringUtils.repeat((String)" ", (int)(spacesCount / 2));
        int maxWidth = 1 << levels - 1;
        for (int i = 0; i < levels; ++i) {
            int j;
            int width = 1 << i;
            int middleGap = (maxWidth - width) / width;
            for (j = 0; j < middleGap >>> 1; ++j) {
                result.append(full);
            }
            if ((middleGap & 1) == 1) {
                result.append(half);
            }
            for (j = 0; j < width && ix < this.heapSize; ++j, ++ix) {
                if (j != 0) {
                    for (int k = 0; k < middleGap; ++k) {
                        result.append(full);
                    }
                    if (middleGap == 0) {
                        result.append(" ");
                    }
                }
                if ((j & 1) == 0) {
                    result.append("(");
                }
                result.append(this.heap[ix].toStringForCache());
                if ((j & 1) != 1) continue;
                result.append(")");
            }
            result.append("\n");
        }
        return result.toString();
    }

    private static void dumpList(StringBuilder result, LlapCacheableBuffer listHeadLocal, LlapCacheableBuffer listTailLocal) {
        if (listHeadLocal == null) {
            result.append("<empty>");
            return;
        }
        LlapCacheableBuffer listItem = listHeadLocal;
        while (listItem.prev != null) {
            listItem = listItem.prev;
        }
        while (listItem != null) {
            result.append(listItem.toStringForCache());
            if (listItem == listTailLocal) {
                result.append("(tail)");
            }
            if (listItem == listHeadLocal) {
                result.append("(head)");
            }
            result.append(" -> ");
            listItem = listItem.next;
        }
    }

    @Override
    public String debugDumpForOom() {
        Object result = this.debugDumpHeap();
        if (this.parentDebugDump != null) {
            result = (String)result + "\n" + this.parentDebugDump.debugDumpForOom();
        }
        return result;
    }

    @Override
    public void debugDumpShort(StringBuilder sb) {
        sb.append("\nLRFU eviction list: ");
        LlapCacheableBuffer listHeadLocal = this.listHead;
        LlapCacheableBuffer listTailLocal = this.listTail;
        if (listHeadLocal == null) {
            sb.append("0 items");
        } else {
            LlapCacheableBuffer listItem = listHeadLocal;
            int c = 0;
            while (listItem != null) {
                ++c;
                if (listItem == listTailLocal) break;
                listItem = listItem.next;
            }
            sb.append(c + " items");
        }
        sb.append("\nLRFU eviction heap: " + this.heapSize + " items");
        if (this.parentDebugDump != null) {
            this.parentDebugDump.debugDumpShort(sb);
        }
    }
}

