/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli;

import com.carrotsearch.hppc.ByteArrayDeque;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.flatbuffers.Table;
import com.lmax.disruptor.RingBuffer;
import io.netty.util.NetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.arrow.flatbuf.Schema;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hive.common.CompressionUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.cli.LlapOptionsProcessor;
import org.apache.hadoop.hive.llap.cli.LlapSliderUtils;
import org.apache.hadoop.hive.llap.configuration.LlapDaemonConfiguration;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.io.api.impl.LlapInputFormat;
import org.apache.hadoop.hive.llap.tezplugins.LlapTezUtils;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.util.ResourceDownloader;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.log4j.config.Log4j1ConfigurationFactory;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.slf4j.Log4jLogger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapServiceDriver {
    protected static final Logger LOG = LoggerFactory.getLogger((String)LlapServiceDriver.class.getName());
    private static final String[] DEFAULT_AUX_CLASSES = new String[]{"org.apache.hive.hcatalog.data.JsonSerDe", "org.apache.hadoop.hive.druid.DruidStorageHandler", "org.apache.hive.storage.jdbc.JdbcStorageHandler"};
    private static final String HBASE_SERDE_CLASS = "org.apache.hadoop.hive.hbase.HBaseSerDe";
    private static final String[] NEEDED_CONFIGS = LlapDaemonConfiguration.DAEMON_CONFIGS;
    private static final String[] OPTIONAL_CONFIGS = LlapDaemonConfiguration.SSL_DAEMON_CONFIGS;
    private static final String OUTPUT_DIR_PREFIX = "llap-yarn-";
    private static final String CONFIG_CLUSTER_NAME = "private.hive.llap.servicedriver.cluster.name";
    private final HiveConf conf;

    public LlapServiceDriver() {
        SessionState ss = SessionState.get();
        this.conf = ss != null ? ss.getConf() : new HiveConf(SessionState.class);
    }

    public static void main(String[] args) throws Exception {
        LOG.info("LLAP service driver invoked with arguments={}", (Object[])args);
        int ret = 0;
        try {
            ret = new LlapServiceDriver().run(args);
        }
        catch (Throwable t) {
            System.err.println("Failed: " + t.getMessage());
            t.printStackTrace();
            ret = 3;
        }
        finally {
            LOG.info("LLAP service driver finished");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Completed processing - exiting with " + ret);
        }
        System.exit(ret);
    }

    private static Configuration resolve(Configuration configured, Properties direct, Properties hiveconf) {
        Configuration conf = new Configuration(false);
        LlapServiceDriver.populateConf(configured, conf, hiveconf, "CLI hiveconf");
        LlapServiceDriver.populateConf(configured, conf, direct, "CLI direct");
        return conf;
    }

    private static void populateConf(Configuration configured, Configuration target, Properties properties, String source) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String val = configured.get(key);
            if (val == null) continue;
            target.set(key, val, source);
        }
    }

    static void populateConfWithLlapProperties(Configuration conf, Properties properties) {
        for (Map.Entry<Object, Object> props : properties.entrySet()) {
            String key = (String)props.getKey();
            if (HiveConf.getLlapDaemonConfVars().contains(key)) {
                conf.set(key, (String)props.getValue());
                continue;
            }
            if (key.startsWith("llap.") || key.startsWith("hive.llap.")) {
                LOG.warn("Adding key [{}] even though it is not in the set of known llap-server keys");
                conf.set(key, (String)props.getValue());
                continue;
            }
            LOG.warn("Ignoring unknown llap server parameter: [{}]", (Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(String[] args) throws Exception {
        LlapOptionsProcessor optionsProcessor = new LlapOptionsProcessor();
        final LlapOptionsProcessor.LlapOptions options = optionsProcessor.processOptions(args);
        final Properties propsDirectOptions = new Properties();
        if (options == null) {
            return 1;
        }
        Path tmpDir = new Path(options.getDirectory());
        if (this.conf == null) {
            throw new Exception("Cannot load any configuration to run command");
        }
        long t0 = System.nanoTime();
        final FileSystem fs = FileSystem.get((Configuration)this.conf);
        final FileSystem lfs = FileSystem.getLocal((Configuration)this.conf).getRawFileSystem();
        int threadCount = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        ExecutorService executor = Executors.newFixedThreadPool(threadCount, new ThreadFactoryBuilder().setNameFormat("llap-pkg-%d").build());
        ExecutorCompletionService asyncRunner = new ExecutorCompletionService(executor);
        int rc = 0;
        try {
            String java_home;
            URL logger;
            long minAlloc;
            long containerSize;
            long size;
            for (String f : NEEDED_CONFIGS) {
                this.conf.addResource(f);
                if (this.conf.getResource(f) != null) continue;
                throw new Exception("Unable to find required config file: " + f);
            }
            for (String f : OPTIONAL_CONFIGS) {
                this.conf.addResource(f);
            }
            this.conf.reloadConfiguration();
            LlapServiceDriver.populateConfWithLlapProperties((Configuration)this.conf, options.getConfig());
            if (options.getName() != null) {
                this.conf.set(HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS.varname, "@" + options.getName());
                propsDirectOptions.setProperty(HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS.varname, "@" + options.getName());
            }
            if (options.getLogger() != null) {
                HiveConf.setVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_LOGGER, (String)options.getLogger());
                propsDirectOptions.setProperty(HiveConf.ConfVars.LLAP_DAEMON_LOGGER.varname, options.getLogger());
            }
            boolean isDirect = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_DIRECT);
            if (options.getSize() != -1L) {
                if (options.getCache() != -1L) {
                    if (!HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_MAPPED)) {
                        Preconditions.checkArgument((options.getCache() < options.getSize() ? 1 : 0) != 0, (Object)("Cache size (" + LlapUtil.humanReadableByteCount((long)options.getCache()) + ") has to be smaller than the container sizing (" + LlapUtil.humanReadableByteCount((long)options.getSize()) + ")"));
                    } else if (options.getCache() < options.getSize()) {
                        LOG.warn("Note that this might need YARN physical memory monitoring to be turned off (yarn.nodemanager.pmem-check-enabled=false)");
                    }
                }
                if (options.getXmx() != -1L) {
                    Preconditions.checkArgument((options.getXmx() < options.getSize() ? 1 : 0) != 0, (Object)("Working memory (Xmx=" + LlapUtil.humanReadableByteCount((long)options.getXmx()) + ") has to be smaller than the container sizing (" + LlapUtil.humanReadableByteCount((long)options.getSize()) + ")"));
                }
                if (isDirect && !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_MAPPED)) {
                    Preconditions.checkArgument((options.getXmx() + options.getCache() <= options.getSize() ? 1 : 0) != 0, (Object)("Working memory (Xmx=" + LlapUtil.humanReadableByteCount((long)options.getXmx()) + ") + cache size (" + LlapUtil.humanReadableByteCount((long)options.getCache()) + ") has to be smaller than the container sizing (" + LlapUtil.humanReadableByteCount((long)options.getSize()) + ")"));
                }
            }
            if (options.getExecutors() != -1) {
                this.conf.setLong(HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS.varname, (long)options.getExecutors());
                propsDirectOptions.setProperty(HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS.varname, String.valueOf(options.getExecutors()));
            }
            if (options.getIoThreads() != -1) {
                this.conf.setLong(HiveConf.ConfVars.LLAP_IO_THREADPOOL_SIZE.varname, (long)options.getIoThreads());
                propsDirectOptions.setProperty(HiveConf.ConfVars.LLAP_IO_THREADPOOL_SIZE.varname, String.valueOf(options.getIoThreads()));
            }
            long cache = -1L;
            long xmx = -1L;
            if (options.getCache() != -1L) {
                cache = options.getCache();
                this.conf.set(HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE.varname, Long.toString(cache));
                propsDirectOptions.setProperty(HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE.varname, Long.toString(cache));
            }
            if (options.getXmx() != -1L) {
                xmx = options.getXmx();
                long xmxMb = xmx / 0x100000L;
                this.conf.setLong(HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB.varname, xmxMb);
                propsDirectOptions.setProperty(HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB.varname, String.valueOf(xmxMb));
            }
            if ((size = options.getSize()) == -1L) {
                long heapSize = xmx;
                if (!isDirect) {
                    heapSize += cache;
                }
                size = Math.min((long)((double)heapSize * 1.2), heapSize + 0x40000000L);
                if (isDirect) {
                    size += cache;
                }
            }
            Preconditions.checkArgument(((containerSize = size / 0x100000L) >= (minAlloc = (long)this.conf.getInt("yarn.scheduler.minimum-allocation-mb", -1)) ? 1 : 0) != 0, (Object)("Container size (" + LlapUtil.humanReadableByteCount((long)options.getSize()) + ") should be greater than minimum allocation(" + LlapUtil.humanReadableByteCount((long)(minAlloc * 1024L * 1024L)) + ")"));
            this.conf.setLong(HiveConf.ConfVars.LLAP_DAEMON_YARN_CONTAINER_MB.varname, containerSize);
            propsDirectOptions.setProperty(HiveConf.ConfVars.LLAP_DAEMON_YARN_CONTAINER_MB.varname, String.valueOf(containerSize));
            LOG.info("Memory settings: container memory: {} executor memory: {} cache memory: {}", new Object[]{LlapUtil.humanReadableByteCount((long)options.getSize()), LlapUtil.humanReadableByteCount((long)options.getXmx()), LlapUtil.humanReadableByteCount((long)options.getCache())});
            if (options.getLlapQueueName() != null && !options.getLlapQueueName().isEmpty()) {
                this.conf.set(HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME.varname, options.getLlapQueueName());
                propsDirectOptions.setProperty(HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME.varname, options.getLlapQueueName());
            }
            if (null == (logger = this.conf.getResource("llap-daemon-log4j2.properties"))) {
                throw new Exception("Unable to find required config file: llap-daemon-log4j2.properties");
            }
            Path home = new Path(System.getenv("HIVE_HOME"));
            Path scriptParent = new Path(new Path(home, "scripts"), "llap");
            Path scripts = new Path(scriptParent, "bin");
            if (!lfs.exists(home)) {
                throw new Exception("Unable to find HIVE_HOME:" + home);
            }
            if (!lfs.exists(scripts)) {
                LOG.warn("Unable to find llap scripts:" + scripts);
            }
            final Path libDir = new Path(tmpDir, "lib");
            final Path tezDir = new Path(libDir, "tez");
            final Path udfDir = new Path(libDir, "udfs");
            final Path confPath = new Path(tmpDir, "conf");
            if (!lfs.mkdirs(confPath)) {
                LOG.warn("mkdirs for " + confPath + " returned false");
            }
            if (!lfs.mkdirs(tezDir)) {
                LOG.warn("mkdirs for " + tezDir + " returned false");
            }
            if (!lfs.mkdirs(udfDir)) {
                LOG.warn("mkdirs for " + udfDir + " returned false");
            }
            NamedCallable<Void> downloadTez = new NamedCallable<Void>("downloadTez"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    FileSystem fileSystem = fs;
                    synchronized (fileSystem) {
                        String tezLibs = LlapServiceDriver.this.conf.get("tez.lib.uris");
                        if (tezLibs == null) {
                            LOG.warn("Missing tez.lib.uris in tez-site.xml");
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Copying tez libs from " + tezLibs);
                        }
                        lfs.mkdirs(tezDir);
                        fs.copyToLocalFile(new Path(tezLibs), new Path(libDir, "tez.tar.gz"));
                        CompressionUtils.unTar((String)new Path(libDir, "tez.tar.gz").toString(), (String)tezDir.toString(), (boolean)true);
                        lfs.delete(new Path(libDir, "tez.tar.gz"), false);
                    }
                    return null;
                }
            };
            NamedCallable<Void> copyLocalJars = new NamedCallable<Void>("copyLocalJars"){

                @Override
                public Void call() throws Exception {
                    Class[] dependencies;
                    for (Class c : dependencies = new Class[]{LlapDaemonProtocolProtos.class, LlapTezUtils.class, LlapInputFormat.class, HiveInputFormat.class, SslContextFactory.class, Rule.class, RegistryUtils.ServiceRecordMarshal.class, RingBuffer.class, org.apache.logging.log4j.Logger.class, Appender.class, Log4jLogger.class, Log4j1ConfigurationFactory.class, NetUtil.class, org.jboss.netty.util.NetUtil.class, ArrowType.class, BaseAllocator.class, Schema.class, Table.class, ByteArrayDeque.class}) {
                        Path jarPath = new Path(Utilities.jarFinderGetJar((Class)c));
                        lfs.copyFromLocalFile(jarPath, libDir);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Copying " + jarPath + " to " + libDir);
                    }
                    return null;
                }
            };
            NamedCallable<Void> copyAuxJars = new NamedCallable<Void>("copyAuxJars"){

                @Override
                public Void call() throws Exception {
                    for (String className : DEFAULT_AUX_CLASSES) {
                        LlapServiceDriver.this.localizeJarForClass(lfs, libDir, className, false);
                    }
                    Collection codecs = LlapServiceDriver.this.conf.getStringCollection("io.compression.codecs");
                    if (codecs != null) {
                        for (String codecClassName : codecs) {
                            LlapServiceDriver.this.localizeJarForClass(lfs, libDir, codecClassName, false);
                        }
                    }
                    if (options.getIsHBase()) {
                        try {
                            LlapServiceDriver.this.localizeJarForClass(lfs, libDir, LlapServiceDriver.HBASE_SERDE_CLASS, true);
                            Job fakeJob = new Job((Configuration)new JobConf());
                            TableMapReduceUtil.addDependencyJars((Job)fakeJob);
                            Collection hbaseJars = fakeJob.getConfiguration().getStringCollection("tmpjars");
                            for (String jarPath : hbaseJars) {
                                if (jarPath.isEmpty()) continue;
                                lfs.copyFromLocalFile(new Path(jarPath), libDir);
                            }
                        }
                        catch (Throwable t) {
                            String err = "Failed to add HBase jars. Use --auxhbase=false to avoid localizing them";
                            LOG.error(err);
                            System.err.println(err);
                            throw new RuntimeException(t);
                        }
                    }
                    HashSet<String> auxJars = new HashSet<String>();
                    if (options.getIsHiveAux()) {
                        this.addAuxJarsToSet(auxJars, LlapServiceDriver.this.conf.getAuxJars(), ",");
                        this.addAuxJarsToSet(auxJars, System.getenv("HIVE_AUX_JARS_PATH"), ":");
                        LOG.info("Adding the following aux jars from the environment and configs: " + auxJars);
                    }
                    this.addAuxJarsToSet(auxJars, options.getAuxJars(), ",");
                    for (String jarPath : auxJars) {
                        lfs.copyFromLocalFile(new Path(jarPath), libDir);
                    }
                    return null;
                }

                private void addAuxJarsToSet(HashSet<String> auxJarSet, String auxJars, String delimiter) {
                    if (auxJars != null && !auxJars.isEmpty()) {
                        String[] jarPaths;
                        for (String jarPath : jarPaths = auxJars.split(delimiter)) {
                            if (jarPath.isEmpty()) continue;
                            auxJarSet.add(jarPath);
                        }
                    }
                }
            };
            NamedCallable<Void> copyUdfJars = new NamedCallable<Void>("copyUdfJars"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    Set<Object> allowedUdfs;
                    if (HiveConf.getBoolVar((Configuration)LlapServiceDriver.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOW_PERMANENT_FNS)) {
                        FileSystem fileSystem = fs;
                        synchronized (fileSystem) {
                            allowedUdfs = LlapServiceDriver.this.downloadPermanentFunctions((Configuration)LlapServiceDriver.this.conf, udfDir);
                        }
                    } else {
                        allowedUdfs = Collections.emptySet();
                    }
                    PrintWriter udfStream = new PrintWriter((OutputStream)lfs.create(new Path(confPath, "llap-udfs.lst")));
                    for (String string : allowedUdfs) {
                        udfStream.println(string);
                    }
                    udfStream.close();
                    return null;
                }
            };
            if (options.getJavaPath() == null || options.getJavaPath().isEmpty()) {
                java_home = System.getenv("JAVA_HOME");
                String jre_home = System.getProperty("java.home");
                if (java_home == null) {
                    java_home = jre_home;
                } else if (!java_home.equals(jre_home)) {
                    LOG.warn("Java versions might not match : JAVA_HOME=[{}],process jre=[{}]", (Object)java_home, (Object)jre_home);
                }
            } else {
                java_home = options.getJavaPath();
            }
            if (java_home == null || java_home.isEmpty()) {
                throw new RuntimeException("Could not determine JAVA_HOME from command line parameters, environment or system properties");
            }
            LOG.info("Using [{}] for JAVA_HOME", (Object)java_home);
            NamedCallable<Void> copyConfigs = new NamedCallable<Void>("copyConfigs"){

                @Override
                public Void call() throws Exception {
                    for (String f : NEEDED_CONFIGS) {
                        LlapServiceDriver.this.copyConfig(lfs, confPath, f);
                    }
                    for (String f : OPTIONAL_CONFIGS) {
                        try {
                            LlapServiceDriver.this.copyConfig(lfs, confPath, f);
                        }
                        catch (Throwable t) {
                            LOG.info("Error getting an optional config " + f + "; ignoring: " + t.getMessage());
                        }
                    }
                    LlapServiceDriver.this.createLlapDaemonConfig(lfs, confPath, (Configuration)LlapServiceDriver.this.conf, propsDirectOptions, options.getConfig());
                    LlapServiceDriver.this.setUpLogAndMetricConfigs(lfs, logger, confPath);
                    return null;
                }
            };
            NamedCallable[] asyncWork = new NamedCallable[]{downloadTez, copyUdfJars, copyLocalJars, copyAuxJars, copyConfigs};
            Future[] asyncResults = new Future[asyncWork.length];
            for (int i = 0; i < asyncWork.length; ++i) {
                asyncResults[i] = asyncRunner.submit(asyncWork[i]);
            }
            JSONObject configs = this.createConfigJson(containerSize, cache, xmx, java_home);
            this.writeConfigJson(tmpDir, lfs, configs);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Config generation took " + (System.nanoTime() - t0) + " ns");
            }
            for (int i = 0; i < asyncWork.length; ++i) {
                long t1 = System.nanoTime();
                asyncResults[i].get();
                long t2 = System.nanoTime();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(asyncWork[i].getName() + " waited for " + (t2 - t1) + " ns");
            }
            if (options.isStarting()) {
                String version = System.getenv("HIVE_VERSION");
                if (version == null || version.isEmpty()) {
                    version = DateTime.now().toString("ddMMMyyyy");
                }
                Object outputDir = options.getOutput();
                Path packageDir = null;
                if (outputDir == null) {
                    outputDir = OUTPUT_DIR_PREFIX + version;
                    packageDir = new Path(Paths.get(".", new String[0]).toAbsolutePath().toString(), OUTPUT_DIR_PREFIX + version);
                } else {
                    packageDir = new Path((String)outputDir);
                }
                rc = this.runPackagePy(args, tmpDir, scriptParent, version, (String)outputDir);
                if (rc == 0) {
                    LlapSliderUtils.startCluster((Configuration)this.conf, options.getName(), "llap-" + version + ".tar.gz", packageDir, HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME));
                }
            } else {
                rc = 0;
            }
        }
        finally {
            executor.shutdown();
            lfs.close();
            fs.close();
        }
        if (rc == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exiting successfully");
            }
        } else {
            LOG.info("Exiting with rc = " + rc);
        }
        return rc;
    }

    private int runPackagePy(String[] args, Path tmpDir, Path scriptParent, String version, String outputDir) throws IOException, InterruptedException {
        Path scriptPath = new Path(new Path(scriptParent, "yarn"), "package.py");
        ArrayList<String> scriptArgs = new ArrayList<String>(args.length + 7);
        scriptArgs.add("python");
        scriptArgs.add(scriptPath.toString());
        scriptArgs.add("--input");
        scriptArgs.add(tmpDir.toString());
        scriptArgs.add("--output");
        scriptArgs.add(outputDir);
        scriptArgs.add("--javaChild");
        for (String arg : args) {
            scriptArgs.add(arg);
        }
        LOG.debug("Calling package.py via: " + scriptArgs);
        ProcessBuilder builder = new ProcessBuilder(scriptArgs);
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        builder.environment().put("HIVE_VERSION", version);
        return builder.start().waitFor();
    }

    private void writeConfigJson(Path tmpDir, FileSystem lfs, JSONObject configs) throws IOException, JSONException {
        FSDataOutputStream os = lfs.create(new Path(tmpDir, "config.json"));
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)os);
        configs.write((Writer)w);
        w.close();
        os.close();
    }

    private JSONObject createConfigJson(long containerSize, long cache, long xmx, String java_home) throws JSONException {
        String clusterHosts;
        JSONObject configs = new JSONObject();
        configs.put("java.home", (Object)java_home);
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_YARN_CONTAINER_MB.varname, HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_YARN_CONTAINER_MB));
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_YARN_CONTAINER_MB.varname, containerSize);
        configs.put(HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE.varname, HiveConf.getSizeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE));
        configs.put(HiveConf.ConfVars.LLAP_ALLOCATOR_DIRECT.varname, HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_DIRECT));
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB.varname, HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB));
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_VCPUS_PER_INSTANCE.varname, HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_VCPUS_PER_INSTANCE));
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS.varname, HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS));
        if (HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME) != null) {
            configs.put(HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME.varname, (Object)HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME));
        }
        if (!StringUtils.isEmpty((CharSequence)(clusterHosts = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS))) && clusterHosts.startsWith("@") && clusterHosts.length() > 1) {
            configs.put(CONFIG_CLUSTER_NAME, (Object)clusterHosts.substring(1));
        }
        configs.put("yarn.scheduler.minimum-allocation-mb", this.conf.getInt("yarn.scheduler.minimum-allocation-mb", -1));
        configs.put("yarn.scheduler.minimum-allocation-vcores", this.conf.getInt("yarn.scheduler.minimum-allocation-vcores", -1));
        long maxDirect = xmx > 0L && cache > 0L && (double)xmx < (double)cache * 1.25 ? (long)((double)cache * 1.25) : -1L;
        configs.put("max_direct_memory", (Object)Long.toString(maxDirect));
        return configs;
    }

    private Set<String> downloadPermanentFunctions(Configuration conf, Path udfDir) throws HiveException, URISyntaxException, IOException {
        HashMap<String, CallSite> udfs = new HashMap<String, CallSite>();
        HiveConf hiveConf = new HiveConf();
        hiveConf.setBoolVar(HiveConf.ConfVars.METASTORE_INIT_METADATA_COUNT_ENABLED, false);
        hiveConf.setBoolVar(HiveConf.ConfVars.METASTORE_METRICS, false);
        Hive hive = Hive.getWithFastCheck((HiveConf)hiveConf, (boolean)false);
        ResourceDownloader resourceDownloader = new ResourceDownloader(conf, udfDir.toUri().normalize().getPath());
        List fns = hive.getAllFunctions();
        HashSet<URI> srcUris = new HashSet<URI>();
        for (Function fn : fns) {
            String fqfn = fn.getDbName() + "." + fn.getFunctionName();
            if (udfs.containsKey(fn.getClassName())) {
                LOG.warn("Duplicate function names found for " + fn.getClassName() + " with " + fqfn + " and " + (String)udfs.get(fn.getClassName()));
            }
            udfs.put(fn.getClassName(), (CallSite)((Object)fqfn));
            List resources = fn.getResourceUris();
            if (resources == null || resources.isEmpty()) {
                LOG.warn("Missing resources for " + fqfn);
                continue;
            }
            for (ResourceUri resource : resources) {
                srcUris.add(ResourceDownloader.createURI((String)resource.getUri()));
            }
        }
        for (URI srcUri : srcUris) {
            List localUris = resourceDownloader.downloadExternal(srcUri, null, false);
            for (URI dst : localUris) {
                LOG.warn("Downloaded " + dst + " from " + srcUri);
            }
        }
        return udfs.keySet();
    }

    private void localizeJarForClass(FileSystem lfs, Path libDir, String className, boolean doThrow) throws IOException {
        String jarPath = null;
        boolean hasException = false;
        try {
            Class<?> auxClass = Class.forName(className);
            jarPath = Utilities.jarFinderGetJar(auxClass);
        }
        catch (Throwable t) {
            if (doThrow) {
                throw t instanceof IOException ? (IOException)t : new IOException(t);
            }
            hasException = true;
            String err = "Cannot find a jar for [" + className + "] due to an exception (" + t.getMessage() + "); not packaging the jar";
            LOG.error(err);
            System.err.println(err);
        }
        if (jarPath != null) {
            lfs.copyFromLocalFile(new Path(jarPath), libDir);
        } else if (!hasException) {
            String err = "Cannot find a jar for [" + className + "]; not packaging the jar";
            if (doThrow) {
                throw new IOException(err);
            }
            LOG.error(err);
            System.err.println(err);
        }
    }

    private void createLlapDaemonConfig(FileSystem lfs, Path confPath, Configuration configured, Properties direct, Properties hiveconf) throws IOException {
        FSDataOutputStream confStream = lfs.create(new Path(confPath, "llap-daemon-site.xml"));
        Configuration llapDaemonConf = LlapServiceDriver.resolve(configured, direct, hiveconf);
        llapDaemonConf.writeXml((OutputStream)confStream);
        confStream.close();
    }

    private void copyConfig(FileSystem lfs, Path confPath, String f) throws IOException {
        HiveConf.getBoolVar((Configuration)new Configuration(false), (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CLIENT_CONSISTENT_SPLITS);
        lfs.copyFromLocalFile(new Path(this.conf.getResource(f).toString()), confPath);
    }

    private void setUpLogAndMetricConfigs(FileSystem lfs, URL logger, Path confPath) throws IOException {
        InputStream loggerContent = logger.openStream();
        IOUtils.copyBytes((InputStream)loggerContent, (OutputStream)lfs.create(new Path(confPath, "llap-daemon-log4j2.properties"), true), (Configuration)this.conf, (boolean)true);
        String metricsFile = "hadoop-metrics2-llapdaemon.properties";
        URL metrics2 = this.conf.getResource(metricsFile);
        if (metrics2 == null) {
            LOG.warn("hadoop-metrics2-llapdaemon.properties cannot be found. Looking for hadoop-metrics2.properties");
            metricsFile = "hadoop-metrics2.properties";
            metrics2 = this.conf.getResource(metricsFile);
        }
        if (metrics2 != null) {
            InputStream metrics2FileStream = metrics2.openStream();
            IOUtils.copyBytes((InputStream)metrics2FileStream, (OutputStream)lfs.create(new Path(confPath, metricsFile), true), (Configuration)this.conf, (boolean)true);
            LOG.info("Copied hadoop metrics2 properties file from " + metrics2);
        } else {
            LOG.warn("Cannot find hadoop-metrics2-llapdaemon.properties or hadoop-metrics2.properties in classpath.");
        }
    }

    private static abstract class NamedCallable<T>
    implements Callable<T> {
        public final String taskName;

        public NamedCallable(String name) {
            this.taskName = name;
        }

        public String getName() {
            return this.taskName;
        }
    }
}

